#import <Foundation/Foundation.h>
#import "ArchiveTestCase.h"
#import "FileInfo.h"
#import "NSObject+Custom.h"
#import "Archive.h"

@implementation ArchiveTestCase : TestCase

- (Archive *)sampleArchive
{
	[self methodIsAbstract:_cmd];
	// shut up the compiler
	return nil;
}

- (void)testCount
{
	[self assertInt:[[self sampleArchive] elementCount] equals:7];
}

- (void)testSortByPath
{
   	Archive *archive;
	FileInfo *element;

	archive = [self sampleArchive];
    [archive sortByPath];	
		
    element = [archive elementAtIndex:0];
    [self assert:[element filename] equals:@".procmailrc"];
	[self assertNil:[element path]];
	
	element = [[archive elements] lastObject];
	[self assert:[element path] equals:@".procmail/"];
}

- (void)testSortBySize
{
	Archive *archive = [self sampleArchive];
	[archive sortBySize];
	
	// test size of first element
	FileInfo *element = [archive elementAtIndex:0];
	[self assert:[element size] equals:[NSNumber numberWithInt:651]];
	
	// test size of last element
	element = [[archive elements] lastObject];
	[self assert:[element size] equals:[NSNumber numberWithInt:14533]];
}

- (void)testSortByFilename
{
	Archive *archive = [self sampleArchive];
	[archive sortByFilename];
	
	FileInfo *fileInfo = [archive elementAtIndex:0];
	[self assert:[fileInfo filename] equals:@".procmailrc"];
	[self assert:[[[archive elements] lastObject] filename] equals:@"vacation.rc"]; 
}

- (void)testToggleSort
{
	Archive *archive = [self sampleArchive];
	// sort ascending
	[archive sortByFilename];
	// this toggles to descending sorting
	[archive sortByFilename];
	
	FileInfo *info = [archive elementAtIndex:0];
	[self assert:[info filename] equals:@"vacation.rc"];
}

- (void)testFullPathWithoutPath
{
	Archive *archive = [self sampleArchive];
	[archive sortByPath];
	
	// the first element has no path
	FileInfo *element = [archive elementAtIndex:0];
	[self assertNil:[element path]];
	[self assert:[element filename] equals:[element fullPath]];
}

@end
