/*
 * @(#)DinoGLP.h
 *
 * Copyright 2007 - 2009  David A. Bagley, bagleyd@tux.org
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for DinoGL */

#ifndef _DinoGLP_h
#define _DinoGLP_h

#include "DinoGL.h"
#include <GL/gl.h>
#include <GL/glu.h>
#ifndef WINVER
#include <GL/glx.h>

/* This gets around C's inability to do inheritance */
typedef struct _DinoGLClassPart {
	int         ignore;
} DinoGLClassPart;

typedef struct _DinoGLClassRec {
	CoreClassPart coreClass;
	DinoClassPart dinoClass;
	DinoGLClassPart dinoGLClass;
} DinoGLClassRec;

extern DinoGLClassRec dinoGLClassRec;
#endif

#define CCW 7
#define TOP 8
#define RIGHT 9
#define BOTTOM 10
#define LEFT 11
#define MAX_ROTATE 3
#define MAX_CORNERS 8
#define MAX_EDGES 12

#define TOP_FACE 0
#define LEFT_FACE 1
#define FRONT_FACE 2
#define RIGHT_FACE 3
#define BOTTOM_FACE 4
#define BACK_FACE 5
#define BORDER_FACE (MAX_FACES)
#define NO_FACE (MAX_FACES+1)
#define NO_CORNER 8
#define NO_EDGE 12
#define NO_POSITION (IGNORE_DIR)
#define NO_ROTATION (2*MAX_ORIENT)
#define NO_DEPTH (IGNORE_DIR)
#define MAX_TURN_INC 10

#define CUBE_LENGTH 0.5
#define CUBEFULLLEN (2.0*CUBE_LENGTH)
#define STICKER_OFFSET 0.1
#define SELECT_OFFSET 0.35
#define CUBE_ROUND (CUBE_LENGTH-0.05)
#define CUBEFULLROUND (2.0*CUBE_ROUND)
#define STICKER_LONG (CUBE_ROUND-0.05)
#define STICKERFULLLONG (2.0*STICKER_LONG)
#define STICKER_SHORT (STICKER_LONG-0.05)
#define STICKERFULLSHORT (2.0*STICKER_SHORT)
#define STICKER_DEPTH (CUBE_LENGTH+0.01)
#define SELECT_LONG (4.0*CUBE_ROUND/5.0-0.05)
#define SELECTFULLLONG (2.0*SELECT_LONG)
#define SELECT_SHORT (4.0*STICKER_LONG/5.0-0.15)
#define SELECTFULLSHORT (2.0*SELECT_SHORT)
#define SELECT_DEPTH (CUBE_LENGTH+0.02)
#define CUT 0.04
#define CUT_DEPTH (STICKER_DEPTH+0.001)

#define SCALE (1.1)

typedef struct _DinoMove {
        int         face, direction;
        int         position;
        int         style;
        int         control;
} DinoMove;

typedef struct _DinoSlice {
        int         corner, rotation;
} DinoSlice;

typedef struct _DinoSplit {
        int         edge, rotation;
} DinoSplit;

typedef struct _DinoGLPart {
	double      angleStep;
	double      rotateStep;
	int         numTurnInc;
	Position    faceDiagonal;
	Position    cubeDiagonalx, cubeDiagonaly, cubeDiagonalz;
	Point       faceSize, viewSize;
	Point       viewMiddle;
	DinoMove    movement;
	int         step;
} DinoGLPart;

typedef struct _DinoGLRec {
	CorePart    core;
	DinoPart    dino;
	DinoGLPart  dinoGL;
} DinoGLRec;

extern Boolean selectPiecesGL(DinoGLWidget w, int x, int y,
	int *face, int *position);
extern Boolean narrowSelectionGL(DinoGLWidget w,
	int *face, int *direction);
extern void drawFrameGL(DinoGLWidget w, Boolean focus);
extern void drawAllPiecesGL(DinoGLWidget w);
extern void moveAllPiecesGL(DinoGLWidget w, int face, int direction,
	int style, int fast);
extern void movePiecesGL(DinoGLWidget w, int face, int position,
	int direction, int style, Boolean control, int fast);
#ifdef WINVER
extern void resizePuzzleGL(DinoGLWidget w);
extern void exposePuzzleGL(DinoGLWidget w);
#endif

#endif /* _DinoGLP_h */
