/* xkeycaps, Copyright (c) 1991, 1992, 1993, 1994, 1995, 1996
 * Jamie Zawinski <jwz@jwz.org>
 *
 * This file describes the key surfaces of the Sony PCG-C1VN ("Picturebook")
 * series keyboard, US layout.
 * by Christoph Berg <cb@cs.uni-sb.de> 030112
 * (copied from ms105de-caps.h)
 *
 * Please note that I do not own a C1VN and the keys described are here may
 * be wrong. (cb)
 */

static const struct key_strings c1vn_us_caps [] = {

  /* Row 0 */

  {"Esc", 0},
  {"F1", 0},
  {"F2", 0},
  {"F3", 0},
  {"F4", 0},
  {"F5", 0},
  {"F6", 0},
  {"F7", 0},
  {"F8", 0},
  {"F9", 0},
  {"F10", 0},
  {"F11", 0},
  {"F12", 0},
  {"NumLk", "", "ScrLk"},
  {"PrtSc", "SysRq", 0},
  {"Insert", "", "Pause"},
  {"Delete", "", "Break"},
  {"ScrLk", 0},
  {"Pause", 0},
  {"Break", 0},

  /* Row 1 */

  {"!", "1", 0},
  {"@", "2", 0},
  {"#", "3", 0},
  {"$", "4", 0},
  {"%", "5", 0},
  {"^", "6", 0},
  {"&", "7", 0},
  {"*", "8", 0},
  {"(", "9", 0},
  {")", "0", 0},
  {"_", "-", 0},
  {"`", "'", 0},
  {"Backspace", 0},

  /* Row 2 */

  {"Tab", 0},
  {"Q", 0},
  {"W", 0},
  {"E", 0},
  {"R", 0},
  {"T", 0},
  {"Y", 0},
  {"U", 0},
  {"I", 0},
  {"O", 0},
  {"P", 0},
  {"{", "[", 0},
  {"}", "]", 0},
  {"Enter", 0},

  /* Row 3 */

  {"CapsLock", 0},
  {"A", 0},
  {"S", 0},
  {"D", 0},
  {"F", 0},
  {"G", 0},
  {"H", 0},
  {"J", 0},
  {"K", 0},
  {"L", 0},
  {":", ";", 0},
  {"\"", "'", 0},
  {"|", "\\", 0},

  /* Row 4 */

  {"Shift", 0},
  {">", "<", 0},
  {"Z", 0},
  {"X", 0},
  {"C", 0},
  {"V", 0},
  {"B", 0},
  {"N", 0},
  {"M", 0},
  {"<", ",", 0},
  {">", ".", 0},
  {"?", "/", 0},
  {"Fn", 0},
  {"UpArrow", 0},
  {"Shift", 0},
  {"PgUp", 0},

  /* Row 5 */

  {"Ctrl", 0},
  {"Fn", 0},
  {"~", "`", 0},
  {"=/+/", 0},
  {"Alt", 0},
  {" ", 0},
  {"Alt Gr", 0},
  {"##", 0},
  {"Ctrl", 0},
  {"LeftArrow", 0},
  {"DownArrow", 0},
  {"RightArrow", 0},
  {"Home", 0},
  {"PgDn", 0},
  {"End", 0},
};
