/*****************************************************************************
	TRAVIS - Trajectory Analyzer and Visualizer
	http://www.travis-analyzer.de/

	Copyright (c) 2009-2017 Martin Brehm
				  2012-2017 Martin Thomas
				  2016-2017 Sascha Gehrke

	This file written by Sascha Gehrke.

	This program is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program.  If not, see <http://www.gnu.org/licenses/>.
*****************************************************************************/


#ifndef IONPAIR_H
#define IONPAIR_H


// This must always be the first include directive
#include "config.h"

#include "moltools.h"


bool gatherIonPair();
bool initializeIonPair();
bool processIonPair(CTimeStep* ts);
bool finalizeIonPair();


class CIonPairObservation: public CObservation
{
public:
	CIonPairObservation();
	~CIonPairObservation();

	CxObArray *m_oaAnion;		// Contains m_iOffset for the Neighbor-atom of each Anion
	CxObArray *m_oaCation; 	//			  "                			Cation
	CxObArray *m_oaCatAtoms;	// Contains IntArray for each cation, with the m_iOffsets for each "cationic atom"
	CxObArray *m_oaAnAtoms; 	// Contains 		"      anion		"		 "anionic atom"
	
	CxObArray *m_oaNeigh;
	CxObArray *m_oaPair;

	CxObArray *m_oaLastNeigh;		// Contains the last neighborstates

	CxIntArray *m_laLastPair;		// Contains the last pair partner (there must be one in every step)

	CxDoubleArray* PairDynamic; // Final Datasets after processing
	CxDoubleArray* DiffusionDynamic;
	CxDoubleArray* k_t; 	// Numerical derivation of BondDynamic
	CxDoubleArray* a;		
	CxDoubleArray* b;

	double m_fDist;

	int m_iDepth, m_iTrunc;
	double m_dGraceMin, m_dGraceMax;

	void initialize();
	void process(CTimeStep* ts);
	void finalize();

	void Initiate_Offsets(int, CxObArray*);
	bool checkAtomChoice(CMolecule*, const char*, CxObArray*);
	bool includeAtom(int, int, int, CxObArray*);
	bool includeALL(int, CxObArray*);
	void CheckBoundary(CxDVector3*);

	void RestoreFunction(CxIntArray*, CxDoubleArray*);
	void CalcMinMax();

	void WriteOutput();

	
private:

};


#endif

