/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.swt;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.piccolo2d.PNode;
import org.piccolo2d.extras.swt.PSWTCanvas;
import org.piccolo2d.extras.swt.SWTGraphics2D;
import org.piccolo2d.util.PBounds;
import org.piccolo2d.util.PPaintContext;

public class PSWTImage
extends PNode {
    private static final long serialVersionUID = 1L;
    private final transient PSWTCanvas canvas;
    private transient Image image;

    public PSWTImage(PSWTCanvas canvas) {
        this.canvas = canvas;
        canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent de) {
                PSWTImage.this.disposeImage();
            }
        });
    }

    public PSWTImage(PSWTCanvas canvas, Image image) {
        this(canvas);
        this.setImage(image);
    }

    public PSWTImage(PSWTCanvas canvas, String fileName) {
        this(canvas);
        this.setImage(fileName);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(String filePath) {
        this.setImage(new Image((Device)this.canvas.getDisplay(), filePath));
    }

    public void setImage(Image newImage) {
        Image old = this.image;
        this.image = newImage;
        if (this.image != null) {
            Rectangle bounds = this.getImage().getBounds();
            this.setBounds(0.0, 0.0, bounds.width, bounds.height);
            this.invalidatePaint();
        }
        this.firePropertyChange(32768, "image", old, this.image);
    }

    protected void disposeImage() {
        if (this.image != null) {
            this.image.dispose();
        }
    }

    protected void paint(PPaintContext paintContext) {
        if (this.getImage() != null) {
            Rectangle r = this.image.getBounds();
            PBounds b = this.getBoundsReference();
            SWTGraphics2D g2 = (SWTGraphics2D)paintContext.getGraphics();
            if (b.x == 0.0 && b.y == 0.0 && b.width == (double)r.width && b.height == (double)r.height) {
                g2.drawImage(this.image, 0.0, 0.0);
            } else {
                g2.translate(b.x, b.y);
                g2.scale(b.width / (double)r.width, b.height / (double)r.height);
                g2.drawImage(this.image, 0.0, 0.0);
                g2.scale((double)r.width / b.width, (double)r.height / b.height);
                g2.translate(-b.x, -b.y);
            }
        }
    }
}

