///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __ATOMSOBJECT_EDITOR_H
#define __ATOMSOBJECT_EDITOR_H

#include <atomviz/AtomViz.h>
#include "AtomsObject.h"

#include <core/Core.h>
#include <core/gui/properties/PropertiesEditor.h>
#include <core/gui/properties/PropertiesPanel.h>
#include <core/gui/properties/RefTargetListParameterUI.h>

namespace AtomViz {

/******************************************************************************
* A properties editor for the AtomsObject class.
******************************************************************************/
class ATOMVIZ_DLLEXPORT AtomsObjectEditor : public PropertiesEditor
{
protected:

	/// Creates the user interface controls for the editor.
	virtual void createUI(const RolloutInsertionParameters& rolloutParams);

private Q_SLOTS:

	/// Is called by the system when a the AtomsObject changed.
	void onEditContentsChanged(RefTarget* newObject);

private:

	/// The sub-editor for the position datachannel.
	PropertiesEditor::SmartPtr _positionChannelEditor;

	/// The sub-editor for the atom type datachannel.
	PropertiesEditor::SmartPtr _atomTypeChannelEditor;

	Q_OBJECT
	DECLARE_PLUGIN_CLASS(AtomsObjectEditor)
};

};	// End of namespace AtomViz

#endif
