# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-795-1 (nagios3)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(64368);
 script_cve_id("CVE-2009-2288");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Ubuntu USN-795-1 (nagios3)";
 script_name(name);

 desc = "The remote host is missing an update to nagios3
announced via advisory USN-795-1.

Details follow:

It was discovered that Nagios did not properly parse certain commands
submitted using the WAP web interface. An authenticated user could exploit
this flaw and execute arbitrary programs on the server.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 8.04 LTS:
  nagios2                         2.11-1ubuntu1.5

Ubuntu 8.10:
  nagios3                         3.0.2-1ubuntu1.2

Ubuntu 9.04:
  nagios3                         3.0.6-2ubuntu1.1

After a standard system upgrade you need to restart Nagios to effect
the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-795-1

Risk factor : High";

 script_description(desc);

 summary = "Ubuntu USN-795-1 (nagios3)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Ubuntu Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"nagios2-common", ver:"2.11-1ubuntu1.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nagios2-doc", ver:"2.11-1ubuntu1.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nagios2-dbg", ver:"2.11-1ubuntu1.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nagios2", ver:"2.11-1ubuntu1.5", rls:"UBUNTU8.04 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nagios3-common", ver:"3.0.2-1ubuntu1.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nagios3-doc", ver:"3.0.2-1ubuntu1.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nagios3-dbg", ver:"3.0.2-1ubuntu1.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nagios3", ver:"3.0.2-1ubuntu1.2", rls:"UBUNTU8.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nagios3-common", ver:"3.0.6-2ubuntu1.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nagios3-doc", ver:"3.0.6-2ubuntu1.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nagios3-dbg", ver:"3.0.6-2ubuntu1.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nagios3", ver:"3.0.6-2ubuntu1.1", rls:"UBUNTU9.04")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
