###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_trillian_bof_vuln.nasl 1348 2009-04-01 15:10:29Z apr $
#
# Trillian Buffer Overflow Vulnerability
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800265);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-6563");
  script_bugtraq_id(28747);
  script_name("Trillian Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is installed with Trillian and is prone to buffer
  overflow vulnerability.

  Vulnerability Insight:
  The application fails to perform adequate boundary checks on user supplied
  data resulting in a parsing error while processing malformed DTD files.

  Impact:
  Successful exploitation will let the attacker execute arbitrary code or
  to cause denial of service.

  Affected Software/OS:
  Trillian IM Client version 3.1.9.0 and prior.

  Fix: Upgrade to Trillian IM Client version 4.2 or later
  For further updates refer, http://blog.ceruleanstudios.com

  References:
  http://osvdb.org/51130
  http://xforce.iss.net/xforce/xfdb/41782
  http://www.securityfocus.com/archive/1/archive/1/490772/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Trillian");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_trillian_detect.nasl");
  script_require_keys("Trillian/Ver");
  exit(0);
}


include("version_func.inc");

version = get_kb_item("Trillian/Ver");
if(!version){
  exit(0);
}

# Grep for Trillian version 3.1.9.0 or prior
if(version_is_less(version:version, test_version:"3.1.9.0")){
  security_hole(0);
}
