# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-0195 (proftpd)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63128);
 script_cve_id("CVE-2008-4242");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 8 FEDORA-2009-0195 (proftpd)";
 script_name(name);

 desc = "The remote host is missing an update to proftpd
announced via advisory FEDORA-2009-0195.

Update Information:

This update fixes a security issue where an attacker could conduct cross-site
request forgery (CSRF) attacks and execute arbitrary FTP commands. It
also fixes some SSL shutdown issues seen with certain clients.

ChangeLog:

* Fri Jan  2 2009 Matthias Saou  1.3.1-8
- Update default configuration to have a lit of available modules and more
example configuration for them.
- Include patches to fix TLS issues (#457280).
* Fri Jan  2 2009 Matthias Saou  1.3.1-7
- Add Debian patch to fix CSRF vulnerability (#464127, upstream #3115).

References:

[ 1 ] Bug #464127 - CVE-2008-4242 proftpd CSRF attack
https://bugzilla.redhat.com/show_bug.cgi?id=464127

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update proftpd' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-0195

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 8 FEDORA-2009-0195 (proftpd)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"proftpd", rpm:"proftpd~1.3.1~8.fc8", rls:"FC8")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"proftpd-ldap", rpm:"proftpd-ldap~1.3.1~8.fc8", rls:"FC8")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"proftpd-mysql", rpm:"proftpd-mysql~1.3.1~8.fc8", rls:"FC8")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"proftpd-postgresql", rpm:"proftpd-postgresql~1.3.1~8.fc8", rls:"FC8")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"proftpd-debuginfo", rpm:"proftpd-debuginfo~1.3.1~8.fc8", rls:"FC8")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
