# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1417-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(59918);
 script_cve_id("CVE-2007-6170");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1417-1 (asterisk)";
 script_name(name);

 desc = "The remote host is missing an update to asterisk
announced via advisory DSA 1417-1.

Tilghman Lesher discovered that the logging engine of Asterisk, a free
software PBX and telephony toolkit performs insufficient sanitising of
call-related data, which may lead to SQL injection.

For the stable distribution (etch), this problem has been fixed in
version 1:1.2.13~dfsg-2etch2. Updated packages for ia64 will be provided
later.

For the old stable distribution (sarge), this problem has been fixed
in version asterisk 1:1.0.7.dfsg.1-2sarge6.

We recommend that you upgrade your asterisk packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201417-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1417-1 (asterisk)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"asterisk-sounds-main", ver:"1.2.13~dfsg-2etch2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-doc", ver:"1.2.13~dfsg-2etch2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-dev", ver:"1.2.13~dfsg-2etch2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-web-vmail", ver:"1.2.13~dfsg-2etch2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-config", ver:"1.2.13~dfsg-2etch2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk", ver:"1.2.13~dfsg-2etch2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-gtk-console", ver:"1.0.7.dfsg.1-2sarge6", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-h323", ver:"1.2.13~dfsg-2etch2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-bristuff", ver:"1.2.13~dfsg-2etch2", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"asterisk-classic", ver:"1.2.13~dfsg-2etch2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
