/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

#include "precompiled.hpp"
#include "gc/shared/gcLogPrecious.hpp"
#include "gc/z/zLargePages.hpp"
#include "runtime/os.hpp"

ZLargePages::State ZLargePages::_state;
bool ZLargePages::_os_enforced_transparent_mode;

void ZLargePages::initialize() {
  pd_initialize();

  log_info_p(gc, init)("Memory: " JULONG_FORMAT "M", os::physical_memory() / M);
  log_info_p(gc, init)("Large Page Support: %s", to_string());
}

const char* ZLargePages::to_string() {
  switch (_state) {
  case Explicit:
    return "Enabled (Explicit)";

  case Transparent:
    if (_os_enforced_transparent_mode) {
      return "Enabled (Transparent, OS enforced)";
    } else {
      return "Enabled (Transparent)";
    }

  default:
    if (_os_enforced_transparent_mode) {
      return "Disabled (OS enforced)";
    } else {
      return "Disabled";
    }
  }
}
