#include <GTLCore/AbstractImage.h>

class CheckImage : public GTLCore::AbstractImage
{
public:
  CheckImage(int width, int height, const GTLCore::PixelDescription& _pixelDescription);
  virtual ~CheckImage();
  virtual GTLCore::RegionI boundingBox() const;
  virtual ConstIterator* createIterator() const;
  virtual Iterator* createIterator();
  virtual char* rawData(int _x, int _y);
  virtual const char* rawData(int _x, int _y) const;  
  void reset();
  GTLCore::RegionI accessed();
private:
  void accessPixel(int _x, int _y) const;
private:
  char* pixel;
  int m_width, m_height;
  mutable GTLCore::RegionI m_accessed;
  mutable bool m_valid_accessed;
};
