/*################################################################################
# Linux Management Providers (LMP), Simple Identity Management provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
################################################################################*/

#ifndef OPENDRIM_IDENTITYINGROUPACCESS_H_
#define OPENDRIM_IDENTITYINGROUPACCESS_H_

#include "Simple_Identity_Management_Common.h"

#include "OpenDRIM_IdentityInGroup.h"
#include "assocOpenDRIM_IdentityInGroup.h"

int Simple_Identity_Management_OpenDRIM_IdentityInGroup_load(const CMPIBroker* broker, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_IdentityInGroup_unload(string& errorMessage);

int Simple_Identity_Management_OpenDRIM_IdentityInGroup_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_IdentityInGroup>& instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_IdentityInGroup_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_IdentityInGroup& instance, const char** properties, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_IdentityInGroup_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_IdentityInGroup& newInstance, const OpenDRIM_IdentityInGroup& oldInstance, const char** properties, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_IdentityInGroup_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_IdentityInGroup& instance, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_IdentityInGroup_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_IdentityInGroup& instance, string& errorMessage);

int Simple_Identity_Management_OpenDRIM_IdentityInGroup_associatorMemberToCollection(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Member_instance, const char** properties, vector<Instance>& Collection_associatedInstances, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_IdentityInGroup_associatorCollectionToMember(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Collection_instance, const char** properties, vector<Instance>& Member_associatedInstances, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_IdentityInGroup_referenceMemberToCollection(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Member_instance, const vector<Instance>& Collection_instances, vector<OpenDRIM_IdentityInGroup>& OpenDRIM_IdentityInGroup_instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_IdentityInGroup_referenceCollectionToMember(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Collection_instance, const vector<Instance>& Member_instances, vector<OpenDRIM_IdentityInGroup>& OpenDRIM_IdentityInGroup_instances, const char** properties, string& errorMessage, const string& discriminant);

int Simple_Identity_Management_OpenDRIM_IdentityInGroup_populate(OpenDRIM_IdentityInGroup& instance, string& errorMessage);

#endif /*OPENDRIM_IDENTITYINGROUPACCESS_H_*/
