/***************************************************************************
 *
 * Project:  OpenCPN
 * Purpose:
 * Author:   David Register, Alec Leamas
 *
 ***************************************************************************
 *   Copyright (C) 2022 by David Register, Alec Leamas                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,  USA.         *
 **************************************************************************/

#ifndef _MDNSQUERY_H
#define _MDNSQUERY_H

#include <string>
#include <vector>

typedef struct ocpn_DNS_record_t ocpn_DNS_record_t;

struct ocpn_DNS_record_t {
  std::string service_instance;
  std::string hostname;
  std::string ip;
  std::string port;
};



extern  int send_dns_sd(void);
extern  void FindAllOCPNServers(size_t timeout_secs);
extern  void FindAllSignalKServers(size_t timeout_secs);
extern std::vector<std::string> get_local_ipv4_addresses();

#endif  // guard
