// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Interface_ReaderModule_HeaderFile
#define _Interface_ReaderModule_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Interface_ReaderModule.hxx>

#include <MMgt_TShared.hxx>
#include <Standard_Integer.hxx>
#include <Handle_Interface_FileReaderData.hxx>
#include <Handle_Interface_Check.hxx>
#include <Handle_Standard_Transient.hxx>
#include <Standard_Boolean.hxx>
class Standard_DomainError;
class Interface_FileReaderData;
class Interface_Check;
class Standard_Transient;


//! Defines unitary operations required to read an Entity from a
//! File (see FileReaderData, FileReaderTool), under control of
//! a FileReaderTool. The initial creation is performed by a
//! GeneralModule (set in GeneralLib). Then, which remains is
//! Loading data from the FileReaderData to the Entity
//!
//! To work, a GeneralModule has formerly recognized the Type read
//! from FileReaderData as a positive Case Number, then the
//! ReaderModule reads it according to this Case Number
class Interface_ReaderModule : public MMgt_TShared
{

public:

  
  //! Translates the type of record <num> in <data> to a positive
  //! Case Number. If Recognition fails, must return 0
  Standard_EXPORT virtual   Standard_Integer CaseNum (const Handle(Interface_FileReaderData)& data, const Standard_Integer num)  const = 0;
  
  //! Performs the effective loading from <data>, record <num>,
  //! to the Entity <ent> formerly created
  //! In case of Error or Warning, fills <ach> with messages
  //! Remark that the Case Number comes from translating a record
  Standard_EXPORT virtual   void Read (const Standard_Integer casenum, const Handle(Interface_FileReaderData)& data, const Standard_Integer num, Handle(Interface_Check)& ach, const Handle(Standard_Transient)& ent)  const = 0;
  
  //! Specific operator (create+read) defaulted to do nothing.
  //! It can be redefined when it is not possible to work in two
  //! steps (NewVoid then Read). This occurs when no default
  //! constructor is defined : hence the result <ent> must be
  //! created with an effective definition from the reader.
  //! Remark : if NewRead is defined, Copy has nothing to do.
  //!
  //! Returns True if it has produced something, false else.
  //! If nothing was produced, <ach> should be filled : it will be
  //! treated as "Unrecognized case" by reader tool.
  Standard_EXPORT virtual   Standard_Boolean NewRead (const Standard_Integer casenum, const Handle(Interface_FileReaderData)& data, const Standard_Integer num, Handle(Interface_Check)& ach, Handle(Standard_Transient)& ent)  const;




  DEFINE_STANDARD_RTTI(Interface_ReaderModule)

protected:




private: 




};







#endif // _Interface_ReaderModule_HeaderFile
