---
id: fast-foundation.anchor
title: Anchor class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [Anchor](./fast-foundation.anchor.md)

## Anchor class

An Anchor Custom HTML Element. Based largely on the [&lt;a&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a)<!-- -->.


start - Content which can be provided before the anchor content


end - Content which can be provided after the anchor content


- The default slot for anchor content


control - The anchor element


content - The element wrapping anchor content

<b>Signature:</b>

```typescript
export declare class Anchor extends FoundationElement 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [control](./fast-foundation.anchor.control.md) |  | HTMLAnchorElement | References the root element |
|  [download](./fast-foundation.anchor.download.md) |  | string | Prompts the user to save the linked URL. See [&lt;a&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a) for more information. |
|  [href](./fast-foundation.anchor.href.md) |  | string | The URL the hyperlink references. See [&lt;a&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a) for more information. |
|  [hreflang](./fast-foundation.anchor.hreflang.md) |  | string | Hints at the language of the referenced resource. See [&lt;a&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a) for more information. |
|  [ping](./fast-foundation.anchor.ping.md) |  | string | See [&lt;a&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a) for more information. |
|  [referrerpolicy](./fast-foundation.anchor.referrerpolicy.md) |  | string | See [&lt;a&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a) for more information. |
|  [rel](./fast-foundation.anchor.rel.md) |  | string | See [&lt;a&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a) for more information. |
|  [target](./fast-foundation.anchor.target.md) |  | "\_self" \| "\_blank" \| "\_parent" \| "\_top" | See [&lt;a&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a) for more information. |
|  [type](./fast-foundation.anchor.type.md) |  | string | See [&lt;a&gt; element](https://developer.mozilla.org/en-US/docs/Web/HTML/Element/a) for more information. |
