/*!
 * depd
 * Copyright(c) 2017 Douglas Christopher Wilson
 * MIT Licensed
 */

'use strict'

/**
 * Module dependencies.
 * @private
 */

var Buffer = require('safe-buffer').Buffer

/**
 * Module exports.
 * @public
 */

module.exports = captureStderr

/**
 * Capture STDERR output during a function invokation.
 * @public
 */

function captureStderr (fn, color) {
  var chunks = []
  var isTTY = process.stderr.isTTY
  var write = process.stderr.write

  process.stderr.isTTY = Boolean(color)
  process.stderr.write = function write (chunk, encoding) {
    chunks.push(Buffer.from(chunk, encoding))
  }

  try {
    fn()
  } finally {
    process.stderr.isTTY = isTTY
    process.stderr.write = write
  }

  return Buffer.concat(chunks).toString('utf8')
}
