<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/modules/mongodb/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/modules/mongodb/metadata.yaml"
sidebar_label: "MongoDB"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Databases"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# MongoDB


<img src="https://netdata.cloud/img/mongodb.svg" width="150"/>


Plugin: go.d.plugin
Module: mongodb

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors MongoDB servers.

Executed queries:

- [serverStatus](https://docs.mongodb.com/manual/reference/command/serverStatus/)
- [dbStats](https://docs.mongodb.com/manual/reference/command/dbStats/)
- [replSetGetStatus](https://www.mongodb.com/docs/manual/reference/command/replSetGetStatus/)




This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This integration doesn't support auto-detection.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.

- WireTiger metrics are available only if [WiredTiger](https://docs.mongodb.com/v6.0/core/wiredtiger/) is used as the
  storage engine.
- Sharding metrics are available on shards only
  for [mongos](https://www.mongodb.com/docs/manual/reference/program/mongos/).


### Per MongoDB instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| mongodb.operations_rate | reads, writes, commands | operations/s |
| mongodb.operations_latency_time | reads, writes, commands | milliseconds |
| mongodb.operations_by_type_rate | insert, query, update, delete, getmore, command | operations/s |
| mongodb.document_operations_rate | inserted, deleted, returned, updated | operations/s |
| mongodb.scanned_indexes_rate | scanned | indexes/s |
| mongodb.scanned_documents_rate | scanned | documents/s |
| mongodb.active_clients_count | readers, writers | clients |
| mongodb.queued_operations_count | reads, writes | operations |
| mongodb.cursors_open_count | open | cursors |
| mongodb.cursors_open_no_timeout_count | open_no_timeout | cursors |
| mongodb.cursors_opened_rate | opened | cursors/s |
| mongodb.cursors_timed_out_rate | timed_out | cursors/s |
| mongodb.cursors_by_lifespan_count | le_1s, 1s_5s, 5s_15s, 15s_30s, 30s_1m, 1m_10m, ge_10m | cursors |
| mongodb.transactions_count | active, inactive, open, prepared | transactions |
| mongodb.transactions_rate | started, aborted, committed, prepared | transactions/s |
| mongodb.connections_usage | available, used | connections |
| mongodb.connections_by_state_count | active, threaded, exhaust_is_master, exhaust_hello, awaiting_topology_changes | connections |
| mongodb.connections_rate | created | connections/s |
| mongodb.asserts_rate | regular, warning, msg, user, tripwire, rollovers | asserts/s |
| mongodb.network_traffic_rate | in, out | bytes/s |
| mongodb.network_requests_rate | requests | requests/s |
| mongodb.network_slow_dns_resolutions_rate | slow_dns | resolutions/s |
| mongodb.network_slow_ssl_handshakes_rate | slow_ssl | handshakes/s |
| mongodb.memory_resident_size | used | bytes |
| mongodb.memory_virtual_size | used | bytes |
| mongodb.memory_page_faults_rate | pgfaults | pgfaults/s |
| mongodb.memory_tcmalloc_stats | allocated, central_cache_freelist, transfer_cache_freelist, thread_cache_freelists, pageheap_freelist, pageheap_unmapped | bytes |
| mongodb.wiredtiger_concurrent_read_transactions_usage | available, used | transactions |
| mongodb.wiredtiger_concurrent_write_transactions_usage | available, used | transactions |
| mongodb.wiredtiger_cache_usage | used | bytes |
| mongodb.wiredtiger_cache_dirty_space_size | dirty | bytes |
| mongodb.wiredtiger_cache_io_rate | read, written | pages/s |
| mongodb.wiredtiger_cache_evictions_rate | unmodified, modified | pages/s |
| mongodb.sharding_nodes_count | shard_aware, shard_unaware | nodes |
| mongodb.sharding_sharded_databases_count | partitioned, unpartitioned | databases |
| mongodb.sharding_sharded_collections_count | partitioned, unpartitioned | collections |

### Per lock type

These metrics refer to the lock type.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| lock_type | lock type (e.g. global, database, collection, mutex) |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| mongodb.lock_acquisitions_rate | shared, exclusive, intent_shared, intent_exclusive | acquisitions/s |

### Per commit type

These metrics refer to the commit type.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| commit_type | commit type (e.g. noShards, singleShard, singleWriteShard) |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| mongodb.transactions_commits_rate | success, fail | commits/s |
| mongodb.transactions_commits_duration_time | commits | milliseconds |

### Per database

These metrics refer to the database.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| database | database name |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| mongodb.database_collection_count | collections | collections |
| mongodb.database_indexes_count | indexes | indexes |
| mongodb.database_views_count | views | views |
| mongodb.database_documents_count | documents | documents |
| mongodb.database_data_size | data_size | bytes |
| mongodb.database_storage_size | storage_size | bytes |
| mongodb.database_index_size | index_size | bytes |

### Per replica set member

These metrics refer to the replica set member.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| repl_set_member | replica set member name |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| mongodb.repl_set_member_state | primary, startup, secondary, recovering, startup2, unknown, arbiter, down, rollback, removed | state |
| mongodb.repl_set_member_health_status | up, down | status |
| mongodb.repl_set_member_replication_lag_time | replication_lag | milliseconds |
| mongodb.repl_set_member_heartbeat_latency_time | heartbeat_latency | milliseconds |
| mongodb.repl_set_member_ping_rtt_time | ping_rtt | milliseconds |
| mongodb.repl_set_member_uptime | uptime | seconds |

### Per shard

These metrics refer to the shard.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| shard_id | shard id |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| mongodb.sharding_shard_chunks_count | chunks | chunks |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Create a read-only user

Create a read-only user for Netdata in the admin database.

- Authenticate as the admin user:

  ```bash
  use admin
  db.auth("admin", "<MONGODB_ADMIN_PASSWORD>")
  ```

- Create a user:

  ```bash
  db.createUser({
    "user":"netdata",
    "pwd": "<UNIQUE_PASSWORD>",
    "roles" : [
      {role: 'read', db: 'admin' },
      {role: 'clusterMonitor', db: 'admin'},
      {role: 'read', db: 'local' }
    ]
  })
  ```



### Configuration

#### File

The configuration file name for this integration is `go.d/mongodb.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/mongodb.conf
```
#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Data collection frequency. | 5 | no |
| autodetection_retry | Recheck interval in seconds. Zero means no recheck will be scheduled. | 0 | no |
| uri | MongoDB connection string. See [URI syntax](https://www.mongodb.com/docs/manual/reference/connection-string/). | mongodb://localhost:27017 | yes |
| timeout | Query timeout in seconds. | 1 | no |
| databases | Databases selector. Determines which database metrics will be collected. |  | no |

</details>

#### Examples

##### TCP socket

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    uri: mongodb://netdata:password@localhost:27017

```
</details>

##### With databases metrics

An example configuration.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    uri: mongodb://netdata:password@localhost:27017
    databases:
      includes:
        - "* *"

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    uri: mongodb://netdata:password@localhost:27017

  - name: remote
    uri: mongodb://netdata:password@203.0.113.0:27017

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `mongodb` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m mongodb
  ```

### Getting Logs

If you're encountering problems with the `mongodb` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep mongodb
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep mongodb /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep mongodb
```


