<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/smartd_log/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/smartd_log/metadata.yaml"
sidebar_label: "S.M.A.R.T."
learn_status: "Published"
learn_rel_path: "Data Collection/Hardware Devices and Sensors"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# S.M.A.R.T.


<img src="https://netdata.cloud/img/smart.png" width="150"/>


Plugin: python.d.plugin
Module: smartd_log

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors HDD/SSD S.M.A.R.T. metrics about drive health and performance.


It reads `smartd` log files to collect the metrics.


This collector is supported on all platforms.

This collector only supports collecting metrics from a single instance of this integration.


### Default Behavior

#### Auto-Detection

Upon satisfying the prerequisites, the collector will auto-detect metrics if written in either `/var/log/smartd/` or `/var/lib/smartmontools/`.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.

The metrics listed below are split in terms of availability on device type, SCSI or ATA.

### Per S.M.A.R.T. instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit | SCSI | ATA |
|:------|:----------|:----|:---:|:---:|
| smartd_log.read_error_rate | a dimension per device | value |   | • |
| smartd_log.seek_error_rate | a dimension per device | value |   | • |
| smartd_log.soft_read_error_rate | a dimension per device | errors |   | • |
| smartd_log.write_error_rate | a dimension per device | value |   | • |
| smartd_log.read_total_err_corrected | a dimension per device | errors | • |   |
| smartd_log.read_total_unc_errors | a dimension per device | errors | • |   |
| smartd_log.write_total_err_corrected | a dimension per device | errors | • |   |
| smartd_log.write_total_unc_errors | a dimension per device | errors | • |   |
| smartd_log.verify_total_err_corrected | a dimension per device | errors | • |   |
| smartd_log.verify_total_unc_errors | a dimension per device | errors | • |   |
| smartd_log.sata_interface_downshift | a dimension per device | events |   | • |
| smartd_log.udma_crc_error_count | a dimension per device | errors |   | • |
| smartd_log.throughput_performance | a dimension per device | value |   | • |
| smartd_log.seek_time_performance | a dimension per device | value |   | • |
| smartd_log.start_stop_count | a dimension per device | events |   | • |
| smartd_log.power_on_hours_count | a dimension per device | hours |   | • |
| smartd_log.power_cycle_count | a dimension per device | events |   | • |
| smartd_log.unexpected_power_loss | a dimension per device | events |   | • |
| smartd_log.spin_up_time | a dimension per device | ms |   | • |
| smartd_log.spin_up_retries | a dimension per device | retries |   | • |
| smartd_log.calibration_retries | a dimension per device | retries |   | • |
| smartd_log.airflow_temperature_celsius | a dimension per device | celsius |   | • |
| smartd_log.temperature_celsius | a dimension per device | celsius | • | • |
| smartd_log.reallocated_sectors_count | a dimension per device | sectors |   | • |
| smartd_log.reserved_block_count | a dimension per device | percentage |   | • |
| smartd_log.program_fail_count | a dimension per device | errors |   | • |
| smartd_log.erase_fail_count | a dimension per device | failures |   | • |
| smartd_log.wear_leveller_worst_case_erase_count | a dimension per device | erases |   | • |
| smartd_log.unused_reserved_nand_blocks | a dimension per device | blocks |   | • |
| smartd_log.reallocation_event_count | a dimension per device | events |   | • |
| smartd_log.current_pending_sector_count | a dimension per device | sectors |   | • |
| smartd_log.offline_uncorrectable_sector_count | a dimension per device | sectors |   | • |
| smartd_log.percent_lifetime_used | a dimension per device | percentage |   | • |
| smartd_log.media_wearout_indicator | a dimension per device | percentage |   | • |
| smartd_log.nand_writes_1gib | a dimension per device | GiB |   | • |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Configure `smartd` to write attribute information to files.

`smartd` must be running with `-A` option to write `smartd` attribute information to files.

For this you need to set `smartd_opts` (or `SMARTD_ARGS`, check _smartd.service_ content) in `/etc/default/smartmontools`:

```
# dump smartd attrs info every 600 seconds
smartd_opts="-A /var/log/smartd/ -i 600"
```

You may need to create the smartd directory before smartd will write to it: 

```sh
mkdir -p /var/log/smartd
```

Otherwise, all the smartd `.csv` files may get written to `/var/lib/smartmontools` (default location). See also <https://linux.die.net/man/8/smartd> for more info on the `-A --attributelog=PREFIX` command.

`smartd` appends logs at every run. It's strongly recommended to use `logrotate` for smartd files.



### Configuration

#### File

The configuration file name for this integration is `python.d/smartd_log.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/smartd_log.conf
```
#### Options

This particular collector does not need further configuration to work if permissions are satisfied, but you can always customize it's data collection behavior.

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| log_path | path to smartd log files. | /var/log/smartd | yes |
| exclude_disks | Space-separated patterns. If the pattern is in the drive name, the module will not collect data for it. |  | no |
| age | Time in minutes since the last dump to file. | 30 | no |
| update_every | Sets the default data collection frequency. | 1 | no |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | no |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | no |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | no |
| name | Job name. This value will overwrite the `job_name` value. JOBS with the same name are mutually exclusive. Only one of them will be allowed running at any time. This allows autodetection to try several alternatives and pick the one that works. |  | no |

</details>

#### Examples

##### Basic

A basic configuration example.

```yaml
custom:
  name: smartd_log
  log_path: '/var/log/smartd/'

```


## Troubleshooting

### Debug Mode

To troubleshoot issues with the `smartd_log` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin smartd_log debug trace
  ```


