# id3file.py - Read tags from ID3 files.

import ID3
from musiclibrarian import genreset
import musiclibrarian.musicfile

# Fix a glaring omission in the id3 module: map strings -> numbers
backgenres={'Unknown Genre' : 255}

genre=0
for name in ID3.ID3.genres:
    backgenres[name.upper()]=genre
    genre=genre+1

del genre
del name

# This works around a bug in some versions of python-id3, where only
# trailing NULs are stripped.  (some broken software produced
# incorrectly formatted tags, where values weren't padded with NULs --
# only one NUL was used to terminate)
def strip_padding(s):
    nulloc=s.find('\0')
    if nulloc <> -1:
        return s[:nulloc].rstrip()
    else:
        return s.rstrip()

class ID3File(musiclibrarian.musicfile.DictFile):
    ID3Genres=genreset.GenreSet(ID3.ID3.genres)

    """This class represents a file with id3 tags (ie, an mp3 file)"""
    def __init__(self, library, fn, cache):
        self.fn=fn

        if cache == None:
            self.__init_from_file(library, fn)
        else:
            self.__init_from_cache(library, cache)

    def __init_from_file(self, library, fn):
        try:
            id3file=ID3.ID3(fn)
        except ID3.InvalidTagError, e:
            raise musicfile.MusicFileError(e.msg)
        # it's not clear what modifying the return value of as_dict()
        # will do, so it's copied below
        d=id3file.as_dict()

        # This works around a bug in some versions of python-id3,
        # where only trailing NULs are stripped.  (some broken
        # software produced incorrectly formatted tags, where values
        # weren't padded with NULs)
        dict={}
        for key,value in d.items():
            # Convert to a list to be consistent with ogg
            dict[key]=[strip_padding(value)]

        musiclibrarian.musicfile.DictFile.__init__(self, library, dict)

    def __init_from_cache(self, library, cache):
        musiclibrarian.musicfile.DictFile.__init__(self, library, cache)

    def write_to_file(self):
        """Write the tags back to the MP3 file."""
        id3file=ID3.ID3(self.fn)

        for key,val in self.comments.items():
            if key=='GENRE':
                if len(val)>0:
                    id3file.genre=backgenres[val[0].upper()]
            else:
                id3file[key]=val[0]
        try:
            id3file.write()
        except ID3.InvalidTagError,e:
            # Suppress the stupid useless duplicate errors that occur because
            # id3file tries to write itself automatically on deletion when
            # modified=1.
            id3file.modified=0
            raise musiclibrarian.musicfile.MusicFileError(e.msg)

    def valid_genres(self):
        """Only some genres are valid for MP3 files."""
        return ID3File.ID3Genres

musiclibrarian.musicfile.register_file_type('mp3', ID3File)
