/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File ParamList.h
// Baudouin Raoult - ECMWF Oct 99

#ifndef ParamList_H
#define ParamList_H

#ifndef XMList_H
#include "XMList.h"
#endif

#ifndef Parameter_H
#include "Parameter.h"
#endif


class ParamList : public ParameterScanner {
public:

// -- Exceptions
	// None

// -- Contructors

	ParamList(Widget,const Parameter&);

// -- Destructor

	~ParamList(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods
	
	vector<string> get();
	void set(const vector<string>&);
	void changed();

	void add(const string&);

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

	// Uncomment for persistent, remove otherwise
	// static os_typespec* get_os_typespec();

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	ParamList(const ParamList&);
	ParamList& operator=(const ParamList&);

// -- Members

	XMList             list_;
	const Parameter&   param_;
	vector<string>     selection_;
	map<string,string> values_;

// -- Methods
	// None

// -- Overridden methods

	// From ParameterScanner
	void next(const Parameter&, const char* first,const char* second);

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const ParamList& p)
	//	{ p.print(s); return s; }

};

inline void destroy(ParamList**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(ParamList);
//#endif

#endif
