/*################################################################################
# Linux Management Providers (LMP), Provider Common Library
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr, desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by <Author(s)>, <Affiliation>, <Year>
################################################################################*/

#ifndef TRANSTYPE_H_
#define TRANSTYPE_H_

#include "cmpidt.h"
#include "cmpimacs.h"

#include "Objectpath.h"

// Added 2007/10/29 by Frederic Desmons (desmons_frederic@yahoo.fr)
// Gets the string interpretation of a CMPIObjectPath
string CT_CMPIObjectPathToString(const CMPIObjectPath* cop);

// Added 2007/10/29 by Frederic Desmons (desmons_frederic@yahoo.fr)
// Gets the string interpretation of a CMPIArray
string CT_CMPIArrayToString(const CMPIArray* array);

// Added 2007/10/29 by Frederic Desmons (desmons_frederic@yahoo.fr)
// Gets the string interpretation of a CMPIData
string CT_CMPIDataToString(const CMPIData& data);

//uint8
CMPIValue CT_toCMPI(const unsigned char& value);
int CT_ToC(const CMPIData& data, unsigned char& value);

//uint16
CMPIValue CT_toCMPI(const unsigned short& value);
int CT_ToC(const CMPIData& data, unsigned short& value);

//uint32
CMPIValue CT_toCMPI(const unsigned int& value);
int CT_ToC(const CMPIData& data, unsigned int& value);

//uint32 deprecated
CMPIValue CT_toCMPI(const unsigned long& value);
int CT_ToC(const CMPIData& data, unsigned long& value);

//uint64
CMPIValue CT_toCMPI(const unsigned long long& value);
int CT_ToC(const CMPIData& data, unsigned long long& value);

//sint8
CMPIValue CT_toCMPI(const signed char& value);
int CT_ToC(const CMPIData& data, signed char& value);

//sint16
CMPIValue CT_toCMPI(const short& value);
int CT_ToC(const CMPIData& data, short& value);

//sint32
CMPIValue CT_toCMPI(const int& value);
int CT_ToC(const CMPIData& data, int& value);

//sint32 deprecated
CMPIValue CT_toCMPI(const long& value);
int CT_ToC(const CMPIData& data, long& value);

//sint64
CMPIValue CT_toCMPI(const long long& value);
int CT_ToC(const CMPIData& data, long long& value);

//real32
CMPIValue CT_toCMPI(const float& value);
int CT_ToC(const CMPIData& data, float& value);

//real64
CMPIValue CT_toCMPI(const double& value);
int CT_ToC(const CMPIData& data, double& value);

//char16
CMPIValue CT_toCMPIChar16(const unsigned short& value);
int CT_ToCChar16(const CMPIData& data, unsigned short& value);

//boolean
CMPIValue CT_toCMPI(const bool& value);
int CT_ToC(const CMPIData& data, bool& value);

//string
CMPIValue CT_toCMPI(const CMPIBroker* broker, const string& value);
int CT_ToC(const CMPIData& data, string& value);

//datetime
CMPIValue CT_toCMPIDatetime(const CMPIBroker* broker, const string& value);
int CT_ToCDatetime(const CMPIData& data, string& value);

//REF
CMPIValue CT_toCMPI(const Objectpath& value);
int CT_ToC(const CMPIBroker* broker, const CMPIData& data, Objectpath& value);

//uint8[]
CMPIValue CT_toCMPI(const CMPIBroker* broker, const vector<unsigned char>& value);
int CT_ToC(const CMPIData& data, vector<unsigned char>& value);

//uint16[]
CMPIValue CT_toCMPI(const CMPIBroker* broker, const vector<unsigned short>& value);
int CT_ToC(const CMPIData& data, vector<unsigned short>& value);

//uint32[]
CMPIValue CT_toCMPI(const CMPIBroker* broker, const vector<unsigned int>& value);
int CT_ToC(const CMPIData& data, vector<unsigned int>& value);

//uint32[] deprecated
CMPIValue CT_toCMPI(const CMPIBroker* broker, const vector<unsigned long>& value);
int CT_ToC(const CMPIData& data, vector<unsigned long>& value);

//uint64[]
CMPIValue CT_toCMPI(const CMPIBroker* broker, const vector<unsigned long long>& value);
int CT_ToC(const CMPIData& data, vector<unsigned long long>& value);

//sint8[]
CMPIValue CT_toCMPI(const CMPIBroker* broker, const vector<signed char>& value);
int CT_ToC(const CMPIData& data, vector<signed char>& value);

//sint16[]
CMPIValue CT_toCMPI(const CMPIBroker* broker, const vector<short>& value);
int CT_ToC(const CMPIData& data, vector<short>& value);

//sint32[]
CMPIValue CT_toCMPI(const CMPIBroker* broker, const vector<int>& value);
int CT_ToC(const CMPIData& data, vector<int>& value);

//sint32[] deprecated
CMPIValue CT_toCMPI(const CMPIBroker* broker, const vector<long>& value);
int CT_ToC(const CMPIData& data, vector<long>& value);

//sint64[]
CMPIValue CT_toCMPI(const CMPIBroker* broker, const vector<long long>& value);
int CT_ToC(const CMPIData& data, vector<long long>& value);

//real32[]
CMPIValue CT_toCMPI(const CMPIBroker* broker, const vector<float>& value);
int CT_ToC(const CMPIData& data, vector<float>& value);

//real64[]
CMPIValue CT_toCMPI(const CMPIBroker* broker, const vector<double>& value);
int CT_ToC(const CMPIData& data, vector<double>& value);

//char16[]
CMPIValue CT_toCMPIChar16(const CMPIBroker* broker, const vector<unsigned short>& value);
int CT_ToCChar16(const CMPIData& data, vector<unsigned short>& value);

//boolean[]
CMPIValue CT_toCMPI(const CMPIBroker* broker, const vector<bool>& value);
int CT_ToC(const CMPIData& data, vector<bool>& value);

//string[]
CMPIValue CT_toCMPI(const CMPIBroker* broker, const vector<string>& value);
int CT_ToC(const CMPIData& data, vector<string>& value);

//datetime[]
CMPIValue CT_toCMPIDatetime(const CMPIBroker* broker, const vector<string>& value);
int CT_ToCDatetime(const CMPIData& data, vector<string>& value);

//REF[]
CMPIValue CT_toCMPI(const CMPIBroker* broker, const vector<Objectpath>& value);
int CT_ToC(const CMPIBroker* broker, const CMPIData& data, vector<Objectpath>& value);

#endif /*TRANSTYPE_H_*/
