//start of DisconnectableInputStream.java
//TEXT_STYLE:CODE=Shift_JIS(Japanese):RET_CODE=CRLF

/**
 * DisconnectableInputStream.java
 * 
 * Copyright (C) 2001-2002  Michel Ishizuka  All rights reserved.
 * 
 * ȉ̏ɓӂȂ΃\[XƃoCi`̍ĔzzƎgp
 * ύX̗Lɂ炸B
 * 
 * PD\[XR[h̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐ێȂĂ͂ȂȂB
 * 
 * QDoCi`̍ĔzzɂĒ쌠\ ̏̃Xg
 *     щL̐gp ̑̔zz
 *     ܂ގɋLqȂ΂ȂȂB
 * 
 * ̃\tgEFA͐Β˔ڂɂĖۏ؂Œ񋟂A̖
 * IBłƂۏ؁AilLƂۏ؂ɂƂǂ܂炸A
 * Ȃ閾IшÎIȕۏ؂ȂB
 * Β˔ڂ ̃\tgEFA̎gpɂ钼ړIAԐړIA
 * IAȁAT^IȁA邢͕KRIȑQ(gpɂf[^
 * AƖ̒f〈܂Ăv̈⎸A֐i
 * T[rX̓l邪AĂꂾɌ肳Ȃ
 * Q)ɑ΂āAȂ鎖Ԃ̌ƂȂƂĂA_̐
 * C△ߎӔC܂ ȂӔC낤ƂAƂꂪs
 * ŝׂ߂łƂĂA܂͂̂悤ȑQ̉\
 * ĂƂĂ؂̐ӔC𕉂Ȃ̂ƂB
 */

package jp.gr.java_conf.dangan.io;

//import classes and interfaces
import java.io.InputStream;
import jp.gr.java_conf.dangan.io.Disconnectable;

//import exceptions
import java.io.IOException;
import java.lang.NullPointerException;

/**
 * f[^̓Xg[ f[^
 * ̓Xg[Ƃ̐ڑ邽߂̃[eBeBNXB<br>
 * java.io.BufferedInputStream ̃obt@OXg[
 * Ƃ̐ڑꍇ
 * jp.gr.java_conf.dangan.io.LimitedInputStream gp
 * ڑʒu߂obt@O}~KvB<br>
 * 
 * <pre>
 * -- revision history --
 * $Log: DisconnectableInputStream.java,v $
 * Revision 1.0  2002/07/24 00:00:00  dangan
 * add to version control
 * [maintenance]
 *     ^up~
 *     CZX̏C
 *     \[X
 *
 * </pre>
 * 
 * @author  $Author: dangan $
 * @version $Revision: 1.0 $
 */
public class DisconnectableInputStream extends InputStream
                                       implements Disconnectable {

    //------------------------------------------------------------------
    //  instance field
    //------------------------------------------------------------------
    //  source
    //------------------------------------------------------------------
    //  private InputStream in
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[
     */
    private InputStream in;

    //------------------------------------------------------------------
    //  constructer
    //------------------------------------------------------------------
    //  private DisconnectableInputStream()
    //  public DisconnectableInputStream( InputStream in )
    //------------------------------------------------------------------
    /**
     * ftHgRXgN^B
     * gpsB
     */
    private DisconnectableInputStream(){    }

    /**
     * in Ƃ̐ڑ\ȓ̓Xg[\zB
     * 
     * @param in ̓Xg[
     */
    public DisconnectableInputStream( InputStream in ){
        if( in != null ){
            this.in = in;
        }else{
            throw new NullPointerException( "in" );
        }
    }


    //------------------------------------------------------------------
    //  java.io.InputStream methods
    //------------------------------------------------------------------
    //  read method
    //------------------------------------------------------------------
    //  public int read()
    //  public int read( byte[] buffer )
    //  public int read( byte[] buffer, int index, int length )
    //  public long skip( long length )
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[ 1oCg̃f[^𓾂B<br>
     * 
     * @return ǂݍ܂ꂽ1oCg̃f[^B<br>
     *         EndOfStreamɒBꍇ -1 ԂB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public int read() throws IOException {
        return this.in.read();                                                  //throws IOException
    }

    /**
     * ڑꂽ̓Xg[ oCgz buffer 
     * 悤Ƀf[^ǂݍށB<br>
     * f[^͕K buffer 𖞂Ƃ͌ȂƂɒӁB<br>
     * 
     * @param buffer ǂݍ܂ꂽf[^i[邽߂̃oCgz
     * 
     * @return buffer ɓǂݍ񂾃f[^ʂoCgŕԂB<br>
     *          EndOfStream ɒBĂꍇ -1 ԂB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public int read( byte[] buffer ) throws IOException {
        return this.in.read( buffer, 0, buffer.length );                        //throws IOException
    }

    /**
     * ڑꂽ̓Xg[ oCgz buffer 
     * index Ŏw肳ꂽʒu length oCg̃f[^
     * ǂݍށB<br>
     * f[^͕K length oCgǂݍ܂Ƃ͌
     * ȂƂɒӁB<br>
     * 
     * @param buffer ǂݍ܂ꂽf[^i[邽߂̃oCgz
     * @param index  buffer̃f[^ǂݍ݊Jnʒu
     * @param length bufferɓǂݍރf[^
     * 
     * @return buffer ɓǂݍ񂾃f[^ʂoCgŕԂB<br>
     *          EndOfStream ɒBĂꍇ -1 ԂB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public int read( byte[] buffer, int index, int length ) throws IOException {
        if( 0 < length ){
            return this.in.read( buffer, index, length );                       //throws IOException
        }else{
            return 0;
        }
    }

    /**
     * ڑꂽ̓Xg[̃f[^ length oCg
     * ǂݔ΂B<br>
     * 
     * @param length ǂݔ΂oCgB<br>
     * 
     * @return ۂɓǂݔ΂ꂽoCgB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public long skip( long length ) throws IOException {
        if( 0 < length ){
            return this.in.skip( length );                                      //throws IOException
        }else{
            return 0;
        }
    }


    //------------------------------------------------------------------
    //  method of java.io.InputStream
    //------------------------------------------------------------------
    //  mark/reset
    //------------------------------------------------------------------
    //  public void mark( int readLimit )
    //  public void reset()
    //  public boolean markSupprted()
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[݈̌ʒuɃ}[Nݒ肵A
     * reset() \bhŃ}[N_ ǂݍ݈ʒu
     * ߂悤ɂB<br>
     * 
     * @param readLimit }[Nʒuɖ߂ẼoCgB
     *                  ̃oCg𒴂ăf[^ǂ
     *                  񂾏ꍇ reset()łȂȂ
     *                  \B<br>
     */
    public void mark( int readLimit ){
        this.in.mark( readLimit );
    }

    /**
     * ڑꂽ̓Xg[̓ǂݍ݈ʒuŌ
     * mark() \bhĂяoꂽƂ̈ʒuɐݒ肷B<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public void reset() throws IOException {
        this.in.reset();                                                        //throws IOException
    }

    /**
     * ڑꂽ̓Xg[ mark()  reset() 
     * T|[g邩𓾂B<br>
     * 
     * @return Xg[ mark()  reset() 
     *         T|[gꍇ trueB<br>
     *         T|[gȂꍇ falseB<br>
     */
    public boolean  markSupprted(){
        return this.in.markSupported();
    }


    //------------------------------------------------------------------
    //  method of java.io.InputStream
    //------------------------------------------------------------------
    //  other
    //------------------------------------------------------------------
    //  public int available()
    //  public void close()
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[ubNȂ
     * ǂݍނƂ̂łoCg𓾂B<br>
     * 
     * @return ubNȂœǂݏooCgB<br>
     * 
     * @exception IOException o̓G[ꍇ
     */
    public int available() throws IOException {
        return this.in.available();                                             //throws IOException
    }

    /**
     * ڑꂽ̓Xg[Ƃ̐ڑB<br>
     * ̃\bh disconnect() ĂԂłB<br>
     */
    public void close(){
        this.disconnect();
    }


    //------------------------------------------------------------------
    //  method of jp.gr.java_conf.dangan.io.Disconnectable 
    //------------------------------------------------------------------
    //  public void disconnect
    //------------------------------------------------------------------
    /**
     * ڑꂽ̓Xg[Ƃ̐ڑB<br>
     */
    public void disconnect(){
        this.in = null;
    }

}
//end of DisconnectableInputStream.java
