------------------------------------------------------------------------------
--               GtkAda - Ada95 binding for the Gimp Toolkit                --
--                                                                          --
--                       Copyright (C) 2018, AdaCore                        --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
-- As a special exception under Section 7 of GPL version 3, you are granted --
-- additional permissions described in the GCC Runtime Library Exception,   --
-- version 3.1, as published by the Free Software Foundation.               --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains a task which performs blocking work, and a protected
--  object which is used to share the result of the work with the rest of the
--  UI.

--  NOTE: no GtkAda package can be withed in this package: the project does
--  not do a "with" of gtkada.gpr. This is intended, as a safety measure, to
--  make sure it's not possible to inadvertently do Gtk+ calls from within
--  a task.

with Ada.Strings.Unbounded; use Ada.Strings.Unbounded;
with Ada.Containers.Synchronized_Queue_Interfaces;
with Ada.Containers.Unbounded_Synchronized_Queues;

package Task_Worker is

   type Work_Item is record
      Some_Data : Unbounded_String;
   end record;
   --  This type represents the data being generated by the task

   package Work_Item_Queues_Interface
   is new Ada.Containers.Synchronized_Queue_Interfaces (Work_Item);
   package Work_Item_Queues
   is new Ada.Containers.Unbounded_Synchronized_Queues
     (Work_Item_Queues_Interface);

   Queue : Work_Item_Queues.Queue;
   --  The protected type used to pass information from the task to the UI

   procedure Run_Task;
   --  This starts a task which produces work, in a blocking manner.
   --  The resulting work is enqueued in The_Queue.

end Task_Worker;
