/* asynchelpers.c generated by valac 0.16.1, the Vala compiler
 * generated from asynchelpers.vala, do not modify */

/*
 * Valadate - Unit testing library for GObject-based libraries.
 * Copyright (C) 2009-2012  Jan Hudec <bulb@ucw.cz>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define FSO_FRAMEWORK_TEST_TYPE_SIGNAL_WAITER (fso_framework_test_signal_waiter_get_type ())
#define FSO_FRAMEWORK_TEST_SIGNAL_WAITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FSO_FRAMEWORK_TEST_TYPE_SIGNAL_WAITER, FsoFrameworkTestSignalWaiter))
#define FSO_FRAMEWORK_TEST_SIGNAL_WAITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FSO_FRAMEWORK_TEST_TYPE_SIGNAL_WAITER, FsoFrameworkTestSignalWaiterClass))
#define FSO_FRAMEWORK_TEST_IS_SIGNAL_WAITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FSO_FRAMEWORK_TEST_TYPE_SIGNAL_WAITER))
#define FSO_FRAMEWORK_TEST_IS_SIGNAL_WAITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FSO_FRAMEWORK_TEST_TYPE_SIGNAL_WAITER))
#define FSO_FRAMEWORK_TEST_SIGNAL_WAITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FSO_FRAMEWORK_TEST_TYPE_SIGNAL_WAITER, FsoFrameworkTestSignalWaiterClass))

typedef struct _FsoFrameworkTestSignalWaiter FsoFrameworkTestSignalWaiter;
typedef struct _FsoFrameworkTestSignalWaiterClass FsoFrameworkTestSignalWaiterClass;
typedef struct _FsoFrameworkTestSignalWaiterPrivate FsoFrameworkTestSignalWaiterPrivate;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _FsoFrameworkTestParamSpecSignalWaiter FsoFrameworkTestParamSpecSignalWaiter;
#define _fso_framework_test_signal_waiter_unref0(var) ((var == NULL) ? NULL : (var = (fso_framework_test_signal_waiter_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;

typedef gboolean (*FsoFrameworkTestPredicate) (void* user_data);
typedef void (*FsoFrameworkTestBlock) (void* user_data);
typedef void (*FsoFrameworkTestAsyncBegin) (GAsyncReadyCallback callback, void* callback_target, void* user_data);
typedef void (*FsoFrameworkTestCancelableAsyncBegin) (GCancellable* cancel, GAsyncReadyCallback callback, void* callback_target, void* user_data);
typedef void (*FsoFrameworkTestAsyncFinish) (GAsyncResult* _result_, void* user_data, GError** error);
struct _FsoFrameworkTestSignalWaiter {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FsoFrameworkTestSignalWaiterPrivate * priv;
	GMainLoop* loop;
	gboolean succeeded;
	FsoFrameworkTestPredicate predicate;
	gpointer predicate_target;
	GDestroyNotify predicate_target_destroy_notify;
};

struct _FsoFrameworkTestSignalWaiterClass {
	GTypeClass parent_class;
	void (*finalize) (FsoFrameworkTestSignalWaiter *self);
};

struct _FsoFrameworkTestParamSpecSignalWaiter {
	GParamSpec parent_instance;
};

struct _Block1Data {
	int _ref_count_;
	gboolean condition;
};

struct _Block2Data {
	int _ref_count_;
	GMainLoop* loop;
	GAsyncResult* _result_;
};

struct _Block3Data {
	int _ref_count_;
	GMainLoop* loop;
	GAsyncResult* _result_;
	GCancellable* cancel;
};


static gpointer fso_framework_test_signal_waiter_parent_class = NULL;

gpointer fso_framework_test_signal_waiter_ref (gpointer instance);
void fso_framework_test_signal_waiter_unref (gpointer instance);
GParamSpec* fso_framework_test_param_spec_signal_waiter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void fso_framework_test_value_set_signal_waiter (GValue* value, gpointer v_object);
void fso_framework_test_value_take_signal_waiter (GValue* value, gpointer v_object);
gpointer fso_framework_test_value_get_signal_waiter (const GValue* value);
GType fso_framework_test_signal_waiter_get_type (void) G_GNUC_CONST;
enum  {
	FSO_FRAMEWORK_TEST_SIGNAL_WAITER_DUMMY_PROPERTY
};
FsoFrameworkTestSignalWaiter* fso_framework_test_signal_waiter_new (FsoFrameworkTestPredicate predicate, void* predicate_target, GDestroyNotify predicate_target_destroy_notify);
FsoFrameworkTestSignalWaiter* fso_framework_test_signal_waiter_construct (GType object_type, FsoFrameworkTestPredicate predicate, void* predicate_target, GDestroyNotify predicate_target_destroy_notify);
gint fso_framework_test_signal_waiter_callback (FsoFrameworkTestSignalWaiter* self);
gboolean fso_framework_test_signal_waiter_abort (FsoFrameworkTestSignalWaiter* self);
static void fso_framework_test_signal_waiter_finalize (FsoFrameworkTestSignalWaiter* obj);
gboolean fso_framework_test_wait_for_condition (gint timeout, GObject* emitter, const gchar* signame, FsoFrameworkTestPredicate predicate, void* predicate_target, GDestroyNotify predicate_target_destroy_notify, FsoFrameworkTestBlock block, void* block_target);
static gboolean _fso_framework_test_signal_waiter_abort_gsource_func (gpointer self);
gboolean fso_framework_test_wait_for_signal (gint timeout, GObject* emitter, const gchar* signame, FsoFrameworkTestBlock block, void* block_target);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda6_ (Block1Data* _data1_);
static gboolean ___lambda6__fso_framework_test_predicate (gpointer self);
gboolean fso_framework_test_wait_for_async (gint timeout, FsoFrameworkTestAsyncBegin async_function, void* async_function_target, FsoFrameworkTestAsyncFinish async_finish, void* async_finish_target, GError** error);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda2_ (Block2Data* _data2_, GObject* o, GAsyncResult* r);
static void ___lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean __lambda3_ (Block2Data* _data2_);
static gboolean ___lambda3__gsource_func (gpointer self);
gboolean fso_framework_test_wait_for_cancellable_async (gint timeout, FsoFrameworkTestCancelableAsyncBegin async_function, void* async_function_target, FsoFrameworkTestAsyncFinish async_finish, void* async_finish_target, GError** error);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda7_ (Block3Data* _data3_, GObject* o, GAsyncResult* r);
static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean __lambda8_ (Block3Data* _data3_);
static gboolean ___lambda8__gsource_func (gpointer self);
static gboolean __lambda9_ (Block3Data* _data3_);
static gboolean ___lambda9__gsource_func (gpointer self);


FsoFrameworkTestSignalWaiter* fso_framework_test_signal_waiter_construct (GType object_type, FsoFrameworkTestPredicate predicate, void* predicate_target, GDestroyNotify predicate_target_destroy_notify) {
	FsoFrameworkTestSignalWaiter* self = NULL;
	FsoFrameworkTestPredicate _tmp0_;
	void* _tmp0__target;
	self = (FsoFrameworkTestSignalWaiter*) g_type_create_instance (object_type);
	_tmp0_ = predicate;
	_tmp0__target = predicate_target;
	(self->predicate_target_destroy_notify == NULL) ? NULL : (self->predicate_target_destroy_notify (self->predicate_target), NULL);
	self->predicate = NULL;
	self->predicate_target = NULL;
	self->predicate_target_destroy_notify = NULL;
	self->predicate = _tmp0_;
	self->predicate_target = _tmp0__target;
	self->predicate_target_destroy_notify = NULL;
	(predicate_target_destroy_notify == NULL) ? NULL : (predicate_target_destroy_notify (predicate_target), NULL);
	predicate = NULL;
	predicate_target = NULL;
	predicate_target_destroy_notify = NULL;
	return self;
}


FsoFrameworkTestSignalWaiter* fso_framework_test_signal_waiter_new (FsoFrameworkTestPredicate predicate, void* predicate_target, GDestroyNotify predicate_target_destroy_notify) {
	return fso_framework_test_signal_waiter_construct (FSO_FRAMEWORK_TEST_TYPE_SIGNAL_WAITER, predicate, predicate_target, predicate_target_destroy_notify);
}


gint fso_framework_test_signal_waiter_callback (FsoFrameworkTestSignalWaiter* self) {
	gint result = 0;
	FsoFrameworkTestPredicate _tmp0_;
	void* _tmp0__target;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->predicate;
	_tmp0__target = self->predicate_target;
	_tmp1_ = _tmp0_ (_tmp0__target);
	if (_tmp1_) {
		GMainLoop* _tmp2_;
		self->succeeded = TRUE;
		_tmp2_ = self->loop;
		g_main_loop_quit (_tmp2_);
	}
	result = 0;
	return result;
}


gboolean fso_framework_test_signal_waiter_abort (FsoFrameworkTestSignalWaiter* self) {
	gboolean result = FALSE;
	GMainLoop* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->loop;
	g_main_loop_quit (_tmp0_);
	result = FALSE;
	return result;
}


static void fso_framework_test_value_signal_waiter_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void fso_framework_test_value_signal_waiter_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		fso_framework_test_signal_waiter_unref (value->data[0].v_pointer);
	}
}


static void fso_framework_test_value_signal_waiter_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = fso_framework_test_signal_waiter_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer fso_framework_test_value_signal_waiter_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* fso_framework_test_value_signal_waiter_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FsoFrameworkTestSignalWaiter* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = fso_framework_test_signal_waiter_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* fso_framework_test_value_signal_waiter_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FsoFrameworkTestSignalWaiter** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = fso_framework_test_signal_waiter_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* fso_framework_test_param_spec_signal_waiter (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FsoFrameworkTestParamSpecSignalWaiter* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FSO_FRAMEWORK_TEST_TYPE_SIGNAL_WAITER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer fso_framework_test_value_get_signal_waiter (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_FRAMEWORK_TEST_TYPE_SIGNAL_WAITER), NULL);
	return value->data[0].v_pointer;
}


void fso_framework_test_value_set_signal_waiter (GValue* value, gpointer v_object) {
	FsoFrameworkTestSignalWaiter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_FRAMEWORK_TEST_TYPE_SIGNAL_WAITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_FRAMEWORK_TEST_TYPE_SIGNAL_WAITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		fso_framework_test_signal_waiter_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_framework_test_signal_waiter_unref (old);
	}
}


void fso_framework_test_value_take_signal_waiter (GValue* value, gpointer v_object) {
	FsoFrameworkTestSignalWaiter* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FSO_FRAMEWORK_TEST_TYPE_SIGNAL_WAITER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FSO_FRAMEWORK_TEST_TYPE_SIGNAL_WAITER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		fso_framework_test_signal_waiter_unref (old);
	}
}


static void fso_framework_test_signal_waiter_class_init (FsoFrameworkTestSignalWaiterClass * klass) {
	fso_framework_test_signal_waiter_parent_class = g_type_class_peek_parent (klass);
	FSO_FRAMEWORK_TEST_SIGNAL_WAITER_CLASS (klass)->finalize = fso_framework_test_signal_waiter_finalize;
}


static void fso_framework_test_signal_waiter_instance_init (FsoFrameworkTestSignalWaiter * self) {
	GMainContext* _tmp0_ = NULL;
	GMainLoop* _tmp1_;
	_tmp0_ = g_main_context_default ();
	_tmp1_ = g_main_loop_new (_tmp0_, TRUE);
	self->loop = _tmp1_;
	self->succeeded = FALSE;
	self->ref_count = 1;
}


static void fso_framework_test_signal_waiter_finalize (FsoFrameworkTestSignalWaiter* obj) {
	FsoFrameworkTestSignalWaiter * self;
	self = FSO_FRAMEWORK_TEST_SIGNAL_WAITER (obj);
	_g_main_loop_unref0 (self->loop);
	(self->predicate_target_destroy_notify == NULL) ? NULL : (self->predicate_target_destroy_notify (self->predicate_target), NULL);
	self->predicate = NULL;
	self->predicate_target = NULL;
	self->predicate_target_destroy_notify = NULL;
}


GType fso_framework_test_signal_waiter_get_type (void) {
	static volatile gsize fso_framework_test_signal_waiter_type_id__volatile = 0;
	if (g_once_init_enter (&fso_framework_test_signal_waiter_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { fso_framework_test_value_signal_waiter_init, fso_framework_test_value_signal_waiter_free_value, fso_framework_test_value_signal_waiter_copy_value, fso_framework_test_value_signal_waiter_peek_pointer, "p", fso_framework_test_value_signal_waiter_collect_value, "p", fso_framework_test_value_signal_waiter_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FsoFrameworkTestSignalWaiterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) fso_framework_test_signal_waiter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FsoFrameworkTestSignalWaiter), 0, (GInstanceInitFunc) fso_framework_test_signal_waiter_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType fso_framework_test_signal_waiter_type_id;
		fso_framework_test_signal_waiter_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FsoFrameworkTestSignalWaiter", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&fso_framework_test_signal_waiter_type_id__volatile, fso_framework_test_signal_waiter_type_id);
	}
	return fso_framework_test_signal_waiter_type_id__volatile;
}


gpointer fso_framework_test_signal_waiter_ref (gpointer instance) {
	FsoFrameworkTestSignalWaiter* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void fso_framework_test_signal_waiter_unref (gpointer instance) {
	FsoFrameworkTestSignalWaiter* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FSO_FRAMEWORK_TEST_SIGNAL_WAITER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


/**
     * Wait until a condition becomes true.
     *
     * Waits until a condition becomes true. The condition is checked
     * at the begining and than each time emitter emits signal signame.
     * This can be used to check asynchronous functionality that uses
     * signals to signal completion when the first emission does not
     * necessarily imply the desired state was reached.
     *
     * @param timeout Maximum timeout to wait for the emission, in
     * milliseconds.
     * @param emitter The object that will emit signal.
     * @param signame Name of the signal to wait for. May include detail
     * (in the format used by g_signal_connect).
     * @param predicate Function that will be called to test whether the
     * waited-for condition occured. The wait will continue until this
     * function returns true.
     * @param block Function that will start the asynchronous operation.
     * The function will register the signal if it's emitted
     * synchronously from block, while obviously it cannot notice if it
     * is emitted before.
     * @return true if the condition became true, false otherwise.
     */
static gboolean _fso_framework_test_signal_waiter_abort_gsource_func (gpointer self) {
	gboolean result;
	result = fso_framework_test_signal_waiter_abort (self);
	return result;
}


gboolean fso_framework_test_wait_for_condition (gint timeout, GObject* emitter, const gchar* signame, FsoFrameworkTestPredicate predicate, void* predicate_target, GDestroyNotify predicate_target_destroy_notify, FsoFrameworkTestBlock block, void* block_target) {
	gboolean result = FALSE;
	FsoFrameworkTestPredicate _tmp0_;
	void* _tmp0__target;
	FsoFrameworkTestSignalWaiter* _tmp1_;
	FsoFrameworkTestSignalWaiter* waiter;
	GObject* _tmp2_;
	const gchar* _tmp3_;
	FsoFrameworkTestSignalWaiter* _tmp4_;
	gulong _tmp5_ = 0UL;
	gulong sh;
	FsoFrameworkTestBlock _tmp6_;
	void* _tmp6__target;
	FsoFrameworkTestSignalWaiter* _tmp7_;
	gint _tmp8_;
	FsoFrameworkTestSignalWaiter* _tmp9_;
	guint _tmp10_ = 0U;
	guint t1;
	FsoFrameworkTestSignalWaiter* _tmp11_;
	GMainLoop* _tmp12_;
	gboolean _tmp13_ = FALSE;
	GObject* _tmp16_;
	gulong _tmp17_;
	guint _tmp18_;
	FsoFrameworkTestSignalWaiter* _tmp19_;
	gboolean _tmp20_;
	g_return_val_if_fail (emitter != NULL, FALSE);
	g_return_val_if_fail (signame != NULL, FALSE);
	_tmp0_ = predicate;
	_tmp0__target = predicate_target;
	_tmp1_ = fso_framework_test_signal_waiter_new (_tmp0_, _tmp0__target, NULL);
	waiter = _tmp1_;
	_tmp2_ = emitter;
	_tmp3_ = signame;
	_tmp4_ = waiter;
	_tmp5_ = g_signal_connect_swapped (_tmp2_, _tmp3_, (GCallback) fso_framework_test_signal_waiter_callback, _tmp4_);
	sh = _tmp5_;
	_tmp6_ = block;
	_tmp6__target = block_target;
	_tmp6_ (_tmp6__target);
	_tmp7_ = waiter;
	fso_framework_test_signal_waiter_callback (_tmp7_);
	_tmp8_ = timeout;
	_tmp9_ = waiter;
	_tmp10_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp8_, _fso_framework_test_signal_waiter_abort_gsource_func, fso_framework_test_signal_waiter_ref (_tmp9_), fso_framework_test_signal_waiter_unref);
	t1 = _tmp10_;
	_tmp11_ = waiter;
	_tmp12_ = _tmp11_->loop;
	_tmp13_ = g_main_loop_is_running (_tmp12_);
	if (_tmp13_) {
		FsoFrameworkTestSignalWaiter* _tmp14_;
		GMainLoop* _tmp15_;
		_tmp14_ = waiter;
		_tmp15_ = _tmp14_->loop;
		g_main_loop_run (_tmp15_);
	}
	_tmp16_ = emitter;
	_tmp17_ = sh;
	g_signal_handler_disconnect (_tmp16_, _tmp17_);
	_tmp18_ = t1;
	g_source_remove (_tmp18_);
	_tmp19_ = waiter;
	_tmp20_ = _tmp19_->succeeded;
	result = _tmp20_;
	_fso_framework_test_signal_waiter_unref0 (waiter);
	(predicate_target_destroy_notify == NULL) ? NULL : (predicate_target_destroy_notify (predicate_target), NULL);
	predicate = NULL;
	predicate_target = NULL;
	predicate_target_destroy_notify = NULL;
	return result;
}


/**
     * Wait for signal to be emited.
     *
     * Waits at most timeout for given signal to be emited and return
     * whether the signal was emited. Runs main loop while waiting. This
     * can be used to test asynchronous functionality using signals to
     * signal completion.
     *
     * @param timeout Maximum timeout to wait for the emission, in
     * milliseconds.
     * @param emitter The object that will emit signal.
     * @param signame Name of the signal to wait for. May include detail
     * (in the format used by g_signal_connect).
     * @param block Function that will start the asynchronous operation.
     * The function will register the signal if it's emitted
     * synchronously from block, while obviously it cannot notice if it
     * is emitted before.
     * @return true if the signal was emited, false otherwise.
     */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda6_ (Block1Data* _data1_) {
	gboolean result = FALSE;
	if (_data1_->condition) {
		result = TRUE;
		return result;
	}
	_data1_->condition = TRUE;
	result = FALSE;
	return result;
}


static gboolean ___lambda6__fso_framework_test_predicate (gpointer self) {
	gboolean result;
	result = __lambda6_ (self);
	return result;
}


gboolean fso_framework_test_wait_for_signal (gint timeout, GObject* emitter, const gchar* signame, FsoFrameworkTestBlock block, void* block_target) {
	gboolean result = FALSE;
	Block1Data* _data1_;
	gint _tmp0_;
	GObject* _tmp1_;
	const gchar* _tmp2_;
	FsoFrameworkTestBlock _tmp3_;
	void* _tmp3__target;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (emitter != NULL, FALSE);
	g_return_val_if_fail (signame != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->condition = FALSE;
	_tmp0_ = timeout;
	_tmp1_ = emitter;
	_tmp2_ = signame;
	_tmp3_ = block;
	_tmp3__target = block_target;
	_tmp4_ = fso_framework_test_wait_for_condition (_tmp0_, _tmp1_, _tmp2_, ___lambda6__fso_framework_test_predicate, block1_data_ref (_data1_), block1_data_unref, _tmp3_, _tmp3__target);
	result = _tmp4_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


/**
     * Wait for an async operation to complete.
     *
     * Waits until a async function completes.
     * @param timeout Maximum timeout to wait for completion, in
     * milliseconds.
     * @param async_function The async function to call. The signature
     * corresponds to function declared as
     * {{{
     *     async void async_function()
     * }}}
     * in Vala.
     * @param async_finish The finsih part of the async function. It is
     * assumed it will either assert any problems, or stash the result
     * somewhere.
     * @return ture if the function completed and passed the check, false
     * otherwise.
     * [[warning:
     * If it times out, the async function may run to completion when
     * main loop is entered again later. By that time, the callback data
     * will be destroyed and the callback will crash.
     *
     * This should be avoided by setting new GLib.MainContext for each
     * test case, but that is only available in development 2.21 GLib.
     * ]]
     */
static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->_result_);
		_g_main_loop_unref0 (_data2_->loop);
		g_slice_free (Block2Data, _data2_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda2_ (Block2Data* _data2_, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	GAsyncResult* _tmp1_;
	GMainLoop* _tmp2_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data2_->_result_);
	_data2_->_result_ = _tmp1_;
	_tmp2_ = _data2_->loop;
	g_main_loop_quit (_tmp2_);
}


static void ___lambda2__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda2_ (self, source_object, res);
}


static gboolean __lambda3_ (Block2Data* _data2_) {
	gboolean result = FALSE;
	GMainLoop* _tmp0_;
	_tmp0_ = _data2_->loop;
	g_main_loop_quit (_tmp0_);
	result = FALSE;
	return result;
}


static gboolean ___lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda3_ (self);
	return result;
}


gboolean fso_framework_test_wait_for_async (gint timeout, FsoFrameworkTestAsyncBegin async_function, void* async_function_target, FsoFrameworkTestAsyncFinish async_finish, void* async_finish_target, GError** error) {
	gboolean result = FALSE;
	Block2Data* _data2_;
	GMainContext* _tmp0_ = NULL;
	GMainLoop* _tmp1_;
	FsoFrameworkTestAsyncBegin _tmp2_;
	void* _tmp2__target;
	gint _tmp3_;
	guint _tmp4_ = 0U;
	guint t1;
	GMainLoop* _tmp5_;
	gboolean _tmp6_ = FALSE;
	guint _tmp8_;
	GAsyncResult* _tmp9_;
	FsoFrameworkTestAsyncFinish _tmp10_;
	void* _tmp10__target;
	GAsyncResult* _tmp11_;
	GError * _inner_error_ = NULL;
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp0_ = g_main_context_default ();
	_tmp1_ = g_main_loop_new (_tmp0_, TRUE);
	_data2_->loop = _tmp1_;
	_data2_->_result_ = NULL;
	_tmp2_ = async_function;
	_tmp2__target = async_function_target;
	_tmp2_ (___lambda2__gasync_ready_callback, _data2_, _tmp2__target);
	_tmp3_ = timeout;
	_tmp4_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp3_, ___lambda3__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	t1 = _tmp4_;
	_tmp5_ = _data2_->loop;
	_tmp6_ = g_main_loop_is_running (_tmp5_);
	if (_tmp6_) {
		GMainLoop* _tmp7_;
		_tmp7_ = _data2_->loop;
		g_main_loop_run (_tmp7_);
	}
	_tmp8_ = t1;
	g_source_remove (_tmp8_);
	_tmp9_ = _data2_->_result_;
	if (_tmp9_ == NULL) {
		result = FALSE;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	}
	_tmp10_ = async_finish;
	_tmp10__target = async_finish_target;
	_tmp11_ = _data2_->_result_;
	_tmp10_ (_tmp11_, _tmp10__target, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return FALSE;
	}
	result = TRUE;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


/**
     * Wait for cancellable async operation to complete.
     *
     * Calls an async function and waits until it completes, at most
     * specified time. If it does not complete in time, it cancels the
     * operation and waits once more the same timeout for the
     * cancellation (it still fails if the cancellation succeeds).
     *
     * @param timeout Maximum timeout to wait for completion, in
     * milliseconds.
     * @param async_function The async function to call. The signature
     * corresponds to function declared as
     * {{{
     *     async void async_function(GLib.Cancellable cancel)
     * }}}
     * in Vala.
     * @param async_finish The finsih part of the async function. It is
     * assumed it will either assert any problems, or stash the result
     * somewhere.
     * @return ture if the function completed (without being cancelled)
     * and passed the check, false otherwise.
     * [[warning:
     * If the cancel fails and it times out second time, the async
     * function may run to completion when main loop is entered again
     * later. By that time, the callback data will be destroyed and the
     * callback will crash.
     *
     * This should be avoided by setting new GLib.MainContext for each
     * test case, but that is only available in development 2.21 GLib.
     * ]]
     */
static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->cancel);
		_g_object_unref0 (_data3_->_result_);
		_g_main_loop_unref0 (_data3_->loop);
		g_slice_free (Block3Data, _data3_);
	}
}


static void __lambda7_ (Block3Data* _data3_, GObject* o, GAsyncResult* r) {
	GAsyncResult* _tmp0_;
	GAsyncResult* _tmp1_;
	GMainLoop* _tmp2_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data3_->_result_);
	_data3_->_result_ = _tmp1_;
	_tmp2_ = _data3_->loop;
	g_main_loop_quit (_tmp2_);
}


static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda7_ (self, source_object, res);
}


static gboolean __lambda8_ (Block3Data* _data3_) {
	gboolean result = FALSE;
	GCancellable* _tmp0_;
	_tmp0_ = _data3_->cancel;
	g_cancellable_cancel (_tmp0_);
	result = FALSE;
	return result;
}


static gboolean ___lambda8__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda8_ (self);
	return result;
}


static gboolean __lambda9_ (Block3Data* _data3_) {
	gboolean result = FALSE;
	GMainLoop* _tmp0_;
	_tmp0_ = _data3_->loop;
	g_main_loop_quit (_tmp0_);
	result = FALSE;
	return result;
}


static gboolean ___lambda9__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda9_ (self);
	return result;
}


gboolean fso_framework_test_wait_for_cancellable_async (gint timeout, FsoFrameworkTestCancelableAsyncBegin async_function, void* async_function_target, FsoFrameworkTestAsyncFinish async_finish, void* async_finish_target, GError** error) {
	gboolean result = FALSE;
	Block3Data* _data3_;
	GMainContext* _tmp0_ = NULL;
	GMainLoop* _tmp1_;
	GCancellable* _tmp2_;
	FsoFrameworkTestCancelableAsyncBegin _tmp3_;
	void* _tmp3__target;
	GCancellable* _tmp4_;
	gint _tmp5_;
	guint _tmp6_ = 0U;
	guint t1;
	gint _tmp7_;
	guint _tmp8_ = 0U;
	guint t2;
	GMainLoop* _tmp9_;
	gboolean _tmp10_ = FALSE;
	guint _tmp12_;
	guint _tmp13_;
	GAsyncResult* _tmp14_;
	GCancellable* _tmp15_;
	gboolean _tmp16_ = FALSE;
	FsoFrameworkTestAsyncFinish _tmp17_;
	void* _tmp17__target;
	GAsyncResult* _tmp18_;
	GError * _inner_error_ = NULL;
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_tmp0_ = g_main_context_default ();
	_tmp1_ = g_main_loop_new (_tmp0_, TRUE);
	_data3_->loop = _tmp1_;
	_data3_->_result_ = NULL;
	_tmp2_ = g_cancellable_new ();
	_data3_->cancel = _tmp2_;
	_tmp3_ = async_function;
	_tmp3__target = async_function_target;
	_tmp4_ = _data3_->cancel;
	_tmp3_ (_tmp4_, ___lambda7__gasync_ready_callback, _data3_, _tmp3__target);
	_tmp5_ = timeout;
	_tmp6_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp5_, ___lambda8__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	t1 = _tmp6_;
	_tmp7_ = timeout;
	_tmp8_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (2 * _tmp7_), ___lambda9__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	t2 = _tmp8_;
	_tmp9_ = _data3_->loop;
	_tmp10_ = g_main_loop_is_running (_tmp9_);
	if (_tmp10_) {
		GMainLoop* _tmp11_;
		_tmp11_ = _data3_->loop;
		g_main_loop_run (_tmp11_);
	}
	_tmp12_ = t1;
	g_source_remove (_tmp12_);
	_tmp13_ = t2;
	g_source_remove (_tmp13_);
	_tmp14_ = _data3_->_result_;
	if (_tmp14_ == NULL) {
		result = FALSE;
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return result;
	}
	_tmp15_ = _data3_->cancel;
	_tmp16_ = g_cancellable_is_cancelled (_tmp15_);
	if (_tmp16_) {
		result = FALSE;
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return result;
	}
	_tmp17_ = async_finish;
	_tmp17__target = async_finish_target;
	_tmp18_ = _data3_->_result_;
	_tmp17_ (_tmp18_, _tmp17__target, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		block3_data_unref (_data3_);
		_data3_ = NULL;
		return FALSE;
	}
	result = TRUE;
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}



