/*
This file is part of LightDM-KDE.

Copyright 2011, 2012 David Edmundson <kde@davidedmundson.co.uk>

LightDM-KDE is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

LightDM-KDE is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with LightDM-KDE.  If not, see <http://www.gnu.org/licenses/>.
*/
// KDE
#include <KCmdLineArgs>
#include <KApplication>
#include <KAboutData>
#include <KLocale>

#include "../about.h"
#include "greeterwindow.h"

int main(int argc, char *argv[])
{
    KAboutData aboutData(
        "lightdm-kde-greeter",        // appName
        //HACK. Force a catalog name. All strings are stored in the theme messages files, however we need a catalog name here, otherwise our call to loadCatalog does not work
        "kcm_lightdm",                // catalogName
        ki18n("LightDM KDE Greeter"), // programName
        "0");                         // version (set by initAboutData)

    initAboutData(&aboutData);

    KCmdLineArgs::init(argc, argv, &aboutData);

    KCmdLineOptions options;
    KCmdLineArgs::addCmdLineOptions(options);
    KCmdLineArgs::parsedArgs();
    KApplication app;

    GreeterWindow *w = new GreeterWindow();
    w->show();

    return app.exec();
}

