/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#include "auth.h"
#include "dialog.h"
#include "listingdialog.h"
#include "mainpolicy.h"
#include "pagemanager.h"

#include "mainwidget.h"

MainWidget::MainWidget( QWidget *parent )
  : QTextBrowser( parent )
{
  mPolicy = new MainPolicy;

  loadPages();
}

MainWidget::~MainWidget()
{
  delete mPolicy;
  mPolicy = 0;
}

void MainWidget::loadPages()
{
  clear();

  QStringList pageNames = PageManager::self()->pageNames();

  QString body;
  body += "<html>\n";
  body += "<body>\n";
  body += "<table width=\"100%\" align=\"center\" cellspacing=\"5\" cellpadding=\"5\">\n";
  body += QString( "<tr><th colspan=\"2\">%1<hr></th></tr>" ).arg( tr( "Welcome to KolabAdmin" ) );

  for ( int i = 0; i < pageNames.count(); ++i ) {

    // filter hidden pages
    if ( !mPolicy->pageVisible( pageNames[ i ] ) )
      continue;

    Page *page = PageManager::self()->page( pageNames[ i ] );

    QUrl url;
    url.setScheme( "open" );
    url.addQueryItem( "id", page->name() );

    body += "<tr>\n";
    body += QString( "<td align=\"center\" width=\"50%\"><a href=\"%5\"><img src=\":%1\"></a></td><td valign=\"bottom\" width=\"50%\"><a href=\"%2\">%3</a><br>%4</td>\n" )
                   .arg( page->iconName(), url.toString(), page->title(), page->description() ).arg( url.toString() );
    body += "</tr>\n";
  }

  body += "</table>\n";
  body += "</body>\n";
  body += "</html>\n";

  setHtml( body );
}

void MainWidget::setSource( const QUrl &url )
{
  QString name = url.queryItemValue( "id" );

  Page *page = PageManager::self()->page( name );
  if ( !page )
    return;

  if ( page->hasListingMode() ) {
    ListingDialog dlg( page, this );

    dlg.exec();
  } else {
    Form::Dialog dlg( page, Auth::self()->dn(), Form::PagePolicy::Modify, this );

    dlg.exec();
  }
}
