/*
 *  Copyright (C) 2013-2018 Team Kodi
 *  This file is part of Kodi - https://kodi.tv
 *
 *  SPDX-License-Identifier: GPL-2.0-or-later
 *  See LICENSES/README.md for more information.
 */

#pragma once

#include <vector>

#include "IListProvider.h"
#include "guilib/GUIStaticItem.h"

class CStaticListProvider : public IListProvider
{
public:
  CStaticListProvider(const TiXmlElement *element, int parentID);
  explicit CStaticListProvider(const std::vector<CGUIStaticItemPtr> &items); // for python
  ~CStaticListProvider() override;

  bool Update(bool forceRefresh) override;
  void Fetch(std::vector<CGUIListItemPtr> &items) override;
  bool OnClick(const CGUIListItemPtr &item) override;
  bool OnInfo(const CGUIListItemPtr &item) override { return false; }
  bool OnContextMenu(const CGUIListItemPtr &item) override { return false; }
  void SetDefaultItem(int item, bool always) override;
  int GetDefaultItem() const override;
  bool AlwaysFocusDefaultItem() const override;
private:
  int m_defaultItem;
  bool m_defaultAlways;
  unsigned int m_updateTime;
  std::vector<CGUIStaticItemPtr> m_items;
};
