/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.validation;

import java.text.NumberFormat;
import java.util.Collection;
import net.sourceforge.stripes.validation.NumberTypeConverterSupport;
import net.sourceforge.stripes.validation.ScopedLocalizableError;
import net.sourceforge.stripes.validation.TypeConverter;
import net.sourceforge.stripes.validation.ValidationError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerTypeConverter
extends NumberTypeConverterSupport
implements TypeConverter<Integer> {
    @Override
    public Integer convert(String input, Class<? extends Integer> targetType, Collection<ValidationError> errors) {
        Number number = this.parse(input, errors);
        Integer retval = null;
        if (errors.size() == 0) {
            long output = number.longValue();
            if (output < Integer.MIN_VALUE || output > Integer.MAX_VALUE) {
                errors.add(new ScopedLocalizableError("converter.integer", "outOfRange", Integer.MIN_VALUE, Integer.MAX_VALUE));
            } else {
                retval = new Integer((int)output);
            }
        }
        return retval;
    }

    @Override
    protected NumberFormat[] getNumberFormats() {
        return new NumberFormat[]{NumberFormat.getIntegerInstance(this.getLocale())};
    }
}

