/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import org.apache.commons.logging.Log;
import org.mortbay.log.LogFactory;
import org.openqa.selenium.server.CommandQueue;
import org.openqa.selenium.server.DefaultRemoteCommand;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.SingleEntryAsyncQueue;

public class CommandHolder {
    private static final int defaultTimeout = 10;
    private static final RemoteCommand poisonCommand = new DefaultRemoteCommand("CommandHolder.POISION", "", "");
    protected static final String RETRY_CMD_STRING = "retryLast";
    protected static final RemoteCommand retryCommand = new DefaultRemoteCommand("retryLast", "", "", "");
    private static Log log = LogFactory.getLog(CommandHolder.class);
    private final String queueId;
    private final SingleEntryAsyncQueue<RemoteCommand> holder;

    public CommandHolder(String queueId, int timeoutInSeconds) {
        this.holder = new SingleEntryAsyncQueue(timeoutInSeconds);
        this.holder.setPoison(poisonCommand);
        this.queueId = queueId;
    }

    public CommandHolder(String queueId) {
        this(queueId, 10);
    }

    public RemoteCommand getCommand() {
        RemoteCommand sc = null;
        String hdr = "\t" + CommandQueue.getIdentification("commandHolder", this.queueId) + " getCommand() ";
        log.debug(hdr + "called");
        sc = this.holder.pollToGetContentUntilTimeout();
        if (null == sc) {
            sc = retryCommand;
        } else if (this.holder.isPoison(sc)) {
            sc = null;
        }
        log.debug(hdr + "-> " + (null == sc ? "null" : sc.toString()));
        return sc;
    }

    public boolean putCommand(RemoteCommand cmd) {
        log.debug("\t" + CommandQueue.getIdentification("commandHolder", this.queueId) + " putCommand() ");
        return this.holder.putContent(cmd);
    }

    public boolean isEmpty() {
        return this.holder.isEmpty();
    }

    public RemoteCommand peek() {
        return this.holder.peek();
    }

    public void poisonPollers() {
        String hdr = "\t" + CommandQueue.getIdentification("commandHolder", this.queueId) + " poisonPollers() ";
        log.debug(hdr + " poisoning pollers");
        this.holder.poisonPollers();
    }
}

