/*
 * Decompiled with CFR 0.152.
 */
package com.sqlmagic.tinysql;

import com.sqlmagic.tinysql.DBFHeader;
import com.sqlmagic.tinysql.UtilString;
import com.sqlmagic.tinysql.Utils;
import com.sqlmagic.tinysql.dbfFile;
import com.sqlmagic.tinysql.tinySQLException;
import com.sqlmagic.tinysql.tinySQLGlobals;
import com.sqlmagic.tinysql.tinySQLTable;
import com.sqlmagic.tinysql.tsColumn;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Vector;

public class dbfFileTable
extends tinySQLTable {
    private String fullPath;
    private String fileName;
    private DBFHeader dbfHeader = null;
    private RandomAccessFile ftbl;
    public boolean fileOpen = false;
    static final String dbfExtension = ".DBF";
    static final int FIELD_NAME_INDEX = 0;
    static final int FIELD_TYPE_INDEX = 11;
    static final int IMU_INDEX = 12;
    static final int FIELD_LENGTH_INDEX = 16;
    static final int DECIMAL_COUNT_INDEX = 17;
    static final int FIELD_RESERVED_INDEX = 18;
    static final int IS_DELETED_INDEX = 0;
    static final char RECORD_IS_DELETED = '*';
    static final char RECORD_IS_NOT_DELETED = ' ';
    int currentRecordNumber = 0;
    private String currentRowCache = null;
    boolean eof = false;

    dbfFileTable(String string, String string2) throws tinySQLException {
        int n = string2.indexOf("->");
        if (n > -1) {
            this.table = string2.substring(0, n);
            this.tableAlias = string2.substring(n + 2);
        } else {
            this.table = string2;
            this.tableAlias = string2;
        }
        this.fileName = this.table;
        if (!this.fileName.toUpperCase().endsWith(dbfExtension)) {
            this.fileName = this.fileName + dbfExtension;
        }
        this.fullPath = string + File.separator + this.fileName;
        if (tinySQLGlobals.DEBUG) {
            System.out.println("dbfFileTable: fileName=" + this.fileName + "\nTable=" + this.table + "\nfullPath=" + this.fullPath);
        }
        this.column_info = this.open_dbf();
    }

    public boolean isOpen() {
        return this.fileOpen;
    }

    public void close() throws tinySQLException {
        try {
            if (tinySQLGlobals.DEBUG) {
                System.out.println("Closing " + this.toString());
            }
            this.ftbl.close();
            this.fileOpen = false;
        }
        catch (IOException iOException) {
            throw new tinySQLException(iOException.getMessage());
        }
    }

    public int ColSize(String string) throws tinySQLException {
        tsColumn tsColumn2 = this.getColumn(string);
        return tsColumn2.size;
    }

    public int GetRowCount() {
        return this.dbfHeader.numRecords;
    }

    public int ColDec(String string) throws tinySQLException {
        tsColumn tsColumn2 = this.getColumn(string);
        return tsColumn2.decimalPlaces;
    }

    public int ColType(String string) throws tinySQLException {
        tsColumn tsColumn2 = this.getColumn(string);
        return tsColumn2.type;
    }

    public tsColumn getColumn(String string) throws tinySQLException {
        tsColumn tsColumn2;
        String string2 = string;
        int n = string2.indexOf(".");
        if (n > -1) {
            string2 = string2.substring(n + 1);
        }
        if ((tsColumn2 = (tsColumn)this.column_info.get(string2 = tinySQLGlobals.getShortName(string2))) == (tsColumn)null) {
            throw new tinySQLException("Column " + string2 + " does not" + " exist in table " + this.table);
        }
        return tsColumn2;
    }

    public void UpdateCurrentRow(Vector vector, Vector vector2) throws tinySQLException {
        int n = 0;
        while (n < vector2.size()) {
            String string = ((String)vector.elementAt(n)).toUpperCase();
            String string2 = (String)vector2.elementAt(n);
            this.UpdateCol(string, string2);
            ++n;
        }
    }

    public void GoTop() throws tinySQLException {
        this.currentRowCache = null;
        this.currentRecordNumber = 0;
        this.eof = false;
    }

    public boolean NextRecord() throws tinySQLException {
        this.currentRowCache = null;
        if (this.currentRecordNumber < this.dbfHeader.numRecords) {
            ++this.currentRecordNumber;
            this.eof = false;
            return true;
        }
        this.eof = true;
        return false;
    }

    public void InsertRow(Vector vector, Vector vector2) throws tinySQLException {
        try {
            int n;
            this.ftbl.seek(this.ftbl.length());
            this.ftbl.write(32);
            int n2 = 1;
            while (n2 < this.dbfHeader.recordLength) {
                this.ftbl.write(32);
                ++n2;
            }
            this.currentRecordNumber = n = this.dbfHeader.numRecords + 1;
            this.dbfHeader.setNumRecords(this.ftbl, n);
        }
        catch (Exception exception) {
            if (tinySQLGlobals.DEBUG) {
                exception.printStackTrace();
            }
            throw new tinySQLException(exception.getMessage());
        }
        if (vector != null && vector2 != null) {
            this.UpdateCurrentRow(vector, vector2);
        } else {
            this.dbfHeader.setTimestamp(this.ftbl);
        }
    }

    public String GetCol(String string) throws tinySQLException {
        String string2 = string;
        int n = string2.indexOf(".");
        if (n > -1) {
            string2 = string2.substring(n + 1);
        }
        tsColumn tsColumn2 = (tsColumn)this.column_info.get(string2);
        if (this.currentRowCache == null) {
            this.currentRowCache = dbfFileTable._GetCol(this.ftbl, this.dbfHeader, this.currentRecordNumber);
        }
        return dbfFileTable.getColumn(tsColumn2, this.currentRowCache);
    }

    public static String getColumn(tsColumn tsColumn2, String string) {
        if (string == (String)null) {
            System.out.println("Row is null");
        } else if (string.length() == 0) {
            System.out.println("Row has 0 length");
        }
        if (tsColumn2 == null) {
            return string.substring(0, 1);
        }
        return string.substring(tsColumn2.position, tsColumn2.position + tsColumn2.size);
    }

    public static String _GetCol(RandomAccessFile randomAccessFile, DBFHeader dBFHeader, int n) throws tinySQLException {
        try {
            randomAccessFile.seek(dBFHeader.headerLength + (n - 1) * dBFHeader.recordLength);
            byte[] byArray = new byte[dBFHeader.recordLength];
            randomAccessFile.readFully(byArray);
            return new String(byArray, "Cp1252");
        }
        catch (Exception exception) {
            throw new tinySQLException(exception.getMessage());
        }
    }

    public void UpdateCol(String string, String string2) throws tinySQLException {
        try {
            if (string.equals("_DELETED")) {
                return;
            }
            String string3 = tinySQLGlobals.getShortName(string);
            tsColumn tsColumn2 = (tsColumn)this.column_info.get(string3);
            if (tsColumn2 == null) {
                throw new tinySQLException("Can't update field=" + string);
            }
            if (Utils.isDateColumn(tsColumn2.type) && string2.trim().length() > 0) {
                string2 = UtilString.dateValue(string2);
            }
            this.ftbl.seek(this.dbfHeader.headerLength + (this.currentRecordNumber - 1) * this.dbfHeader.recordLength + tsColumn2.position);
            string2 = Utils.forceToSize(string2, tsColumn2.size, " ");
            byte[] byArray = string2.getBytes("Cp1252");
            this.ftbl.write(byArray);
            this.dbfHeader.setTimestamp(this.ftbl);
        }
        catch (Exception exception) {
            throw new tinySQLException(exception.getMessage());
        }
    }

    public void DeleteRow() throws tinySQLException {
        try {
            this.ftbl.seek(this.dbfHeader.headerLength + (this.currentRecordNumber - 1) * this.dbfHeader.recordLength);
            this.ftbl.write(42);
        }
        catch (Exception exception) {
            throw new tinySQLException(exception.getMessage());
        }
    }

    public boolean isDeleted() throws tinySQLException {
        return this.GetCol("_DELETED").charAt(0) == '*';
    }

    public static boolean isDeleted(RandomAccessFile randomAccessFile, DBFHeader dBFHeader, int n) throws tinySQLException {
        char c = dbfFileTable._GetCol(randomAccessFile, dBFHeader, n).charAt(0);
        return c == '*';
    }

    public static boolean isDeleted(String string) {
        return string.charAt(0) == '*';
    }

    public int getRecordLength() {
        return this.dbfHeader.recordLength;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Table " + this.table + ", path " + this.fullPath + ", file " + this.ftbl.toString());
        return stringBuffer.toString();
    }

    Hashtable open_dbf() throws tinySQLException {
        try {
            File file = new File(this.fullPath);
            if (tinySQLGlobals.DEBUG) {
                System.out.println("Try to open  " + file.getAbsolutePath());
            }
            if (!file.exists()) {
                throw new tinySQLException("Unable to open " + file.getAbsolutePath() + " - does not exist. or can't be read.");
            }
            if (!file.canRead()) {
                throw new tinySQLException("Unable to open " + file.getAbsolutePath() + " - file can't be read (permissions?).");
            }
            this.ftbl = file.canWrite() ? new RandomAccessFile(file, "rw") : new RandomAccessFile(file, "r");
            this.dbfHeader = new DBFHeader(this.ftbl);
            Hashtable<String, tsColumn> hashtable = new Hashtable<String, tsColumn>();
            this.columnNameKeys = new Vector();
            int n = 0;
            int n2 = 1;
            while (n2 <= this.dbfHeader.numFields) {
                tsColumn tsColumn2 = dbfFile.readColdef(this.ftbl, this.table, n2, n);
                n += tsColumn2.size;
                hashtable.put(tsColumn2.name, tsColumn2);
                this.columnNameKeys.addElement(tsColumn2.name);
                ++n2;
            }
            this.fileOpen = true;
            return hashtable;
        }
        catch (Exception exception) {
            if (tinySQLGlobals.DEBUG) {
                exception.printStackTrace();
            }
            throw new tinySQLException(exception.getMessage());
        }
    }
}

