# frozen_string_literal: true

require 'open3'
require 'json'
require 'yaml'
require 'hocon'
require 'hocon/config_value_factory'
require 'singleton'
require 'logger'

require_relative '../../framework/core/options/config_file_options'
require_relative '../../framework/core/options/option_store'
require_relative '../../framework/core/options/options_validator'

require_relative '../../../facter/framework/core/options'
require_relative '../../../facter/framework/logging/logger_helper'
require_relative '../../../facter/framework/logging/logger'

require_relative '../../../facter/util/file_helper'

require_relative '../../../facter/resolvers/base_resolver'
require_relative '../../../facter/framework/detector/os_hierarchy'
require_relative '../../../facter/framework/detector/os_detector'

require_relative '../../../facter/framework/config/config_reader'
require_relative '../../../facter/framework/config/fact_groups'

require_relative '../../util/api_debugger'
require_relative '../../util/file_helper'
require_relative '../../util/utils'

require_relative '../../util/resolvers/aws_token'
require_relative '../../util/resolvers/filesystem_helper'
require_relative '../../util/resolvers/fingerprint'
require_relative '../../util/resolvers/http'
require_relative '../../util/resolvers/ssh'
require_relative '../../util/resolvers/ssh_helper'
require_relative '../../util/resolvers/uptime_helper'

require_relative '../../util/facts/facts_utils'
require_relative '../../util/facts/unit_converter'
require_relative '../../util/facts/uptime_parser'
require_relative '../../util/facts/windows_release_finder'

require_relative '../../util/facts/posix/virtual_detector'

require_relative '../../util/resolvers/networking/dhcp'
require_relative '../../util/resolvers/networking/networking'
require_relative '../../util/resolvers/networking/primary_interface'

require_relative '../../resolvers/aio_agent_version'
require_relative '../../resolvers/augeas'
require_relative '../../resolvers/az'
require_relative '../../resolvers/base_resolver'
require_relative '../../resolvers/containers'
require_relative '../../resolvers/debian_version'
require_relative '../../resolvers/disks'
require_relative '../../resolvers/dmi'
require_relative '../../resolvers/dmi_decode'
require_relative '../../resolvers/ec2'
require_relative '../../resolvers/eos_release'
require_relative '../../resolvers/facterversion'
require_relative '../../resolvers/filesystems'
require_relative '../../resolvers/fips_enabled'
require_relative '../../resolvers/gce'
require_relative '../../resolvers/hostname'
require_relative '../../resolvers/identity'
require_relative '../../resolvers/load_averages'
require_relative '../../resolvers/lpar'
require_relative '../../resolvers/lsb_release'
require_relative '../../resolvers/lspci'
require_relative '../../resolvers/memory'
require_relative '../../resolvers/mountpoints'
require_relative '../../resolvers/networking'
require_relative '../../resolvers/open_vz'
require_relative '../../resolvers/os_release'
require_relative '../../resolvers/partitions'
require_relative '../../resolvers/path'
require_relative '../../resolvers/processors'
require_relative '../../resolvers/processors_lscpu'
require_relative '../../resolvers/redhat_release'
require_relative '../../resolvers/release_from_first_line'
require_relative '../../resolvers/ruby'
require_relative '../../resolvers/selinux'
require_relative '../../resolvers/specific_release_file'
require_relative '../../resolvers/ssh'
require_relative '../../resolvers/suse_release'
require_relative '../../resolvers/sw_vers'
require_relative '../../resolvers/timezone'
require_relative '../../resolvers/uname'
require_relative '../../resolvers/uptime'
require_relative '../../resolvers/virt_what'
require_relative '../../resolvers/vmware'
require_relative '../../resolvers/wpar'
require_relative '../../resolvers/xen'
require_relative '../../resolvers/zfs'
require_relative '../../resolvers/zpool'

require_relative '../../framework/core/cache_manager'
require_relative '../../framework/core/fact_filter'
require_relative '../../framework/core/fact_manager'
require_relative '../../framework/core/options'
require_relative '../../framework/core/session_cache'

require_relative '../../models/fact_collection'
require_relative '../../models/loaded_fact'
require_relative '../../models/resolved_fact'
require_relative '../../models/searched_fact'

require_relative '../../framework/benchmarking/timer'

require_relative '../../framework/core/fact_loaders/class_discoverer'
require_relative '../../framework/core/fact_loaders/external_fact_loader'
require_relative '../../framework/core/fact_loaders/fact_loader'
require_relative '../../framework/core/fact_loaders/internal_fact_loader'

require_relative '../../framework/core/fact/internal/core_fact'
require_relative '../../framework/core/fact/internal/internal_fact_manager'

require_relative '../../framework/core/fact/external/external_fact_manager'

require_relative '../../framework/formatters/formatter_factory'
require_relative '../../framework/formatters/formatter_helper'
require_relative '../../framework/formatters/hocon_fact_formatter'
require_relative '../../framework/formatters/json_fact_formatter'
require_relative '../../framework/formatters/legacy_fact_formatter'
require_relative '../../framework/formatters/yaml_fact_formatter'

os_hierarchy = OsDetector.instance.hierarchy
os_hierarchy.each do |os|
  case os.downcase
  when 'aix'
    require_relative '../../util/aix/info_extractor'
    require_relative '../../util/aix/odm_query'

    require_relative '../../facts/aix/aio_agent_version'
    require_relative '../../facts/aix/augeas/version'
    require_relative '../../facts/aix/disks'
    require_relative '../../facts/aix/facterversion'
    require_relative '../../facts/aix/filesystems'
    require_relative '../../facts/aix/hypervisors/lpar'
    require_relative '../../facts/aix/hypervisors/wpar'
    require_relative '../../facts/aix/identity/gid'
    require_relative '../../facts/aix/identity/group'
    require_relative '../../facts/aix/identity/privileged'
    require_relative '../../facts/aix/identity/uid'
    require_relative '../../facts/aix/identity/user'
    require_relative '../../facts/aix/interfaces'
    require_relative '../../facts/aix/ipaddress6_interfaces'
    require_relative '../../facts/aix/ipaddress_interfaces'
    require_relative '../../facts/aix/kernel'
    require_relative '../../facts/aix/kernelmajversion'
    require_relative '../../facts/aix/kernelrelease'
    require_relative '../../facts/aix/kernelversion'
    require_relative '../../facts/aix/load_averages'
    require_relative '../../facts/aix/macaddress_interfaces'
    require_relative '../../facts/aix/memory/swap/available'
    require_relative '../../facts/aix/memory/swap/available_bytes'
    require_relative '../../facts/aix/memory/swap/capacity'
    require_relative '../../facts/aix/memory/swap/total'
    require_relative '../../facts/aix/memory/swap/total_bytes'
    require_relative '../../facts/aix/memory/swap/used'
    require_relative '../../facts/aix/memory/swap/used_bytes'
    require_relative '../../facts/aix/memory/system/available'
    require_relative '../../facts/aix/memory/system/available_bytes'
    require_relative '../../facts/aix/memory/system/capacity'
    require_relative '../../facts/aix/memory/system/total'
    require_relative '../../facts/aix/memory/system/total_bytes'
    require_relative '../../facts/aix/memory/system/used'
    require_relative '../../facts/aix/memory/system/used_bytes'
    require_relative '../../facts/aix/mountpoints'
    require_relative '../../facts/aix/mtu_interfaces'
    require_relative '../../facts/aix/netmask6_interfaces'
    require_relative '../../facts/aix/netmask_interfaces'
    require_relative '../../facts/aix/network6_interfaces'
    require_relative '../../facts/aix/network_interfaces'
    require_relative '../../facts/aix/networking/domain'
    require_relative '../../facts/aix/networking/fqdn'
    require_relative '../../facts/aix/networking/hostname'
    require_relative '../../facts/aix/networking/interfaces'
    require_relative '../../facts/aix/networking/ip'
    require_relative '../../facts/aix/networking/ip6'
    require_relative '../../facts/aix/networking/mac'
    require_relative '../../facts/aix/networking/mtu'
    require_relative '../../facts/aix/networking/netmask'
    require_relative '../../facts/aix/networking/netmask6'
    require_relative '../../facts/aix/networking/network'
    require_relative '../../facts/aix/networking/network6'
    require_relative '../../facts/aix/networking/primary'
    require_relative '../../facts/aix/networking/scope6'
    require_relative '../../facts/aix/nim_type'
    require_relative '../../facts/aix/os/architecture'
    require_relative '../../facts/aix/os/family'
    require_relative '../../facts/aix/os/hardware'
    require_relative '../../facts/aix/os/name'
    require_relative '../../facts/aix/os/release'
    require_relative '../../facts/aix/partitions'
    require_relative '../../facts/aix/path'
    require_relative '../../facts/aix/processor'
    require_relative '../../facts/aix/processors/cores'
    require_relative '../../facts/aix/processors/count'
    require_relative '../../facts/aix/processors/isa'
    require_relative '../../facts/aix/processors/models'
    require_relative '../../facts/aix/processors/speed'
    require_relative '../../facts/aix/processors/threads'
    require_relative '../../facts/aix/ruby/platform'
    require_relative '../../facts/aix/ruby/sitedir'
    require_relative '../../facts/aix/ruby/version'
    require_relative '../../facts/aix/scope6_interfaces'
    require_relative '../../facts/aix/serialnumber'
    require_relative '../../facts/aix/ssh'
    require_relative '../../facts/aix/sshalgorithmkey'
    require_relative '../../facts/aix/sshfp_algorithm'
    require_relative '../../facts/aix/system_uptime/days'
    require_relative '../../facts/aix/system_uptime/hours'
    require_relative '../../facts/aix/system_uptime/seconds'
    require_relative '../../facts/aix/system_uptime/uptime'
    require_relative '../../facts/aix/timezone'

    require_relative '../../resolvers/aix/architecture'
    require_relative '../../resolvers/aix/disks'
    require_relative '../../resolvers/aix/filesystem'
    require_relative '../../resolvers/aix/hardware'
    require_relative '../../resolvers/aix/load_averages'
    require_relative '../../resolvers/aix/memory'
    require_relative '../../resolvers/aix/mountpoints'
    require_relative '../../resolvers/aix/networking'
    require_relative '../../resolvers/aix/nim'
    require_relative '../../resolvers/aix/os_level'
    require_relative '../../resolvers/aix/partitions'
    require_relative '../../resolvers/aix/processors'
    require_relative '../../resolvers/aix/serialnumber'

  when 'alpine'
    require_relative '../../facts/alpine/os/release'

  when 'amzn'
    require_relative '../../facts/amzn/lsbdistcodename'
    require_relative '../../facts/amzn/lsbdistdescription'
    require_relative '../../facts/amzn/lsbdistid'
    require_relative '../../facts/amzn/os/distro/codename'
    require_relative '../../facts/amzn/os/distro/description'
    require_relative '../../facts/amzn/os/distro/id'
    require_relative '../../facts/amzn/os/distro/release'
    require_relative '../../facts/amzn/os/release'

    require_relative '../../resolvers/amzn/os_release_rpm'

  when 'bsd'
    require_relative '../../facts/bsd/kernelmajversion'
    require_relative '../../facts/bsd/kernelversion'
    require_relative '../../facts/bsd/load_averages'
    require_relative '../../facts/bsd/os/family'
    require_relative '../../facts/bsd/processors/count'
    require_relative '../../facts/bsd/processors/models'
    require_relative '../../facts/bsd/processors/speed'

    require_relative '../../resolvers/bsd/processors'

  when 'debian'
    require_relative '../../facts/debian/architecture'
    require_relative '../../facts/debian/lsbdistcodename'
    require_relative '../../facts/debian/lsbdistdescription'
    require_relative '../../facts/debian/lsbdistid'
    require_relative '../../facts/debian/os/distro/codename'
    require_relative '../../facts/debian/os/distro/description'
    require_relative '../../facts/debian/os/distro/id'
    require_relative '../../facts/debian/os/distro/release'
    require_relative '../../facts/debian/os/release'

  when 'devuan'
    require_relative '../../facts/devuan/os/distro/release'
    require_relative '../../facts/devuan/os/release'

  when 'freebsd'
    require_relative '../../facts/freebsd/augeas/version'
    require_relative '../../facts/freebsd/disks'
    require_relative '../../facts/freebsd/dmi/bios/release_date'
    require_relative '../../facts/freebsd/dmi/bios/vendor'
    require_relative '../../facts/freebsd/dmi/bios/version'
    require_relative '../../facts/freebsd/dmi/manufacturer'
    require_relative '../../facts/freebsd/dmi/product/name'
    require_relative '../../facts/freebsd/dmi/product/serial_number'
    require_relative '../../facts/freebsd/dmi/product/uuid'
    require_relative '../../facts/freebsd/ec2_metadata'
    require_relative '../../facts/freebsd/ec2_userdata'
    require_relative '../../facts/freebsd/facterversion'
    require_relative '../../facts/freebsd/identity/gid'
    require_relative '../../facts/freebsd/identity/group'
    require_relative '../../facts/freebsd/identity/privileged'
    require_relative '../../facts/freebsd/identity/uid'
    require_relative '../../facts/freebsd/identity/user'
    require_relative '../../facts/freebsd/ipaddress6_interfaces'
    require_relative '../../facts/freebsd/ipaddress_interfaces'
    require_relative '../../facts/freebsd/is_virtual'
    require_relative '../../facts/freebsd/kernel'
    require_relative '../../facts/freebsd/kernelrelease'
    require_relative '../../facts/freebsd/memory/swap/available'
    require_relative '../../facts/freebsd/memory/swap/available_bytes'
    require_relative '../../facts/freebsd/memory/swap/capacity'
    require_relative '../../facts/freebsd/memory/swap/encrypted'
    require_relative '../../facts/freebsd/memory/swap/total'
    require_relative '../../facts/freebsd/memory/swap/total_bytes'
    require_relative '../../facts/freebsd/memory/swap/used'
    require_relative '../../facts/freebsd/memory/swap/used_bytes'
    require_relative '../../facts/freebsd/memory/system/available'
    require_relative '../../facts/freebsd/memory/system/available_bytes'
    require_relative '../../facts/freebsd/memory/system/capacity'
    require_relative '../../facts/freebsd/memory/system/total'
    require_relative '../../facts/freebsd/memory/system/total_bytes'
    require_relative '../../facts/freebsd/memory/system/used'
    require_relative '../../facts/freebsd/memory/system/used_bytes'
    require_relative '../../facts/freebsd/mountpoints'
    require_relative '../../facts/freebsd/netmask6_interfaces'
    require_relative '../../facts/freebsd/netmask_interfaces'
    require_relative '../../facts/freebsd/network6_interfaces'
    require_relative '../../facts/freebsd/network_interfaces'
    require_relative '../../facts/freebsd/networking/dhcp'
    require_relative '../../facts/freebsd/networking/domain'
    require_relative '../../facts/freebsd/networking/fqdn'
    require_relative '../../facts/freebsd/networking/hostname'
    require_relative '../../facts/freebsd/networking/interfaces'
    require_relative '../../facts/freebsd/networking/ip'
    require_relative '../../facts/freebsd/networking/ip6'
    require_relative '../../facts/freebsd/networking/mac'
    require_relative '../../facts/freebsd/networking/mtu'
    require_relative '../../facts/freebsd/networking/netmask'
    require_relative '../../facts/freebsd/networking/netmask6'
    require_relative '../../facts/freebsd/networking/network'
    require_relative '../../facts/freebsd/networking/network6'
    require_relative '../../facts/freebsd/networking/primary'
    require_relative '../../facts/freebsd/networking/scope6'
    require_relative '../../facts/freebsd/os/architecture'
    require_relative '../../facts/freebsd/os/hardware'
    require_relative '../../facts/freebsd/os/name'
    require_relative '../../facts/freebsd/os/release'
    require_relative '../../facts/freebsd/partitions'
    require_relative '../../facts/freebsd/path'
    require_relative '../../facts/freebsd/processors/count'
    require_relative '../../facts/freebsd/processors/isa'
    require_relative '../../facts/freebsd/processors/models'
    require_relative '../../facts/freebsd/processors/speed'
    require_relative '../../facts/freebsd/ruby/platform'
    require_relative '../../facts/freebsd/ruby/sitedir'
    require_relative '../../facts/freebsd/ruby/version'
    require_relative '../../facts/freebsd/ssh'
    require_relative '../../facts/freebsd/sshalgorithmkey'
    require_relative '../../facts/freebsd/sshfp_algorithm'
    require_relative '../../facts/freebsd/system_uptime/days'
    require_relative '../../facts/freebsd/system_uptime/hours'
    require_relative '../../facts/freebsd/system_uptime/seconds'
    require_relative '../../facts/freebsd/system_uptime/uptime'
    require_relative '../../facts/freebsd/timezone'
    require_relative '../../facts/freebsd/virtual'
    require_relative '../../facts/freebsd/zfs_featurenumbers'
    require_relative '../../facts/freebsd/zfs_version'
    require_relative '../../facts/freebsd/zpool_featureflags'
    require_relative '../../facts/freebsd/zpool_featurenumbers'
    require_relative '../../facts/freebsd/zpool_version'

    require_relative '../../resolvers/freebsd/dmi'
    require_relative '../../resolvers/freebsd/freebsd_version'
    require_relative '../../resolvers/freebsd/geom'
    require_relative '../../resolvers/freebsd/processors'
    require_relative '../../resolvers/freebsd/swap_memory'
    require_relative '../../resolvers/freebsd/system_memory'
    require_relative '../../resolvers/freebsd/virtual'

  when 'gentoo'
    require_relative '../../facts/gentoo/os/release'

  when 'linux'
    require_relative '../../util/linux/dhcp'
    require_relative '../../util/linux/if_inet6'
    require_relative '../../util/linux/routing_table'
    require_relative '../../util/linux/socket_parser'

    require_relative '../../facts/linux/aio_agent_version'
    require_relative '../../facts/linux/augeas/version'
    require_relative '../../facts/linux/az_metadata'
    require_relative '../../facts/linux/cloud/provider'
    require_relative '../../facts/linux/dhcp_servers'
    require_relative '../../facts/linux/disks'
    require_relative '../../facts/linux/dmi/bios/release_date'
    require_relative '../../facts/linux/dmi/bios/vendor'
    require_relative '../../facts/linux/dmi/bios/version'
    require_relative '../../facts/linux/dmi/board/asset_tag'
    require_relative '../../facts/linux/dmi/board/manufacturer'
    require_relative '../../facts/linux/dmi/board/product'
    require_relative '../../facts/linux/dmi/board/serial_number'
    require_relative '../../facts/linux/dmi/chassis/asset_tag'
    require_relative '../../facts/linux/dmi/chassis/type'
    require_relative '../../facts/linux/dmi/manufacturer'
    require_relative '../../facts/linux/dmi/product/name'
    require_relative '../../facts/linux/dmi/product/serial_number'
    require_relative '../../facts/linux/dmi/product/uuid'
    require_relative '../../facts/linux/dmi/product/version'
    require_relative '../../facts/linux/ec2_metadata'
    require_relative '../../facts/linux/ec2_userdata'
    require_relative '../../facts/linux/facterversion'
    require_relative '../../facts/linux/filesystems'
    require_relative '../../facts/linux/fips_enabled'
    require_relative '../../facts/linux/gce'
    require_relative '../../facts/linux/hypervisors/docker'
    require_relative '../../facts/linux/hypervisors/hyper_v'
    require_relative '../../facts/linux/hypervisors/kvm'
    require_relative '../../facts/linux/hypervisors/lxc'
    require_relative '../../facts/linux/hypervisors/openvz'
    require_relative '../../facts/linux/hypervisors/systemd_nspawn'
    require_relative '../../facts/linux/hypervisors/virtualbox'
    require_relative '../../facts/linux/hypervisors/vmware'
    require_relative '../../facts/linux/hypervisors/xen'
    require_relative '../../facts/linux/identity/gid'
    require_relative '../../facts/linux/identity/group'
    require_relative '../../facts/linux/identity/privileged'
    require_relative '../../facts/linux/identity/uid'
    require_relative '../../facts/linux/identity/user'
    require_relative '../../facts/linux/interfaces'
    require_relative '../../facts/linux/ipaddress6_interfaces'
    require_relative '../../facts/linux/ipaddress_interfaces'
    require_relative '../../facts/linux/is_virtual'
    require_relative '../../facts/linux/kernel'
    require_relative '../../facts/linux/kernelmajversion'
    require_relative '../../facts/linux/kernelrelease'
    require_relative '../../facts/linux/kernelversion'
    require_relative '../../facts/linux/load_averages'
    require_relative '../../facts/linux/lsbdistrelease'
    require_relative '../../facts/linux/macaddress_interfaces'
    require_relative '../../facts/linux/memory/swap/available'
    require_relative '../../facts/linux/memory/swap/available_bytes'
    require_relative '../../facts/linux/memory/swap/capacity'
    require_relative '../../facts/linux/memory/swap/total'
    require_relative '../../facts/linux/memory/swap/total_bytes'
    require_relative '../../facts/linux/memory/swap/used'
    require_relative '../../facts/linux/memory/swap/used_bytes'
    require_relative '../../facts/linux/memory/system/available'
    require_relative '../../facts/linux/memory/system/available_bytes'
    require_relative '../../facts/linux/memory/system/capacity'
    require_relative '../../facts/linux/memory/system/total'
    require_relative '../../facts/linux/memory/system/total_bytes'
    require_relative '../../facts/linux/memory/system/used'
    require_relative '../../facts/linux/memory/system/used_bytes'
    require_relative '../../facts/linux/mountpoints'
    require_relative '../../facts/linux/mtu_interfaces'
    require_relative '../../facts/linux/netmask6_interfaces'
    require_relative '../../facts/linux/netmask_interfaces'
    require_relative '../../facts/linux/network6_interfaces'
    require_relative '../../facts/linux/network_interfaces'
    require_relative '../../facts/linux/networking/dhcp'
    require_relative '../../facts/linux/networking/domain'
    require_relative '../../facts/linux/networking/fqdn'
    require_relative '../../facts/linux/networking/hostname'
    require_relative '../../facts/linux/networking/interfaces'
    require_relative '../../facts/linux/networking/ip'
    require_relative '../../facts/linux/networking/ip6'
    require_relative '../../facts/linux/networking/mac'
    require_relative '../../facts/linux/networking/mtu'
    require_relative '../../facts/linux/networking/netmask'
    require_relative '../../facts/linux/networking/netmask6'
    require_relative '../../facts/linux/networking/network'
    require_relative '../../facts/linux/networking/network6'
    require_relative '../../facts/linux/networking/primary'
    require_relative '../../facts/linux/networking/scope6'
    require_relative '../../facts/linux/os/architecture'
    require_relative '../../facts/linux/os/distro/codename'
    require_relative '../../facts/linux/os/distro/description'
    require_relative '../../facts/linux/os/distro/id'
    require_relative '../../facts/linux/os/distro/release'
    require_relative '../../facts/linux/os/distro/specification'
    require_relative '../../facts/linux/os/family'
    require_relative '../../facts/linux/os/hardware'
    require_relative '../../facts/linux/os/name'
    require_relative '../../facts/linux/os/release'
    require_relative '../../facts/linux/os/selinux/config_mode'
    require_relative '../../facts/linux/os/selinux/config_policy'
    require_relative '../../facts/linux/os/selinux/current_mode'
    require_relative '../../facts/linux/os/selinux/enabled'
    require_relative '../../facts/linux/os/selinux/enforced'
    require_relative '../../facts/linux/os/selinux/policy_version'
    require_relative '../../facts/linux/partitions'
    require_relative '../../facts/linux/path'
    require_relative '../../facts/linux/processor'
    require_relative '../../facts/linux/processors/cores'
    require_relative '../../facts/linux/processors/count'
    require_relative '../../facts/linux/processors/isa'
    require_relative '../../facts/linux/processors/models'
    require_relative '../../facts/linux/processors/physicalcount'
    require_relative '../../facts/linux/processors/speed'
    require_relative '../../facts/linux/processors/threads'
    require_relative '../../facts/linux/ruby/platform'
    require_relative '../../facts/linux/ruby/sitedir'
    require_relative '../../facts/linux/ruby/version'
    require_relative '../../facts/linux/scope6_interfaces'
    require_relative '../../facts/linux/ssh'
    require_relative '../../facts/linux/sshalgorithmkey'
    require_relative '../../facts/linux/sshfp_algorithm'
    require_relative '../../facts/linux/system_uptime/days'
    require_relative '../../facts/linux/system_uptime/hours'
    require_relative '../../facts/linux/system_uptime/seconds'
    require_relative '../../facts/linux/system_uptime/uptime'
    require_relative '../../facts/linux/timezone'
    require_relative '../../facts/linux/virtual'
    require_relative '../../facts/linux/xen'

    require_relative '../../resolvers/linux/docker_uptime'
    require_relative '../../resolvers/linux/hostname'
    require_relative '../../resolvers/linux/load_averages'
    require_relative '../../resolvers/linux/networking'

  when 'linuxmint'
    require_relative '../../facts/linuxmint/os/name'
    require_relative '../../facts/linuxmint/os/release'

  when 'macosx'
    require_relative '../../util/macosx/system_profile_executor'

    require_relative '../../facts/macosx/aio_agent_version'
    require_relative '../../facts/macosx/augeas/version'
    require_relative '../../facts/macosx/dhcp_servers'
    require_relative '../../facts/macosx/dmi/product/name'
    require_relative '../../facts/macosx/facterversion'
    require_relative '../../facts/macosx/filesystems'
    require_relative '../../facts/macosx/identity/gid'
    require_relative '../../facts/macosx/identity/group'
    require_relative '../../facts/macosx/identity/privileged'
    require_relative '../../facts/macosx/identity/uid'
    require_relative '../../facts/macosx/identity/user'
    require_relative '../../facts/macosx/interfaces'
    require_relative '../../facts/macosx/ipaddress6_interfaces'
    require_relative '../../facts/macosx/ipaddress_interfaces'
    require_relative '../../facts/macosx/is_virtual'
    require_relative '../../facts/macosx/kernel'
    require_relative '../../facts/macosx/kernelmajversion'
    require_relative '../../facts/macosx/kernelrelease'
    require_relative '../../facts/macosx/kernelversion'
    require_relative '../../facts/macosx/load_averages'
    require_relative '../../facts/macosx/macaddress_interfaces'
    require_relative '../../facts/macosx/memory/swap/available'
    require_relative '../../facts/macosx/memory/swap/available_bytes'
    require_relative '../../facts/macosx/memory/swap/capacity'
    require_relative '../../facts/macosx/memory/swap/encrypted'
    require_relative '../../facts/macosx/memory/swap/total'
    require_relative '../../facts/macosx/memory/swap/total_bytes'
    require_relative '../../facts/macosx/memory/swap/used'
    require_relative '../../facts/macosx/memory/swap/used_bytes'
    require_relative '../../facts/macosx/memory/system/available'
    require_relative '../../facts/macosx/memory/system/available_bytes'
    require_relative '../../facts/macosx/memory/system/capacity'
    require_relative '../../facts/macosx/memory/system/total'
    require_relative '../../facts/macosx/memory/system/total_bytes'
    require_relative '../../facts/macosx/memory/system/used'
    require_relative '../../facts/macosx/memory/system/used_bytes'
    require_relative '../../facts/macosx/mountpoints'
    require_relative '../../facts/macosx/mtu_interfaces'
    require_relative '../../facts/macosx/netmask6_interfaces'
    require_relative '../../facts/macosx/netmask_interfaces'
    require_relative '../../facts/macosx/network6_interfaces'
    require_relative '../../facts/macosx/network_interfaces'
    require_relative '../../facts/macosx/networking/dhcp'
    require_relative '../../facts/macosx/networking/domain'
    require_relative '../../facts/macosx/networking/fqdn'
    require_relative '../../facts/macosx/networking/hostname'
    require_relative '../../facts/macosx/networking/interfaces'
    require_relative '../../facts/macosx/networking/ip'
    require_relative '../../facts/macosx/networking/ip6'
    require_relative '../../facts/macosx/networking/mac'
    require_relative '../../facts/macosx/networking/mtu'
    require_relative '../../facts/macosx/networking/netmask'
    require_relative '../../facts/macosx/networking/netmask6'
    require_relative '../../facts/macosx/networking/network'
    require_relative '../../facts/macosx/networking/network6'
    require_relative '../../facts/macosx/networking/primary'
    require_relative '../../facts/macosx/networking/scope6'
    require_relative '../../facts/macosx/os/architecture'
    require_relative '../../facts/macosx/os/family'
    require_relative '../../facts/macosx/os/hardware'
    require_relative '../../facts/macosx/os/macosx/build'
    require_relative '../../facts/macosx/os/macosx/product'
    require_relative '../../facts/macosx/os/macosx/version'
    require_relative '../../facts/macosx/os/name'
    require_relative '../../facts/macosx/os/release'
    require_relative '../../facts/macosx/path'
    require_relative '../../facts/macosx/processors/cores'
    require_relative '../../facts/macosx/processors/count'
    require_relative '../../facts/macosx/processors/isa'
    require_relative '../../facts/macosx/processors/models'
    require_relative '../../facts/macosx/processors/physicalcount'
    require_relative '../../facts/macosx/processors/speed'
    require_relative '../../facts/macosx/processors/threads'
    require_relative '../../facts/macosx/ruby/platform'
    require_relative '../../facts/macosx/ruby/sitedir'
    require_relative '../../facts/macosx/ruby/version'
    require_relative '../../facts/macosx/scope6_interfaces'
    require_relative '../../facts/macosx/ssh'
    require_relative '../../facts/macosx/sshalgorithmkey'
    require_relative '../../facts/macosx/sshfp_algorithm'
    require_relative '../../facts/macosx/system_profiler/boot_mode'
    require_relative '../../facts/macosx/system_profiler/boot_rom_version'
    require_relative '../../facts/macosx/system_profiler/boot_volume'
    require_relative '../../facts/macosx/system_profiler/computer_name'
    require_relative '../../facts/macosx/system_profiler/cores'
    require_relative '../../facts/macosx/system_profiler/hardware_uuid'
    require_relative '../../facts/macosx/system_profiler/kernel_version'
    require_relative '../../facts/macosx/system_profiler/l2_cache_per_core'
    require_relative '../../facts/macosx/system_profiler/l3_cache'
    require_relative '../../facts/macosx/system_profiler/memory'
    require_relative '../../facts/macosx/system_profiler/model_identifier'
    require_relative '../../facts/macosx/system_profiler/model_name'
    require_relative '../../facts/macosx/system_profiler/processor_name'
    require_relative '../../facts/macosx/system_profiler/processor_speed'
    require_relative '../../facts/macosx/system_profiler/processors'
    require_relative '../../facts/macosx/system_profiler/secure_virtual_memory'
    require_relative '../../facts/macosx/system_profiler/serial_number'
    require_relative '../../facts/macosx/system_profiler/smc_version'
    require_relative '../../facts/macosx/system_profiler/system_version'
    require_relative '../../facts/macosx/system_profiler/uptime'
    require_relative '../../facts/macosx/system_profiler/username'
    require_relative '../../facts/macosx/system_uptime/days'
    require_relative '../../facts/macosx/system_uptime/hours'
    require_relative '../../facts/macosx/system_uptime/seconds'
    require_relative '../../facts/macosx/system_uptime/uptime'
    require_relative '../../facts/macosx/timezone'
    require_relative '../../facts/macosx/virtual'

    require_relative '../../resolvers/macosx/dmi'
    require_relative '../../resolvers/macosx/filesystems'
    require_relative '../../resolvers/macosx/load_averages'
    require_relative '../../resolvers/macosx/mountpoints'
    require_relative '../../resolvers/macosx/processors'
    require_relative '../../resolvers/macosx/swap_memory'
    require_relative '../../resolvers/macosx/system_memory'
    require_relative '../../resolvers/macosx/system_profiler'

  when 'mageia'
    require_relative '../../facts/mageia/os/release'

  when 'mariner'
    require_relative '../../facts/mariner/os/release'

  when 'meego'
    require_relative '../../facts/meego/os/release'

  when 'oel'
    require_relative '../../facts/oel/os/release'

  when 'ol'
    require_relative '../../facts/ol/os/release'
    require_relative '../../facts/ol/lsbdistdescription'
    require_relative '../../facts/ol/lsbdistid'
    require_relative '../../facts/ol/os/distro/description'
    require_relative '../../facts/ol/os/distro/id'

  when 'openwrt'
    require_relative '../../facts/openwrt/os/release'

  when 'ovs'
    require_relative '../../facts/ovs/os/release'

  when 'photon'
    require_relative '../../facts/photon/os/release'

  when 'rhel'
    require_relative '../../facts/rhel/lsbdistcodename'
    require_relative '../../facts/rhel/lsbdistdescription'
    require_relative '../../facts/rhel/lsbdistid'
    require_relative '../../facts/rhel/os/distro/codename'
    require_relative '../../facts/rhel/os/distro/description'
    require_relative '../../facts/rhel/os/distro/id'
    require_relative '../../facts/rhel/os/distro/release'
    require_relative '../../facts/rhel/os/family'
    require_relative '../../facts/rhel/os/name'
    require_relative '../../facts/rhel/os/release'

  when 'slackware'
    require_relative '../../facts/slackware/os/release'

  when 'sles'
    require_relative '../../facts/sles/lsbdistcodename'
    require_relative '../../facts/sles/lsbdistdescription'
    require_relative '../../facts/sles/lsbdistid'
    require_relative '../../facts/sles/os/distro/codename'
    require_relative '../../facts/sles/os/distro/description'
    require_relative '../../facts/sles/os/distro/id'
    require_relative '../../facts/sles/os/distro/release'
    require_relative '../../facts/sles/os/family'
    require_relative '../../facts/sles/os/release'

  when 'solaris'
    require_relative '../../facts/solaris/aio_agent_version'
    require_relative '../../facts/solaris/augeas/version'
    require_relative '../../facts/solaris/current_zone'
    require_relative '../../facts/solaris/dhcp_servers'
    require_relative '../../facts/solaris/disks'
    require_relative '../../facts/solaris/dmi/bios/release_date'
    require_relative '../../facts/solaris/dmi/bios/vendor'
    require_relative '../../facts/solaris/dmi/bios/version'
    require_relative '../../facts/solaris/dmi/chassis/asset_tag'
    require_relative '../../facts/solaris/dmi/chassis/type'
    require_relative '../../facts/solaris/dmi/manufacturer'
    require_relative '../../facts/solaris/dmi/product/name'
    require_relative '../../facts/solaris/dmi/product/serial_number'
    require_relative '../../facts/solaris/dmi/product/uuid'
    require_relative '../../facts/solaris/facterversion'
    require_relative '../../facts/solaris/filesystems'
    require_relative '../../facts/solaris/hypervisors/ldom'
    require_relative '../../facts/solaris/hypervisors/zone'
    require_relative '../../facts/solaris/identity/gid'
    require_relative '../../facts/solaris/identity/group'
    require_relative '../../facts/solaris/identity/privileged'
    require_relative '../../facts/solaris/identity/uid'
    require_relative '../../facts/solaris/identity/user'
    require_relative '../../facts/solaris/interfaces'
    require_relative '../../facts/solaris/ipaddress6_interfaces'
    require_relative '../../facts/solaris/ipaddress_interfaces'
    require_relative '../../facts/solaris/is_virtual'
    require_relative '../../facts/solaris/kernel'
    require_relative '../../facts/solaris/kernelmajversion'
    require_relative '../../facts/solaris/kernelrelease'
    require_relative '../../facts/solaris/kernelversion'
    require_relative '../../facts/solaris/ldom'
    require_relative '../../facts/solaris/load_averages'
    require_relative '../../facts/solaris/macaddress_interfaces'
    require_relative '../../facts/solaris/memory/swap/available'
    require_relative '../../facts/solaris/memory/swap/available_bytes'
    require_relative '../../facts/solaris/memory/swap/capacity'
    require_relative '../../facts/solaris/memory/swap/total'
    require_relative '../../facts/solaris/memory/swap/total_bytes'
    require_relative '../../facts/solaris/memory/swap/used'
    require_relative '../../facts/solaris/memory/swap/used_bytes'
    require_relative '../../facts/solaris/memory/system/available'
    require_relative '../../facts/solaris/memory/system/available_bytes'
    require_relative '../../facts/solaris/memory/system/capacity'
    require_relative '../../facts/solaris/memory/system/total'
    require_relative '../../facts/solaris/memory/system/total_bytes'
    require_relative '../../facts/solaris/memory/system/used'
    require_relative '../../facts/solaris/memory/system/used_bytes'
    require_relative '../../facts/solaris/mountpoints'
    require_relative '../../facts/solaris/mtu_interfaces'
    require_relative '../../facts/solaris/netmask6_interfaces'
    require_relative '../../facts/solaris/netmask_interfaces'
    require_relative '../../facts/solaris/network6_interfaces'
    require_relative '../../facts/solaris/network_interfaces'
    require_relative '../../facts/solaris/networking/dhcp'
    require_relative '../../facts/solaris/networking/domain'
    require_relative '../../facts/solaris/networking/fqdn'
    require_relative '../../facts/solaris/networking/hostname'
    require_relative '../../facts/solaris/networking/interfaces'
    require_relative '../../facts/solaris/networking/ip'
    require_relative '../../facts/solaris/networking/ip6'
    require_relative '../../facts/solaris/networking/mac'
    require_relative '../../facts/solaris/networking/mtu'
    require_relative '../../facts/solaris/networking/netmask'
    require_relative '../../facts/solaris/networking/netmask6'
    require_relative '../../facts/solaris/networking/network'
    require_relative '../../facts/solaris/networking/network6'
    require_relative '../../facts/solaris/networking/primary'
    require_relative '../../facts/solaris/os/architecture'
    require_relative '../../facts/solaris/os/family'
    require_relative '../../facts/solaris/os/hardware'
    require_relative '../../facts/solaris/os/name'
    require_relative '../../facts/solaris/os/release'
    require_relative '../../facts/solaris/path'
    require_relative '../../facts/solaris/processors/cores'
    require_relative '../../facts/solaris/processors/count'
    require_relative '../../facts/solaris/processors/isa'
    require_relative '../../facts/solaris/processors/models'
    require_relative '../../facts/solaris/processors/physicalcount'
    require_relative '../../facts/solaris/processors/speed'
    require_relative '../../facts/solaris/processors/threads'
    require_relative '../../facts/solaris/ruby/platform'
    require_relative '../../facts/solaris/ruby/sitedir'
    require_relative '../../facts/solaris/ruby/version'
    require_relative '../../facts/solaris/ssh'
    require_relative '../../facts/solaris/sshalgorithmkey'
    require_relative '../../facts/solaris/sshfp_algorithm'
    require_relative '../../facts/solaris/system_uptime/days'
    require_relative '../../facts/solaris/system_uptime/hours'
    require_relative '../../facts/solaris/system_uptime/seconds'
    require_relative '../../facts/solaris/system_uptime/uptime'
    require_relative '../../facts/solaris/timezone'
    require_relative '../../facts/solaris/virtual'
    require_relative '../../facts/solaris/zfs_featurenumbers'
    require_relative '../../facts/solaris/zfs_version'
    require_relative '../../facts/solaris/zones'
    require_relative '../../facts/solaris/zpool_featureflags'
    require_relative '../../facts/solaris/zpool_featurenumbers'
    require_relative '../../facts/solaris/zpool_version'

    require_relative '../../resolvers/solaris/disks'
    require_relative '../../resolvers/solaris/dmi'
    require_relative '../../resolvers/solaris/dmi_sparc'
    require_relative '../../resolvers/solaris/filesystems'
    require_relative '../../resolvers/solaris/ipaddress'
    require_relative '../../resolvers/solaris/ldom'
    require_relative '../../resolvers/solaris/memory'
    require_relative '../../resolvers/solaris/mountpoints'
    require_relative '../../resolvers/solaris/networking'
    require_relative '../../resolvers/solaris/os_release'
    require_relative '../../resolvers/solaris/processors'
    require_relative '../../resolvers/solaris/zone'
    require_relative '../../resolvers/solaris/zone_name'

  when 'ubuntu'
    require_relative '../../facts/ubuntu/lsbdistrelease'
    require_relative '../../facts/ubuntu/os/distro/release'
    require_relative '../../facts/ubuntu/os/release'

  when 'windows'
    require_relative '../../util/windows/win32ole'

    require_relative '../../facts/windows/aio_agent_version'
    require_relative '../../facts/windows/az_metadata'
    require_relative '../../facts/windows/cloud/provider'
    require_relative '../../facts/windows/dhcp_servers'
    require_relative '../../facts/windows/dmi/manufacturer'
    require_relative '../../facts/windows/dmi/product/name'
    require_relative '../../facts/windows/dmi/product/serial_number'
    require_relative '../../facts/windows/dmi/product/uuid'
    require_relative '../../facts/windows/ec2_metadata'
    require_relative '../../facts/windows/ec2_userdata'
    require_relative '../../facts/windows/facterversion'
    require_relative '../../facts/windows/fips_enabled'
    require_relative '../../facts/windows/gce'
    require_relative '../../facts/windows/hypervisors/hyperv'
    require_relative '../../facts/windows/hypervisors/kvm'
    require_relative '../../facts/windows/hypervisors/virtualbox'
    require_relative '../../facts/windows/hypervisors/vmware'
    require_relative '../../facts/windows/hypervisors/xen'
    require_relative '../../facts/windows/identity/privileged'
    require_relative '../../facts/windows/identity/user'
    require_relative '../../facts/windows/interfaces'
    require_relative '../../facts/windows/ipaddress6_interfaces'
    require_relative '../../facts/windows/ipaddress_interfaces'
    require_relative '../../facts/windows/is_virtual'
    require_relative '../../facts/windows/kernel'
    require_relative '../../facts/windows/kernelmajversion'
    require_relative '../../facts/windows/kernelrelease'
    require_relative '../../facts/windows/kernelversion'
    require_relative '../../facts/windows/macaddress_interfaces'
    require_relative '../../facts/windows/memory/system/available'
    require_relative '../../facts/windows/memory/system/available_bytes'
    require_relative '../../facts/windows/memory/system/capacity'
    require_relative '../../facts/windows/memory/system/total'
    require_relative '../../facts/windows/memory/system/total_bytes'
    require_relative '../../facts/windows/memory/system/used'
    require_relative '../../facts/windows/memory/system/used_bytes'
    require_relative '../../facts/windows/mtu_interfaces'
    require_relative '../../facts/windows/netmask6_interfaces'
    require_relative '../../facts/windows/netmask_interfaces'
    require_relative '../../facts/windows/network6_interfaces'
    require_relative '../../facts/windows/network_interfaces'
    require_relative '../../facts/windows/networking/dhcp'
    require_relative '../../facts/windows/networking/domain'
    require_relative '../../facts/windows/networking/fqdn'
    require_relative '../../facts/windows/networking/hostname'
    require_relative '../../facts/windows/networking/interfaces'
    require_relative '../../facts/windows/networking/ip'
    require_relative '../../facts/windows/networking/ip6'
    require_relative '../../facts/windows/networking/mac'
    require_relative '../../facts/windows/networking/mtu'
    require_relative '../../facts/windows/networking/netmask'
    require_relative '../../facts/windows/networking/netmask6'
    require_relative '../../facts/windows/networking/network'
    require_relative '../../facts/windows/networking/network6'
    require_relative '../../facts/windows/networking/primary'
    require_relative '../../facts/windows/networking/scope6'
    require_relative '../../facts/windows/os/architecture'
    require_relative '../../facts/windows/os/family'
    require_relative '../../facts/windows/os/hardware'
    require_relative '../../facts/windows/os/name'
    require_relative '../../facts/windows/os/release'
    require_relative '../../facts/windows/os/windows/display_version'
    require_relative '../../facts/windows/os/windows/edition_id'
    require_relative '../../facts/windows/os/windows/installation_type'
    require_relative '../../facts/windows/os/windows/product_name'
    require_relative '../../facts/windows/os/windows/release_id'
    require_relative '../../facts/windows/os/windows/system32'
    require_relative '../../facts/windows/path'
    require_relative '../../facts/windows/processor'
    require_relative '../../facts/windows/processors/cores'
    require_relative '../../facts/windows/processors/count'
    require_relative '../../facts/windows/processors/isa'
    require_relative '../../facts/windows/processors/models'
    require_relative '../../facts/windows/processors/physicalcount'
    require_relative '../../facts/windows/processors/threads'
    require_relative '../../facts/windows/ruby/platform'
    require_relative '../../facts/windows/ruby/sitedir'
    require_relative '../../facts/windows/ruby/version'
    require_relative '../../facts/windows/scope6_interfaces'
    require_relative '../../facts/windows/ssh'
    require_relative '../../facts/windows/sshalgorithmkey'
    require_relative '../../facts/windows/sshfp_algorithm'
    require_relative '../../facts/windows/system_uptime/days'
    require_relative '../../facts/windows/system_uptime/hours'
    require_relative '../../facts/windows/system_uptime/seconds'
    require_relative '../../facts/windows/system_uptime/uptime'
    require_relative '../../facts/windows/timezone'
    require_relative '../../facts/windows/virtual'

    require_relative '../../resolvers/windows/aio_agent_version'
    require_relative '../../resolvers/windows/dmi_bios'
    require_relative '../../resolvers/windows/dmi_computersystem'
    require_relative '../../resolvers/windows/fips'
    require_relative '../../resolvers/windows/hardware_architecture'
    require_relative '../../resolvers/windows/identity'
    require_relative '../../resolvers/windows/kernel'
    require_relative '../../resolvers/windows/memory'
    require_relative '../../resolvers/windows/netkvm'
    require_relative '../../resolvers/windows/networking'
    require_relative '../../resolvers/windows/processors'
    require_relative '../../resolvers/windows/product_release'
    require_relative '../../resolvers/windows/ssh'
    require_relative '../../resolvers/windows/system32'
    require_relative '../../resolvers/windows/timezone'
    require_relative '../../resolvers/windows/uptime'
    require_relative '../../resolvers/windows/virtualization'
    require_relative '../../resolvers/windows/win_os_description'
  end
end

require_relative '../../../facter/custom_facts/core/legacy_facter'

require_relative '../../../facter/framework/parsers/query_parser'
