/**
 * @file euca.h
 *
 * @brief Contains a set of helper functions for communicating with Eucalyptus
 *
 * @author Adrian Muresan (adrian.muresan@ens-lyon.fr)
 *
 * @section Licence
 *   |LICENCE|
 */


/* euca.h
   Generated by wsdl2h 1.2.16 from ec2.2008-12-01.wsdl and WS-typemap.dat
   2010-04-20 15:04:11 GMT

   DO NOT INCLUDE THIS FILE DIRECTLY INTO YOUR PROJECT BUILDS
   USE THE soapcpp2-GENERATED SOURCE CODE FILES FOR YOUR PROJECT BUILDS

   gSOAP XML Web services tools.
   Copyright (C) 2001-2010 Robert van Engelen, Genivia Inc. All Rights Reserved.
   Part of this software is released under one of the following licenses:
   GPL or Genivia's license for commercial use.
 */

/** @page page_notes Build Notes

    NOTE:

    - Run soapcpp2 on euca.h to generate the SOAP/XML processing logic.
    Use soapcpp2 option -I to specify paths for #import
    To build with STL, 'stlvector.h' is imported from 'import' dir in package.
    Use soapcpp2 option -i to generate improved proxy and server classes.
    - Use wsdl2h options -c and -s to generate pure C code or C++ code without STL.
    - Use 'typemap.dat' to control namespace bindings and type mappings.
    It is strongly recommended to customize the names of the namespace prefixes
    generated by wsdl2h. To do so, modify the prefix bindings in the Namespaces
    section below and add the modified lines to 'typemap.dat' to rerun wsdl2h.
    - Use Doxygen (www.doxygen.org) on this file to generate documentation.
    - Use wsdl2h options -nname and -Nname to globally rename the prefix 'ns'.
    - Use wsdl2h option -d to enable DOM support for xsd:anyType.
    - Use wsdl2h option -g to auto-generate readers and writers for root elements.
    - Struct/class members serialized as XML attributes are annotated with a '@'.
    - Struct/class members that have a special role are annotated with a '$'.

    WARNING:

    DO NOT INCLUDE THIS FILE DIRECTLY INTO YOUR PROJECT BUILDS.
    USE THE SOURCE CODE FILES GENERATED BY soapcpp2 FOR YOUR PROJECT BUILDS:
    THE soapStub.h FILE CONTAINS THIS CONTENT WITHOUT ANNOTATIONS.


    @verbatim
    --------------------------------------------------------------------------------
    gSOAP XML Web services tools
    Copyright (C) 2000-2010, Robert van Engelen, Genivia Inc. All Rights Reserved.

    This software is released under one of the following two licenses:
    1) GPL or 2) Genivia's license for commercial use.
    --------------------------------------------------------------------------------
    1) GPL license.

    This program is free software; you can redistribute it and/or modify it under
    the terms of the GNU General Public License as published by the Free Software
    Foundation; either version 2 of the License, or (at your option) any later
    version.

    This program is distributed in the hope that it will be useful, but WITHOUT ANY
    WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
    PARTICULAR PURPOSE. See the GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along with
    this program; if not, write to the Free Software Foundation, Inc., 59 Temple
    Place, Suite 330, Boston, MA 02111-1307 USA

    Author contact information:
    engelen@genivia.com / engelen@acm.org
    --------------------------------------------------------------------------------
    2) A commercial-use license is available from Genivia, Inc., contact@genivia.com
    --------------------------------------------------------------------------------
    @endverbatim

 */


// gsoapopt cw

/******************************************************************************\
*                                                                            *
* Definitions                                                                *
*   http://ec2.amazonaws.com/doc/2008-12-01/                                 *
*                                                                            *
\******************************************************************************/


/******************************************************************************\
*                                                                            *
* Import                                                                     *
*                                                                            *
\******************************************************************************/
#import "wsse.h"

/******************************************************************************\
*                                                                            *
* Schema Namespaces                                                          *
*                                                                            *
\******************************************************************************/


/* NOTE:

   It is strongly recommended to customize the names of the namespace prefixes
   generated by wsdl2h. To do so, modify the prefix bindings below and add the
   modified lines to typemap.dat to rerun wsdl2h:

   ec2 = "http://ec2.amazonaws.com/doc/2008-12-01/"

 */

// / @brief
#define SOAP_NAMESPACE_OF_ec2 "http://ec2.amazonaws.com/doc/2008-12-01/"
// gsoap ec2   schema namespace: http://ec2.amazonaws.com/doc/2008-12-01/
// gsoap ec2   schema elementForm:       qualified
// gsoap ec2   schema attributeForm:     unqualified

/******************************************************************************\
*                                                                            *
* Built-in Schema Types and Top-Level Elements and Attributes                *
*                                                                            *
\******************************************************************************/


// / Built-in type "xs:boolean".
enum xsd__boolean_ {_false, _true};


/******************************************************************************\
*                                                                            *
* Schema Types and Top-Level Elements and Attributes                         *
*   http://ec2.amazonaws.com/doc/2008-12-01/                                 *
*                                                                            *
\******************************************************************************/


/******************************************************************************\
*                                                                            *
* Schema Complex Types and Top-Level Elements                                *
*   http://ec2.amazonaws.com/doc/2008-12-01/                                 *
*                                                                            *
\******************************************************************************/


// / "http://ec2.amazonaws.com/doc/2008-12-01/":RegisterImageType is a complexType.
struct ec2__RegisterImageType {
  // / Element imageLocation of type xs:string.
  char *imageLocation 1;       // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":RegisterImageResponseType is a complexType.
struct ec2__RegisterImageResponseType {
  // / Element requestId of type xs:string.
  char *requestId 1;       // /< Required element.
  // / Element imageId of type xs:string.
  char *imageId                        1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DeregisterImageType is a complexType.
struct ec2__DeregisterImageType
{
  // / Element imageId of type xs:string.
  char *imageId                        1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DeregisterImageResponseType is a complexType.
struct ec2__DeregisterImageResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element return of type xs:boolean.
  enum xsd__boolean_ return_                        1;                        // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":CreateKeyPairType is a complexType.
struct ec2__CreateKeyPairType
{
  // / Element keyName of type xs:string.
  char *keyName                        1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":CreateKeyPairResponseType is a complexType.
struct ec2__CreateKeyPairResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element keyName of type xs:string.
  char *keyName                        1;                                     // /< Required element.
  // / Element keyFingerprint of type xs:string.
  char *keyFingerprint                 1;                                     // /< Required element.
  // / Element keyMaterial of type xs:string.
  char *keyMaterial                    1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteKeyPairType is a complexType.
struct ec2__DeleteKeyPairType
{
  // / Element keyName of type xs:string.
  char *keyName                        1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteKeyPairResponseType is a complexType.
struct ec2__DeleteKeyPairResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element return of type xs:boolean.
  enum xsd__boolean_ return_                        1;                        // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeKeyPairsType is a complexType.
struct ec2__DescribeKeyPairsType
{
  // / Element keySet of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeKeyPairsInfoType.
  struct ec2__DescribeKeyPairsInfoType *keySet                         1;     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeKeyPairsInfoType is a complexType.
struct ec2__DescribeKeyPairsInfoType
{
  // / Size of array of struct ec2__DescribeKeyPairsItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__DescribeKeyPairsItemType* of length 0..unbounded
  struct ec2__DescribeKeyPairsItemType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeKeyPairsItemType is a complexType.
struct ec2__DescribeKeyPairsItemType
{
  // / Element keyName of type xs:string.
  char *keyName                        1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeKeyPairsResponseType is a complexType.
struct ec2__DescribeKeyPairsResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element keySet of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeKeyPairsResponseInfoType.
  struct ec2__DescribeKeyPairsResponseInfoType *keySet
  1;                                                                                  // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeKeyPairsResponseInfoType is a complexType.
struct ec2__DescribeKeyPairsResponseInfoType
{
  // / Size of array of struct ec2__DescribeKeyPairsResponseItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__DescribeKeyPairsResponseItemType* of length 0..unbounded
  struct ec2__DescribeKeyPairsResponseItemType *item
  0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeKeyPairsResponseItemType is a complexType.
struct ec2__DescribeKeyPairsResponseItemType
{
  // / Element keyName of type xs:string.
  char *keyName                        1;                                     // /< Required element.
  // / Element keyFingerprint of type xs:string.
  char *keyFingerprint                 1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":RunInstancesType is a complexType.
struct ec2__RunInstancesType
{
  // / Element imageId of type xs:string.
  char *imageId                        1;                                     // /< Required element.
  // / Element minCount of type xs:int.
  int minCount                       1;                                       // /< Required element.
  // / Element maxCount of type xs:int.
  int maxCount                       1;                                       // /< Required element.
  // / Element keyName of type xs:string.
  char *keyName                        0;                                     // /< Optional element.
  // / Element groupSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":GroupSetType.
  struct ec2__GroupSetType *groupSet                       1;                 // /< Required element.
  // / Element additionalInfo of type xs:string.
  char *additionalInfo                 0;                                     // /< Optional element.
  // / Element userData of type "http://ec2.amazonaws.com/doc/2008-12-01/":UserDataType.
  struct ec2__UserDataType *userData                       0;                 // /< Optional element.
  // / Element addressingType of type xs:string.
  char *addressingType                 0;                                     // /< Optional element.
  // / Element instanceType of type xs:string.
  char *instanceType                   1;                                     // /< Required element.
  // / Element placement of type "http://ec2.amazonaws.com/doc/2008-12-01/":PlacementRequestType.
  struct ec2__PlacementRequestType *placement                      0;         // /< Optional element.
  // / Element kernelId of type xs:string.
  char *kernelId                       0;                                     // /< Optional element.
  // / Element ramdiskId of type xs:string.
  char *ramdiskId                      0;                                     // /< Optional element.
  // / Element blockDeviceMapping of type "http://ec2.amazonaws.com/doc/2008-12-01/":BlockDeviceMappingType.
  struct ec2__BlockDeviceMappingType *blockDeviceMapping             0;       // /< Optional element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":GroupSetType is a complexType.
struct ec2__GroupSetType
{
  // / Size of array of struct ec2__GroupItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__GroupItemType* of length 0..unbounded
  struct ec2__GroupItemType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":GroupItemType is a complexType.
struct ec2__GroupItemType
{
  // / Element groupId of type xs:string.
  char *groupId                        1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":UserDataType is a complexType.
struct ec2__UserDataType
{
  // / Element data of type xs:string.
  char *data                           1;                                     // /< Required element.
  // / Attribute version of type xs:string.
  @char *version                        1 = "1.0";                                     // /< Fixed required value="1.0".
  // / Attribute encoding of type xs:string.
  @char *encoding                       1 = "base64";                                  // /< Fixed required value="base64".
  // / TODO: this mixed complexType is user-definable.
  // /       Consult the protocol documentation to change or insert declarations.
  // /       Use wsdl2h option -d for xsd__anyType DOM (soap_dom_element).
  _XML __mixed                       0;                                       // /< Catch mixed content in XML string
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":BlockDeviceMappingType is a complexType.
struct ec2__BlockDeviceMappingType
{
  // / Size of array of struct ec2__BlockDeviceMappingItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__BlockDeviceMappingItemType* of length 0..unbounded
  struct ec2__BlockDeviceMappingItemType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":BlockDeviceMappingItemType is a complexType.
struct ec2__BlockDeviceMappingItemType
{
  // / Element virtualName of type xs:string.
  char *virtualName                    1;                                     // /< Required element.
  // / Element deviceName of type xs:string.
  char *deviceName                     1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":PlacementRequestType is a complexType.
struct ec2__PlacementRequestType
{
  // / Element availabilityZone of type xs:string.
  char *availabilityZone               0;                                     // /< Optional element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":RunInstancesResponseType is a complexType.
struct ec2__RunInstancesResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element reservationId of type xs:string.
  char *reservationId                  1;                                     // /< Required element.
  // / Element ownerId of type xs:string.
  char *ownerId                        1;                                     // /< Required element.
  // / Element groupSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":GroupSetType.
  struct ec2__GroupSetType *groupSet                       1;                 // /< Required element.
  // / Element instancesSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":RunningInstancesSetType.
  struct ec2__RunningInstancesSetType *instancesSet                   1;      // /< Required element.
  // / Element requesterId of type xs:string.
  char *requesterId                    0;                                     // /< Optional element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":ReservationInfoType is a complexType.
struct ec2__ReservationInfoType
{
  // / Element reservationId of type xs:string.
  char *reservationId                  1;                                     // /< Required element.
  // / Element ownerId of type xs:string.
  char *ownerId                        1;                                     // /< Required element.
  // / Element groupSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":GroupSetType.
  struct ec2__GroupSetType *groupSet                       1;                 // /< Required element.
  // / Element instancesSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":RunningInstancesSetType.
  struct ec2__RunningInstancesSetType *instancesSet                   1;      // /< Required element.
  // / Element requesterId of type xs:string.
  char *requesterId                    0;                                     // /< Optional element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":RunningInstancesSetType is a complexType.
struct ec2__RunningInstancesSetType
{
  // / Size of array of struct ec2__RunningInstancesItemType* is 1..unbounded
  $int __sizeitem                     1;
  // / Array struct ec2__RunningInstancesItemType* of length 1..unbounded
  struct ec2__RunningInstancesItemType *item                           1;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":RunningInstancesItemType is a complexType.
struct ec2__RunningInstancesItemType
{
  // / Element instanceId of type xs:string.
  char *instanceId                     1;                                     // /< Required element.
  // / Element imageId of type xs:string.
  char *imageId                        1;                                     // /< Required element.
  // / Element instanceState of type "http://ec2.amazonaws.com/doc/2008-12-01/":InstanceStateType.
  struct ec2__InstanceStateType *instanceState                  1;            // /< Required element.
  // / Element privateDnsName of type xs:string.
  char *privateDnsName                 1;                                     // /< Required element.
  // / Element dnsName of type xs:string.
  char *dnsName                        1;                                     // /< Required element.
  // / Element reason of type xs:string.
  char *reason                         0;                                     // /< Optional element.
  // / Element keyName of type xs:string.
  char *keyName                        0;                                     // /< Optional element.
  // / Element amiLaunchIndex of type xs:string.
  char *amiLaunchIndex                 0;                                     // /< Optional element.
  // / Element productCodes of type "http://ec2.amazonaws.com/doc/2008-12-01/":ProductCodesSetType.
  struct ec2__ProductCodesSetType *productCodes                   0;          // /< Optional element.
  // / Element instanceType of type xs:string.
  char *instanceType                   1;                                     // /< Required element.
  // / Element launchTime of type xs:dateTime.
  time_t launchTime                     1;                                    // /< Required element.
  // / Element placement of type "http://ec2.amazonaws.com/doc/2008-12-01/":PlacementResponseType.
  struct ec2__PlacementResponseType *placement                      0;        // /< Optional element.
  // / Element kernelId of type xs:string.
  char *kernelId                       0;                                     // /< Optional element.
  // / Element ramdiskId of type xs:string.
  char *ramdiskId                      0;                                     // /< Optional element.
  // / Element platform of type xs:string.
  char *platform                       0;                                     // /< Optional element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":PlacementResponseType is a complexType.
struct ec2__PlacementResponseType
{
  // / Element availabilityZone of type xs:string.
  char *availabilityZone               1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":GetConsoleOutputType is a complexType.
struct ec2__GetConsoleOutputType
{
  // / Element instanceId of type xs:string.
  char *instanceId                     1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":GetConsoleOutputResponseType is a complexType.
struct ec2__GetConsoleOutputResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element instanceId of type xs:string.
  char *instanceId                     1;                                     // /< Required element.
  // / Element timestamp of type xs:dateTime.
  time_t timestamp                      1;                                    // /< Required element.
  // / Element output of type xs:string.
  char *output                         1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":TerminateInstancesType is a complexType.
struct ec2__TerminateInstancesType
{
  // / Element instancesSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":TerminateInstancesInfoType.
  struct ec2__TerminateInstancesInfoType *instancesSet                   1;   // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":TerminateInstancesInfoType is a complexType.
struct ec2__TerminateInstancesInfoType
{
  // / Size of array of struct ec2__TerminateInstancesItemType* is 1..unbounded
  $int __sizeitem                     1;
  // / Array struct ec2__TerminateInstancesItemType* of length 1..unbounded
  struct ec2__TerminateInstancesItemType *item                           1;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":TerminateInstancesItemType is a complexType.
struct ec2__TerminateInstancesItemType
{
  // / Element instanceId of type xs:string.
  char *instanceId                     1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":TerminateInstancesResponseType is a complexType.
struct ec2__TerminateInstancesResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element instancesSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":TerminateInstancesResponseInfoType.
  struct ec2__TerminateInstancesResponseInfoType *instancesSet
  1;                                                                                  // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":TerminateInstancesResponseInfoType is a complexType.
struct ec2__TerminateInstancesResponseInfoType
{
  // / Size of array of struct ec2__TerminateInstancesResponseItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__TerminateInstancesResponseItemType* of length 0..unbounded
  struct ec2__TerminateInstancesResponseItemType *item
  0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":TerminateInstancesResponseItemType is a complexType.
struct ec2__TerminateInstancesResponseItemType
{
  // / Element instanceId of type xs:string.
  char *instanceId                     1;                                     // /< Required element.
  // / Element shutdownState of type "http://ec2.amazonaws.com/doc/2008-12-01/":InstanceStateType.
  struct ec2__InstanceStateType *shutdownState                  1;            // /< Required element.
  // / Element previousState of type "http://ec2.amazonaws.com/doc/2008-12-01/":InstanceStateType.
  struct ec2__InstanceStateType *previousState                  1;            // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":RebootInstancesType is a complexType.
struct ec2__RebootInstancesType
{
  // / Element instancesSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":RebootInstancesInfoType.
  struct ec2__RebootInstancesInfoType *instancesSet                   1;      // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":RebootInstancesInfoType is a complexType.
struct ec2__RebootInstancesInfoType
{
  // / Size of array of struct ec2__RebootInstancesItemType* is 1..unbounded
  $int __sizeitem                     1;
  // / Array struct ec2__RebootInstancesItemType* of length 1..unbounded
  struct ec2__RebootInstancesItemType *item                           1;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":RebootInstancesItemType is a complexType.
struct ec2__RebootInstancesItemType
{
  // / Element instanceId of type xs:string.
  char *instanceId                     1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":RebootInstancesResponseType is a complexType.
struct ec2__RebootInstancesResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element return of type xs:boolean.
  enum xsd__boolean_ return_                        1;                        // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeInstancesType is a complexType.
struct ec2__DescribeInstancesType
{
  // / Element instancesSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeInstancesInfoType.
  struct ec2__DescribeInstancesInfoType *instancesSet                   1;    // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeInstancesInfoType is a complexType.
struct ec2__DescribeInstancesInfoType
{
  // / Size of array of struct ec2__DescribeInstancesItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__DescribeInstancesItemType* of length 0..unbounded
  struct ec2__DescribeInstancesItemType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeInstancesItemType is a complexType.
struct ec2__DescribeInstancesItemType
{
  // / Element instanceId of type xs:string.
  char *instanceId                     1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeInstancesResponseType is a complexType.
struct ec2__DescribeInstancesResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element reservationSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":ReservationSetType.
  struct ec2__ReservationSetType *reservationSet                 1;           // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":ReservationSetType is a complexType.
struct ec2__ReservationSetType
{
  // / Size of array of struct ec2__ReservationInfoType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__ReservationInfoType* of length 0..unbounded
  struct ec2__ReservationInfoType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImagesType is a complexType.
struct ec2__DescribeImagesType
{
  // / Element executableBySet of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImagesExecutableBySetType.
  struct ec2__DescribeImagesExecutableBySetType *executableBySet
  0;                                                                                  // /< Optional element.
  // / Element imagesSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImagesInfoType.
  struct ec2__DescribeImagesInfoType *imagesSet                      1;       // /< Required element.
  // / Element ownersSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImagesOwnersType.
  struct ec2__DescribeImagesOwnersType *ownersSet                      0;     // /< Optional element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImagesInfoType is a complexType.
struct ec2__DescribeImagesInfoType
{
  // / Size of array of struct ec2__DescribeImagesItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__DescribeImagesItemType* of length 0..unbounded
  struct ec2__DescribeImagesItemType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImagesItemType is a complexType.
struct ec2__DescribeImagesItemType
{
  // / Element imageId of type xs:string.
  char *imageId                        1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImagesOwnersType is a complexType.
struct ec2__DescribeImagesOwnersType
{
  // / Size of array of struct ec2__DescribeImagesOwnerType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__DescribeImagesOwnerType* of length 0..unbounded
  struct ec2__DescribeImagesOwnerType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImagesOwnerType is a complexType.
struct ec2__DescribeImagesOwnerType
{
  // / Element owner of type xs:string.
  char *owner                          1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImagesExecutableBySetType is a complexType.
struct ec2__DescribeImagesExecutableBySetType
{
  // / Size of array of struct ec2__DescribeImagesExecutableByType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__DescribeImagesExecutableByType* of length 0..unbounded
  struct ec2__DescribeImagesExecutableByType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImagesExecutableByType is a complexType.
struct ec2__DescribeImagesExecutableByType
{
  // / Element user of type xs:string.
  char *user                           1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImagesResponseType is a complexType.
struct ec2__DescribeImagesResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element imagesSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImagesResponseInfoType.
  struct ec2__DescribeImagesResponseInfoType *imagesSet                      1;       // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImagesResponseInfoType is a complexType.
struct ec2__DescribeImagesResponseInfoType
{
  // / Size of array of struct ec2__DescribeImagesResponseItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__DescribeImagesResponseItemType* of length 0..unbounded
  struct ec2__DescribeImagesResponseItemType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImagesResponseItemType is a complexType.
struct ec2__DescribeImagesResponseItemType
{
  // / Element imageId of type xs:string.
  char *imageId                        1;                                     // /< Required element.
  // / Element imageLocation of type xs:string.
  char *imageLocation                  1;                                     // /< Required element.
  // / Element imageState of type xs:string.
  char *imageState                     1;                                     // /< Required element.
  // / Element imageOwnerId of type xs:string.
  char *imageOwnerId                   1;                                     // /< Required element.
  // / Element isPublic of type xs:boolean.
  enum xsd__boolean_ isPublic                       1;                        // /< Required element.
  // / Element productCodes of type "http://ec2.amazonaws.com/doc/2008-12-01/":ProductCodesSetType.
  struct ec2__ProductCodesSetType *productCodes                   0;          // /< Optional element.
  // / Element architecture of type xs:string.
  char *architecture                   0;                                     // /< Optional element.
  // / Element imageType of type xs:string.
  char *imageType                      0;                                     // /< Optional element.
  // / Element kernelId of type xs:string.
  char *kernelId                       0;                                     // /< Optional element.
  // / Element ramdiskId of type xs:string.
  char *ramdiskId                      0;                                     // /< Optional element.
  // / Element platform of type xs:string.
  char *platform                       0;                                     // /< Optional element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":CreateSecurityGroupType is a complexType.
struct ec2__CreateSecurityGroupType
{
  // / Element groupName of type xs:string.
  char *groupName                      1;                                     // /< Required element.
  // / Element groupDescription of type xs:string.
  char *groupDescription               1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":CreateSecurityGroupResponseType is a complexType.
struct ec2__CreateSecurityGroupResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element return of type xs:boolean.
  enum xsd__boolean_ return_                        1;                        // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteSecurityGroupType is a complexType.
struct ec2__DeleteSecurityGroupType
{
  // / Element groupName of type xs:string.
  char *groupName                      1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteSecurityGroupResponseType is a complexType.
struct ec2__DeleteSecurityGroupResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element return of type xs:boolean.
  enum xsd__boolean_ return_                        1;                        // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSecurityGroupsType is a complexType.
struct ec2__DescribeSecurityGroupsType
{
  // / Element securityGroupSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSecurityGroupsSetType.
  struct ec2__DescribeSecurityGroupsSetType *securityGroupSet               1;        // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSecurityGroupsSetType is a complexType.
struct ec2__DescribeSecurityGroupsSetType
{
  // / Size of array of struct ec2__DescribeSecurityGroupsSetItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__DescribeSecurityGroupsSetItemType* of length 0..unbounded
  struct ec2__DescribeSecurityGroupsSetItemType *item
  0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSecurityGroupsSetItemType is a complexType.
struct ec2__DescribeSecurityGroupsSetItemType
{
  // / Element groupName of type xs:string.
  char *groupName                      1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSecurityGroupsResponseType is a complexType.
struct ec2__DescribeSecurityGroupsResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element securityGroupInfo of type "http://ec2.amazonaws.com/doc/2008-12-01/":SecurityGroupSetType.
  struct ec2__SecurityGroupSetType *securityGroupInfo              1;         // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":IpPermissionSetType is a complexType.
struct ec2__IpPermissionSetType
{
  // / Size of array of struct ec2__IpPermissionType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__IpPermissionType* of length 0..unbounded
  struct ec2__IpPermissionType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":IpPermissionType is a complexType.
struct ec2__IpPermissionType
{
  // / Element ipProtocol of type xs:string.
  char *ipProtocol                     1;                                     // /< Required element.
  // / Element fromPort of type xs:int.
  int fromPort                       1;                                       // /< Required element.
  // / Element toPort of type xs:int.
  int toPort                         1;                                       // /< Required element.
  // / Element groups of type "http://ec2.amazonaws.com/doc/2008-12-01/":UserIdGroupPairSetType.
  struct ec2__UserIdGroupPairSetType *groups                         1;       // /< Required element.
  // / Element ipRanges of type "http://ec2.amazonaws.com/doc/2008-12-01/":IpRangeSetType.
  struct ec2__IpRangeSetType *ipRanges                       1;               // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":IpRangeSetType is a complexType.
struct ec2__IpRangeSetType
{
  // / Size of array of struct ec2__IpRangeItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__IpRangeItemType* of length 0..unbounded
  struct ec2__IpRangeItemType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":IpRangeItemType is a complexType.
struct ec2__IpRangeItemType
{
  // / Element cidrIp of type xs:string.
  char *cidrIp                         1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":UserIdGroupPairSetType is a complexType.
struct ec2__UserIdGroupPairSetType
{
  // / Size of array of struct ec2__UserIdGroupPairType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__UserIdGroupPairType* of length 0..unbounded
  struct ec2__UserIdGroupPairType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":UserIdGroupPairType is a complexType.
struct ec2__UserIdGroupPairType
{
  // / Element userId of type xs:string.
  char *userId                         1;                                     // /< Required element.
  // / Element groupName of type xs:string.
  char *groupName                      1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":SecurityGroupSetType is a complexType.
struct ec2__SecurityGroupSetType
{
  // / Size of array of struct ec2__SecurityGroupItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__SecurityGroupItemType* of length 0..unbounded
  struct ec2__SecurityGroupItemType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":SecurityGroupItemType is a complexType.
struct ec2__SecurityGroupItemType
{
  // / Element ownerId of type xs:string.
  char *ownerId                        1;                                     // /< Required element.
  // / Element groupName of type xs:string.
  char *groupName                      1;                                     // /< Required element.
  // / Element groupDescription of type xs:string.
  char *groupDescription               1;                                     // /< Required element.
  // / Element ipPermissions of type "http://ec2.amazonaws.com/doc/2008-12-01/":IpPermissionSetType.
  struct ec2__IpPermissionSetType *ipPermissions                  1;          // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":AuthorizeSecurityGroupIngressType is a complexType.
struct ec2__AuthorizeSecurityGroupIngressType
{
  // / Element userId of type xs:string.
  char *userId                         1;                                     // /< Required element.
  // / Element groupName of type xs:string.
  char *groupName                      1;                                     // /< Required element.
  // / Element ipPermissions of type "http://ec2.amazonaws.com/doc/2008-12-01/":IpPermissionSetType.
  struct ec2__IpPermissionSetType *ipPermissions                  1;          // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":AuthorizeSecurityGroupIngressResponseType is a complexType.
struct ec2__AuthorizeSecurityGroupIngressResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element return of type xs:boolean.
  enum xsd__boolean_ return_                        1;                        // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":RevokeSecurityGroupIngressType is a complexType.
struct ec2__RevokeSecurityGroupIngressType
{
  // / Element userId of type xs:string.
  char *userId                         1;                                     // /< Required element.
  // / Element groupName of type xs:string.
  char *groupName                      1;                                     // /< Required element.
  // / Element ipPermissions of type "http://ec2.amazonaws.com/doc/2008-12-01/":IpPermissionSetType.
  struct ec2__IpPermissionSetType *ipPermissions                  1;          // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":RevokeSecurityGroupIngressResponseType is a complexType.
struct ec2__RevokeSecurityGroupIngressResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element return of type xs:boolean.
  enum xsd__boolean_ return_                        1;                        // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":InstanceStateType is a complexType.
struct ec2__InstanceStateType
{
  // / Element code of type xs:int.
  int code                           1;                                       // /< Required element.
  // / Element name of type xs:string.
  char *name                           1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":ModifyImageAttributeType is a complexType.
struct ec2__ModifyImageAttributeType
{
  // / Element imageId of type xs:string.
  char *imageId                        1;                                     // /< Required element.
  // / CHOICE OF ELEMENTS <xs:choice>
  $int __union_ModifyImageAttributeType;                                       // /< Union _ec2__union_ModifyImageAttributeType selector: set to SOAP_UNION__ec2__union_ModifyImageAttributeType_<fieldname>
  union _ec2__union_ModifyImageAttributeType
  {
    // / Element launchPermission of type "http://ec2.amazonaws.com/doc/2008-12-01/":LaunchPermissionOperationType.
    struct ec2__LaunchPermissionOperationType *launchPermission               1;        // /< Required element.
    // / Element productCodes of type "http://ec2.amazonaws.com/doc/2008-12-01/":ProductCodeListType.
    struct ec2__ProductCodeListType *productCodes                   1;          // /< Required element.
  }                                    union_ModifyImageAttributeType;
  // END OF CHOICE
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":LaunchPermissionOperationType is a complexType.
struct ec2__LaunchPermissionOperationType
{
  // / CHOICE OF ELEMENTS <xs:choice>
  $int __union_LaunchPermissionOperationType;                                  // /< Union _ec2__union_LaunchPermissionOperationType selector: set to SOAP_UNION__ec2__union_LaunchPermissionOperationType_<fieldname>
  // / Union for choice in type ec2__LaunchPermissionOperationType
  union _ec2__union_LaunchPermissionOperationType
  {
    // / Element add of type "http://ec2.amazonaws.com/doc/2008-12-01/":LaunchPermissionListType.
    struct ec2__LaunchPermissionListType *add                            1;     // /< Required element.
    // / Element remove of type "http://ec2.amazonaws.com/doc/2008-12-01/":LaunchPermissionListType.
    struct ec2__LaunchPermissionListType *remove                         1;     // /< Required element.
  }                                    union_LaunchPermissionOperationType;
  // END OF CHOICE
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":LaunchPermissionListType is a complexType.
struct ec2__LaunchPermissionListType
{
  // / Size of array of struct ec2__LaunchPermissionItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__LaunchPermissionItemType* of length 0..unbounded
  struct ec2__LaunchPermissionItemType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":LaunchPermissionItemType is a complexType.
struct ec2__LaunchPermissionItemType
{
  // / CHOICE OF ELEMENTS <xs:choice>
  $int __union_LaunchPermissionItemType;                                       // /< Union _ec2__union_LaunchPermissionItemType selector: set to SOAP_UNION__ec2__union_LaunchPermissionItemType_<fieldname>
  // / Union for choice in type ec2__LaunchPermissionItemType
  union _ec2__union_LaunchPermissionItemType
  {
    // / Element userId of type xs:string.
    char *userId                         1;                                     // /< Required element.
    // / Element group of type xs:string.
    char *group                          1;                                     // /< Required element.
  }                                    union_LaunchPermissionItemType;
  // END OF CHOICE
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":ProductCodeListType is a complexType.
struct ec2__ProductCodeListType
{
  // / Size of array of struct ec2__ProductCodeItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__ProductCodeItemType* of length 0..unbounded
  struct ec2__ProductCodeItemType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":ProductCodeItemType is a complexType.
struct ec2__ProductCodeItemType
{
  // / CHOICE OF ELEMENTS <xs:choice>
  $int __union_ProductCodeItemType;                                           // /< Union _ec2__union_ProductCodeItemType selector: set to SOAP_UNION__ec2__union_ProductCodeItemType_<fieldname>
  // / Union for choice in type ec2__ProductCodeItemType
  union _ec2__union_ProductCodeItemType
  {
    // / Element productCode of type xs:string.
    char *productCode                    1;                                     // /< Required element.
  }                                    union_ProductCodeItemType;
  // END OF CHOICE
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":ModifyImageAttributeResponseType is a complexType.
struct ec2__ModifyImageAttributeResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element return of type xs:boolean.
  enum xsd__boolean_ return_                        1;                        // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":ResetImageAttributeType is a complexType.
struct ec2__ResetImageAttributeType
{
  // / CHOICE OF ELEMENTS <xs:choice>
  $int __union_ResetImageAttributeType;                                        // /< Union _ec2__union_ResetImageAttributeType selector: set to SOAP_UNION__ec2__union_ResetImageAttributeType_<fieldname>
  union _ec2__union_ResetImageAttributeType
  {
    // / Element launchPermission of type "http://ec2.amazonaws.com/doc/2008-12-01/":EmptyElementType.
    struct ec2__EmptyElementType *launchPermission               1;             // /< Required element.
  }                                    union_ResetImageAttributeType;
  // END OF CHOICE
  // / Element imageId of type xs:string.
  char *imageId                        1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":EmptyElementType is a complexType.
struct ec2__EmptyElementType
{
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":ResetImageAttributeResponseType is a complexType.
struct ec2__ResetImageAttributeResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element return of type xs:boolean.
  enum xsd__boolean_ return_                        1;                        // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImageAttributeType is a complexType.
struct ec2__DescribeImageAttributeType
{
  // / CHOICE OF ELEMENTS <xs:choice>
  $int __union_DescribeImageAttributeType;                                     // /< Union _ec2__union_DescribeImageAttributeType selector: set to SOAP_UNION__ec2__union_DescribeImageAttributeType_<fieldname>
  union _ec2__union_DescribeImageAttributeType
  {
    // / Element launchPermission of type "http://ec2.amazonaws.com/doc/2008-12-01/":EmptyElementType.
    struct ec2__EmptyElementType *launchPermission               1;             // /< Required element.
    // / Element productCodes of type "http://ec2.amazonaws.com/doc/2008-12-01/":EmptyElementType.
    struct ec2__EmptyElementType *productCodes                   1;             // /< Required element.
    // / Element kernel of type "http://ec2.amazonaws.com/doc/2008-12-01/":EmptyElementType.
    struct ec2__EmptyElementType *kernel                         1;             // /< Required element.
    // / Element ramdisk of type "http://ec2.amazonaws.com/doc/2008-12-01/":EmptyElementType.
    struct ec2__EmptyElementType *ramdisk                        1;             // /< Required element.
    // / Element blockDeviceMapping of type "http://ec2.amazonaws.com/doc/2008-12-01/":EmptyElementType.
    struct ec2__EmptyElementType *blockDeviceMapping             1;             // /< Required element.
  }                                    union_DescribeImageAttributeType;
  // END OF CHOICE
  // / Element imageId of type xs:string.
  char *imageId                        1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImageAttributeResponseType is a complexType.
struct ec2__DescribeImageAttributeResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element imageId of type xs:string.
  char *imageId                        1;                                     // /< Required element.
  // / CHOICE OF ELEMENTS <xs:choice>
  $int __union_DescribeImageAttributeResponseType;                                     // /< Union _ec2__union_DescribeImageAttributeResponseType selector: set to SOAP_UNION__ec2__union_DescribeImageAttributeResponseType_<fieldname>
  union _ec2__union_DescribeImageAttributeResponseType
  {
    // / Element launchPermission of type "http://ec2.amazonaws.com/doc/2008-12-01/":LaunchPermissionListType.
    struct ec2__LaunchPermissionListType *launchPermission               1;     // /< Required element.
    // / Element productCodes of type "http://ec2.amazonaws.com/doc/2008-12-01/":ProductCodeListType.
    struct ec2__ProductCodeListType *productCodes                   1;          // /< Required element.
    // / Element kernel of type "http://ec2.amazonaws.com/doc/2008-12-01/":NullableAttributeValueType.
    struct ec2__NullableAttributeValueType *kernel                         1;   // /< Required element.
    // / Element ramdisk of type "http://ec2.amazonaws.com/doc/2008-12-01/":NullableAttributeValueType.
    struct ec2__NullableAttributeValueType *ramdisk                        1;   // /< Required element.
    // / Element blockDeviceMapping of type "http://ec2.amazonaws.com/doc/2008-12-01/":BlockDeviceMappingType.
    struct ec2__BlockDeviceMappingType *blockDeviceMapping             1;       // /< Required element.
  }                                    union_DescribeImageAttributeResponseType;
  // END OF CHOICE
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":NullableAttributeValueType is a complexType.
struct ec2__NullableAttributeValueType
{
  // / Element value of type xs:string.
  char *value                          0;                                     // /< Optional element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":AttributeValueType is a complexType.
struct ec2__AttributeValueType
{
  // / Element value of type xs:string.
  char *value                          1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":ConfirmProductInstanceType is a complexType.
struct ec2__ConfirmProductInstanceType
{
  // / Element productCode of type xs:string.
  char *productCode                    1;                                     // /< Required element.
  // / Element instanceId of type xs:string.
  char *instanceId                     1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":ProductCodesSetType is a complexType.
struct ec2__ProductCodesSetType
{
  // / Size of array of struct ec2__ProductCodesSetItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__ProductCodesSetItemType* of length 0..unbounded
  struct ec2__ProductCodesSetItemType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":ProductCodesSetItemType is a complexType.
struct ec2__ProductCodesSetItemType
{
  // / Element productCode of type xs:string.
  char *productCode                    1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":ConfirmProductInstanceResponseType is a complexType.
struct ec2__ConfirmProductInstanceResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element return of type xs:boolean.
  enum xsd__boolean_ return_                        1;                        // /< Required element.
  // / Element ownerId of type xs:string.
  char *ownerId                        0;                                     // /< Optional element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAvailabilityZonesType is a complexType.
struct ec2__DescribeAvailabilityZonesType
{
  // / Element availabilityZoneSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAvailabilityZonesSetType.
  struct ec2__DescribeAvailabilityZonesSetType *availabilityZoneSet
  1;                                                                                  // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAvailabilityZonesSetType is a complexType.
struct ec2__DescribeAvailabilityZonesSetType
{
  // / Size of array of struct ec2__DescribeAvailabilityZonesSetItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__DescribeAvailabilityZonesSetItemType* of length 0..unbounded
  struct ec2__DescribeAvailabilityZonesSetItemType *item
  0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAvailabilityZonesSetItemType is a complexType.
struct ec2__DescribeAvailabilityZonesSetItemType
{
  // / Element zoneName of type xs:string.
  char *zoneName                       1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAvailabilityZonesResponseType is a complexType.
struct ec2__DescribeAvailabilityZonesResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element availabilityZoneInfo of type "http://ec2.amazonaws.com/doc/2008-12-01/":AvailabilityZoneSetType.
  struct ec2__AvailabilityZoneSetType *availabilityZoneInfo           1;      // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":AvailabilityZoneSetType is a complexType.
struct ec2__AvailabilityZoneSetType
{
  // / Size of array of struct ec2__AvailabilityZoneItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__AvailabilityZoneItemType* of length 0..unbounded
  struct ec2__AvailabilityZoneItemType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":AvailabilityZoneItemType is a complexType.
struct ec2__AvailabilityZoneItemType
{
  // / Element zoneName of type xs:string.
  char *zoneName                       1;                                     // /< Required element.
  // / Element zoneState of type xs:string.
  char *zoneState                      1;                                     // /< Required element.
  // / Element regionName of type xs:string.
  char *regionName                     1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":AllocateAddressType is a complexType.
struct ec2__AllocateAddressType
{
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":AllocateAddressResponseType is a complexType.
struct ec2__AllocateAddressResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element publicIp of type xs:string.
  char *publicIp                       1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":ReleaseAddressType is a complexType.
struct ec2__ReleaseAddressType
{
  // / Element publicIp of type xs:string.
  char *publicIp                       1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":ReleaseAddressResponseType is a complexType.
struct ec2__ReleaseAddressResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element return of type xs:boolean.
  enum xsd__boolean_ return_                        1;                        // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAddressesType is a complexType.
struct ec2__DescribeAddressesType
{
  // / Element publicIpsSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAddressesInfoType.
  struct ec2__DescribeAddressesInfoType *publicIpsSet                   1;    // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAddressesInfoType is a complexType.
struct ec2__DescribeAddressesInfoType
{
  // / Size of array of struct ec2__DescribeAddressesItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__DescribeAddressesItemType* of length 0..unbounded
  struct ec2__DescribeAddressesItemType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAddressesItemType is a complexType.
struct ec2__DescribeAddressesItemType
{
  // / Element publicIp of type xs:string.
  char *publicIp                       1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAddressesResponseType is a complexType.
struct ec2__DescribeAddressesResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element addressesSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAddressesResponseInfoType.
  struct ec2__DescribeAddressesResponseInfoType *addressesSet
  1;                                                                                  // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAddressesResponseInfoType is a complexType.
struct ec2__DescribeAddressesResponseInfoType
{
  // / Size of array of struct ec2__DescribeAddressesResponseItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__DescribeAddressesResponseItemType* of length 0..unbounded
  struct ec2__DescribeAddressesResponseItemType *item
  0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAddressesResponseItemType is a complexType.
struct ec2__DescribeAddressesResponseItemType
{
  // / Element publicIp of type xs:string.
  char *publicIp                       1;                                     // /< Required element.
  // / Element instanceId of type xs:string.
  char *instanceId                     0;                                     // /< Optional element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":AssociateAddressType is a complexType.
struct ec2__AssociateAddressType
{
  // / Element publicIp of type xs:string.
  char *publicIp                       1;                                     // /< Required element.
  // / Element instanceId of type xs:string.
  char *instanceId                     1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":AssociateAddressResponseType is a complexType.
struct ec2__AssociateAddressResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element return of type xs:boolean.
  enum xsd__boolean_ return_                        1;                        // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DisassociateAddressType is a complexType.
struct ec2__DisassociateAddressType
{
  // / Element publicIp of type xs:string.
  char *publicIp                       1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DisassociateAddressResponseType is a complexType.
struct ec2__DisassociateAddressResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element return of type xs:boolean.
  enum xsd__boolean_ return_                        1;                        // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":CreateVolumeType is a complexType.
struct ec2__CreateVolumeType
{
  // / Element size of type xs:string.
  char *size                           0;                                     // /< Optional element.
  // / Element snapshotId of type xs:string.
  char *snapshotId                     0;                                     // /< Optional element.
  // / Element availabilityZone of type xs:string.
  char *availabilityZone               1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":CreateVolumeResponseType is a complexType.
struct ec2__CreateVolumeResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element volumeId of type xs:string.
  char *volumeId                       1;                                     // /< Required element.
  // / Element size of type xs:string.
  char *size                           1;                                     // /< Required element.
  // / Element snapshotId of type xs:string.
  char *snapshotId                     1;                                     // /< Required element.
  // / Element availabilityZone of type xs:string.
  char *availabilityZone               1;                                     // /< Required element.
  // / Element status of type xs:string.
  char *status                         1;                                     // /< Required element.
  // / Element createTime of type xs:dateTime.
  time_t createTime                     1;                                    // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteVolumeType is a complexType.
struct ec2__DeleteVolumeType
{
  // / Element volumeId of type xs:string.
  char *volumeId                       1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteVolumeResponseType is a complexType.
struct ec2__DeleteVolumeResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element return of type xs:boolean.
  enum xsd__boolean_ return_                        1;                        // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeVolumesType is a complexType.
struct ec2__DescribeVolumesType
{
  // / Element volumeSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeVolumesSetType.
  struct ec2__DescribeVolumesSetType *volumeSet                      1;       // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeVolumesSetType is a complexType.
struct ec2__DescribeVolumesSetType
{
  // / Size of array of struct ec2__DescribeVolumesSetItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__DescribeVolumesSetItemType* of length 0..unbounded
  struct ec2__DescribeVolumesSetItemType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeVolumesSetItemType is a complexType.
struct ec2__DescribeVolumesSetItemType
{
  // / Element volumeId of type xs:string.
  char *volumeId                       1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeVolumesResponseType is a complexType.
struct ec2__DescribeVolumesResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element volumeSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeVolumesSetResponseType.
  struct ec2__DescribeVolumesSetResponseType *volumeSet                      1;       // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeVolumesSetResponseType is a complexType.
struct ec2__DescribeVolumesSetResponseType
{
  // / Size of array of struct ec2__DescribeVolumesSetItemResponseType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__DescribeVolumesSetItemResponseType* of length 0..unbounded
  struct ec2__DescribeVolumesSetItemResponseType *item
  0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeVolumesSetItemResponseType is a complexType.
struct ec2__DescribeVolumesSetItemResponseType
{
  // / Element volumeId of type xs:string.
  char *volumeId                       1;                                     // /< Required element.
  // / Element size of type xs:string.
  char *size                           1;                                     // /< Required element.
  // / Element snapshotId of type xs:string.
  char *snapshotId                     1;                                     // /< Required element.
  // / Element availabilityZone of type xs:string.
  char *availabilityZone               1;                                     // /< Required element.
  // / Element status of type xs:string.
  char *status                         1;                                     // /< Required element.
  // / Element createTime of type xs:dateTime.
  time_t createTime                     1;                                    // /< Required element.
  // / Element attachmentSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":AttachmentSetResponseType.
  struct ec2__AttachmentSetResponseType *attachmentSet                  1;    // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":AttachmentSetResponseType is a complexType.
struct ec2__AttachmentSetResponseType
{
  // / Size of array of struct ec2__AttachmentSetItemResponseType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__AttachmentSetItemResponseType* of length 0..unbounded
  struct ec2__AttachmentSetItemResponseType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":AttachmentSetItemResponseType is a complexType.
struct ec2__AttachmentSetItemResponseType
{
  // / Element volumeId of type xs:string.
  char *volumeId                       1;                                     // /< Required element.
  // / Element instanceId of type xs:string.
  char *instanceId                     1;                                     // /< Required element.
  // / Element device of type xs:string.
  char *device                         1;                                     // /< Required element.
  // / Element status of type xs:string.
  char *status                         1;                                     // /< Required element.
  // / Element attachTime of type xs:dateTime.
  time_t attachTime                     1;                                    // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":AttachVolumeType is a complexType.
struct ec2__AttachVolumeType
{
  // / Element volumeId of type xs:string.
  char *volumeId                       1;                                     // /< Required element.
  // / Element instanceId of type xs:string.
  char *instanceId                     1;                                     // /< Required element.
  // / Element device of type xs:string.
  char *device                         1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":AttachVolumeResponseType is a complexType.
struct ec2__AttachVolumeResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element volumeId of type xs:string.
  char *volumeId                       1;                                     // /< Required element.
  // / Element instanceId of type xs:string.
  char *instanceId                     1;                                     // /< Required element.
  // / Element device of type xs:string.
  char *device                         1;                                     // /< Required element.
  // / Element status of type xs:string.
  char *status                         1;                                     // /< Required element.
  // / Element attachTime of type xs:dateTime.
  time_t attachTime                     1;                                    // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DetachVolumeType is a complexType.
struct ec2__DetachVolumeType
{
  // / Element volumeId of type xs:string.
  char *volumeId                       1;                                     // /< Required element.
  // / Element instanceId of type xs:string.
  char *instanceId                     0;                                     // /< Optional element.
  // / Element device of type xs:string.
  char *device                         0;                                     // /< Optional element.
  // / Element force of type xs:boolean.
  enum xsd__boolean_ *force                          0;                       // /< Optional element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DetachVolumeResponseType is a complexType.
struct ec2__DetachVolumeResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element volumeId of type xs:string.
  char *volumeId                       1;                                     // /< Required element.
  // / Element instanceId of type xs:string.
  char *instanceId                     1;                                     // /< Required element.
  // / Element device of type xs:string.
  char *device                         1;                                     // /< Required element.
  // / Element status of type xs:string.
  char *status                         1;                                     // /< Required element.
  // / Element attachTime of type xs:dateTime.
  time_t attachTime                     1;                                    // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":CreateSnapshotType is a complexType.
struct ec2__CreateSnapshotType
{
  // / Element volumeId of type xs:string.
  char *volumeId                       1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":CreateSnapshotResponseType is a complexType.
struct ec2__CreateSnapshotResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element snapshotId of type xs:string.
  char *snapshotId                     1;                                     // /< Required element.
  // / Element volumeId of type xs:string.
  char *volumeId                       1;                                     // /< Required element.
  // / Element status of type xs:string.
  char *status                         1;                                     // /< Required element.
  // / Element startTime of type xs:dateTime.
  time_t startTime                      1;                                    // /< Required element.
  // / Element progress of type xs:string.
  char *progress                       1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteSnapshotType is a complexType.
struct ec2__DeleteSnapshotType
{
  // / Element snapshotId of type xs:string.
  char *snapshotId                     1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteSnapshotResponseType is a complexType.
struct ec2__DeleteSnapshotResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element return of type xs:boolean.
  enum xsd__boolean_ return_                        1;                        // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSnapshotsType is a complexType.
struct ec2__DescribeSnapshotsType
{
  // / Element snapshotSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSnapshotsSetType.
  struct ec2__DescribeSnapshotsSetType *snapshotSet                    1;     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSnapshotsSetType is a complexType.
struct ec2__DescribeSnapshotsSetType
{
  // / Size of array of struct ec2__DescribeSnapshotsSetItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__DescribeSnapshotsSetItemType* of length 0..unbounded
  struct ec2__DescribeSnapshotsSetItemType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSnapshotsSetItemType is a complexType.
struct ec2__DescribeSnapshotsSetItemType
{
  // / Element snapshotId of type xs:string.
  char *snapshotId                     1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSnapshotsResponseType is a complexType.
struct ec2__DescribeSnapshotsResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element snapshotSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSnapshotsSetResponseType.
  struct ec2__DescribeSnapshotsSetResponseType *snapshotSet
  1;                                                                                  // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSnapshotsSetResponseType is a complexType.
struct ec2__DescribeSnapshotsSetResponseType
{
  // / Size of array of struct ec2__DescribeSnapshotsSetItemResponseType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__DescribeSnapshotsSetItemResponseType* of length 0..unbounded
  struct ec2__DescribeSnapshotsSetItemResponseType *item
  0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSnapshotsSetItemResponseType is a complexType.
struct ec2__DescribeSnapshotsSetItemResponseType
{
  // / Element snapshotId of type xs:string.
  char *snapshotId                     1;                                     // /< Required element.
  // / Element volumeId of type xs:string.
  char *volumeId                       1;                                     // /< Required element.
  // / Element status of type xs:string.
  char *status                         1;                                     // /< Required element.
  // / Element startTime of type xs:dateTime.
  time_t startTime                      1;                                    // /< Required element.
  // / Element progress of type xs:string.
  char *progress                       1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":BundleInstanceType is a complexType.
struct ec2__BundleInstanceType
{
  // / Element instanceId of type xs:string.
  char *instanceId                     1;                                     // /< Required element.
  // / Element storage of type "http://ec2.amazonaws.com/doc/2008-12-01/":BundleInstanceTaskStorageType.
  struct ec2__BundleInstanceTaskStorageType *storage                        1;        // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":BundleInstanceTaskStorageType is a complexType.
struct ec2__BundleInstanceTaskStorageType
{
  // / Element S3 of type "http://ec2.amazonaws.com/doc/2008-12-01/":BundleInstanceS3StorageType.
  struct ec2__BundleInstanceS3StorageType *S3                             1;  // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":BundleInstanceS3StorageType is a complexType.
struct ec2__BundleInstanceS3StorageType
{
  // / Element bucket of type xs:string.
  char *bucket                         1;                                     // /< Required element.
  // / Element prefix of type xs:string.
  char *prefix                         1;                                     // /< Required element.
  // / Element awsAccessKeyId of type xs:string.
  char *awsAccessKeyId                 0;                                     // /< Optional element.
  // / Element uploadPolicy of type xs:string.
  char *uploadPolicy                   0;                                     // /< Optional element.
  // / Element uploadPolicySignature of type xs:string.
  char *uploadPolicySignature          0;                                     // /< Optional element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":BundleInstanceResponseType is a complexType.
struct ec2__BundleInstanceResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element bundleInstanceTask of type "http://ec2.amazonaws.com/doc/2008-12-01/":BundleInstanceTaskType.
  struct ec2__BundleInstanceTaskType *bundleInstanceTask             1;       // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":BundleInstanceTaskType is a complexType.
struct ec2__BundleInstanceTaskType
{
  // / Element instanceId of type xs:string.
  char *instanceId                     1;                                     // /< Required element.
  // / Element bundleId of type xs:string.
  char *bundleId                       1;                                     // /< Required element.
  // / Element state of type xs:string.
  char *state                          1;                                     // /< Required element.
  // / Element startTime of type xs:dateTime.
  time_t startTime                      1;                                    // /< Required element.
  // / Element updateTime of type xs:dateTime.
  time_t updateTime                     1;                                    // /< Required element.
  // / Element storage of type "http://ec2.amazonaws.com/doc/2008-12-01/":BundleInstanceTaskStorageType.
  struct ec2__BundleInstanceTaskStorageType *storage                        1;        // /< Required element.
  // / Element progress of type xs:string.
  char *progress                       0;                                     // /< Optional element.
  // / Element error of type "http://ec2.amazonaws.com/doc/2008-12-01/":BundleInstanceTaskErrorType.
  struct ec2__BundleInstanceTaskErrorType *error                          0;  // /< Optional element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":BundleInstanceTaskErrorType is a complexType.
struct ec2__BundleInstanceTaskErrorType
{
  // / Element code of type xs:string.
  char *code                           1;                                     // /< Required element.
  // / Element message of type xs:string.
  char *message                        1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeBundleTasksType is a complexType.
struct ec2__DescribeBundleTasksType
{
  // / Element bundlesSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeBundleTasksInfoType.
  struct ec2__DescribeBundleTasksInfoType *bundlesSet                     1;  // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeBundleTasksInfoType is a complexType.
struct ec2__DescribeBundleTasksInfoType
{
  // / Size of array of struct ec2__DescribeBundleTasksItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__DescribeBundleTasksItemType* of length 0..unbounded
  struct ec2__DescribeBundleTasksItemType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeBundleTasksItemType is a complexType.
struct ec2__DescribeBundleTasksItemType
{
  // / Element bundleId of type xs:string.
  char *bundleId                       1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeBundleTasksResponseType is a complexType.
struct ec2__DescribeBundleTasksResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element bundleInstanceTasksSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":BundleInstanceTasksSetType.
  struct ec2__BundleInstanceTasksSetType *bundleInstanceTasksSet         1;   // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":BundleInstanceTasksSetType is a complexType.
struct ec2__BundleInstanceTasksSetType
{
  // / Size of array of struct ec2__BundleInstanceTaskType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__BundleInstanceTaskType* of length 0..unbounded
  struct ec2__BundleInstanceTaskType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":CancelBundleTaskType is a complexType.
struct ec2__CancelBundleTaskType
{
  // / Element bundleId of type xs:string.
  char *bundleId                       1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":CancelBundleTaskResponseType is a complexType.
struct ec2__CancelBundleTaskResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element bundleInstanceTask of type "http://ec2.amazonaws.com/doc/2008-12-01/":BundleInstanceTaskType.
  struct ec2__BundleInstanceTaskType *bundleInstanceTask             1;       // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeRegionsType is a complexType.
struct ec2__DescribeRegionsType
{
  // / Element regionSet of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeRegionsSetType.
  struct ec2__DescribeRegionsSetType *regionSet                      1;       // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeRegionsSetType is a complexType.
struct ec2__DescribeRegionsSetType
{
  // / Size of array of struct ec2__DescribeRegionsSetItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__DescribeRegionsSetItemType* of length 0..unbounded
  struct ec2__DescribeRegionsSetItemType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeRegionsSetItemType is a complexType.
struct ec2__DescribeRegionsSetItemType
{
  // / Element regionName of type xs:string.
  char *regionName                     1;                                     // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeRegionsResponseType is a complexType.
struct ec2__DescribeRegionsResponseType
{
  // / Element requestId of type xs:string.
  char *requestId                      1;                                     // /< Required element.
  // / Element regionInfo of type "http://ec2.amazonaws.com/doc/2008-12-01/":RegionSetType.
  struct ec2__RegionSetType *regionInfo                     1;                // /< Required element.
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":RegionSetType is a complexType.
struct ec2__RegionSetType
{
  // / Size of array of struct ec2__RegionItemType* is 0..unbounded
  $int __sizeitem                     0;
  // / Array struct ec2__RegionItemType* of length 0..unbounded
  struct ec2__RegionItemType *item                           0;
};

// / "http://ec2.amazonaws.com/doc/2008-12-01/":RegionItemType is a complexType.
struct ec2__RegionItemType
{
  // / Element regionName of type xs:string.
  char *regionName                     1;                                     // /< Required element.
  // / Element regionEndpoint of type xs:string.
  char *regionEndpoint                 1;                                     // /< Required element.
};

/******************************************************************************\
*                                                                            *
* Additional Top-Level Elements                                              *
*   http://ec2.amazonaws.com/doc/2008-12-01/                                 *
*                                                                            *
\******************************************************************************/


// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":RegisterImage of type "http://ec2.amazonaws.com/doc/2008-12-01/":RegisterImageType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":RegisterImageResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":RegisterImageResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DeregisterImage of type "http://ec2.amazonaws.com/doc/2008-12-01/":DeregisterImageType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DeregisterImageResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":DeregisterImageResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":CreateKeyPair of type "http://ec2.amazonaws.com/doc/2008-12-01/":CreateKeyPairType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":CreateKeyPairResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":CreateKeyPairResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteKeyPair of type "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteKeyPairType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteKeyPairResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteKeyPairResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeKeyPairs of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeKeyPairsType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeKeyPairsResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeKeyPairsResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":RunInstances of type "http://ec2.amazonaws.com/doc/2008-12-01/":RunInstancesType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":RunInstancesResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":RunInstancesResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":GetConsoleOutput of type "http://ec2.amazonaws.com/doc/2008-12-01/":GetConsoleOutputType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":GetConsoleOutputResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":GetConsoleOutputResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":TerminateInstances of type "http://ec2.amazonaws.com/doc/2008-12-01/":TerminateInstancesType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":TerminateInstancesResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":TerminateInstancesResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":RebootInstances of type "http://ec2.amazonaws.com/doc/2008-12-01/":RebootInstancesType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":RebootInstancesResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":RebootInstancesResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeInstances of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeInstancesType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeInstancesResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeInstancesResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImages of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImagesType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImagesResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImagesResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":CreateSecurityGroup of type "http://ec2.amazonaws.com/doc/2008-12-01/":CreateSecurityGroupType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":CreateSecurityGroupResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":CreateSecurityGroupResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteSecurityGroup of type "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteSecurityGroupType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteSecurityGroupResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteSecurityGroupResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSecurityGroups of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSecurityGroupsType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSecurityGroupsResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSecurityGroupsResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":AuthorizeSecurityGroupIngress of type "http://ec2.amazonaws.com/doc/2008-12-01/":AuthorizeSecurityGroupIngressType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":AuthorizeSecurityGroupIngressResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":AuthorizeSecurityGroupIngressResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":RevokeSecurityGroupIngress of type "http://ec2.amazonaws.com/doc/2008-12-01/":RevokeSecurityGroupIngressType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":RevokeSecurityGroupIngressResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":RevokeSecurityGroupIngressResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":ModifyImageAttribute of type "http://ec2.amazonaws.com/doc/2008-12-01/":ModifyImageAttributeType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":ModifyImageAttributeResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":ModifyImageAttributeResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":ResetImageAttribute of type "http://ec2.amazonaws.com/doc/2008-12-01/":ResetImageAttributeType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":ResetImageAttributeResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":ResetImageAttributeResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImageAttribute of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImageAttributeType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImageAttributeResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeImageAttributeResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":ConfirmProductInstance of type "http://ec2.amazonaws.com/doc/2008-12-01/":ConfirmProductInstanceType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":ConfirmProductInstanceResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":ConfirmProductInstanceResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAvailabilityZones of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAvailabilityZonesType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAvailabilityZonesResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAvailabilityZonesResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":AllocateAddress of type "http://ec2.amazonaws.com/doc/2008-12-01/":AllocateAddressType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":AllocateAddressResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":AllocateAddressResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":ReleaseAddress of type "http://ec2.amazonaws.com/doc/2008-12-01/":ReleaseAddressType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":ReleaseAddressResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":ReleaseAddressResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAddresses of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAddressesType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAddressesResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeAddressesResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":AssociateAddress of type "http://ec2.amazonaws.com/doc/2008-12-01/":AssociateAddressType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":AssociateAddressResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":AssociateAddressResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DisassociateAddress of type "http://ec2.amazonaws.com/doc/2008-12-01/":DisassociateAddressType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DisassociateAddressResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":DisassociateAddressResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":CreateVolume of type "http://ec2.amazonaws.com/doc/2008-12-01/":CreateVolumeType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":CreateVolumeResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":CreateVolumeResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteVolume of type "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteVolumeType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteVolumeResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteVolumeResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeVolumes of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeVolumesType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeVolumesResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeVolumesResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":AttachVolume of type "http://ec2.amazonaws.com/doc/2008-12-01/":AttachVolumeType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":AttachVolumeResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":AttachVolumeResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DetachVolume of type "http://ec2.amazonaws.com/doc/2008-12-01/":DetachVolumeType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DetachVolumeResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":DetachVolumeResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":CreateSnapshot of type "http://ec2.amazonaws.com/doc/2008-12-01/":CreateSnapshotType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":CreateSnapshotResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":CreateSnapshotResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteSnapshot of type "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteSnapshotType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteSnapshotResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":DeleteSnapshotResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSnapshots of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSnapshotsType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSnapshotsResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeSnapshotsResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":BundleInstance of type "http://ec2.amazonaws.com/doc/2008-12-01/":BundleInstanceType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":BundleInstanceResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":BundleInstanceResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeBundleTasks of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeBundleTasksType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeBundleTasksResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeBundleTasksResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":CancelBundleTask of type "http://ec2.amazonaws.com/doc/2008-12-01/":CancelBundleTaskType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":CancelBundleTaskResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":CancelBundleTaskResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeRegions of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeRegionsType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

// / Top-level root element "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeRegionsResponse of type "http://ec2.amazonaws.com/doc/2008-12-01/":DescribeRegionsResponseType.
// / Note: use wsdl2h option -g to auto-generate a top-level root element declaration and processing code.

/******************************************************************************\
*                                                                            *
* Additional Top-Level Attributes                                            *
*   http://ec2.amazonaws.com/doc/2008-12-01/                                 *
*                                                                            *
\******************************************************************************/


/******************************************************************************\
*                                                                            *
* Services                                                                   *
*                                                                            *
\******************************************************************************/


// gsoap ec2  service name:      AmazonEC2Binding
// gsoap ec2  service type:      AmazonEC2PortType
// gsoap ec2  service port:      https://ec2.amazonaws.com/
// gsoap ec2  service namespace: http://ec2.amazonaws.com/doc/2008-12-01/
// gsoap ec2  service transport: http://schemas.xmlsoap.org/soap/http

/** @mainpage Service Definitions

    @section Service_bindings Service Bindings
    - @ref AmazonEC2Binding

    @section Service_more More Information
    - @ref page_notes "Notes"
    - @ref page_XMLDataBinding "XML Data Binding"
    - @ref SOAP_ENV__Header "SOAP Header Content"
    - @ref SOAP_ENV__Detail "SOAP Fault Detail Content" (when applicable)


 */

/**

   @page AmazonEC2Binding Binding "AmazonEC2Binding"

   @section AmazonEC2Binding_operations Operations of Binding  "AmazonEC2Binding"
   - @ref __ec2__RegisterImage
   - @ref __ec2__DeregisterImage
   - @ref __ec2__CreateKeyPair
   - @ref __ec2__DescribeKeyPairs
   - @ref __ec2__DeleteKeyPair
   - @ref __ec2__RunInstances
   - @ref __ec2__GetConsoleOutput
   - @ref __ec2__TerminateInstances
   - @ref __ec2__RebootInstances
   - @ref __ec2__DescribeInstances
   - @ref __ec2__DescribeImages
   - @ref __ec2__CreateSecurityGroup
   - @ref __ec2__DeleteSecurityGroup
   - @ref __ec2__DescribeSecurityGroups
   - @ref __ec2__AuthorizeSecurityGroupIngress
   - @ref __ec2__RevokeSecurityGroupIngress
   - @ref __ec2__ModifyImageAttribute
   - @ref __ec2__ResetImageAttribute
   - @ref __ec2__DescribeImageAttribute
   - @ref __ec2__ConfirmProductInstance
   - @ref __ec2__DescribeAvailabilityZones
   - @ref __ec2__AllocateAddress
   - @ref __ec2__ReleaseAddress
   - @ref __ec2__DescribeAddresses
   - @ref __ec2__AssociateAddress
   - @ref __ec2__DisassociateAddress
   - @ref __ec2__CreateVolume
   - @ref __ec2__DeleteVolume
   - @ref __ec2__DescribeVolumes
   - @ref __ec2__AttachVolume
   - @ref __ec2__DetachVolume
   - @ref __ec2__CreateSnapshot
   - @ref __ec2__DeleteSnapshot
   - @ref __ec2__DescribeSnapshots
   - @ref __ec2__BundleInstance
   - @ref __ec2__DescribeBundleTasks
   - @ref __ec2__CancelBundleTask
   - @ref __ec2__DescribeRegions

   @section AmazonEC2Binding_ports Endpoints of Binding  "AmazonEC2Binding"
   - https://ec2.amazonaws.com/

   Note: use wsdl2h option -N to change the service binding prefix name

 */

/******************************************************************************\
*                                                                            *
* Service Binding                                                            *
*   AmazonEC2Binding                                                         *
*                                                                            *
\******************************************************************************/


/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__RegisterImage                                                     *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__RegisterImage" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="RegisterImage"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__RegisterImage(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__RegisterImageType*      ec2__RegisterImage,
   // response parameters:
   struct ec2__RegisterImageResponseType* ec2__RegisterImageResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__RegisterImage(
   struct soap *soap,
   // request parameters:
   struct ec2__RegisterImageType*      ec2__RegisterImage,
   // response parameters:
   struct ec2__RegisterImageResponseType* ec2__RegisterImageResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      RegisterImage document
// gsoap ec2  service method-encoding:   RegisterImage literal
// gsoap ec2  service method-action:     RegisterImage RegisterImage
int
__ec2__RegisterImage(
  struct ec2__RegisterImageType *ec2__RegisterImage,                                 // /< Request parameter
  struct ec2__RegisterImageResponseType *ec2__RegisterImageResponse                          // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__DeregisterImage                                                   *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__DeregisterImage" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="DeregisterImage"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__DeregisterImage(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__DeregisterImageType*    ec2__DeregisterImage,
   // response parameters:
   struct ec2__DeregisterImageResponseType* ec2__DeregisterImageResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__DeregisterImage(
   struct soap *soap,
   // request parameters:
   struct ec2__DeregisterImageType*    ec2__DeregisterImage,
   // response parameters:
   struct ec2__DeregisterImageResponseType* ec2__DeregisterImageResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      DeregisterImage document
// gsoap ec2  service method-encoding:   DeregisterImage literal
// gsoap ec2  service method-action:     DeregisterImage DeregisterImage
int
__ec2__DeregisterImage(
  struct ec2__DeregisterImageType *ec2__DeregisterImage,                               // /< Request parameter
  struct ec2__DeregisterImageResponseType *ec2__DeregisterImageResponse                                // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__CreateKeyPair                                                     *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__CreateKeyPair" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="CreateKeyPair"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__CreateKeyPair(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__CreateKeyPairType*      ec2__CreateKeyPair,
   // response parameters:
   struct ec2__CreateKeyPairResponseType* ec2__CreateKeyPairResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__CreateKeyPair(
   struct soap *soap,
   // request parameters:
   struct ec2__CreateKeyPairType*      ec2__CreateKeyPair,
   // response parameters:
   struct ec2__CreateKeyPairResponseType* ec2__CreateKeyPairResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      CreateKeyPair document
// gsoap ec2  service method-encoding:   CreateKeyPair literal
// gsoap ec2  service method-action:     CreateKeyPair CreateKeyPair
int
__ec2__CreateKeyPair(
  struct ec2__CreateKeyPairType *ec2__CreateKeyPair,                                 // /< Request parameter
  struct ec2__CreateKeyPairResponseType *ec2__CreateKeyPairResponse                          // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__DescribeKeyPairs                                                  *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__DescribeKeyPairs" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="DescribeKeyPairs"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__DescribeKeyPairs(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__DescribeKeyPairsType*   ec2__DescribeKeyPairs,
   // response parameters:
   struct ec2__DescribeKeyPairsResponseType* ec2__DescribeKeyPairsResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__DescribeKeyPairs(
   struct soap *soap,
   // request parameters:
   struct ec2__DescribeKeyPairsType*   ec2__DescribeKeyPairs,
   // response parameters:
   struct ec2__DescribeKeyPairsResponseType* ec2__DescribeKeyPairsResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      DescribeKeyPairs document
// gsoap ec2  service method-encoding:   DescribeKeyPairs literal
// gsoap ec2  service method-action:     DescribeKeyPairs DescribeKeyPairs
int
__ec2__DescribeKeyPairs(
  struct ec2__DescribeKeyPairsType *ec2__DescribeKeyPairs,                              // /< Request parameter
  struct ec2__DescribeKeyPairsResponseType *ec2__DescribeKeyPairsResponse                               // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__DeleteKeyPair                                                     *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__DeleteKeyPair" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="DeleteKeyPair"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__DeleteKeyPair(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__DeleteKeyPairType*      ec2__DeleteKeyPair,
   // response parameters:
   struct ec2__DeleteKeyPairResponseType* ec2__DeleteKeyPairResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__DeleteKeyPair(
   struct soap *soap,
   // request parameters:
   struct ec2__DeleteKeyPairType*      ec2__DeleteKeyPair,
   // response parameters:
   struct ec2__DeleteKeyPairResponseType* ec2__DeleteKeyPairResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      DeleteKeyPair document
// gsoap ec2  service method-encoding:   DeleteKeyPair literal
// gsoap ec2  service method-action:     DeleteKeyPair DeleteKeyPair
int
__ec2__DeleteKeyPair(
  struct ec2__DeleteKeyPairType *ec2__DeleteKeyPair,                                 // /< Request parameter
  struct ec2__DeleteKeyPairResponseType *ec2__DeleteKeyPairResponse                          // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__RunInstances                                                      *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__RunInstances" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="RunInstances"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__RunInstances(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__RunInstancesType*       ec2__RunInstances,
   // response parameters:
   struct ec2__RunInstancesResponseType* ec2__RunInstancesResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__RunInstances(
   struct soap *soap,
   // request parameters:
   struct ec2__RunInstancesType*       ec2__RunInstances,
   // response parameters:
   struct ec2__RunInstancesResponseType* ec2__RunInstancesResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      RunInstances document
// gsoap ec2  service method-encoding:   RunInstances literal
// gsoap ec2  service method-action:     RunInstances RunInstances
int
__ec2__RunInstances(
  struct ec2__RunInstancesType *ec2__RunInstances,                                  // /< Request parameter
  struct ec2__RunInstancesResponseType *ec2__RunInstancesResponse                           // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__GetConsoleOutput                                                  *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__GetConsoleOutput" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="GetConsoleOutput"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__GetConsoleOutput(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__GetConsoleOutputType*   ec2__GetConsoleOutput,
   // response parameters:
   struct ec2__GetConsoleOutputResponseType* ec2__GetConsoleOutputResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__GetConsoleOutput(
   struct soap *soap,
   // request parameters:
   struct ec2__GetConsoleOutputType*   ec2__GetConsoleOutput,
   // response parameters:
   struct ec2__GetConsoleOutputResponseType* ec2__GetConsoleOutputResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      GetConsoleOutput document
// gsoap ec2  service method-encoding:   GetConsoleOutput literal
// gsoap ec2  service method-action:     GetConsoleOutput GetConsoleOutput
int
__ec2__GetConsoleOutput(
  struct ec2__GetConsoleOutputType *ec2__GetConsoleOutput,                              // /< Request parameter
  struct ec2__GetConsoleOutputResponseType *ec2__GetConsoleOutputResponse                               // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__TerminateInstances                                                *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__TerminateInstances" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="TerminateInstances"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__TerminateInstances(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__TerminateInstancesType* ec2__TerminateInstances,
   // response parameters:
   struct ec2__TerminateInstancesResponseType* ec2__TerminateInstancesResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__TerminateInstances(
   struct soap *soap,
   // request parameters:
   struct ec2__TerminateInstancesType* ec2__TerminateInstances,
   // response parameters:
   struct ec2__TerminateInstancesResponseType* ec2__TerminateInstancesResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      TerminateInstances document
// gsoap ec2  service method-encoding:   TerminateInstances literal
// gsoap ec2  service method-action:     TerminateInstances TerminateInstances
int
__ec2__TerminateInstances(
  struct ec2__TerminateInstancesType *ec2__TerminateInstances,                                    // /< Request parameter
  struct ec2__TerminateInstancesResponseType *ec2__TerminateInstancesResponse                             // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__RebootInstances                                                   *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__RebootInstances" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="RebootInstances"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__RebootInstances(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__RebootInstancesType*    ec2__RebootInstances,
   // response parameters:
   struct ec2__RebootInstancesResponseType* ec2__RebootInstancesResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__RebootInstances(
   struct soap *soap,
   // request parameters:
   struct ec2__RebootInstancesType*    ec2__RebootInstances,
   // response parameters:
   struct ec2__RebootInstancesResponseType* ec2__RebootInstancesResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      RebootInstances document
// gsoap ec2  service method-encoding:   RebootInstances literal
// gsoap ec2  service method-action:     RebootInstances RebootInstances
int
__ec2__RebootInstances(
  struct ec2__RebootInstancesType *ec2__RebootInstances,                               // /< Request parameter
  struct ec2__RebootInstancesResponseType *ec2__RebootInstancesResponse                                // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__DescribeInstances                                                 *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__DescribeInstances" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="DescribeInstances"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__DescribeInstances(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__DescribeInstancesType*  ec2__DescribeInstances,
   // response parameters:
   struct ec2__DescribeInstancesResponseType* ec2__DescribeInstancesResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__DescribeInstances(
   struct soap *soap,
   // request parameters:
   struct ec2__DescribeInstancesType*  ec2__DescribeInstances,
   // response parameters:
   struct ec2__DescribeInstancesResponseType* ec2__DescribeInstancesResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      DescribeInstances document
// gsoap ec2  service method-encoding:   DescribeInstances literal
// gsoap ec2  service method-action:     DescribeInstances DescribeInstances
int
__ec2__DescribeInstances(
  struct ec2__DescribeInstancesType *ec2__DescribeInstances,                             // /< Request parameter
  struct ec2__DescribeInstancesResponseType *ec2__DescribeInstancesResponse                              // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__DescribeImages                                                    *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__DescribeImages" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="DescribeImages"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__DescribeImages(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__DescribeImagesType*     ec2__DescribeImages,
   // response parameters:
   struct ec2__DescribeImagesResponseType* ec2__DescribeImagesResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__DescribeImages(
   struct soap *soap,
   // request parameters:
   struct ec2__DescribeImagesType*     ec2__DescribeImages,
   // response parameters:
   struct ec2__DescribeImagesResponseType* ec2__DescribeImagesResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      DescribeImages document
// gsoap ec2  service method-encoding:   DescribeImages literal
// gsoap ec2  service method-action:     DescribeImages DescribeImages
int
__ec2__DescribeImages(
  struct ec2__DescribeImagesType *ec2__DescribeImages,                                // /< Request parameter
  struct ec2__DescribeImagesResponseType *ec2__DescribeImagesResponse                         // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__CreateSecurityGroup                                               *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__CreateSecurityGroup" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="CreateSecurityGroup"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__CreateSecurityGroup(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__CreateSecurityGroupType* ec2__CreateSecurityGroup,
   // response parameters:
   struct ec2__CreateSecurityGroupResponseType* ec2__CreateSecurityGroupResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__CreateSecurityGroup(
   struct soap *soap,
   // request parameters:
   struct ec2__CreateSecurityGroupType* ec2__CreateSecurityGroup,
   // response parameters:
   struct ec2__CreateSecurityGroupResponseType* ec2__CreateSecurityGroupResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      CreateSecurityGroup document
// gsoap ec2  service method-encoding:   CreateSecurityGroup literal
// gsoap ec2  service method-action:     CreateSecurityGroup CreateSecurityGroup
int
__ec2__CreateSecurityGroup(
  struct ec2__CreateSecurityGroupType *ec2__CreateSecurityGroup,                                   // /< Request parameter
  struct ec2__CreateSecurityGroupResponseType *ec2__CreateSecurityGroupResponse                                    // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__DeleteSecurityGroup                                               *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__DeleteSecurityGroup" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="DeleteSecurityGroup"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__DeleteSecurityGroup(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__DeleteSecurityGroupType* ec2__DeleteSecurityGroup,
   // response parameters:
   struct ec2__DeleteSecurityGroupResponseType* ec2__DeleteSecurityGroupResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__DeleteSecurityGroup(
   struct soap *soap,
   // request parameters:
   struct ec2__DeleteSecurityGroupType* ec2__DeleteSecurityGroup,
   // response parameters:
   struct ec2__DeleteSecurityGroupResponseType* ec2__DeleteSecurityGroupResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      DeleteSecurityGroup document
// gsoap ec2  service method-encoding:   DeleteSecurityGroup literal
// gsoap ec2  service method-action:     DeleteSecurityGroup DeleteSecurityGroup
int
__ec2__DeleteSecurityGroup(
  struct ec2__DeleteSecurityGroupType *ec2__DeleteSecurityGroup,                                   // /< Request parameter
  struct ec2__DeleteSecurityGroupResponseType *ec2__DeleteSecurityGroupResponse                                    // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__DescribeSecurityGroups                                            *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__DescribeSecurityGroups" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="DescribeSecurityGroups"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__DescribeSecurityGroups(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__DescribeSecurityGroupsType* ec2__DescribeSecurityGroups,
   // response parameters:
   struct ec2__DescribeSecurityGroupsResponseType* ec2__DescribeSecurityGroupsResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__DescribeSecurityGroups(
   struct soap *soap,
   // request parameters:
   struct ec2__DescribeSecurityGroupsType* ec2__DescribeSecurityGroups,
   // response parameters:
   struct ec2__DescribeSecurityGroupsResponseType* ec2__DescribeSecurityGroupsResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      DescribeSecurityGroups document
// gsoap ec2  service method-encoding:   DescribeSecurityGroups literal
// gsoap ec2  service method-action:     DescribeSecurityGroups DescribeSecurityGroups
int
__ec2__DescribeSecurityGroups(
  struct ec2__DescribeSecurityGroupsType *ec2__DescribeSecurityGroups,                                        // /< Request parameter
  struct ec2__DescribeSecurityGroupsResponseType *
  ec2__DescribeSecurityGroupsResponse                                                                                 // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__AuthorizeSecurityGroupIngress                                     *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__AuthorizeSecurityGroupIngress" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="AuthorizeSecurityGroupIngress"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__AuthorizeSecurityGroupIngress(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__AuthorizeSecurityGroupIngressType* ec2__AuthorizeSecurityGroupIngress,
   // response parameters:
   struct ec2__AuthorizeSecurityGroupIngressResponseType* ec2__AuthorizeSecurityGroupIngressResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__AuthorizeSecurityGroupIngress(
   struct soap *soap,
   // request parameters:
   struct ec2__AuthorizeSecurityGroupIngressType* ec2__AuthorizeSecurityGroupIngress,
   // response parameters:
   struct ec2__AuthorizeSecurityGroupIngressResponseType* ec2__AuthorizeSecurityGroupIngressResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      AuthorizeSecurityGroupIngress document
// gsoap ec2  service method-encoding:   AuthorizeSecurityGroupIngress literal
// gsoap ec2  service method-action:     AuthorizeSecurityGroupIngress AuthorizeSecurityGroupIngress
int
__ec2__AuthorizeSecurityGroupIngress(
  struct ec2__AuthorizeSecurityGroupIngressType *
  ec2__AuthorizeSecurityGroupIngress,                                                                                        // /< Request parameter
  struct ec2__AuthorizeSecurityGroupIngressResponseType *
  ec2__AuthorizeSecurityGroupIngressResponse                                                                                                 // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__RevokeSecurityGroupIngress                                        *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__RevokeSecurityGroupIngress" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="RevokeSecurityGroupIngress"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__RevokeSecurityGroupIngress(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__RevokeSecurityGroupIngressType* ec2__RevokeSecurityGroupIngress,
   // response parameters:
   struct ec2__RevokeSecurityGroupIngressResponseType* ec2__RevokeSecurityGroupIngressResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__RevokeSecurityGroupIngress(
   struct soap *soap,
   // request parameters:
   struct ec2__RevokeSecurityGroupIngressType* ec2__RevokeSecurityGroupIngress,
   // response parameters:
   struct ec2__RevokeSecurityGroupIngressResponseType* ec2__RevokeSecurityGroupIngressResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      RevokeSecurityGroupIngress document
// gsoap ec2  service method-encoding:   RevokeSecurityGroupIngress literal
// gsoap ec2  service method-action:     RevokeSecurityGroupIngress RevokeSecurityGroupIngress
int
__ec2__RevokeSecurityGroupIngress(
  struct ec2__RevokeSecurityGroupIngressType *ec2__RevokeSecurityGroupIngress,                                            // /< Request parameter
  struct ec2__RevokeSecurityGroupIngressResponseType *
  ec2__RevokeSecurityGroupIngressResponse                                                                                         // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__ModifyImageAttribute                                              *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__ModifyImageAttribute" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="ModifyImageAttribute"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__ModifyImageAttribute(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__ModifyImageAttributeType* ec2__ModifyImageAttribute,
   // response parameters:
   struct ec2__ModifyImageAttributeResponseType* ec2__ModifyImageAttributeResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__ModifyImageAttribute(
   struct soap *soap,
   // request parameters:
   struct ec2__ModifyImageAttributeType* ec2__ModifyImageAttribute,
   // response parameters:
   struct ec2__ModifyImageAttributeResponseType* ec2__ModifyImageAttributeResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      ModifyImageAttribute document
// gsoap ec2  service method-encoding:   ModifyImageAttribute literal
// gsoap ec2  service method-action:     ModifyImageAttribute ModifyImageAttribute
int
__ec2__ModifyImageAttribute(
  struct ec2__ModifyImageAttributeType *ec2__ModifyImageAttribute,                                  // /< Request parameter
  struct ec2__ModifyImageAttributeResponseType *
  ec2__ModifyImageAttributeResponse                                                                                 // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__ResetImageAttribute                                               *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__ResetImageAttribute" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="ResetImageAttribute"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__ResetImageAttribute(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__ResetImageAttributeType* ec2__ResetImageAttribute,
   // response parameters:
   struct ec2__ResetImageAttributeResponseType* ec2__ResetImageAttributeResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__ResetImageAttribute(
   struct soap *soap,
   // request parameters:
   struct ec2__ResetImageAttributeType* ec2__ResetImageAttribute,
   // response parameters:
   struct ec2__ResetImageAttributeResponseType* ec2__ResetImageAttributeResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      ResetImageAttribute document
// gsoap ec2  service method-encoding:   ResetImageAttribute literal
// gsoap ec2  service method-action:     ResetImageAttribute ResetImageAttribute
int
__ec2__ResetImageAttribute(
  struct ec2__ResetImageAttributeType *ec2__ResetImageAttribute,                                   // /< Request parameter
  struct ec2__ResetImageAttributeResponseType *ec2__ResetImageAttributeResponse                                    // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__DescribeImageAttribute                                            *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__DescribeImageAttribute" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="DescribeImageAttribute"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__DescribeImageAttribute(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__DescribeImageAttributeType* ec2__DescribeImageAttribute,
   // response parameters:
   struct ec2__DescribeImageAttributeResponseType* ec2__DescribeImageAttributeResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__DescribeImageAttribute(
   struct soap *soap,
   // request parameters:
   struct ec2__DescribeImageAttributeType* ec2__DescribeImageAttribute,
   // response parameters:
   struct ec2__DescribeImageAttributeResponseType* ec2__DescribeImageAttributeResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      DescribeImageAttribute document
// gsoap ec2  service method-encoding:   DescribeImageAttribute literal
// gsoap ec2  service method-action:     DescribeImageAttribute DescribeImageAttribute
int
__ec2__DescribeImageAttribute(
  struct ec2__DescribeImageAttributeType *ec2__DescribeImageAttribute,                                        // /< Request parameter
  struct ec2__DescribeImageAttributeResponseType *
  ec2__DescribeImageAttributeResponse                                                                                 // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__ConfirmProductInstance                                            *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__ConfirmProductInstance" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="ConfirmProductInstance"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__ConfirmProductInstance(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__ConfirmProductInstanceType* ec2__ConfirmProductInstance,
   // response parameters:
   struct ec2__ConfirmProductInstanceResponseType* ec2__ConfirmProductInstanceResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__ConfirmProductInstance(
   struct soap *soap,
   // request parameters:
   struct ec2__ConfirmProductInstanceType* ec2__ConfirmProductInstance,
   // response parameters:
   struct ec2__ConfirmProductInstanceResponseType* ec2__ConfirmProductInstanceResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      ConfirmProductInstance document
// gsoap ec2  service method-encoding:   ConfirmProductInstance literal
// gsoap ec2  service method-action:     ConfirmProductInstance ConfirmProductInstance
int
__ec2__ConfirmProductInstance(
  struct ec2__ConfirmProductInstanceType *ec2__ConfirmProductInstance,                                        // /< Request parameter
  struct ec2__ConfirmProductInstanceResponseType *
  ec2__ConfirmProductInstanceResponse                                                                                 // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__DescribeAvailabilityZones                                         *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__DescribeAvailabilityZones" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="DescribeAvailabilityZones"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__DescribeAvailabilityZones(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__DescribeAvailabilityZonesType* ec2__DescribeAvailabilityZones,
   // response parameters:
   struct ec2__DescribeAvailabilityZonesResponseType* ec2__DescribeAvailabilityZonesResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__DescribeAvailabilityZones(
   struct soap *soap,
   // request parameters:
   struct ec2__DescribeAvailabilityZonesType* ec2__DescribeAvailabilityZones,
   // response parameters:
   struct ec2__DescribeAvailabilityZonesResponseType* ec2__DescribeAvailabilityZonesResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      DescribeAvailabilityZones document
// gsoap ec2  service method-encoding:   DescribeAvailabilityZones literal
// gsoap ec2  service method-action:     DescribeAvailabilityZones DescribeAvailabilityZones
int
__ec2__DescribeAvailabilityZones(
  struct ec2__DescribeAvailabilityZonesType *ec2__DescribeAvailabilityZones,                                     // /< Request parameter
  struct ec2__DescribeAvailabilityZonesResponseType *
  ec2__DescribeAvailabilityZonesResponse                                                                                         // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__AllocateAddress                                                   *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__AllocateAddress" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="AllocateAddress"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__AllocateAddress(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__AllocateAddressType*    ec2__AllocateAddress,
   // response parameters:
   struct ec2__AllocateAddressResponseType* ec2__AllocateAddressResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__AllocateAddress(
   struct soap *soap,
   // request parameters:
   struct ec2__AllocateAddressType*    ec2__AllocateAddress,
   // response parameters:
   struct ec2__AllocateAddressResponseType* ec2__AllocateAddressResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      AllocateAddress document
// gsoap ec2  service method-encoding:   AllocateAddress literal
// gsoap ec2  service method-action:     AllocateAddress AllocateAddress
int
__ec2__AllocateAddress(
  struct ec2__AllocateAddressType *ec2__AllocateAddress,                               // /< Request parameter
  struct ec2__AllocateAddressResponseType *ec2__AllocateAddressResponse                                // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__ReleaseAddress                                                    *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__ReleaseAddress" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="ReleaseAddress"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__ReleaseAddress(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__ReleaseAddressType*     ec2__ReleaseAddress,
   // response parameters:
   struct ec2__ReleaseAddressResponseType* ec2__ReleaseAddressResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__ReleaseAddress(
   struct soap *soap,
   // request parameters:
   struct ec2__ReleaseAddressType*     ec2__ReleaseAddress,
   // response parameters:
   struct ec2__ReleaseAddressResponseType* ec2__ReleaseAddressResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      ReleaseAddress document
// gsoap ec2  service method-encoding:   ReleaseAddress literal
// gsoap ec2  service method-action:     ReleaseAddress ReleaseAddress
int
__ec2__ReleaseAddress(
  struct ec2__ReleaseAddressType *ec2__ReleaseAddress,                                // /< Request parameter
  struct ec2__ReleaseAddressResponseType *ec2__ReleaseAddressResponse                         // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__DescribeAddresses                                                 *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__DescribeAddresses" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="DescribeAddresses"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__DescribeAddresses(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__DescribeAddressesType*  ec2__DescribeAddresses,
   // response parameters:
   struct ec2__DescribeAddressesResponseType* ec2__DescribeAddressesResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__DescribeAddresses(
   struct soap *soap,
   // request parameters:
   struct ec2__DescribeAddressesType*  ec2__DescribeAddresses,
   // response parameters:
   struct ec2__DescribeAddressesResponseType* ec2__DescribeAddressesResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      DescribeAddresses document
// gsoap ec2  service method-encoding:   DescribeAddresses literal
// gsoap ec2  service method-action:     DescribeAddresses DescribeAddresses
int
__ec2__DescribeAddresses(
  struct ec2__DescribeAddressesType *ec2__DescribeAddresses,                             // /< Request parameter
  struct ec2__DescribeAddressesResponseType *ec2__DescribeAddressesResponse                              // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__AssociateAddress                                                  *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__AssociateAddress" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="AssociateAddress"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__AssociateAddress(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__AssociateAddressType*   ec2__AssociateAddress,
   // response parameters:
   struct ec2__AssociateAddressResponseType* ec2__AssociateAddressResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__AssociateAddress(
   struct soap *soap,
   // request parameters:
   struct ec2__AssociateAddressType*   ec2__AssociateAddress,
   // response parameters:
   struct ec2__AssociateAddressResponseType* ec2__AssociateAddressResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      AssociateAddress document
// gsoap ec2  service method-encoding:   AssociateAddress literal
// gsoap ec2  service method-action:     AssociateAddress AssociateAddress
int
__ec2__AssociateAddress(
  struct ec2__AssociateAddressType *ec2__AssociateAddress,                              // /< Request parameter
  struct ec2__AssociateAddressResponseType *ec2__AssociateAddressResponse                               // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__DisassociateAddress                                               *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__DisassociateAddress" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="DisassociateAddress"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__DisassociateAddress(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__DisassociateAddressType* ec2__DisassociateAddress,
   // response parameters:
   struct ec2__DisassociateAddressResponseType* ec2__DisassociateAddressResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__DisassociateAddress(
   struct soap *soap,
   // request parameters:
   struct ec2__DisassociateAddressType* ec2__DisassociateAddress,
   // response parameters:
   struct ec2__DisassociateAddressResponseType* ec2__DisassociateAddressResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      DisassociateAddress document
// gsoap ec2  service method-encoding:   DisassociateAddress literal
// gsoap ec2  service method-action:     DisassociateAddress DisassociateAddress
int
__ec2__DisassociateAddress(
  struct ec2__DisassociateAddressType *ec2__DisassociateAddress,                                   // /< Request parameter
  struct ec2__DisassociateAddressResponseType *ec2__DisassociateAddressResponse                                    // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__CreateVolume                                                      *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__CreateVolume" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="CreateVolume"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__CreateVolume(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__CreateVolumeType*       ec2__CreateVolume,
   // response parameters:
   struct ec2__CreateVolumeResponseType* ec2__CreateVolumeResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__CreateVolume(
   struct soap *soap,
   // request parameters:
   struct ec2__CreateVolumeType*       ec2__CreateVolume,
   // response parameters:
   struct ec2__CreateVolumeResponseType* ec2__CreateVolumeResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      CreateVolume document
// gsoap ec2  service method-encoding:   CreateVolume literal
// gsoap ec2  service method-action:     CreateVolume CreateVolume
int
__ec2__CreateVolume(
  struct ec2__CreateVolumeType *ec2__CreateVolume,                                  // /< Request parameter
  struct ec2__CreateVolumeResponseType *ec2__CreateVolumeResponse                           // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__DeleteVolume                                                      *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__DeleteVolume" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="DeleteVolume"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__DeleteVolume(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__DeleteVolumeType*       ec2__DeleteVolume,
   // response parameters:
   struct ec2__DeleteVolumeResponseType* ec2__DeleteVolumeResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__DeleteVolume(
   struct soap *soap,
   // request parameters:
   struct ec2__DeleteVolumeType*       ec2__DeleteVolume,
   // response parameters:
   struct ec2__DeleteVolumeResponseType* ec2__DeleteVolumeResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      DeleteVolume document
// gsoap ec2  service method-encoding:   DeleteVolume literal
// gsoap ec2  service method-action:     DeleteVolume DeleteVolume
int
__ec2__DeleteVolume(
  struct ec2__DeleteVolumeType *ec2__DeleteVolume,                                  // /< Request parameter
  struct ec2__DeleteVolumeResponseType *ec2__DeleteVolumeResponse                           // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__DescribeVolumes                                                   *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__DescribeVolumes" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="DescribeVolumes"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__DescribeVolumes(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__DescribeVolumesType*    ec2__DescribeVolumes,
   // response parameters:
   struct ec2__DescribeVolumesResponseType* ec2__DescribeVolumesResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__DescribeVolumes(
   struct soap *soap,
   // request parameters:
   struct ec2__DescribeVolumesType*    ec2__DescribeVolumes,
   // response parameters:
   struct ec2__DescribeVolumesResponseType* ec2__DescribeVolumesResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      DescribeVolumes document
// gsoap ec2  service method-encoding:   DescribeVolumes literal
// gsoap ec2  service method-action:     DescribeVolumes DescribeVolumes
int
__ec2__DescribeVolumes(
  struct ec2__DescribeVolumesType *ec2__DescribeVolumes,                               // /< Request parameter
  struct ec2__DescribeVolumesResponseType *ec2__DescribeVolumesResponse                                // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__AttachVolume                                                      *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__AttachVolume" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="AttachVolume"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__AttachVolume(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__AttachVolumeType*       ec2__AttachVolume,
   // response parameters:
   struct ec2__AttachVolumeResponseType* ec2__AttachVolumeResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__AttachVolume(
   struct soap *soap,
   // request parameters:
   struct ec2__AttachVolumeType*       ec2__AttachVolume,
   // response parameters:
   struct ec2__AttachVolumeResponseType* ec2__AttachVolumeResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      AttachVolume document
// gsoap ec2  service method-encoding:   AttachVolume literal
// gsoap ec2  service method-action:     AttachVolume AttachVolume
int
__ec2__AttachVolume(
  struct ec2__AttachVolumeType *ec2__AttachVolume,                                  // /< Request parameter
  struct ec2__AttachVolumeResponseType *ec2__AttachVolumeResponse                           // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__DetachVolume                                                      *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__DetachVolume" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="DetachVolume"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__DetachVolume(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__DetachVolumeType*       ec2__DetachVolume,
   // response parameters:
   struct ec2__DetachVolumeResponseType* ec2__DetachVolumeResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__DetachVolume(
   struct soap *soap,
   // request parameters:
   struct ec2__DetachVolumeType*       ec2__DetachVolume,
   // response parameters:
   struct ec2__DetachVolumeResponseType* ec2__DetachVolumeResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      DetachVolume document
// gsoap ec2  service method-encoding:   DetachVolume literal
// gsoap ec2  service method-action:     DetachVolume DetachVolume
int
__ec2__DetachVolume(
  struct ec2__DetachVolumeType *ec2__DetachVolume,                                  // /< Request parameter
  struct ec2__DetachVolumeResponseType *ec2__DetachVolumeResponse                           // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__CreateSnapshot                                                    *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__CreateSnapshot" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="CreateSnapshot"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__CreateSnapshot(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__CreateSnapshotType*     ec2__CreateSnapshot,
   // response parameters:
   struct ec2__CreateSnapshotResponseType* ec2__CreateSnapshotResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__CreateSnapshot(
   struct soap *soap,
   // request parameters:
   struct ec2__CreateSnapshotType*     ec2__CreateSnapshot,
   // response parameters:
   struct ec2__CreateSnapshotResponseType* ec2__CreateSnapshotResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      CreateSnapshot document
// gsoap ec2  service method-encoding:   CreateSnapshot literal
// gsoap ec2  service method-action:     CreateSnapshot CreateSnapshot
int
__ec2__CreateSnapshot(
  struct ec2__CreateSnapshotType *ec2__CreateSnapshot,                                // /< Request parameter
  struct ec2__CreateSnapshotResponseType *ec2__CreateSnapshotResponse                         // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__DeleteSnapshot                                                    *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__DeleteSnapshot" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="DeleteSnapshot"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__DeleteSnapshot(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__DeleteSnapshotType*     ec2__DeleteSnapshot,
   // response parameters:
   struct ec2__DeleteSnapshotResponseType* ec2__DeleteSnapshotResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__DeleteSnapshot(
   struct soap *soap,
   // request parameters:
   struct ec2__DeleteSnapshotType*     ec2__DeleteSnapshot,
   // response parameters:
   struct ec2__DeleteSnapshotResponseType* ec2__DeleteSnapshotResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      DeleteSnapshot document
// gsoap ec2  service method-encoding:   DeleteSnapshot literal
// gsoap ec2  service method-action:     DeleteSnapshot DeleteSnapshot
int
__ec2__DeleteSnapshot(
  struct ec2__DeleteSnapshotType *ec2__DeleteSnapshot,                                // /< Request parameter
  struct ec2__DeleteSnapshotResponseType *ec2__DeleteSnapshotResponse                         // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__DescribeSnapshots                                                 *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__DescribeSnapshots" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="DescribeSnapshots"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__DescribeSnapshots(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__DescribeSnapshotsType*  ec2__DescribeSnapshots,
   // response parameters:
   struct ec2__DescribeSnapshotsResponseType* ec2__DescribeSnapshotsResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__DescribeSnapshots(
   struct soap *soap,
   // request parameters:
   struct ec2__DescribeSnapshotsType*  ec2__DescribeSnapshots,
   // response parameters:
   struct ec2__DescribeSnapshotsResponseType* ec2__DescribeSnapshotsResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      DescribeSnapshots document
// gsoap ec2  service method-encoding:   DescribeSnapshots literal
// gsoap ec2  service method-action:     DescribeSnapshots DescribeSnapshots
int
__ec2__DescribeSnapshots(
  struct ec2__DescribeSnapshotsType *ec2__DescribeSnapshots,                             // /< Request parameter
  struct ec2__DescribeSnapshotsResponseType *ec2__DescribeSnapshotsResponse                              // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__BundleInstance                                                    *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__BundleInstance" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="BundleInstance"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__BundleInstance(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__BundleInstanceType*     ec2__BundleInstance,
   // response parameters:
   struct ec2__BundleInstanceResponseType* ec2__BundleInstanceResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__BundleInstance(
   struct soap *soap,
   // request parameters:
   struct ec2__BundleInstanceType*     ec2__BundleInstance,
   // response parameters:
   struct ec2__BundleInstanceResponseType* ec2__BundleInstanceResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      BundleInstance document
// gsoap ec2  service method-encoding:   BundleInstance literal
// gsoap ec2  service method-action:     BundleInstance BundleInstance
int
__ec2__BundleInstance(
  struct ec2__BundleInstanceType *ec2__BundleInstance,                                // /< Request parameter
  struct ec2__BundleInstanceResponseType *ec2__BundleInstanceResponse                         // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__DescribeBundleTasks                                               *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__DescribeBundleTasks" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="DescribeBundleTasks"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__DescribeBundleTasks(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__DescribeBundleTasksType* ec2__DescribeBundleTasks,
   // response parameters:
   struct ec2__DescribeBundleTasksResponseType* ec2__DescribeBundleTasksResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__DescribeBundleTasks(
   struct soap *soap,
   // request parameters:
   struct ec2__DescribeBundleTasksType* ec2__DescribeBundleTasks,
   // response parameters:
   struct ec2__DescribeBundleTasksResponseType* ec2__DescribeBundleTasksResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      DescribeBundleTasks document
// gsoap ec2  service method-encoding:   DescribeBundleTasks literal
// gsoap ec2  service method-action:     DescribeBundleTasks DescribeBundleTasks
int
__ec2__DescribeBundleTasks(
  struct ec2__DescribeBundleTasksType *ec2__DescribeBundleTasks,                                   // /< Request parameter
  struct ec2__DescribeBundleTasksResponseType *ec2__DescribeBundleTasksResponse                                    // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__CancelBundleTask                                                  *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__CancelBundleTask" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="CancelBundleTask"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__CancelBundleTask(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__CancelBundleTaskType*   ec2__CancelBundleTask,
   // response parameters:
   struct ec2__CancelBundleTaskResponseType* ec2__CancelBundleTaskResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__CancelBundleTask(
   struct soap *soap,
   // request parameters:
   struct ec2__CancelBundleTaskType*   ec2__CancelBundleTask,
   // response parameters:
   struct ec2__CancelBundleTaskResponseType* ec2__CancelBundleTaskResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      CancelBundleTask document
// gsoap ec2  service method-encoding:   CancelBundleTask literal
// gsoap ec2  service method-action:     CancelBundleTask CancelBundleTask
int
__ec2__CancelBundleTask(
  struct ec2__CancelBundleTaskType *ec2__CancelBundleTask,                              // /< Request parameter
  struct ec2__CancelBundleTaskResponseType *ec2__CancelBundleTaskResponse                               // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* Service Operation                                                          *
*   __ec2__DescribeRegions                                                   *
*                                                                            *
\******************************************************************************/


// / Operation "__ec2__DescribeRegions" of service binding "AmazonEC2Binding"

/**

   Operation details:

   - SOAP document/literal style
   - SOAP action="DescribeRegions"

   C stub function (defined in soapClient.c[pp] generated by soapcpp2):
   @code
   int soap_call___ec2__DescribeRegions(
   struct soap *soap,
   NULL, // char *endpoint = NULL selects default endpoint for this operation
   NULL, // char *action = NULL selects default action for this operation
   // request parameters:
   struct ec2__DescribeRegionsType*    ec2__DescribeRegions,
   // response parameters:
   struct ec2__DescribeRegionsResponseType* ec2__DescribeRegionsResponse
   );
   @endcode

   C server function (called from the service dispatcher defined in soapServer.c[pp]):
   @code
   int __ec2__DescribeRegions(
   struct soap *soap,
   // request parameters:
   struct ec2__DescribeRegionsType*    ec2__DescribeRegions,
   // response parameters:
   struct ec2__DescribeRegionsResponseType* ec2__DescribeRegionsResponse
   );
   @endcode

 */

// gsoap ec2  service method-style:      DescribeRegions document
// gsoap ec2  service method-encoding:   DescribeRegions literal
// gsoap ec2  service method-action:     DescribeRegions DescribeRegions
int
__ec2__DescribeRegions(
  struct ec2__DescribeRegionsType *ec2__DescribeRegions,                               // /< Request parameter
  struct ec2__DescribeRegionsResponseType *ec2__DescribeRegionsResponse                                // /< Response parameter
  );

/******************************************************************************\
*                                                                            *
* XML Data Binding                                                           *
*                                                                            *
\******************************************************************************/


/**

   @page page_XMLDataBinding XML Data Binding

   SOAP/XML services use data bindings contractually bound by WSDL and auto-
   generated by wsdl2h and soapcpp2 (see Service Bindings). Plain data bindings
   are adopted from XML schemas as part of the WSDL types section or when running
   wsdl2h on a set of schemas to produce non-SOAP-based XML data bindings.

   The following readers and writers are C/C++ data type (de)serializers auto-
   generated by wsdl2h and soapcpp2. Run soapcpp2 on this file to generate the
   (de)serialization code, which is stored in soapC.c[pp]. Include "soapH.h" in
   your code to import these data type and function declarations. Only use the
   soapcpp2-generated files in your project build. Do not include the wsdl2h-
   generated .h file in your code.

   XML content can be retrieved from:
   - a FILE* fd, using soap->recvfd = fd
   - a socket, using soap->socket = ...
   - a C++ stream, using soap->is = ...
   - a buffer, using the soap->frecv() callback

   XML content can be stored to:
   - a FILE* fd, using soap->sendfd = fd
   - a socket, using soap->socket = ...
   - a C++ stream, using soap->os = ...
   - a buffer, using the soap->fsend() callback


   @section ec2 Top-level root elements of schema "http://ec2.amazonaws.com/doc/2008-12-01/"

   - <ec2:RegisterImage> (use wsdl2h option -g to auto-generate)

   - <ec2:RegisterImageResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:DeregisterImage> (use wsdl2h option -g to auto-generate)

   - <ec2:DeregisterImageResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:CreateKeyPair> (use wsdl2h option -g to auto-generate)

   - <ec2:CreateKeyPairResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:DeleteKeyPair> (use wsdl2h option -g to auto-generate)

   - <ec2:DeleteKeyPairResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeKeyPairs> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeKeyPairsResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:RunInstances> (use wsdl2h option -g to auto-generate)

   - <ec2:RunInstancesResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:GetConsoleOutput> (use wsdl2h option -g to auto-generate)

   - <ec2:GetConsoleOutputResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:TerminateInstances> (use wsdl2h option -g to auto-generate)

   - <ec2:TerminateInstancesResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:RebootInstances> (use wsdl2h option -g to auto-generate)

   - <ec2:RebootInstancesResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeInstances> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeInstancesResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeImages> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeImagesResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:CreateSecurityGroup> (use wsdl2h option -g to auto-generate)

   - <ec2:CreateSecurityGroupResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:DeleteSecurityGroup> (use wsdl2h option -g to auto-generate)

   - <ec2:DeleteSecurityGroupResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeSecurityGroups> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeSecurityGroupsResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:AuthorizeSecurityGroupIngress> (use wsdl2h option -g to auto-generate)

   - <ec2:AuthorizeSecurityGroupIngressResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:RevokeSecurityGroupIngress> (use wsdl2h option -g to auto-generate)

   - <ec2:RevokeSecurityGroupIngressResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:ModifyImageAttribute> (use wsdl2h option -g to auto-generate)

   - <ec2:ModifyImageAttributeResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:ResetImageAttribute> (use wsdl2h option -g to auto-generate)

   - <ec2:ResetImageAttributeResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeImageAttribute> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeImageAttributeResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:ConfirmProductInstance> (use wsdl2h option -g to auto-generate)

   - <ec2:ConfirmProductInstanceResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeAvailabilityZones> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeAvailabilityZonesResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:AllocateAddress> (use wsdl2h option -g to auto-generate)

   - <ec2:AllocateAddressResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:ReleaseAddress> (use wsdl2h option -g to auto-generate)

   - <ec2:ReleaseAddressResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeAddresses> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeAddressesResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:AssociateAddress> (use wsdl2h option -g to auto-generate)

   - <ec2:AssociateAddressResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:DisassociateAddress> (use wsdl2h option -g to auto-generate)

   - <ec2:DisassociateAddressResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:CreateVolume> (use wsdl2h option -g to auto-generate)

   - <ec2:CreateVolumeResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:DeleteVolume> (use wsdl2h option -g to auto-generate)

   - <ec2:DeleteVolumeResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeVolumes> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeVolumesResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:AttachVolume> (use wsdl2h option -g to auto-generate)

   - <ec2:AttachVolumeResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:DetachVolume> (use wsdl2h option -g to auto-generate)

   - <ec2:DetachVolumeResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:CreateSnapshot> (use wsdl2h option -g to auto-generate)

   - <ec2:CreateSnapshotResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:DeleteSnapshot> (use wsdl2h option -g to auto-generate)

   - <ec2:DeleteSnapshotResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeSnapshots> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeSnapshotsResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:BundleInstance> (use wsdl2h option -g to auto-generate)

   - <ec2:BundleInstanceResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeBundleTasks> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeBundleTasksResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:CancelBundleTask> (use wsdl2h option -g to auto-generate)

   - <ec2:CancelBundleTaskResponse> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeRegions> (use wsdl2h option -g to auto-generate)

   - <ec2:DescribeRegionsResponse> (use wsdl2h option -g to auto-generate)

 */

/* End of euca.h */
