/*!

\if MANPAGES
\page storescp DICOM storage (C-STORE) SCP
\else
\page storescp storescp: DICOM storage (C-STORE) SCP
\endif

\section synopsis SYNOPSIS

\verbatim
storescp [options] [port]
\endverbatim

\section description DESCRIPTION

The \b storescp application implements a Service Class Provider (SCP) for the
Storage Service Class.  It listens on a specific TCP/IP port for incoming
association requests from a Storage Service Class User (SCU) and can receive
both DICOM images and other DICOM composite objects.  The \b storescp
application also supports the Verification Service Class as an SCP.

\section parameters PARAMETERS

\verbatim
port  tcp/ip port number to listen on
      (this parameter is required unless the --inetd option is specified)
\endverbatim

\section options OPTIONS

\subsection general_options general options
\verbatim
  -h    --help
          print this help text and exit

        --version
          print version information and exit

        --arguments
          print expanded command line arguments

  -q    --quiet
          quiet mode, print no warnings and errors

  -v    --verbose
          verbose mode, print processing details

  -d    --debug
          debug mode, print debug information

  -ll   --log-level  [l]evel: string constant
          (fatal, error, warn, info, debug, trace)
          use level l for the logger

  -lc   --log-config  [f]ilename: string
          use config file f for the logger

  +v    --verbose-pc
          show presentation contexts in verbose mode
\endverbatim

\subsection multi_process_options multi-process options
\verbatim
        --single-process
          single process mode (default)

        --fork
          fork child process for each association
\endverbatim

\subsection network_options network options
\verbatim
association negotiation profile from configuration file:

  -xf   --config-file  [f]ilename [p]rofile: string
          use profile p from config file f

preferred network transfer syntaxes (not with --config-file):

  +x=   --prefer-uncompr
          prefer explicit VR local byte order (default)

  +xe   --prefer-little
          prefer explicit VR little endian TS

  +xb   --prefer-big
          prefer explicit VR big endian TS

  +xs   --prefer-lossless
          prefer default JPEG lossless TS

  +xy   --prefer-jpeg8
          prefer default JPEG lossy TS for 8 bit data

  +xx   --prefer-jpeg12
          prefer default JPEG lossy TS for 12 bit data

  +xv   --prefer-j2k-lossless
          prefer JPEG 2000 lossless TS

  +xw   --prefer-j2k-lossy
          prefer JPEG 2000 lossy TS

  +xt   --prefer-jls-lossless
          prefer JPEG-LS lossless TS

  +xu   --prefer-jls-lossy
          prefer JPEG-LS lossy TS

  +xm   --prefer-mpeg2
          prefer MPEG2 Main Profile @ Main Level TS

  +xh   --prefer-mpeg2-high
          prefer MPEG2 Main Profile @ High Level TS

  +xr   --prefer-rle
          prefer RLE lossless TS

  +xd   --prefer-deflated
          prefer deflated explicit VR little endian TS

  +xi   --implicit
          accept implicit VR little endian TS only

  +xa   --accept-all
          accept all supported transfer syntaxes

network host access control (tcp wrapper):

  -ac   --access-full
          accept connections from any host (default)

  +ac   --access-control
          enforce host access control rules

other network options:

  -id   --inetd
          run from inetd super server (not with --fork)
          (this option is available only on Posix platforms)

  -ta   --acse-timeout  [s]econds: integer (default: 30)
          timeout for ACSE messages

  -td   --dimse-timeout  [s]econds: integer (default: unlimited)
          timeout for DIMSE messages

  -aet  --aetitle  [a]etitle: string
          set my AE title (default: STORESCP)

  -pdu  --max-pdu  [n]umber of bytes: integer (4096..131072)
          set max receive pdu to n bytes (default: 16384)

  -dhl  --disable-host-lookup
          disable hostname lookup

        --refuse
          refuse association

        --reject
          reject association if no implementation class UID

        --ignore
          ignore store data, receive but do not store

        --sleep-after  [s]econds: integer
          sleep s seconds after store (default: 0)

        --sleep-during  [s]econds: integer
          sleep s seconds during store (default: 0)

        --abort-after
          abort association after receipt of C-STORE-RQ
          (but before sending response)

        --abort-during
          abort association during receipt of C-STORE-RQ

  -pm   --promiscuous
          promiscuous mode, accept unknown SOP classes
          (not with --config-file)

  -up   --uid-padding
          silently correct space-padded UIDs
\endverbatim

\section output_options output options

\verbatim
general:

  -od   --output-directory  [d]irectory: string (default: ".")
          write received objects to existing directory d

bit preserving mode:

  -B    --normal
          allow implicit format conversions (default)

  +B    --bit-preserving
          write data exactly as read

output file format:

  +F    --write-file
          write file format (default)

  -F    --write-dataset
          write data set without file meta information

output transfer syntax
(not with --bit-preserving or compressed transmission):

  +t=   --write-xfer-same
          write with same TS as input (default)

  +te   --write-xfer-little
          write with explicit VR little endian TS

  +tb   --write-xfer-big
          write with explicit VR big endian TS

  +ti   --write-xfer-implicit
          write with implicit VR little endian TS

  +td   --write-xfer-deflated
          write with deflated explicit VR little endian TS

post-1993 value representations (not with --bit-preserving):

  +u    --enable-new-vr
          enable support for new VRs (UN/UT) (default)

  -u    --disable-new-vr
          disable support for new VRs, convert to OB

group length encoding (not with --bit-preserving):

  +g=   --group-length-recalc
          recalculate group lengths if present (default)

  +g    --group-length-create
          always write with group length elements

  -g    --group-length-remove
          always write without group length elements

length encoding in sequences and items (not with --bit-preserving):

  +e    --length-explicit
          write with explicit lengths (default)

  -e    --length-undefined
          write with undefined lengths

data set trailing padding
(not with --write-dataset or --bit-preserving):

  -p    --padding-off
          no padding (default)

  +p    --padding-create  [f]ile-pad [i]tem-pad: integer
          align file on multiple of f bytes and items on
          multiple of i bytes

deflate compression level (only with --write-xfer-deflated/same):

  +cl   --compression-level  [l]evel: integer (default: 6)
          0=uncompressed, 1=fastest, 9=best compression

sorting into subdirectories (not with --bit-preserving):

  -ss   --sort-conc-studies  [p]refix: string
          sort studies using prefix p and a timestamp

  -su   --sort-on-study-uid  [p]refix: string
          sort studies using prefix p and the Study Instance UID

  -sp   --sort-on-patientname
          sort studies using the Patient's Name and a timestamp

filename generation:

  -uf   --default-filenames
          generate filename from instance UID (default)

  +uf   --unique-filenames
          generate unique filenames

  -tn   --timenames
          generate filename from creation time

  -fe   --filename-extension  [e]xtension: string
          append e to all filenames
\endverbatim

\subsection event_options event options
\verbatim
  -xcr  --exec-on-reception  [c]ommand: string
          execute command c after having received and processed
          one C-STORE-RQ message

  -xcs  --exec-on-eostudy  [c]ommand: string
          execute command c after having received and processed
          all C-STORE-RQ messages that belong to one study

  -rns  --rename-on-eostudy
          having received and processed all C-STORE-RQ messages
          that belong to one study, rename output files according
          to a certain pattern

  -tos  --eostudy-timeout  [t]imeout: integer
          specifies a timeout of t seconds for end-of-study
          determination

  -xs   --exec-sync
          execute command synchronously in foreground
\endverbatim

\subsection tls_options transport layer security (TLS) options
\verbatim
transport protocol stack:

  -tls  --disable-tls
          use normal TCP/IP connection (default)

  +tls  --enable-tls  [p]rivate key file, [c]ertificate file: string
          use authenticated secure TLS connection

private key password (only with --enable-tls):

  +ps   --std-passwd
          prompt user to type password on stdin (default)

  +pw   --use-passwd  [p]assword: string
          use specified password

  -pw   --null-passwd
          use empty string as password

key and certificate file format:

  -pem  --pem-keys
          read keys and certificates as PEM file (default)

  -der  --der-keys
          read keys and certificates as DER file

certification authority:

  +cf   --add-cert-file  [c]ertificate filename: string
          add certificate file to list of certificates

  +cd   --add-cert-dir  [c]ertificate directory: string
          add certificates in d to list of certificates

ciphersuite:

  +cs   --cipher  [c]iphersuite name: string
          add ciphersuite to list of negotiated suites

  +dp   --dhparam  [f]ilename: string
          read DH parameters for DH/DSS ciphersuites

pseudo random generator:

  +rs   --seed  [f]ilename: string
          seed random generator with contents of f

  +ws   --write-seed
          write back modified seed (only with --seed)

  +wf   --write-seed-file  [f]ilename: string (only with --seed)
          write modified seed to file f

peer authentication:

  -rc   --require-peer-cert
          verify peer certificate, fail if absent (default)

  -vc   --verify-peer-cert
          verify peer certificate if present

  -ic   --ignore-peer-cert
          don't verify peer certificate
\endverbatim

\section notes NOTES

The semantic impacts of the above mentioned options is clear for the majority
of options.  Some particular options, however, are so specific that they need
detailed descriptions which will be given in this passage.

Option \e --sort-conc-studies enables a user to sort all received DICOM objects
into different subdirectories.  The sorting will be done with regard to the
studies the individual objects belong to, i.e. objects that belong to the same
study will be stored in the same subdirectory.  In general, a DICOM object
d_n+1 is considered to belong to the same study as a DICOM object d_n if and
only if d_n and d_n+1 show the exact same values in attribute Study Instance
UID.  The names of the resulting subdirectories always start with a prefix p
which was passed to this option as a parameter.  In addition to this prefix,
the subdirectory names contain time stamp information with regard to the date
and time of reception of this particular study's first DICOM object.  In
detail, the determination of the subdirectory names pertains to the pattern

\verbatim
  [prefix]_[YYYYMMDD]_[HHMMSSPPP]
\endverbatim

where YYYY refers to year (4 digits), MM to month (01-12), DD to day (01-31),
HH to hour (00-23), MM to minute (00-59), SS to second (00-59) and PPP to
milliseconds (000-999).  If the prefix is an empty string, the first "_" is
omitted.

The other \e --sort-xxx options work in a similar manner, only the subdirectory
names are created differently.  For option \e --sort-on-study-uid the pattern
is

\verbatim
  [prefix]_[StudyInstanceUID]
\endverbatim

and for option \e --sort-on-patientname

\verbatim
  [PatientName]_[YYYYMMDD]_[HHMMSSPPP]
\endverbatim

where 'PatientName' is replaced by "ANONYMOUS" if the data element is empty or
absent in the data set.  Please note, however, that for option
\e --sort-on-study-uid the same subdirectory will be used for all DICOM objects
that belong to the same study, i.e. in contrast to the other \e --sort-xxx
options there is no guarantee that a study directory is ever completed.

Option \e --timenames creates filenames from timestamps corresponding to the
time, \b storescp writes a file to disk.  The format is

\verbatim
  [YYYYMMDDHHMMSSPPP]_[SERIALNO].[MD]
\endverbatim

where YYYY, MM, DD, HH, MM, SS, PPP are interpreted as described above.  If
more files are created at the same time, SERIALNO is inserted.  It consists of
a 4-digit, consecutive number (0000 to 9999).  For the first file, that exists
for a specific time, no number (and no "_") is inserted at all.  MD represents
an identification code (2 letters) for the kind of object stored in the file
(see notes on \e --rename-on-eostudy).

Option \e --filename-extension appends a specified suffix to each filename (a
dot "." is not added automatically).  This suffix is not appended to the
filenames created by \e --rename-on-eostudy to maintain the length of 8
characters.

Option \e --exec-on-reception allows to execute a certain command line after
having received and processed one DICOM object (through a C-STORE-RQ message).
The command line to be executed is passed to this option as a parameter.  The
specified command line may contain a number of placeholders which will be
replaced at run time:

\li \b \#p: complete path to the output directory into which the last DICOM
            object was stored (not available with option \e --ignore though)
\li \b \#f: filename of the current output file (not available with option
            \e --ignore though)
\li \b \#a: calling application entity title of the peer Storage SCU
\li \b \#c: called application entity title used by the peer Storage SCU to
            address \b storescp
\li \b \#r: calling presentation address, i.e. hostname or IP address of the
            peer Storage SCU

The specified command line is executed as a separate process, so that the
execution of \b storescp will not be held back.

Option \e --exec-on-eostudy allows to execute a certain command line when all
DICOM objects that belong to one study have been received by \b storescp.
The same placeholders as with \e --exec-on-reception may be used, except for
'\#f', which is not supported.  A study is considered complete by \b storescp
when an object belonging to a different study is received or the timeout
specified with \e --eostudy-timeout takes place.  If option
\e --rename-on-eostudy is in force, the renaming takes place before the
external command is executed.

Option \e --rename-on-eostudy refers to the above mentioned \e --sort-xxx
options and can only be used in combination with one of these options.
If a user specifies option \e --rename-on-eostudy and \b storescp
determines that all DICOM objects that belong to a certain study have
been received, all DICOM files that belong to the last study will be
renamed in the corresponding output directory.  The filenames into which
the files are being renamed will be calculated using the pattern

\verbatim
  [prefix][consecutive numbering]
\endverbatim

where [prefix] is a 2 character prefix that reveals the kind of DICOM object
stored in the file and [consecutive numbering] is a consecutively numbered,
6-digit number, starting at "000001".  In general, the question if all DICOM
objects that belong to one study have been received by \b storescp will be
answered positively if and only if two consecutively received DICOM objects
d_n and d_n+1 do not show the same values in attribute Study Instance UID; in
such a case, d_n+1 is considered to belong to a new study.

Using option \e --eostudy-timeout a user can modify the determination process
to figure out if all DICOM objects that belong to one study have already been
received by \b storescp.  With regard to this fact, it is clear that this
option can only be used in combination with at least one of the following
options: \e --sort-xxx, \e --exec-on-eostudy and \e --rename-on-eostudy.
If option \e --eostudy-timeout is specified, the end of a study is considered
to have occurred not only if two consecutively received DICOM objects d_n and
d_n+1 do not show the same values in attribute Study Instance UID, but also if
whithin a time span of x seconds after the reception of a DICOM object d_n, no
other DICOM object was received over the network.  Note that the amount x of
seconds (which determines the length of this time span) has to be passed to
this option as a parameter.

\subsection dicom_conformance DICOM Conformance

The \b storescp application supports the following SOP Classes as an SCP:

\verbatim
VerificationSOPClass                                 1.2.840.10008.1.1

RETIRED_StoredPrintStorage                           1.2.840.10008.5.1.1.27
RETIRED_HardcopyGrayscaleImageStorage                1.2.840.10008.5.1.1.29
RETIRED_HardcopyColorImageStorage                    1.2.840.10008.5.1.1.30
ComputedRadiographyImageStorage                      1.2.840.10008.5.1.4.1.1.1
DigitalXRayImageStorageForPresentation               1.2.840.10008.5.1.4.1.1.1.1
DigitalXRayImageStorageForProcessing                 1.2.840.10008.5.1.4.1.1.1.1.1
DigitalMammographyXRayImageStorageForPresentation    1.2.840.10008.5.1.4.1.1.1.2
DigitalMammographyXRayImageStorageForProcessing      1.2.840.10008.5.1.4.1.1.1.2.1
DigitalIntraOralXRayImageStorageForPresentation      1.2.840.10008.5.1.4.1.1.1.3
DigitalIntraOralXRayImageStorageForProcessing        1.2.840.10008.5.1.4.1.1.1.3.1
CTImageStorage                                       1.2.840.10008.5.1.4.1.1.2
EnhancedCTImageStorage                               1.2.840.10008.5.1.4.1.1.2.1
RETIRED_UltrasoundMultiframeImageStorage             1.2.840.10008.5.1.4.1.1.3
UltrasoundMultiframeImageStorage                     1.2.840.10008.5.1.4.1.1.3.1
MRImageStorage                                       1.2.840.10008.5.1.4.1.1.4
EnhancedMRImageStorage                               1.2.840.10008.5.1.4.1.1.4.1
MRSpectroscopyStorage                                1.2.840.10008.5.1.4.1.1.4.2
EnhancedMRColorImageStorage                          1.2.840.10008.5.1.4.1.1.4.3
RETIRED_NuclearMedicineImageStorage                  1.2.840.10008.5.1.4.1.1.5
RETIRED_UltrasoundImageStorage                       1.2.840.10008.5.1.4.1.1.6
UltrasoundImageStorage                               1.2.840.10008.5.1.4.1.1.6.1
EnhancedUSVolumeStorage                              1.2.840.10008.5.1.4.1.1.6.2
SecondaryCaptureImageStorage                         1.2.840.10008.5.1.4.1.1.7
MultiframeSingleBitSecondaryCaptureImageStorage      1.2.840.10008.5.1.4.1.1.7.1
MultiframeGrayscaleByteSecondaryCaptureImageStorage  1.2.840.10008.5.1.4.1.1.7.2
MultiframeGrayscaleWordSecondaryCaptureImageStorage  1.2.840.10008.5.1.4.1.1.7.3
MultiframeTrueColorSecondaryCaptureImageStorage      1.2.840.10008.5.1.4.1.1.7.4
RETIRED_StandaloneOverlayStorage                     1.2.840.10008.5.1.4.1.1.8
RETIRED_StandaloneCurveStorage                       1.2.840.10008.5.1.4.1.1.9
DRAFT_WaveformStorage                                1.2.840.10008.5.1.4.1.1.9.1
TwelveLeadECGWaveformStorage                         1.2.840.10008.5.1.4.1.1.9.1.1
GeneralECGWaveformStorage                            1.2.840.10008.5.1.4.1.1.9.1.2
AmbulatoryECGWaveformStorage                         1.2.840.10008.5.1.4.1.1.9.1.3
HemodynamicWaveformStorage                           1.2.840.10008.5.1.4.1.1.9.2.1
CardiacElectrophysiologyWaveformStorage              1.2.840.10008.5.1.4.1.1.9.3.1
BasicVoiceAudioWaveformStorage                       1.2.840.10008.5.1.4.1.1.9.4.1
GeneralAudioWaveformStorage                          1.2.840.10008.5.1.4.1.1.9.4.2
ArterialPulseWaveformStorage                         1.2.840.10008.5.1.4.1.1.9.5.1
RespiratoryWaveformStorage                           1.2.840.10008.5.1.4.1.1.9.6.1
RETIRED_StandaloneModalityLUTStorage                 1.2.840.10008.5.1.4.1.1.10
RETIRED_StandaloneVOILUTStorage                      1.2.840.10008.5.1.4.1.1.11
GrayscaleSoftcopyPresentationStateStorage            1.2.840.10008.5.1.4.1.1.11.1
ColorSoftcopyPresentationStateStorage                1.2.840.10008.5.1.4.1.1.11.2
PseudoColorSoftcopyPresentationStateStorage          1.2.840.10008.5.1.4.1.1.11.3
BlendingSoftcopyPresentationStateStorage             1.2.840.10008.5.1.4.1.1.11.4
XAXRFGrayscaleSoftcopyPresentationStateStorage       1.2.840.10008.5.1.4.1.1.11.5
XRayAngiographicImageStorage                         1.2.840.10008.5.1.4.1.1.12.1
EnhancedXAImageStorage                               1.2.840.10008.5.1.4.1.1.12.1.1
XRayRadiofluoroscopicImageStorage                    1.2.840.10008.5.1.4.1.1.12.2
EnhancedXRFImageStorage                              1.2.840.10008.5.1.4.1.1.12.2.1
XRay3DAngiographicImageStorage                       1.2.840.10008.5.1.4.1.1.13.1.1
XRay3DCraniofacialImageStorage                       1.2.840.10008.5.1.4.1.1.13.1.2
BreastTomosynthesisImageStorage                      1.2.840.10008.5.1.4.1.1.13.1.3
RETIRED_XRayAngiographicBiPlaneImageStorage          1.2.840.10008.5.1.4.1.1.12.3
NuclearMedicineImageStorage                          1.2.840.10008.5.1.4.1.1.20
RawDataStorage                                       1.2.840.10008.5.1.4.1.1.66
SpatialRegistrationStorage                           1.2.840.10008.5.1.4.1.1.66.1
SpatialFiducialsStorage                              1.2.840.10008.5.1.4.1.1.66.2
DeformableSpatialRegistrationStorage                 1.2.840.10008.5.1.4.1.1.66.3
SegmentationStorage                                  1.2.840.10008.5.1.4.1.1.66.4
SurfaceSegmentationStorage                           1.2.840.10008.5.1.4.1.1.66.5
RealWorldValueMappingStorage                         1.2.840.10008.5.1.4.1.1.67
RETIRED_VLImageStorage                               1.2.840.10008.5.1.4.1.1.77.1
VLEndoscopicImageStorage                             1.2.840.10008.5.1.4.1.1.77.1.1
VideoEndoscopicImageStorage                          1.2.840.10008.5.1.4.1.1.77.1.1.1
VLMicroscopicImageStorage                            1.2.840.10008.5.1.4.1.1.77.1.2
VideoMicroscopicImageStorage                         1.2.840.10008.5.1.4.1.1.77.1.2.1
VLSlideCoordinatesMicroscopicImageStorage            1.2.840.10008.5.1.4.1.1.77.1.3
VLPhotographicImageStorage                           1.2.840.10008.5.1.4.1.1.77.1.4
VideoPhotographicImageStorage                        1.2.840.10008.5.1.4.1.1.77.1.4.1
OphthalmicPhotography8BitImageStorage                1.2.840.10008.5.1.4.1.1.77.1.5.1
OphthalmicPhotography16BitImageStorage               1.2.840.10008.5.1.4.1.1.77.1.5.2
StereometricRelationshipStorage                      1.2.840.10008.5.1.4.1.1.77.1.5.3
OphthalmicTomographyImageStorage                     1.2.840.10008.5.1.4.1.1.77.1.5.4
VLWholeSlideMicroscopyImageStorage                   1.2.840.10008.5.1.4.1.1.77.1.6
RETIRED_VLMultiFrameImageStorage                     1.2.840.10008.5.1.4.1.1.77.2
LensometryMeasurementsStorage                        1.2.840.10008.5.1.4.1.1.78.1
AutorefractionMeasurementsStorage                    1.2.840.10008.5.1.4.1.1.78.2
KeratometryMeasurementsStorage                       1.2.840.10008.5.1.4.1.1.78.3
SubjectiveRefractionMeasurementsStorage              1.2.840.10008.5.1.4.1.1.78.4
VisualAcuityMeasurementsStorage                      1.2.840.10008.5.1.4.1.1.78.5
SpectaclePrescriptionReportStorage                   1.2.840.10008.5.1.4.1.1.78.6
OphthalmicAxialMeasurementsStorage                   1.2.840.10008.5.1.4.1.1.78.7
IntraocularLensCalculationsStorage                   1.2.840.10008.5.1.4.1.1.78.8
MacularGridThicknessAndVolumeReportStorage           1.2.840.10008.5.1.4.1.1.79.1
OphthalmicVisualFieldStaticPerimetryMeasurementsSt.  1.2.840.10008.5.1.4.1.1.80.1
DRAFT_SRTextStorage                                  1.2.840.10008.5.1.4.1.1.88.1
DRAFT_SRAudioStorage                                 1.2.840.10008.5.1.4.1.1.88.2
DRAFT_SRDetailStorage                                1.2.840.10008.5.1.4.1.1.88.3
DRAFT_SRComprehensiveStorage                         1.2.840.10008.5.1.4.1.1.88.4
BasicTextSRStorage                                   1.2.840.10008.5.1.4.1.1.88.11
EnhancedSRStorage                                    1.2.840.10008.5.1.4.1.1.88.22
ComprehensiveSRStorage                               1.2.840.10008.5.1.4.1.1.88.33
ProcedureLogStorage                                  1.2.840.10008.5.1.4.1.1.88.40
MammographyCADSRStorage                              1.2.840.10008.5.1.4.1.1.88.50
KeyObjectSelectionDocumentStorage                    1.2.840.10008.5.1.4.1.1.88.59
ChestCADSRStorage                                    1.2.840.10008.5.1.4.1.1.88.65
XRayRadiationDoseSRStorage                           1.2.840.10008.5.1.4.1.1.88.67
ColonCADSRStorage                                    1.2.840.10008.5.1.4.1.1.88.69
ImplantationPlanSRDocumentStorage                    1.2.840.10008.5.1.4.1.1.88.70
EncapsulatedPDFStorage                               1.2.840.10008.5.1.4.1.1.104.1
EncapsulatedCDAStorage                               1.2.840.10008.5.1.4.1.1.104.2
PositronEmissionTomographyImageStorage               1.2.840.10008.5.1.4.1.1.128
RETIRED_StandalonePETCurveStorage                    1.2.840.10008.5.1.4.1.1.129
EnhancedPETImageStorage                              1.2.840.10008.5.1.4.1.1.130
BasicStructuredDisplayStorage                        1.2.840.10008.5.1.4.1.1.131
RTImageStorage                                       1.2.840.10008.5.1.4.1.1.481.1
RTDoseStorage                                        1.2.840.10008.5.1.4.1.1.481.2
RTStructureSetStorage                                1.2.840.10008.5.1.4.1.1.481.3
RTBeamsTreatmentRecordStorage                        1.2.840.10008.5.1.4.1.1.481.4
RTPlanStorage                                        1.2.840.10008.5.1.4.1.1.481.5
RTBrachyTreatmentRecordStorage                       1.2.840.10008.5.1.4.1.1.481.6
RTTreatmentSummaryRecordStorage                      1.2.840.10008.5.1.4.1.1.481.7
RTIonPlanStorage                                     1.2.840.10008.5.1.4.1.1.481.8
RTIonBeamsTreatmentRecordStorage                     1.2.840.10008.5.1.4.1.1.481.9
DRAFT_RTBeamsDeliveryInstructionStorage              1.2.840.10008.5.1.4.34.1
GenericImplantTemplateStorage                        1.2.840.10008.5.1.4.43.1
ImplantAssemblyTemplateStorage                       1.2.840.10008.5.1.4.44.1
ImplantTemplateGroupStorage                          1.2.840.10008.5.1.4.45.1
\endverbatim

The \b storescp application will accept presentation contexts for all of the
abovementioned supported SOP Classes using any of the following transfer
syntaxes:

\verbatim
LittleEndianImplicitTransferSyntax                   1.2.840.10008.1.2
LittleEndianExplicitTransferSyntax                   1.2.840.10008.1.2.1
BigEndianExplicitTransferSyntax                      1.2.840.10008.1.2.2
\endverbatim

The default behaviour of the \b storescp application is to prefer transfer
syntaxes having an explicit encoding over the default implicit transfer syntax.
If \b storescp is running on big-endian hardware it will prefer
BigEndianExplicit to LittleEndianExplicit transfer syntax (and vice versa).
This behaviour can be changed with the \e --prefer options (see above).  Using
option \e --accept-all any of the following transfer syntaxes is supported:

\verbatim
LittleEndianImplicitTransferSyntax                   1.2.840.10008.1.2
LittleEndianExplicitTransferSyntax                   1.2.840.10008.1.2.1
DeflatedExplicitVRLittleEndianTransferSyntax         1.2.840.10008.1.2.1.99
BigEndianExplicitTransferSyntax                      1.2.840.10008.1.2.2
JPEGProcess1TransferSyntax                           1.2.840.10008.1.2.4.50
JPEGProcess2_4TransferSyntax                         1.2.840.10008.1.2.4.51
JPEGProcess14SV1TransferSyntax                       1.2.840.10008.1.2.4.70
JPEGLSLosslessTransferSyntax                         1.2.840.10008.1.2.4.80
JPEGLSLossyTransferSyntax                            1.2.840.10008.1.2.4.81
JPEG2000LosslessOnlyTransferSyntax                   1.2.840.10008.1.2.4.90
JPEG2000TransferSyntax                               1.2.840.10008.1.2.4.91
MPEG2MainProfileAtMainLevelTransferSyntax            1.2.840.10008.1.2.4.100
MPEG2MainProfileAtHighLevelTransferSyntax            1.2.840.10008.1.2.4.101
RLELosslessTransferSyntax                            1.2.840.10008.1.2.5
\endverbatim

Additional Storage SOP Classes and Transfer Syntaxes can be used with the
so-called "association negotiation profiles" (see below).

The \b storescp application does not support extended negotiation by default.
However, using an appropriate association negotiation profile (see below)
the optional support for extended negotiation can be added to particular SOP
classes.

\subsection access_control Access Control

When compiled on Unix platforms with TCP wrapper support, host-based access
control can be enabled with the \e --access-control command line option.  In
this case the access control rules defined in the system's host access control
tables for \b storescp are enforced.  The default locations of the host access
control tables are <em>/etc/hosts.allow</em> and <em>/etc/hosts.deny</em>.
Further details are described in <b>hosts_access</b>(5).

\subsection running_from_inetd Running storescp from inetd

On Posix platforms, \b storescp can be initiated through the inetd(8) super
server.  This requires that \b storescp be configured in the
<em>/etc/inetd.conf</em> configuration file.  A typical configuration line
could look like this:

\verbatim
acr-nema stream tcp nowait root /usr/sbin/storescp -id +ac -od /tmp/storescp
\endverbatim

where \e -id (\e --inetd) activates the inetd mode in which the DICOM
association is actually accepted by inetd and passed to \b storescp, \e +ac
(\e --access-control) activates the TCP wrapper based access control
described above and \e -od (\e --output-directory) defines the directory in
which \b storescp stores incoming DICOM objects.  Note that the service name
("acr-nema" in this example) determines the port number on which DICOM
associations are accepted and must be defined in <em>/etc/services</em>.
When runnning from inetd, the stdout and stderr streams are redirected to
files in the <em>/tmp</em> filesystem which can be identified by the
filename starting with the prefix "storescp_".

Please note that when run through inetd, \b storescp is executed with root
privileges, which may be a security risk.

\subsection profiles Association Negotiation Profiles and Configuration Files

\b storescp supports a flexible mechanism for specifying the DICOM network
association negotiation behaviour, based on so-called "association negotiation
profiles" which may be read from a configuration file.  The format and
semantics of this configuration file are documented in \e asconfig.txt.

\section logging LOGGING

The level of logging output of the various command line tools and underlying
libraries can be specified by the user.  By default, only errors and warnings
are written to the standard error stream.  Using option \e --verbose also
informational messages like processing details are reported.  Option
\e --debug can be used to get more details on the internal activity, e.g. for
debugging purposes.  Other logging levels can be selected using option
\e --log-level.  In \e --quiet mode only fatal errors are reported.  In such
very severe error events, the application will usually terminate.  For more
details on the different logging levels, see documentation of module "oflog".

In case the logging output should be written to file (optionally with logfile
rotation), to syslog (Unix) or the event log (Windows) option \e --log-config
can be used.  This configuration file also allows for directing only certain
messages to a particular output stream and for filtering certain messages
based on the module or application where they are generated.  An example
configuration file is provided in <em>\<etcdir\>/logger.cfg</em>).

\section command_line COMMAND LINE

All command line tools use the following notation for parameters: square
brackets enclose optional values (0-1), three trailing dots indicate that
multiple values are allowed (1-n), a combination of both means 0 to n values.

Command line options are distinguished from parameters by a leading '+' or '-'
sign, respectively.  Usually, order and position of command line options are
arbitrary (i.e. they can appear anywhere).  However, if options are mutually
exclusive the rightmost appearance is used.  This behaviour conforms to the
standard evaluation rules of common Unix shells.

In addition, one or more command files can be specified using an '@' sign as a
prefix to the filename (e.g. <em>\@command.txt</em>).  Such a command argument
is replaced by the content of the corresponding text file (multiple
whitespaces are treated as a single separator unless they appear between two
quotation marks) prior to any further evaluation.  Please note that a command
file cannot contain another command file.  This simple but effective approach
allows to summarize common combinations of options/parameters and avoids
longish and confusing command lines (an example is provided in file
<em>\<datadir\>/dumppat.txt</em>).

\section environment ENVIRONMENT

The \b storescp utility will attempt to load DICOM data dictionaries specified
in the \e DCMDICTPATH environment variable.  By default, i.e. if the
\e DCMDICTPATH environment variable is not set, the file
<em>\<datadir\>/dicom.dic</em> will be loaded unless the dictionary is built
into the application (default for Windows).

The default behaviour should be preferred and the \e DCMDICTPATH environment
variable only used when alternative data dictionaries are required.  The
\e DCMDICTPATH environment variable has the same format as the Unix shell
\e PATH variable in that a colon (":") separates entries.  On Windows systems,
a semicolon (";") is used as a separator.  The data dictionary code will
attempt to load each file specified in the \e DCMDICTPATH environment variable.
It is an error if no data dictionary can be loaded.

\section files FILES

<em>\<docdir\>/asconfig.txt</em> - configuration file documentation
\n<em>\<etcdir\>/storescp.cfg</em> - example association negotiation profile

\section see_also SEE ALSO

<b>storescu</b>(1)

\section copyright COPYRIGHT

Copyright (C) 1996-2010 by OFFIS e.V., Escherweg 2, 26121 Oldenburg, Germany.

*/
