/****************************************************************************
 *    lib/b/Scanner.l - This file is part of coala							*
 *																			*
 *    Copyright (C) 2009-2010  Torsten Grote								*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/

%{
#include <stdio.h>
#include "Parser.h"
%}

%option yylineno nounput noyywrap c++ prefix="b"

%s ltl

MOD		mod
IDENTIFIER	  [a-z][a-zA-Z0-9_]*
NEG_IDENTI	\-[a-z][a-zA-Z0-9_]*
NUMBER		[0-9]+
VARIABLE	[A-Z][a-zA-Z0-9_]*
COMMENT		\%.*\n
NOT		not
ACT		<action>
FLU		<fluent>
DFLU	<defined\ fluent>
CAUS	<caused>
CAUSES	<causes>
IF		<if>
EXE		<executable>
NONEXE	<impossible>
INIT	<initially>
OC_AT	<occurs\ at>
HO_AT	<holds\ at>
GOAL	<goal>
WHERE	<where>
TRUE	<true>
FALSE	<false>

%%
[\t\n ]+		// ignore white space.
"LTL:"			{ BEGIN(ltl); return BParser::LTL; }
<ltl>"X"		{ return BParser::X; }
<ltl>"F"		{ return BParser::F; }
<ltl>"G"		{ return BParser::G; }
<ltl>"U"		{ return BParser::U; }
<ltl>"R"		{ return BParser::R; }
{NOT}			{ return BParser::NOT; }
{ACT}			{ return BParser::ACT; }
{FLU}			{ return BParser::FLU; }
{DFLU}			{ return BParser::DFLU; }
{CAUS}			{ return BParser::CAUS; }
{CAUSES}		{ return BParser::CAUSES; }
{IF}			{ return BParser::IF; }
{EXE}			{ return BParser::EXE; }
{NONEXE}		{ return BParser::NONEXE; }
{INIT}			{ return BParser::INIT; }
{OC_AT}			{ return BParser::OC_AT; }
{HO_AT}			{ return BParser::HO_AT; }
{GOAL}			{ return BParser::GOAL; }
{WHERE}			{ return BParser::WHERE; }
{TRUE}			{ return BParser::TRUE; }
{FALSE}			{ return BParser::FALSE; }
{MOD}			{ return BParser::MOD; }
{IDENTIFIER}	{ return BParser::IDENTIFIER; }
{NEG_IDENTI}	{ return BParser::NEG_IDENTI; }
{NUMBER}		{ return BParser::NUMBER; }
{VARIABLE}		{ return BParser::VARIABLE; }
","				{ return BParser::COMMA; }
";"				{ return BParser::SEMIC; }
":"				{ return BParser::COLON; }
".."			{ return BParser::DDOT; }
"."				{ BEGIN(0); return BParser::DOT; }
"("				{ return BParser::LBRAC; }
")"				{ return BParser::RBRAC; }
"=="			{ return BParser::EQ; }
"!="			{ return BParser::NEQ; }
"<"				{ return BParser::LT; }
">"				{ return BParser::GT; }
"<="			{ return BParser::LE; }
">="			{ return BParser::GE; }
"+"				{ return BParser::PLUS; }
"-"				{ return BParser::MINUS; }
"*"				{ return BParser::TIMES; }
"/"				{ return BParser::DIV; }
"&"				{ return BParser::AND; }
"?"				{ return BParser::OR; }
"^"				{ return BParser::XOR; }
"!"				{ return BParser::LTLNOT; }
"|"				{ return BParser::LTLOR; }
"->"			{ return BParser::IMPL; }
"<->"			{ return BParser::EQUIV; }
{COMMENT}		{ /* comment */ }
<<EOF>>         { yyterminate(); }
.				{ cerr << "\n\nError: Unknown keyword '"+string(yytext)+"' found at line "<<lineno()<<".\n";
				  exit(2);
				}
%%
