#include <vector>
#include <cstring>
#include <ctype.h>

#include "param_conversion.h"
#include "listarray.h"

template <typename T>
ListArray<T>::ListArray()
{
  nalloc = 0;
  allinc = 1024;
}

template <typename T>
T *
ListArray<T>::data()
{
  return array.data();
}

template <typename T>
void
ListArray<T>::setValue(int num, T value)
{
  ensureArraySize(num);
  array[num] = value;
}

template <typename T>
T
ListArray<T>::getValue(int num)
{
  return array[num];
}

template <typename T>
int
ListArray<T>::argvToInt(std::vector<std::string> &argv)
{
  int nint = 0;

  for (const auto &argument : argv)
    {
      int first, last, inc;
      split_intstring(argument, first, last, inc);

      if (inc >= 0)
        {
          for (int ival = first; ival <= last; ival += inc) setValue(nint++, ival);
        }
      else
        {
          for (int ival = first; ival >= last; ival += inc) setValue(nint++, ival);
        }
    }

  return nint;
}

template <typename T>
int
ListArray<T>::argvToFlt(std::vector<std::string> &argv)
{
  int nint = 0;

  for (const auto &argument : argv)
    {
      int len = (int) argument.size();
      int i;
      for (i = 0; i < len; i++)
        if (argument[i] != '/' && argument[i] != '-' && !isdigit(argument[i])) break;

      if (i != len)
        {
          double tmp_val = parameter2double(argument);
          setValue(nint++, tmp_val);
        }
      else
        {
          int first, last, inc;
          split_intstring(argument, first, last, inc);

          if (inc >= 0)
            {
              for (int ival = first; ival <= last; ival += inc) setValue(nint++, (double) ival);
            }
          else
            {
              for (int ival = first; ival >= last; ival += inc) setValue(nint++, (double) ival);
            }
        }
    }

  return nint;
}

template <typename T>
void
ListArray<T>::ensureArraySize(int num)
{
  while (nalloc <= num)
    {
      nalloc += allinc;
      array.resize(nalloc);
    }
}

template class ListArray<int>;
template class ListArray<double>;
template class ListArray<float>;
