/////////////////////////////////////////////////////////////////////////
// $Id: dis_tables_x87.inc,v 1.1 2010/02/08 15:13:39 sshwarts Exp $
/////////////////////////////////////////////////////////////////////////
//
//   Copyright (c) 2005-2010 Stanislav Shwartsman
//          Written by Stanislav Shwartsman [sshwarts at sourceforge net]
//
//  This library is free software; you can redistribute it and/or
//  modify it under the terms of the GNU Lesser General Public
//  License as published by the Free Software Foundation; either
//  version 2 of the License, or (at your option) any later version.
//
//  This library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//  Lesser General Public License for more details.
//
//  You should have received a copy of the GNU Lesser General Public
//  License along with this library; if not, write to the Free Software
//  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
//
/////////////////////////////////////////////////////////////////////////

/* ************************************************************************ */
/* 3DNow! opcodes */

static BxDisasmOpcodeTable_t BxDisasm3DNowGroup[256] = {
  // 256 entries for 3DNow opcodes_by suffix
  /* 00 */ { 0, &Ia_Invalid },
  /* 01 */ { 0, &Ia_Invalid },
  /* 02 */ { 0, &Ia_Invalid },
  /* 03 */ { 0, &Ia_Invalid },
  /* 04 */ { 0, &Ia_Invalid },
  /* 05 */ { 0, &Ia_Invalid },
  /* 06 */ { 0, &Ia_Invalid },
  /* 07 */ { 0, &Ia_Invalid },
  /* 08 */ { 0, &Ia_Invalid },
  /* 09 */ { 0, &Ia_Invalid },
  /* 0A */ { 0, &Ia_Invalid },
  /* 0B */ { 0, &Ia_Invalid },
  /* 0C */ { 0, &Ia_pi2fw_Pq_Qq },
  /* 0D */ { 0, &Ia_pi2fd_Pq_Qq },
  /* 0E */ { 0, &Ia_Invalid },
  /* 0F */ { 0, &Ia_Invalid },
  /* 10 */ { 0, &Ia_Invalid },
  /* 11 */ { 0, &Ia_Invalid },
  /* 12 */ { 0, &Ia_Invalid },
  /* 13 */ { 0, &Ia_Invalid },
  /* 14 */ { 0, &Ia_Invalid },
  /* 15 */ { 0, &Ia_Invalid },
  /* 16 */ { 0, &Ia_Invalid },
  /* 17 */ { 0, &Ia_Invalid },
  /* 18 */ { 0, &Ia_Invalid },
  /* 19 */ { 0, &Ia_Invalid },
  /* 1A */ { 0, &Ia_Invalid },
  /* 1B */ { 0, &Ia_Invalid },
  /* 1C */ { 0, &Ia_pf2iw_Pq_Qq },
  /* 1D */ { 0, &Ia_pf2id_Pq_Qq },
  /* 1E */ { 0, &Ia_Invalid },
  /* 1F */ { 0, &Ia_Invalid },
  /* 20 */ { 0, &Ia_Invalid },
  /* 21 */ { 0, &Ia_Invalid },
  /* 22 */ { 0, &Ia_Invalid },
  /* 23 */ { 0, &Ia_Invalid },
  /* 24 */ { 0, &Ia_Invalid },
  /* 25 */ { 0, &Ia_Invalid },
  /* 26 */ { 0, &Ia_Invalid },
  /* 27 */ { 0, &Ia_Invalid },
  /* 28 */ { 0, &Ia_Invalid },
  /* 29 */ { 0, &Ia_Invalid },
  /* 2A */ { 0, &Ia_Invalid },
  /* 2B */ { 0, &Ia_Invalid },
  /* 2C */ { 0, &Ia_Invalid },
  /* 2D */ { 0, &Ia_Invalid },
  /* 2E */ { 0, &Ia_Invalid },
  /* 2F */ { 0, &Ia_Invalid },
  /* 30 */ { 0, &Ia_Invalid },
  /* 31 */ { 0, &Ia_Invalid },
  /* 32 */ { 0, &Ia_Invalid },
  /* 33 */ { 0, &Ia_Invalid },
  /* 34 */ { 0, &Ia_Invalid },
  /* 35 */ { 0, &Ia_Invalid },
  /* 36 */ { 0, &Ia_Invalid },
  /* 37 */ { 0, &Ia_Invalid },
  /* 38 */ { 0, &Ia_Invalid },
  /* 39 */ { 0, &Ia_Invalid },
  /* 3A */ { 0, &Ia_Invalid },
  /* 3B */ { 0, &Ia_Invalid },
  /* 3C */ { 0, &Ia_Invalid },
  /* 3D */ { 0, &Ia_Invalid },
  /* 3E */ { 0, &Ia_Invalid },
  /* 3F */ { 0, &Ia_Invalid },
  /* 40 */ { 0, &Ia_Invalid },
  /* 41 */ { 0, &Ia_Invalid },
  /* 42 */ { 0, &Ia_Invalid },
  /* 43 */ { 0, &Ia_Invalid },
  /* 44 */ { 0, &Ia_Invalid },
  /* 45 */ { 0, &Ia_Invalid },
  /* 46 */ { 0, &Ia_Invalid },
  /* 47 */ { 0, &Ia_Invalid },
  /* 48 */ { 0, &Ia_Invalid },
  /* 49 */ { 0, &Ia_Invalid },
  /* 4A */ { 0, &Ia_Invalid },
  /* 4B */ { 0, &Ia_Invalid },
  /* 4C */ { 0, &Ia_Invalid },
  /* 4D */ { 0, &Ia_Invalid },
  /* 4E */ { 0, &Ia_Invalid },
  /* 4F */ { 0, &Ia_Invalid },
  /* 50 */ { 0, &Ia_Invalid },
  /* 51 */ { 0, &Ia_Invalid },
  /* 52 */ { 0, &Ia_Invalid },
  /* 53 */ { 0, &Ia_Invalid },
  /* 54 */ { 0, &Ia_Invalid },
  /* 55 */ { 0, &Ia_Invalid },
  /* 56 */ { 0, &Ia_Invalid },
  /* 57 */ { 0, &Ia_Invalid },
  /* 58 */ { 0, &Ia_Invalid },
  /* 59 */ { 0, &Ia_Invalid },
  /* 5A */ { 0, &Ia_Invalid },
  /* 5B */ { 0, &Ia_Invalid },
  /* 5C */ { 0, &Ia_Invalid },
  /* 5D */ { 0, &Ia_Invalid },
  /* 5E */ { 0, &Ia_Invalid },
  /* 5F */ { 0, &Ia_Invalid },
  /* 60 */ { 0, &Ia_Invalid },
  /* 61 */ { 0, &Ia_Invalid },
  /* 62 */ { 0, &Ia_Invalid },
  /* 63 */ { 0, &Ia_Invalid },
  /* 64 */ { 0, &Ia_Invalid },
  /* 65 */ { 0, &Ia_Invalid },
  /* 66 */ { 0, &Ia_Invalid },
  /* 67 */ { 0, &Ia_Invalid },
  /* 68 */ { 0, &Ia_Invalid },
  /* 69 */ { 0, &Ia_Invalid },
  /* 6A */ { 0, &Ia_Invalid },
  /* 6B */ { 0, &Ia_Invalid },
  /* 6C */ { 0, &Ia_Invalid },
  /* 6D */ { 0, &Ia_Invalid },
  /* 6E */ { 0, &Ia_Invalid },
  /* 6F */ { 0, &Ia_Invalid },
  /* 70 */ { 0, &Ia_Invalid },
  /* 71 */ { 0, &Ia_Invalid },
  /* 72 */ { 0, &Ia_Invalid },
  /* 73 */ { 0, &Ia_Invalid },
  /* 74 */ { 0, &Ia_Invalid },
  /* 75 */ { 0, &Ia_Invalid },
  /* 76 */ { 0, &Ia_Invalid },
  /* 77 */ { 0, &Ia_Invalid },
  /* 78 */ { 0, &Ia_Invalid },
  /* 79 */ { 0, &Ia_Invalid },
  /* 7A */ { 0, &Ia_Invalid },
  /* 7B */ { 0, &Ia_Invalid },
  /* 7C */ { 0, &Ia_Invalid },
  /* 7D */ { 0, &Ia_Invalid },
  /* 7E */ { 0, &Ia_Invalid },
  /* 7F */ { 0, &Ia_Invalid },
  /* 80 */ { 0, &Ia_Invalid },
  /* 81 */ { 0, &Ia_Invalid },
  /* 82 */ { 0, &Ia_Invalid },
  /* 83 */ { 0, &Ia_Invalid },
  /* 84 */ { 0, &Ia_Invalid },
  /* 85 */ { 0, &Ia_Invalid },
  /* 86 */ { 0, &Ia_Invalid },
  /* 87 */ { 0, &Ia_Invalid },
  /* 88 */ { 0, &Ia_Invalid },
  /* 89 */ { 0, &Ia_Invalid },
  /* 8A */ { 0, &Ia_pfnacc_Pq_Qq },
  /* 8B */ { 0, &Ia_Invalid },
  /* 8C */ { 0, &Ia_Invalid },
  /* 8D */ { 0, &Ia_Invalid },
  /* 8E */ { 0, &Ia_pfpnacc_Pq_Qq },
  /* 8F */ { 0, &Ia_Invalid },
  /* 90 */ { 0, &Ia_pfcmpge_Pq_Qq },
  /* 91 */ { 0, &Ia_Invalid },
  /* 92 */ { 0, &Ia_Invalid },
  /* 93 */ { 0, &Ia_Invalid },
  /* 94 */ { 0, &Ia_pfmin_Pq_Qq },
  /* 95 */ { 0, &Ia_Invalid },
  /* 96 */ { 0, &Ia_pfrcp_Pq_Qq },
  /* 97 */ { 0, &Ia_pfrsqrt_Pq_Qq },
  /* 98 */ { 0, &Ia_Invalid },
  /* 99 */ { 0, &Ia_Invalid },
  /* 9A */ { 0, &Ia_pfsub_Pq_Qq },
  /* 9B */ { 0, &Ia_Invalid },
  /* 9C */ { 0, &Ia_Invalid },
  /* 9D */ { 0, &Ia_Invalid },
  /* 9E */ { 0, &Ia_pfadd_Pq_Qq },
  /* 9F */ { 0, &Ia_Invalid },
  /* A0 */ { 0, &Ia_pfcmpgt_Pq_Qq },
  /* A1 */ { 0, &Ia_Invalid },
  /* A2 */ { 0, &Ia_Invalid },
  /* A3 */ { 0, &Ia_Invalid },
  /* A4 */ { 0, &Ia_pfmax_Pq_Qq },
  /* A5 */ { 0, &Ia_Invalid },
  /* A6 */ { 0, &Ia_pfrcpit1_Pq_Qq },
  /* A7 */ { 0, &Ia_pfrsqit1_Pq_Qq },
  /* A8 */ { 0, &Ia_Invalid },
  /* A9 */ { 0, &Ia_Invalid },
  /* AA */ { 0, &Ia_pfsubr_Pq_Qq },
  /* AB */ { 0, &Ia_Invalid },
  /* AC */ { 0, &Ia_Invalid },
  /* AD */ { 0, &Ia_Invalid },
  /* AE */ { 0, &Ia_pfacc_Pq_Qq },
  /* AF */ { 0, &Ia_Invalid },
  /* B0 */ { 0, &Ia_pfcmpeq_Pq_Qq },
  /* B1 */ { 0, &Ia_Invalid },
  /* B2 */ { 0, &Ia_Invalid },
  /* B3 */ { 0, &Ia_Invalid },
  /* B4 */ { 0, &Ia_pfmul_Pq_Qq },
  /* B5 */ { 0, &Ia_Invalid },
  /* B6 */ { 0, &Ia_pfrcpit2_Pq_Qq },
  /* B7 */ { 0, &Ia_pmulhrw_Pq_Qq },
  /* B8 */ { 0, &Ia_Invalid },
  /* B9 */ { 0, &Ia_Invalid },
  /* BA */ { 0, &Ia_Invalid },
  /* BB */ { 0, &Ia_pswapd_Pq_Qq },
  /* BC */ { 0, &Ia_Invalid },
  /* BD */ { 0, &Ia_Invalid },
  /* BE */ { 0, &Ia_Invalid },
  /* BF */ { 0, &Ia_pavgb_Pq_Qq },
  /* C0 */ { 0, &Ia_Invalid },
  /* C1 */ { 0, &Ia_Invalid },
  /* C2 */ { 0, &Ia_Invalid },
  /* C3 */ { 0, &Ia_Invalid },
  /* C4 */ { 0, &Ia_Invalid },
  /* C5 */ { 0, &Ia_Invalid },
  /* C6 */ { 0, &Ia_Invalid },
  /* C7 */ { 0, &Ia_Invalid },
  /* C8 */ { 0, &Ia_Invalid },
  /* C9 */ { 0, &Ia_Invalid },
  /* CA */ { 0, &Ia_Invalid },
  /* CB */ { 0, &Ia_Invalid },
  /* CC */ { 0, &Ia_Invalid },
  /* CD */ { 0, &Ia_Invalid },
  /* CE */ { 0, &Ia_Invalid },
  /* CF */ { 0, &Ia_Invalid },
  /* D0 */ { 0, &Ia_Invalid },
  /* D1 */ { 0, &Ia_Invalid },
  /* D2 */ { 0, &Ia_Invalid },
  /* D3 */ { 0, &Ia_Invalid },
  /* D4 */ { 0, &Ia_Invalid },
  /* D5 */ { 0, &Ia_Invalid },
  /* D6 */ { 0, &Ia_Invalid },
  /* D7 */ { 0, &Ia_Invalid },
  /* D8 */ { 0, &Ia_Invalid },
  /* D9 */ { 0, &Ia_Invalid },
  /* DA */ { 0, &Ia_Invalid },
  /* DB */ { 0, &Ia_Invalid },
  /* DC */ { 0, &Ia_Invalid },
  /* DD */ { 0, &Ia_Invalid },
  /* DE */ { 0, &Ia_Invalid },
  /* DF */ { 0, &Ia_Invalid },
  /* E0 */ { 0, &Ia_Invalid },
  /* E1 */ { 0, &Ia_Invalid },
  /* E2 */ { 0, &Ia_Invalid },
  /* E3 */ { 0, &Ia_Invalid },
  /* E4 */ { 0, &Ia_Invalid },
  /* E5 */ { 0, &Ia_Invalid },
  /* E6 */ { 0, &Ia_Invalid },
  /* E7 */ { 0, &Ia_Invalid },
  /* E8 */ { 0, &Ia_Invalid },
  /* E9 */ { 0, &Ia_Invalid },
  /* EA */ { 0, &Ia_Invalid },
  /* EB */ { 0, &Ia_Invalid },
  /* EC */ { 0, &Ia_Invalid },
  /* ED */ { 0, &Ia_Invalid },
  /* EE */ { 0, &Ia_Invalid },
  /* EF */ { 0, &Ia_Invalid },
  /* F0 */ { 0, &Ia_Invalid },
  /* F1 */ { 0, &Ia_Invalid },
  /* F2 */ { 0, &Ia_Invalid },
  /* F3 */ { 0, &Ia_Invalid },
  /* F4 */ { 0, &Ia_Invalid },
  /* F5 */ { 0, &Ia_Invalid },
  /* F6 */ { 0, &Ia_Invalid },
  /* F7 */ { 0, &Ia_Invalid },
  /* F8 */ { 0, &Ia_Invalid },
  /* F9 */ { 0, &Ia_Invalid },
  /* FA */ { 0, &Ia_Invalid },
  /* FB */ { 0, &Ia_Invalid },
  /* FC */ { 0, &Ia_Invalid },
  /* FD */ { 0, &Ia_Invalid },
  /* FE */ { 0, &Ia_Invalid },
  /* FF */ { 0, &Ia_Invalid }
};

/* ************************************************************************ */
/* FPU Opcodes */

// floating point instructions when mod!=11b.
// the following tables will be accessed like groups using the nnn (reg) field of
// the modrm byte. (the first byte is D8-DF)

  // D8 (modrm is outside 00h - BFh) (mod != 11)
static BxDisasmOpcodeTable_t BxDisasmFPGroupD8[8] = {
  /* 0 */ { 0, &Ia_fadds_Md  },
  /* 1 */ { 0, &Ia_fmuls_Md  },
  /* 2 */ { 0, &Ia_fcoms_Md  },
  /* 3 */ { 0, &Ia_fcomps_Md },
  /* 4 */ { 0, &Ia_fsubs_Md  },
  /* 5 */ { 0, &Ia_fsubrs_Md },
  /* 6 */ { 0, &Ia_fdivs_Md  },
  /* 7 */ { 0, &Ia_fdivrs_Md }
};

  // D9 (modrm is outside 00h - BFh) (mod != 11)
static BxDisasmOpcodeTable_t BxDisasmFPGroupD9[8] = {
  /* 0 */ { 0, &Ia_flds_Md   },
  /* 1 */ { 0, &Ia_Invalid   },
  /* 2 */ { 0, &Ia_fsts_Md   },
  /* 3 */ { 0, &Ia_fstps_Md  },
  /* 4 */ { 0, &Ia_fldenv    },
  /* 5 */ { 0, &Ia_fldcw     },
  /* 6 */ { 0, &Ia_fnstenv   },
  /* 7 */ { 0, &Ia_fnstcw    }
};

  // DA (modrm is outside 00h - BFh) (mod != 11)
static BxDisasmOpcodeTable_t BxDisasmFPGroupDA[8] = {
  /* 0 */ { 0, &Ia_fiaddl_Md  },
  /* 1 */ { 0, &Ia_fimull_Md  },
  /* 2 */ { 0, &Ia_ficoml_Md  },
  /* 3 */ { 0, &Ia_ficompl_Md },
  /* 4 */ { 0, &Ia_fisubl_Md  },
  /* 5 */ { 0, &Ia_fisubrl_Md },
  /* 6 */ { 0, &Ia_fidivl_Md  },
  /* 7 */ { 0, &Ia_fidivrl_Md }
};

  // DB (modrm is outside 00h - BFh) (mod != 11)
static BxDisasmOpcodeTable_t BxDisasmFPGroupDB[8] = {
  /* 0 */ { 0, &Ia_fildl_Md   },
  /* 1 */ { 0, &Ia_fisttpl_Md },
  /* 2 */ { 0, &Ia_fistl_Md   },
  /* 3 */ { 0, &Ia_fistpl_Md  },
  /* 4 */ { 0, &Ia_Invalid    },
  /* 5 */ { 0, &Ia_fldt_Mt    },
  /* 6 */ { 0, &Ia_Invalid    },
  /* 7 */ { 0, &Ia_fstpt_Mt   }
};

  // DC (modrm is outside 00h - BFh) (mod != 11)
static BxDisasmOpcodeTable_t BxDisasmFPGroupDC[8] = {
  /* 0 */ { 0, &Ia_faddl_Mq  },
  /* 1 */ { 0, &Ia_fmull_Mq  },
  /* 2 */ { 0, &Ia_fcoml_Mq  },
  /* 3 */ { 0, &Ia_fcompl_Mq },
  /* 4 */ { 0, &Ia_fsubl_Mq  },
  /* 5 */ { 0, &Ia_fsubrl_Mq },
  /* 6 */ { 0, &Ia_fdivl_Mq  },
  /* 7 */ { 0, &Ia_fdivrl_Mq }
};

  // DD (modrm is outside 00h - BFh) (mod != 11)
static BxDisasmOpcodeTable_t BxDisasmFPGroupDD[8] = {
  /* 0 */ { 0, &Ia_fldl_Mq    },
  /* 1 */ { 0, &Ia_fisttpq_Mq },
  /* 2 */ { 0, &Ia_fstl_Mq    },
  /* 3 */ { 0, &Ia_fstpl_Mq   },
  /* 4 */ { 0, &Ia_frstor     },
  /* 5 */ { 0, &Ia_Invalid    },
  /* 6 */ { 0, &Ia_fnsave     },
  /* 7 */ { 0, &Ia_fnstsw     }
};

  // DE (modrm is outside 00h - BFh) (mod != 11)
static BxDisasmOpcodeTable_t BxDisasmFPGroupDE[8] = {
  /* 0 */ { 0, &Ia_fiadds_Mw  },
  /* 1 */ { 0, &Ia_fimuls_Mw  },
  /* 2 */ { 0, &Ia_ficoms_Mw  },
  /* 3 */ { 0, &Ia_ficomps_Mw },
  /* 4 */ { 0, &Ia_fisubs_Mw  },
  /* 5 */ { 0, &Ia_fisubrs_Mw },
  /* 6 */ { 0, &Ia_fidivs_Mw  },
  /* 7 */ { 0, &Ia_fidivrs_Mw }
};

  // DF (modrm is outside 00h - BFh) (mod != 11)
static BxDisasmOpcodeTable_t BxDisasmFPGroupDF[8] = {
  /* 0 */ { 0, &Ia_filds_Mw   },
  /* 1 */ { 0, &Ia_fisttps_Mw },
  /* 2 */ { 0, &Ia_fists_Mw   },
  /* 3 */ { 0, &Ia_fistps_Mw  },
  /* 4 */ { 0, &Ia_fbldt_Mt   },
  /* 5 */ { 0, &Ia_fildq_Mq   },
  /* 6 */ { 0, &Ia_fbstpt_Mt  },
  /* 7 */ { 0, &Ia_fistpq_Mq  }
};

// 512 entries for second byte of floating point instructions. (when mod==11b)
static BxDisasmOpcodeTable_t BxDisasmOpcodeInfoFP[512] = {
  // D8 (modrm is outside 00h - BFh) (mod == 11)
  /* D8 C0 */ { 0, &Ia_fadd_ST0_STi  },
  /* D8 C1 */ { 0, &Ia_fadd_ST0_STi  },
  /* D8 C2 */ { 0, &Ia_fadd_ST0_STi  },
  /* D8 C3 */ { 0, &Ia_fadd_ST0_STi  },
  /* D8 C4 */ { 0, &Ia_fadd_ST0_STi  },
  /* D8 C5 */ { 0, &Ia_fadd_ST0_STi  },
  /* D8 C6 */ { 0, &Ia_fadd_ST0_STi  },
  /* D8 C7 */ { 0, &Ia_fadd_ST0_STi  },
  /* D8 C8 */ { 0, &Ia_fmul_ST0_STi  },
  /* D8 C9 */ { 0, &Ia_fmul_ST0_STi  },
  /* D8 CA */ { 0, &Ia_fmul_ST0_STi  },
  /* D8 CB */ { 0, &Ia_fmul_ST0_STi  },
  /* D8 CC */ { 0, &Ia_fmul_ST0_STi  },
  /* D8 CD */ { 0, &Ia_fmul_ST0_STi  },
  /* D8 CE */ { 0, &Ia_fmul_ST0_STi  },
  /* D8 CF */ { 0, &Ia_fmul_ST0_STi  },
  /* D8 D0 */ { 0, &Ia_fcom_STi      },
  /* D8 D1 */ { 0, &Ia_fcom_STi      },
  /* D8 D2 */ { 0, &Ia_fcom_STi      },
  /* D8 D3 */ { 0, &Ia_fcom_STi      },
  /* D8 D4 */ { 0, &Ia_fcom_STi      },
  /* D8 D5 */ { 0, &Ia_fcom_STi      },
  /* D8 D6 */ { 0, &Ia_fcom_STi      },
  /* D8 D7 */ { 0, &Ia_fcom_STi      },
  /* D8 D8 */ { 0, &Ia_fcomp_STi     },
  /* D8 D9 */ { 0, &Ia_fcomp_STi     },
  /* D8 DA */ { 0, &Ia_fcomp_STi     },
  /* D8 DB */ { 0, &Ia_fcomp_STi     },
  /* D8 DC */ { 0, &Ia_fcomp_STi     },
  /* D8 DD */ { 0, &Ia_fcomp_STi     },
  /* D8 DE */ { 0, &Ia_fcomp_STi     },
  /* D8 DF */ { 0, &Ia_fcomp_STi     },
  /* D8 E0 */ { 0, &Ia_fsub_ST0_STi  },
  /* D8 E1 */ { 0, &Ia_fsub_ST0_STi  },
  /* D8 E2 */ { 0, &Ia_fsub_ST0_STi  },
  /* D8 E3 */ { 0, &Ia_fsub_ST0_STi  },
  /* D8 E4 */ { 0, &Ia_fsub_ST0_STi  },
  /* D8 E5 */ { 0, &Ia_fsub_ST0_STi  },
  /* D8 E6 */ { 0, &Ia_fsub_ST0_STi  },
  /* D8 E7 */ { 0, &Ia_fsub_ST0_STi  },
  /* D8 E8 */ { 0, &Ia_fsubr_ST0_STi },
  /* D8 E9 */ { 0, &Ia_fsubr_ST0_STi },
  /* D8 EA */ { 0, &Ia_fsubr_ST0_STi },
  /* D8 EB */ { 0, &Ia_fsubr_ST0_STi },
  /* D8 EC */ { 0, &Ia_fsubr_ST0_STi },
  /* D8 ED */ { 0, &Ia_fsubr_ST0_STi },
  /* D8 EE */ { 0, &Ia_fsubr_ST0_STi },
  /* D8 EF */ { 0, &Ia_fsubr_ST0_STi },
  /* D8 F0 */ { 0, &Ia_fdiv_ST0_STi  },
  /* D8 F1 */ { 0, &Ia_fdiv_ST0_STi  },
  /* D8 F2 */ { 0, &Ia_fdiv_ST0_STi  },
  /* D8 F3 */ { 0, &Ia_fdiv_ST0_STi  },
  /* D8 F4 */ { 0, &Ia_fdiv_ST0_STi  },
  /* D8 F5 */ { 0, &Ia_fdiv_ST0_STi  },
  /* D8 F6 */ { 0, &Ia_fdiv_ST0_STi  },
  /* D8 F7 */ { 0, &Ia_fdiv_ST0_STi  },
  /* D8 F8 */ { 0, &Ia_fdivr_ST0_STi },
  /* D8 F9 */ { 0, &Ia_fdivr_ST0_STi },
  /* D8 FA */ { 0, &Ia_fdivr_ST0_STi },
  /* D8 FB */ { 0, &Ia_fdivr_ST0_STi },
  /* D8 FC */ { 0, &Ia_fdivr_ST0_STi },
  /* D8 FD */ { 0, &Ia_fdivr_ST0_STi },
  /* D8 FE */ { 0, &Ia_fdivr_ST0_STi },
  /* D8 FF */ { 0, &Ia_fdivr_ST0_STi },

  // D9 (modrm is outside 00h - BFh) (mod == 11)
  /* D9 C0 */ { 0, &Ia_fld_STi },
  /* D9 C1 */ { 0, &Ia_fld_STi },
  /* D9 C2 */ { 0, &Ia_fld_STi },
  /* D9 C3 */ { 0, &Ia_fld_STi },
  /* D9 C4 */ { 0, &Ia_fld_STi },
  /* D9 C5 */ { 0, &Ia_fld_STi },
  /* D9 C6 */ { 0, &Ia_fld_STi },
  /* D9 C7 */ { 0, &Ia_fld_STi },
  /* D9 C8 */ { 0, &Ia_fxch    },
  /* D9 C9 */ { 0, &Ia_fxch    },
  /* D9 CA */ { 0, &Ia_fxch    },
  /* D9 CB */ { 0, &Ia_fxch    },
  /* D9 CC */ { 0, &Ia_fxch    },
  /* D9 CD */ { 0, &Ia_fxch    },
  /* D9 CE */ { 0, &Ia_fxch    },
  /* D9 CF */ { 0, &Ia_fxch    },
  /* D9 D0 */ { 0, &Ia_fnop    },
  /* D9 D1 */ { 0, &Ia_Invalid },
  /* D9 D2 */ { 0, &Ia_Invalid },
  /* D9 D3 */ { 0, &Ia_Invalid },
  /* D9 D4 */ { 0, &Ia_Invalid },
  /* D9 D5 */ { 0, &Ia_Invalid },
  /* D9 D6 */ { 0, &Ia_Invalid },
  /* D9 D7 */ { 0, &Ia_Invalid },
  /* D9 D8 */ { 0, &Ia_fstp_STi }, // undocumented
  /* D9 D9 */ { 0, &Ia_fstp_STi }, // undocumented
  /* D9 DA */ { 0, &Ia_fstp_STi }, // undocumented
  /* D9 DB */ { 0, &Ia_fstp_STi }, // undocumented
  /* D9 DC */ { 0, &Ia_fstp_STi }, // undocumented
  /* D9 DD */ { 0, &Ia_fstp_STi }, // undocumented
  /* D9 DE */ { 0, &Ia_fstp_STi }, // undocumented
  /* D9 DF */ { 0, &Ia_fstp_STi }, // undocumented
  /* D9 E0 */ { 0, &Ia_fchs    },
  /* D9 E1 */ { 0, &Ia_fabs    },
  /* D9 E2 */ { 0, &Ia_Invalid },
  /* D9 E3 */ { 0, &Ia_Invalid },
  /* D9 E4 */ { 0, &Ia_ftst    },
  /* D9 E5 */ { 0, &Ia_fxam    },
  /* D9 E6 */ { 0, &Ia_Invalid },
  /* D9 E7 */ { 0, &Ia_Invalid },
  /* D9 E8 */ { 0, &Ia_fld1    },
  /* D9 E9 */ { 0, &Ia_fldl2t  },
  /* D9 EA */ { 0, &Ia_fldl2e  },
  /* D9 EB */ { 0, &Ia_fldpi   },
  /* D9 EC */ { 0, &Ia_fldlg2  },
  /* D9 ED */ { 0, &Ia_fldln2  },
  /* D9 EE */ { 0, &Ia_fldz    },
  /* D9 EF */ { 0, &Ia_Invalid },
  /* D9 F0 */ { 0, &Ia_f2xm1   },
  /* D9 F1 */ { 0, &Ia_fyl2x   },
  /* D9 F2 */ { 0, &Ia_fptan   },
  /* D9 F3 */ { 0, &Ia_fpatan  },
  /* D9 F4 */ { 0, &Ia_fxtract },
  /* D9 F5 */ { 0, &Ia_fprem1  },
  /* D9 F6 */ { 0, &Ia_fdecstp },
  /* D9 F7 */ { 0, &Ia_fincstp },
  /* D9 F8 */ { 0, &Ia_fprem   },
  /* D9 F9 */ { 0, &Ia_fyl2xp1 },
  /* D9 FA */ { 0, &Ia_fsqrt   },
  /* D9 FB */ { 0, &Ia_fsincos },
  /* D9 FC */ { 0, &Ia_frndint },
  /* D9 FD */ { 0, &Ia_fscale  },
  /* D9 FE */ { 0, &Ia_fsin    },
  /* D9 FF */ { 0, &Ia_fcos    },

  // DA (modrm is outside 00h - BFh) (mod == 11)
  /* DA C0 */ { 0, &Ia_fcmovb_ST0_STi  },
  /* DA C1 */ { 0, &Ia_fcmovb_ST0_STi  },
  /* DA C2 */ { 0, &Ia_fcmovb_ST0_STi  },
  /* DA C3 */ { 0, &Ia_fcmovb_ST0_STi  },
  /* DA C4 */ { 0, &Ia_fcmovb_ST0_STi  },
  /* DA C5 */ { 0, &Ia_fcmovb_ST0_STi  },
  /* DA C6 */ { 0, &Ia_fcmovb_ST0_STi  },
  /* DA C7 */ { 0, &Ia_fcmovb_ST0_STi  },
  /* DA C8 */ { 0, &Ia_fcmove_ST0_STi  },
  /* DA C9 */ { 0, &Ia_fcmove_ST0_STi  },
  /* DA CA */ { 0, &Ia_fcmove_ST0_STi  },
  /* DA CB */ { 0, &Ia_fcmove_ST0_STi  },
  /* DA CC */ { 0, &Ia_fcmove_ST0_STi  },
  /* DA CD */ { 0, &Ia_fcmove_ST0_STi  },
  /* DA CE */ { 0, &Ia_fcmove_ST0_STi  },
  /* DA CF */ { 0, &Ia_fcmove_ST0_STi  },
  /* DA D0 */ { 0, &Ia_fcmovbe_ST0_STi },
  /* DA D1 */ { 0, &Ia_fcmovbe_ST0_STi },
  /* DA D2 */ { 0, &Ia_fcmovbe_ST0_STi },
  /* DA D3 */ { 0, &Ia_fcmovbe_ST0_STi },
  /* DA D4 */ { 0, &Ia_fcmovbe_ST0_STi },
  /* DA D5 */ { 0, &Ia_fcmovbe_ST0_STi },
  /* DA D6 */ { 0, &Ia_fcmovbe_ST0_STi },
  /* DA D7 */ { 0, &Ia_fcmovbe_ST0_STi },
  /* DA D8 */ { 0, &Ia_fcmovu_ST0_STi  },
  /* DA D9 */ { 0, &Ia_fcmovu_ST0_STi  },
  /* DA DA */ { 0, &Ia_fcmovu_ST0_STi  },
  /* DA DB */ { 0, &Ia_fcmovu_ST0_STi  },
  /* DA DC */ { 0, &Ia_fcmovu_ST0_STi  },
  /* DA DD */ { 0, &Ia_fcmovu_ST0_STi  },
  /* DA DE */ { 0, &Ia_fcmovu_ST0_STi  },
  /* DA DF */ { 0, &Ia_fcmovu_ST0_STi  },
  /* DA E0 */ { 0, &Ia_Invalid },
  /* DA E1 */ { 0, &Ia_Invalid },
  /* DA E2 */ { 0, &Ia_Invalid },
  /* DA E3 */ { 0, &Ia_Invalid },
  /* DA E4 */ { 0, &Ia_Invalid },
  /* DA E5 */ { 0, &Ia_Invalid },
  /* DA E6 */ { 0, &Ia_Invalid },
  /* DA E7 */ { 0, &Ia_Invalid },
  /* DA E8 */ { 0, &Ia_Invalid },
  /* DA E9 */ { 0, &Ia_fucompp },
  /* DA EA */ { 0, &Ia_Invalid },
  /* DA EB */ { 0, &Ia_Invalid },
  /* DA EC */ { 0, &Ia_Invalid },
  /* DA ED */ { 0, &Ia_Invalid },
  /* DA EE */ { 0, &Ia_Invalid },
  /* DA EF */ { 0, &Ia_Invalid },
  /* DA F0 */ { 0, &Ia_Invalid },
  /* DA F1 */ { 0, &Ia_Invalid },
  /* DA F2 */ { 0, &Ia_Invalid },
  /* DA F3 */ { 0, &Ia_Invalid },
  /* DA F4 */ { 0, &Ia_Invalid },
  /* DA F5 */ { 0, &Ia_Invalid },
  /* DA F6 */ { 0, &Ia_Invalid },
  /* DA F7 */ { 0, &Ia_Invalid },
  /* DA F8 */ { 0, &Ia_Invalid },
  /* DA F9 */ { 0, &Ia_Invalid },
  /* DA FA */ { 0, &Ia_Invalid },
  /* DA FB */ { 0, &Ia_Invalid },
  /* DA FC */ { 0, &Ia_Invalid },
  /* DA FD */ { 0, &Ia_Invalid },
  /* DA FE */ { 0, &Ia_Invalid },
  /* DA FF */ { 0, &Ia_Invalid },

  // DB (modrm is outside 00h - BFh) (mod == 11)
  /* DB C0 */ { 0, &Ia_fcmovnb_ST0_STi  },
  /* DB C1 */ { 0, &Ia_fcmovnb_ST0_STi  },
  /* DB C2 */ { 0, &Ia_fcmovnb_ST0_STi  },
  /* DB C3 */ { 0, &Ia_fcmovnb_ST0_STi  },
  /* DB C4 */ { 0, &Ia_fcmovnb_ST0_STi  },
  /* DB C5 */ { 0, &Ia_fcmovnb_ST0_STi  },
  /* DB C6 */ { 0, &Ia_fcmovnb_ST0_STi  },
  /* DB C7 */ { 0, &Ia_fcmovnb_ST0_STi  },
  /* DB C8 */ { 0, &Ia_fcmovne_ST0_STi  },
  /* DB C9 */ { 0, &Ia_fcmovne_ST0_STi  },
  /* DB CA */ { 0, &Ia_fcmovne_ST0_STi  },
  /* DB CB */ { 0, &Ia_fcmovne_ST0_STi  },
  /* DB CC */ { 0, &Ia_fcmovne_ST0_STi  },
  /* DB CD */ { 0, &Ia_fcmovne_ST0_STi  },
  /* DB CE */ { 0, &Ia_fcmovne_ST0_STi  },
  /* DB CF */ { 0, &Ia_fcmovne_ST0_STi  },
  /* DB D0 */ { 0, &Ia_fcmovnbe_ST0_STi },
  /* DB D1 */ { 0, &Ia_fcmovnbe_ST0_STi },
  /* DB D2 */ { 0, &Ia_fcmovnbe_ST0_STi },
  /* DB D3 */ { 0, &Ia_fcmovnbe_ST0_STi },
  /* DB D4 */ { 0, &Ia_fcmovnbe_ST0_STi },
  /* DB D5 */ { 0, &Ia_fcmovnbe_ST0_STi },
  /* DB D6 */ { 0, &Ia_fcmovnbe_ST0_STi },
  /* DB D7 */ { 0, &Ia_fcmovnbe_ST0_STi },
  /* DB D8 */ { 0, &Ia_fcmovnu_ST0_STi  },
  /* DB D9 */ { 0, &Ia_fcmovnu_ST0_STi  },
  /* DB DA */ { 0, &Ia_fcmovnu_ST0_STi  },
  /* DB DB */ { 0, &Ia_fcmovnu_ST0_STi  },
  /* DB DC */ { 0, &Ia_fcmovnu_ST0_STi  },
  /* DB DD */ { 0, &Ia_fcmovnu_ST0_STi  },
  /* DB DE */ { 0, &Ia_fcmovnu_ST0_STi  },
  /* DB DF */ { 0, &Ia_fcmovnu_ST0_STi  },
  /* DB E0 */ { 0, &Ia_feni    },
  /* DB E1 */ { 0, &Ia_fdisi   },
  /* DB E2 */ { 0, &Ia_fnclex  },
  /* DB E3 */ { 0, &Ia_fninit  },
  /* DB E4 */ { 0, &Ia_fsetpm  },
  /* DB E5 */ { 0, &Ia_Invalid },
  /* DB E6 */ { 0, &Ia_Invalid },
  /* DB E7 */ { 0, &Ia_Invalid },
  /* DB E8 */ { 0, &Ia_fucomi_ST0_STi },
  /* DB E9 */ { 0, &Ia_fucomi_ST0_STi },
  /* DB EA */ { 0, &Ia_fucomi_ST0_STi },
  /* DB EB */ { 0, &Ia_fucomi_ST0_STi },
  /* DB EC */ { 0, &Ia_fucomi_ST0_STi },
  /* DB ED */ { 0, &Ia_fucomi_ST0_STi },
  /* DB EE */ { 0, &Ia_fucomi_ST0_STi },
  /* DB EF */ { 0, &Ia_fucomi_ST0_STi },
  /* DB F0 */ { 0, &Ia_fcomi_ST0_STi  },
  /* DB F1 */ { 0, &Ia_fcomi_ST0_STi  },
  /* DB F2 */ { 0, &Ia_fcomi_ST0_STi  },
  /* DB F3 */ { 0, &Ia_fcomi_ST0_STi  },
  /* DB F4 */ { 0, &Ia_fcomi_ST0_STi  },
  /* DB F5 */ { 0, &Ia_fcomi_ST0_STi  },
  /* DB F6 */ { 0, &Ia_fcomi_ST0_STi  },
  /* DB F7 */ { 0, &Ia_fcomi_ST0_STi  },
  /* DB F8 */ { 0, &Ia_Invalid },
  /* DB F9 */ { 0, &Ia_Invalid },
  /* DB FA */ { 0, &Ia_Invalid },
  /* DB FB */ { 0, &Ia_Invalid },
  /* DB FC */ { 0, &Ia_Invalid },
  /* DB FD */ { 0, &Ia_Invalid },
  /* DB FE */ { 0, &Ia_Invalid },
  /* DB FF */ { 0, &Ia_Invalid },

  // DC (modrm is outside 00h - BFh) (mod == 11)
  /* DC C0 */ { 0, &Ia_fadd_STi_ST0 },
  /* DC C1 */ { 0, &Ia_fadd_STi_ST0 },
  /* DC C2 */ { 0, &Ia_fadd_STi_ST0 },
  /* DC C3 */ { 0, &Ia_fadd_STi_ST0 },
  /* DC C4 */ { 0, &Ia_fadd_STi_ST0 },
  /* DC C5 */ { 0, &Ia_fadd_STi_ST0 },
  /* DC C6 */ { 0, &Ia_fadd_STi_ST0 },
  /* DC C7 */ { 0, &Ia_fadd_STi_ST0 },
  /* DC C8 */ { 0, &Ia_fmul_STi_ST0 },
  /* DC C9 */ { 0, &Ia_fmul_STi_ST0 },
  /* DC CA */ { 0, &Ia_fmul_STi_ST0 },
  /* DC CB */ { 0, &Ia_fmul_STi_ST0 },
  /* DC CC */ { 0, &Ia_fmul_STi_ST0 },
  /* DC CD */ { 0, &Ia_fmul_STi_ST0 },
  /* DC CE */ { 0, &Ia_fmul_STi_ST0 },
  /* DC CF */ { 0, &Ia_fmul_STi_ST0 },
  /* DC D0 */ { 0, &Ia_fcom_STi     }, // undocumented
  /* DC D1 */ { 0, &Ia_fcom_STi     }, // undocumented
  /* DC D2 */ { 0, &Ia_fcom_STi     }, // undocumented
  /* DC D3 */ { 0, &Ia_fcom_STi     }, // undocumented
  /* DC D4 */ { 0, &Ia_fcom_STi     }, // undocumented
  /* DC D5 */ { 0, &Ia_fcom_STi     }, // undocumented
  /* DC D6 */ { 0, &Ia_fcom_STi     }, // undocumented
  /* DC D7 */ { 0, &Ia_fcom_STi     }, // undocumented
  /* DC D8 */ { 0, &Ia_fcomp_STi    }, // undocumented
  /* DC D9 */ { 0, &Ia_fcomp_STi    }, // undocumented
  /* DC DA */ { 0, &Ia_fcomp_STi    }, // undocumented
  /* DC DB */ { 0, &Ia_fcomp_STi    }, // undocumented
  /* DC DC */ { 0, &Ia_fcomp_STi    }, // undocumented
  /* DC DD */ { 0, &Ia_fcomp_STi    }, // undocumented
  /* DC DE */ { 0, &Ia_fcomp_STi    }, // undocumented
  /* DC DF */ { 0, &Ia_fcomp_STi    }, // undocumented
  /* DC E0 */ { 0, &Ia_fsubr_STi_ST0 },
  /* DC E1 */ { 0, &Ia_fsubr_STi_ST0 },
  /* DC E2 */ { 0, &Ia_fsubr_STi_ST0 },
  /* DC E3 */ { 0, &Ia_fsubr_STi_ST0 },
  /* DC E4 */ { 0, &Ia_fsubr_STi_ST0 },
  /* DC E5 */ { 0, &Ia_fsubr_STi_ST0 },
  /* DC E6 */ { 0, &Ia_fsubr_STi_ST0 },
  /* DC E7 */ { 0, &Ia_fsubr_STi_ST0 },
  /* DC E8 */ { 0, &Ia_fsub_STi_ST0  },
  /* DC E9 */ { 0, &Ia_fsub_STi_ST0  },
  /* DC EA */ { 0, &Ia_fsub_STi_ST0  },
  /* DC EB */ { 0, &Ia_fsub_STi_ST0  },
  /* DC EC */ { 0, &Ia_fsub_STi_ST0  },
  /* DC ED */ { 0, &Ia_fsub_STi_ST0  },
  /* DC EE */ { 0, &Ia_fsub_STi_ST0  },
  /* DC EF */ { 0, &Ia_fsub_STi_ST0  },
  /* DC F0 */ { 0, &Ia_fdivr_STi_ST0 },
  /* DC F1 */ { 0, &Ia_fdivr_STi_ST0 },
  /* DC F2 */ { 0, &Ia_fdivr_STi_ST0 },
  /* DC F3 */ { 0, &Ia_fdivr_STi_ST0 },
  /* DC F4 */ { 0, &Ia_fdivr_STi_ST0 },
  /* DC F5 */ { 0, &Ia_fdivr_STi_ST0 },
  /* DC F6 */ { 0, &Ia_fdivr_STi_ST0 },
  /* DC F7 */ { 0, &Ia_fdivr_STi_ST0 },
  /* DC F8 */ { 0, &Ia_fdiv_STi_ST0  },
  /* DC F9 */ { 0, &Ia_fdiv_STi_ST0  },
  /* DC FA */ { 0, &Ia_fdiv_STi_ST0  },
  /* DC FB */ { 0, &Ia_fdiv_STi_ST0  },
  /* DC FC */ { 0, &Ia_fdiv_STi_ST0  },
  /* DC FD */ { 0, &Ia_fdiv_STi_ST0  },
  /* DC FE */ { 0, &Ia_fdiv_STi_ST0  },
  /* DC FF */ { 0, &Ia_fdiv_STi_ST0  },

  // DD (modrm is outside 00h - BFh) (mod == 11)
  /* DD C0 */ { 0, &Ia_ffree_STi },
  /* DD C1 */ { 0, &Ia_ffree_STi },
  /* DD C2 */ { 0, &Ia_ffree_STi },
  /* DD C3 */ { 0, &Ia_ffree_STi },
  /* DD C4 */ { 0, &Ia_ffree_STi },
  /* DD C5 */ { 0, &Ia_ffree_STi },
  /* DD C6 */ { 0, &Ia_ffree_STi },
  /* DD C7 */ { 0, &Ia_ffree_STi },
  /* DD C8 */ { 0, &Ia_fxch      }, // undocumented
  /* DD C9 */ { 0, &Ia_fxch      }, // undocumented
  /* DD CA */ { 0, &Ia_fxch      }, // undocumented
  /* DD CB */ { 0, &Ia_fxch      }, // undocumented
  /* DD CC */ { 0, &Ia_fxch      }, // undocumented
  /* DD CD */ { 0, &Ia_fxch      }, // undocumented
  /* DD CE */ { 0, &Ia_fxch      }, // undocumented
  /* DD CF */ { 0, &Ia_fxch      }, // undocumented
  /* DD D0 */ { 0, &Ia_fst_STi   },
  /* DD D1 */ { 0, &Ia_fst_STi   },
  /* DD D2 */ { 0, &Ia_fst_STi   },
  /* DD D3 */ { 0, &Ia_fst_STi   },
  /* DD D4 */ { 0, &Ia_fst_STi   },
  /* DD D5 */ { 0, &Ia_fst_STi   },
  /* DD D6 */ { 0, &Ia_fst_STi   },
  /* DD D7 */ { 0, &Ia_fst_STi   },
  /* DD D8 */ { 0, &Ia_fstp_STi  },
  /* DD D9 */ { 0, &Ia_fstp_STi  },
  /* DD DA */ { 0, &Ia_fstp_STi  },
  /* DD DB */ { 0, &Ia_fstp_STi  },
  /* DD DC */ { 0, &Ia_fstp_STi  },
  /* DD DD */ { 0, &Ia_fstp_STi  },
  /* DD DE */ { 0, &Ia_fstp_STi  },
  /* DD DF */ { 0, &Ia_fstp_STi  },
  /* DD E0 */ { 0, &Ia_fucom_STi },
  /* DD E1 */ { 0, &Ia_fucom_STi },
  /* DD E2 */ { 0, &Ia_fucom_STi },
  /* DD E3 */ { 0, &Ia_fucom_STi },
  /* DD E4 */ { 0, &Ia_fucom_STi },
  /* DD E5 */ { 0, &Ia_fucom_STi },
  /* DD E6 */ { 0, &Ia_fucom_STi },
  /* DD E7 */ { 0, &Ia_fucom_STi },
  /* DD E8 */ { 0, &Ia_fucomp_STi },
  /* DD E9 */ { 0, &Ia_fucomp_STi },
  /* DD EA */ { 0, &Ia_fucomp_STi },
  /* DD EB */ { 0, &Ia_fucomp_STi },
  /* DD EC */ { 0, &Ia_fucomp_STi },
  /* DD ED */ { 0, &Ia_fucomp_STi },
  /* DD EE */ { 0, &Ia_fucomp_STi },
  /* DD EF */ { 0, &Ia_fucomp_STi },
  /* DD F0 */ { 0, &Ia_Invalid },
  /* DD F1 */ { 0, &Ia_Invalid },
  /* DD F2 */ { 0, &Ia_Invalid },
  /* DD F3 */ { 0, &Ia_Invalid },
  /* DD F4 */ { 0, &Ia_Invalid },
  /* DD F5 */ { 0, &Ia_Invalid },
  /* DD F6 */ { 0, &Ia_Invalid },
  /* DD F7 */ { 0, &Ia_Invalid },
  /* DD F8 */ { 0, &Ia_Invalid },
  /* DD F9 */ { 0, &Ia_Invalid },
  /* DD FA */ { 0, &Ia_Invalid },
  /* DD FB */ { 0, &Ia_Invalid },
  /* DD FC */ { 0, &Ia_Invalid },
  /* DD FD */ { 0, &Ia_Invalid },
  /* DD FE */ { 0, &Ia_Invalid },
  /* DD FF */ { 0, &Ia_Invalid },

  // DE (modrm is outside 00h - BFh) (mod == 11)
  /* DE C0 */ { 0, &Ia_faddp_STi_ST0 },
  /* DE C1 */ { 0, &Ia_faddp_STi_ST0 },
  /* DE C2 */ { 0, &Ia_faddp_STi_ST0 },
  /* DE C3 */ { 0, &Ia_faddp_STi_ST0 },
  /* DE C4 */ { 0, &Ia_faddp_STi_ST0 },
  /* DE C5 */ { 0, &Ia_faddp_STi_ST0 },
  /* DE C6 */ { 0, &Ia_faddp_STi_ST0 },
  /* DE C7 */ { 0, &Ia_faddp_STi_ST0 },
  /* DE C8 */ { 0, &Ia_fmulp_STi_ST0 },
  /* DE C9 */ { 0, &Ia_fmulp_STi_ST0 },
  /* DE CA */ { 0, &Ia_fmulp_STi_ST0 },
  /* DE CB */ { 0, &Ia_fmulp_STi_ST0 },
  /* DE CC */ { 0, &Ia_fmulp_STi_ST0 },
  /* DE CD */ { 0, &Ia_fmulp_STi_ST0 },
  /* DE CE */ { 0, &Ia_fmulp_STi_ST0 },
  /* DE CF */ { 0, &Ia_fmulp_STi_ST0 },
  /* DE D0 */ { 0, &Ia_fcomp_STi }, // undocumented
  /* DE D1 */ { 0, &Ia_fcomp_STi }, // undocumented
  /* DE D2 */ { 0, &Ia_fcomp_STi }, // undocumented
  /* DE D3 */ { 0, &Ia_fcomp_STi }, // undocumented
  /* DE D4 */ { 0, &Ia_fcomp_STi }, // undocumented
  /* DE D5 */ { 0, &Ia_fcomp_STi }, // undocumented
  /* DE D6 */ { 0, &Ia_fcomp_STi }, // undocumented
  /* DE D7 */ { 0, &Ia_fcomp_STi }, // undocumented
  /* DE D8 */ { 0, &Ia_Invalid },
  /* DE D9 */ { 0, &Ia_fcompp  },
  /* DE DA */ { 0, &Ia_Invalid },
  /* DE DB */ { 0, &Ia_Invalid },
  /* DE DC */ { 0, &Ia_Invalid },
  /* DE DD */ { 0, &Ia_Invalid },
  /* DE DE */ { 0, &Ia_Invalid },
  /* DE DF */ { 0, &Ia_Invalid },
  /* DE E0 */ { 0, &Ia_fsubrp_STi_ST0 },
  /* DE E1 */ { 0, &Ia_fsubrp_STi_ST0 },
  /* DE E2 */ { 0, &Ia_fsubrp_STi_ST0 },
  /* DE E3 */ { 0, &Ia_fsubrp_STi_ST0 },
  /* DE E4 */ { 0, &Ia_fsubrp_STi_ST0 },
  /* DE E5 */ { 0, &Ia_fsubrp_STi_ST0 },
  /* DE E6 */ { 0, &Ia_fsubrp_STi_ST0 },
  /* DE E7 */ { 0, &Ia_fsubrp_STi_ST0 },
  /* DE E8 */ { 0, &Ia_fsubp_STi_ST0  },
  /* DE E9 */ { 0, &Ia_fsubp_STi_ST0  },
  /* DE EA */ { 0, &Ia_fsubp_STi_ST0  },
  /* DE EB */ { 0, &Ia_fsubp_STi_ST0  },
  /* DE EC */ { 0, &Ia_fsubp_STi_ST0  },
  /* DE ED */ { 0, &Ia_fsubp_STi_ST0  },
  /* DE EE */ { 0, &Ia_fsubp_STi_ST0  },
  /* DE EF */ { 0, &Ia_fsubp_STi_ST0  },
  /* DE F0 */ { 0, &Ia_fdivrp_STi_ST0 },
  /* DE F1 */ { 0, &Ia_fdivrp_STi_ST0 },
  /* DE F2 */ { 0, &Ia_fdivrp_STi_ST0 },
  /* DE F3 */ { 0, &Ia_fdivrp_STi_ST0 },
  /* DE F4 */ { 0, &Ia_fdivrp_STi_ST0 },
  /* DE F5 */ { 0, &Ia_fdivrp_STi_ST0 },
  /* DE F6 */ { 0, &Ia_fdivrp_STi_ST0 },
  /* DE F7 */ { 0, &Ia_fdivrp_STi_ST0 },
  /* DE F8 */ { 0, &Ia_fdivp_STi_ST0  },
  /* DE F9 */ { 0, &Ia_fdivp_STi_ST0  },
  /* DE FA */ { 0, &Ia_fdivp_STi_ST0  },
  /* DE FB */ { 0, &Ia_fdivp_STi_ST0  },
  /* DE FC */ { 0, &Ia_fdivp_STi_ST0  },
  /* DE FD */ { 0, &Ia_fdivp_STi_ST0  },
  /* DE FE */ { 0, &Ia_fdivp_STi_ST0  },
  /* DE FF */ { 0, &Ia_fdivp_STi_ST0  },

  // DF (modrm is outside 00h - BFh) (mod == 11)
  /* DF C0 */ { 0, &Ia_ffreep_STi }, // 287 compatibility opcode
  /* DF C1 */ { 0, &Ia_ffreep_STi },
  /* DF C2 */ { 0, &Ia_ffreep_STi },
  /* DF C3 */ { 0, &Ia_ffreep_STi },
  /* DF C4 */ { 0, &Ia_ffreep_STi },
  /* DF C5 */ { 0, &Ia_ffreep_STi },
  /* DF C6 */ { 0, &Ia_ffreep_STi },
  /* DF C7 */ { 0, &Ia_ffreep_STi },
  /* DF C8 */ { 0, &Ia_fxch     }, // undocumented
  /* DF C9 */ { 0, &Ia_fxch     }, // undocumented
  /* DF CA */ { 0, &Ia_fxch     }, // undocumented
  /* DF CB */ { 0, &Ia_fxch     }, // undocumented
  /* DF CC */ { 0, &Ia_fxch     }, // undocumented
  /* DF CD */ { 0, &Ia_fxch     }, // undocumented
  /* DF CE */ { 0, &Ia_fxch     }, // undocumented
  /* DF CF */ { 0, &Ia_fxch     }, // undocumented
  /* DF D0 */ { 0, &Ia_fstp_STi }, // undocumented
  /* DF D1 */ { 0, &Ia_fstp_STi }, // undocumented
  /* DF D2 */ { 0, &Ia_fstp_STi }, // undocumented
  /* DF D3 */ { 0, &Ia_fstp_STi }, // undocumented
  /* DF D4 */ { 0, &Ia_fstp_STi }, // undocumented
  /* DF D5 */ { 0, &Ia_fstp_STi }, // undocumented
  /* DF D6 */ { 0, &Ia_fstp_STi }, // undocumented
  /* DF D7 */ { 0, &Ia_fstp_STi }, // undocumented
  /* DF D8 */ { 0, &Ia_fstp_STi }, // undocumented
  /* DF D9 */ { 0, &Ia_fstp_STi }, // undocumented
  /* DF DA */ { 0, &Ia_fstp_STi }, // undocumented
  /* DF DB */ { 0, &Ia_fstp_STi }, // undocumented
  /* DF DC */ { 0, &Ia_fstp_STi }, // undocumented
  /* DF DD */ { 0, &Ia_fstp_STi }, // undocumented
  /* DF DE */ { 0, &Ia_fstp_STi }, // undocumented
  /* DF DF */ { 0, &Ia_fstp_STi }, // undocumented
  /* DF E0 */ { 0, &Ia_fnstsw_AX },
  /* DF E1 */ { 0, &Ia_Invalid },
  /* DF E2 */ { 0, &Ia_Invalid },
  /* DF E3 */ { 0, &Ia_Invalid },
  /* DF E4 */ { 0, &Ia_Invalid },
  /* DF E5 */ { 0, &Ia_Invalid },
  /* DF E6 */ { 0, &Ia_Invalid },
  /* DF E7 */ { 0, &Ia_Invalid },
  /* DF E8 */ { 0, &Ia_fucomip_ST0_STi },
  /* DF E9 */ { 0, &Ia_fucomip_ST0_STi },
  /* DF EA */ { 0, &Ia_fucomip_ST0_STi },
  /* DF EB */ { 0, &Ia_fucomip_ST0_STi },
  /* DF EC */ { 0, &Ia_fucomip_ST0_STi },
  /* DF ED */ { 0, &Ia_fucomip_ST0_STi },
  /* DF EE */ { 0, &Ia_fucomip_ST0_STi },
  /* DF EF */ { 0, &Ia_fucomip_ST0_STi },
  /* DF F0 */ { 0, &Ia_fcomip_ST0_STi  },
  /* DF F1 */ { 0, &Ia_fcomip_ST0_STi  },
  /* DF F2 */ { 0, &Ia_fcomip_ST0_STi  },
  /* DF F3 */ { 0, &Ia_fcomip_ST0_STi  },
  /* DF F4 */ { 0, &Ia_fcomip_ST0_STi  },
  /* DF F5 */ { 0, &Ia_fcomip_ST0_STi  },
  /* DF F6 */ { 0, &Ia_fcomip_ST0_STi  },
  /* DF F7 */ { 0, &Ia_fcomip_ST0_STi  },
  /* DF F8 */ { 0, &Ia_Invalid },
  /* DF F9 */ { 0, &Ia_Invalid },
  /* DF FA */ { 0, &Ia_Invalid },
  /* DF FB */ { 0, &Ia_Invalid },
  /* DF FC */ { 0, &Ia_Invalid },
  /* DF FD */ { 0, &Ia_Invalid },
  /* DF FE */ { 0, &Ia_Invalid },
  /* DF FF */ { 0, &Ia_Invalid },
};
