/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// generated by Fast Light User Interface Designer (fluid) version 1.0104

#include <config.h>
#include <global.hpp>

#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>


#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Value_Slider.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Image.H>
#include <FL/Fl_Pixmap.H>
#include <FL/fl_draw.H>
#include <FL/Fl_Scroll.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Light_Button.H>
#include <FL/Fl_Color_Chooser.H>
#include <FL/Fl_Help_Dialog.H>


#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>
#include <bist_plugin.hpp>
#include <mol_canvas.hpp>

#include <util.hpp>
#include <box_prop.hpp>

#include <finestra_pr.hpp>
#include <editor.hpp>


extern finestra_pr* MainWindow;


void box_prop_type_cb(Fl_Widget* w, void* d){
  box_prop* arrp=dynamic_cast<box_prop*>(w->parent());
  editor* ed=dynamic_cast<editor*>(MainWindow);
  Fl_Menu_Button* the_menu=dynamic_cast<Fl_Menu_Button*>(w);
  box_type the_type=static_cast<box_type>(the_menu->value());
  arrp->_box->b_type(the_type);
  ed->redraw();
}


void box_prop_color_cb(Fl_Widget* w, void* d){
  unsigned char r,g,b;
  int pushd=fl_color_chooser(_("pick a color..."), r, g, b);
  editor* ed=dynamic_cast<editor*>(MainWindow);
  box_prop* propr=dynamic_cast<box_prop*>(w->parent());
  if(pushd){
    propr->_box->cr(r);
    propr->_box->cg(g);
    propr->_box->cb(b);
    ed->redraw();
  }
}

void box_prop_ok_cb(Fl_Widget* w, void* d){
  Fl_Window* wi=dynamic_cast<Fl_Window*>(w->parent());
  wi->hide();

}

void box_prop_cancel_cb(Fl_Widget* w, void* d){
  Fl_Window* wi=dynamic_cast<Fl_Window*>(w->parent());
  wi->hide();
}

void box_prop_width_cb(Fl_Widget* w, void* d){
  Fl_Value_Slider* sl=dynamic_cast<Fl_Value_Slider*>(w);
  box_prop* arrp=dynamic_cast<box_prop*>(w->parent());
  editor* ed=dynamic_cast<editor*>(MainWindow);
  arrp->_box->spessore(static_cast<int>(sl->value()));
  ed->redraw();
}

void box_prop_tick_cb(Fl_Widget* w, void* d){

  Fl_Value_Slider* sl=dynamic_cast<Fl_Value_Slider*>(w);
  box_prop* arrp=dynamic_cast<box_prop*>(w->parent());
  editor* ed=dynamic_cast<editor*>(MainWindow);
  arrp->_box->dash(static_cast<int>(sl->value()));
  ed->redraw();
}

box_prop::~box_prop(){

}

box_prop::box_prop(BoxProc* arr)
  :Fl_Double_Window(400, 171),
   _box(arr)
 {
      
   { Fl_Box* o = new Fl_Box(5, 20, 395, 110, _("Box properties"));
   o->box(FL_ENGRAVED_BOX);
   o->align(FL_ALIGN_TOP_LEFT);
   }
   
   { 
     Fl_Value_Slider* o = new Fl_Value_Slider(100, 25, 250, 25, _("Dash:"));
     o->type(1);
     o->step(0.01);
     o->align(FL_ALIGN_LEFT);
     o->range(0, 30);
     o->precision(0);
     o->value(_box->dash());
     o->callback(box_prop_tick_cb);
   }
    
   { 
     Fl_Value_Slider* o = new Fl_Value_Slider(100, 52, 250, 25, _("Thickness:"));
     o->type(1);
     o->step(0.01);
     o->align(FL_ALIGN_LEFT);
     o->range(0, 10);
     o->precision(0);
     o->value(_box->spessore());
     o->callback(box_prop_width_cb);
   }

   
   Fl_Button* color=new Fl_Button(w()/2-LARG_BUTTON_DEFAULT*2, 92, 
                                   LARG_BUTTON_DEFAULT*2, LARG_BUTTON_DEFAULT, _("Color"));
   color->callback(box_prop_color_cb);
   add(color);


   Fl_Menu_Item menu_type[] = {
     {_("normal"), 0, 0, NULL},
     {_("shadowed"), 0, 0, NULL},
     {0}
   };

   Fl_Menu_Button* type_box=new Fl_Menu_Button(w()/2, 92, 
                               LARG_BUTTON_DEFAULT*3, LARG_BUTTON_DEFAULT, _("Type"));
   type_box->copy(menu_type);
   type_box->callback(box_prop_type_cb);
   type_box->align(FL_ALIGN_LEFT | FL_ALIGN_INSIDE);
   add(type_box);

   Fl_Button* annulla=new Fl_Button(w()/2-LARG_BUTTON_DEFAULT*3/2, h()-LARG_BUTTON_DEFAULT-10, 
                                    LARG_BUTTON_DEFAULT*3, LARG_BUTTON_DEFAULT, _("Close"));
   annulla->callback(box_prop_cancel_cb);
   add(annulla);
   
   end();
   set_modal();
   dialog_position(this);
}

void box_win(BoxProc* at){
  box_prop p(at);
  p.show();

  while(p.shown()){
    Fl::wait();
  }

  
}
