class newton_integ {

public:
  newton_integ();
  newton_integ(newton_integ &other);
  virtual ~newton_integ();

  virtual std::vector<float> force()=0;

  void  dt(float nw);
  float dt();

  void  thrs_pos(float nw);
  float thrs_pos();

  void  m(float nw);
  float m();

  void pos(std::vector<float> nw);
  std::vector<float> pos();

  bool update();

protected:
  

  float _dt;
  float _thrs_pos;
  float _m;


  std::vector<float> _accel; 
  std::vector<float> _velo;
  std::vector<float> _pos; 

  std::vector<float> _savedpos; 

};


class bidimensional_vinculated_particle : public newton_integ {

public:
  
  bidimensional_vinculated_particle();
  bidimensional_vinculated_particle(bidimensional_vinculated_particle& other);

  void add_particle(std::pair<float, float> particle);

  void add_center(std::pair<float, float> center);

  void k_spring(float nw);

  float k_spring();

  virtual ~bidimensional_vinculated_particle();
  virtual std::vector<float> force();


protected:

  std::vector< std::pair<float, float> > _particles;
  std::pair<float, float>                _center;
  
  float                                  _k_spring;

};
