/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef _DIALOGBOOK_H
#define _DIALOGBOOK_H

#include <gtkmm.h>
#include <iostream>
#include <libintl.h>
#include "Book.h"

#define _(String) gettext (String)
#define gettext_noop(String) (String)
#define N_(String) gettext_noop (String)

using namespace std;

class DialogBook : public Gtk::Window {
public:
  DialogBook(Book* book);
  virtual ~DialogBook();
  
  /* Emitted when the "Edit" button has been clicked. */
  SigC::Signal2<void, DialogBook*, Book*> signal_button_edit_clicked;
  /* Emitted when the "Close" button has been clicked. */
  SigC::Signal2<void, DialogBook*, Book*> signal_button_close_clicked;
  
  /* Returns a pointer to the book associated with this window. */
  Book* get_book(void);
  
protected:
  /* Called, whenever the "Edit" button has been clicked. */
  void on_button_edit_clicked(void);
  /* Called, whenever the "Close" button has been clicked. */
  void on_button_close_clicked(void);
  /* Called, when the window was closed using the window manager. */
  bool on_window_delete_event(GdkEventAny* trash);
  
  Book*                     book;
  Gtk::Table                table;
  
  // Labels
  Gtk::Label                label_author;
  Gtk::Label                label_author_str;
  Gtk::Label                label_title;
  Gtk::Label                label_title_str;
  Gtk::Label                label_isbn;
  Gtk::Label                label_isbn_str;
  Gtk::Label                label_category;
  Gtk::Label                label_category_str;
  Gtk::Label                label_rating;
  Gtk::Image                image_rating;
  Gtk::Label                label_readdate;
  Gtk::Label                label_readdate_str;
  
  // Summary and Review
  Gtk::Label                label_summary;
  Gtk::Label                label_summary_str;
  Gtk::ScrolledWindow       scroll_summary;
  Gtk::Label                label_review;
  Gtk::Label                label_review_str;
  Gtk::ScrolledWindow       scroll_review;
  
  // Buttons
  Gtk::HBox                 buttonbox;
  Gtk::Fixed                fixed;
  
  Gtk::HBox                 hbox_button_edit;
  Gtk::Label                label_button_edit;
  Gtk::Image                image_button_edit;
  Gtk::Button               button_edit;
  
  Gtk::Button               button_close;
};

#endif /* _DIALOGBOOK_H */
