#!/bin/sh
src=`pwd`
tmp=$src/tests-tmp
rm -rf $tmp
mkdir -p $tmp
PATH="$src:/bin:/usr/bin:/usr/local/bin"
tests_failed=0
tests_count=0
_UID=`id -u`
_GID=`id -g`
export USER=`whoami`
export BCRON_SPOOL=$tmp/spool
export BCRON_SPOOL=$tmp/spool
export BCRON_USER=$USER
export BCRONTAB_SOCKET=$tmp/socket
export CRONTABS=$BCRON_SPOOL/crontabs

mkdir $BCRON_SPOOL
mkdir $CRONTABS
mkdir $BCRON_SPOOL/tmp
mkfifo $BCRON_SPOOL/trigger

netstring() {
  perl -e '
    $string = join("", <>);
    printf "%d:%s,", length($string), $string;
  '
}

spoolsockcmd() {
  unixclient $BCRONTAB_SOCKET sh -c "
    perl -e '
      \$string = join(\"\", <>);
      printf \"%d:%s,\", length(\$string), \$string;
    ' >&7; cat <&6; echo"
}

spoolcmd() {
    perl -e '
      $string = join("", <>);
      printf "%d:%s,", length($string), $string;
    ' | env PROTO=UNIX UNIXREMOTEEUID=`id -u` $src/bcron-spool "$@" 2>/dev/null
    echo
}

sched() {
  MSG_DEBUG=0 $src/test-sched "$@" 2>&1
}

run_compare_test() {
  local name=$1
  shift
  sed -e "s:@SOURCE@:$src:g"   	-e "s:@TMPDIR@:$tmp:g"   	-e "s:@UID@:$_UID:" 	-e "s:@GID@:$_GID:" 	>$tmp/expected
  ( runtest "$@" 2>&1 ) 2>&1 >$tmp/actual-raw
  cat -v $tmp/actual-raw >$tmp/actual
  if ! cmp $tmp/expected $tmp/actual >/dev/null 2>&1
  then
    echo "Test $name $@ failed:"
	( cd $tmp; diff -U 9999 expected actual | tail -n +3; echo; )
	let tests_failed=tests_failed+1
  fi
  rm -f $tmp/expected $tmp/actual
  let tests_count=tests_count+1
}

##### Test tests/spool-delete-baduser #####

runtest() {
touch $CRONTABS/root
echo -n "Rroot" | spoolcmd
test -e $CRONTABS/root && echo File still exists.
}
run_compare_test tests/spool-delete-baduser  <<END_OF_TEST_RESULTS
37:DUsername does not match invoking UID,
File still exists.
END_OF_TEST_RESULTS


##### Test tests/sched-dst #####

runtest() {
local job="$1"
local start="$2"
export TZ=EST5EDT
sched "$job echo" $start
unset TZ
}
run_compare_test tests/sched-dst '0 * * * *' '1081054860' <<END_OF_TEST_RESULTS
last: 1081054860 2004-04-04 00:01:00 EST
next: 1081058400 2004-04-04 01:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 * * * *' '1081058460' <<END_OF_TEST_RESULTS
last: 1081058460 2004-04-04 01:01:00 EST
next: 1081062000 2004-04-04 03:00:00 EDT
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 * * * *' '1081062060' <<END_OF_TEST_RESULTS
last: 1081062060 2004-04-04 03:01:00 EDT
next: 1081065600 2004-04-04 04:00:00 EDT
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 * * * *' '1099195260' <<END_OF_TEST_RESULTS
last: 1099195260 2004-10-31 00:01:00 EDT
next: 1099198800 2004-10-31 01:00:00 EDT
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 * * * *' '1099198860' <<END_OF_TEST_RESULTS
last: 1099198860 2004-10-31 01:01:00 EDT
next: 1099202400 2004-10-31 01:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 * * * *' '1099202460' <<END_OF_TEST_RESULTS
last: 1099202460 2004-10-31 01:01:00 EST
next: 1099206000 2004-10-31 02:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 * * * *' '1099206060' <<END_OF_TEST_RESULTS
last: 1099206060 2004-10-31 02:01:00 EST
next: 1099209600 2004-10-31 03:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 0 * * *' '1081054860' <<END_OF_TEST_RESULTS
last: 1081054860 2004-04-04 00:01:00 EST
next: 1081137600 2004-04-05 00:00:00 EDT
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 0 * * *' '1081058460' <<END_OF_TEST_RESULTS
last: 1081058460 2004-04-04 01:01:00 EST
next: 1081137600 2004-04-05 00:00:00 EDT
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 0 * * *' '1081062060' <<END_OF_TEST_RESULTS
last: 1081062060 2004-04-04 03:01:00 EDT
next: 1081137600 2004-04-05 00:00:00 EDT
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 0 * * *' '1099195260' <<END_OF_TEST_RESULTS
last: 1099195260 2004-10-31 00:01:00 EDT
next: 1099285200 2004-11-01 00:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 0 * * *' '1099198860' <<END_OF_TEST_RESULTS
last: 1099198860 2004-10-31 01:01:00 EDT
next: 1099285200 2004-11-01 00:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 0 * * *' '1099202460' <<END_OF_TEST_RESULTS
last: 1099202460 2004-10-31 01:01:00 EST
next: 1099285200 2004-11-01 00:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 0 * * *' '1099206060' <<END_OF_TEST_RESULTS
last: 1099206060 2004-10-31 02:01:00 EST
next: 1099285200 2004-11-01 00:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 1 * * *' '1081054860' <<END_OF_TEST_RESULTS
last: 1081054860 2004-04-04 00:01:00 EST
next: 1081058400 2004-04-04 01:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 1 * * *' '1081058460' <<END_OF_TEST_RESULTS
last: 1081058460 2004-04-04 01:01:00 EST
next: 1081141200 2004-04-05 01:00:00 EDT
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 1 * * *' '1081062060' <<END_OF_TEST_RESULTS
last: 1081062060 2004-04-04 03:01:00 EDT
next: 1081141200 2004-04-05 01:00:00 EDT
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 1 * * *' '1099195260' <<END_OF_TEST_RESULTS
last: 1099195260 2004-10-31 00:01:00 EDT
next: 1099198800 2004-10-31 01:00:00 EDT
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 1 * * *' '1099198860' <<END_OF_TEST_RESULTS
last: 1099198860 2004-10-31 01:01:00 EDT
next: 1099288800 2004-11-01 01:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 1 * * *' '1099202460' <<END_OF_TEST_RESULTS
last: 1099202460 2004-10-31 01:01:00 EST
next: 1099288800 2004-11-01 01:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 1 * * *' '1099206060' <<END_OF_TEST_RESULTS
last: 1099206060 2004-10-31 02:01:00 EST
next: 1099288800 2004-11-01 01:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 2 * * *' '1081054860' <<END_OF_TEST_RESULTS
last: 1081054860 2004-04-04 00:01:00 EST
next: 1081062000 2004-04-04 03:00:00 EDT
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 2 * * *' '1081058460' <<END_OF_TEST_RESULTS
last: 1081058460 2004-04-04 01:01:00 EST
next: 1081062000 2004-04-04 03:00:00 EDT
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 2 * * *' '1081062060' <<END_OF_TEST_RESULTS
last: 1081062060 2004-04-04 03:01:00 EDT
next: 1081144800 2004-04-05 02:00:00 EDT
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 2 * * *' '1099195260' <<END_OF_TEST_RESULTS
last: 1099195260 2004-10-31 00:01:00 EDT
next: 1099206000 2004-10-31 02:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 2 * * *' '1099198860' <<END_OF_TEST_RESULTS
last: 1099198860 2004-10-31 01:01:00 EDT
next: 1099206000 2004-10-31 02:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 2 * * *' '1099202460' <<END_OF_TEST_RESULTS
last: 1099202460 2004-10-31 01:01:00 EST
next: 1099206000 2004-10-31 02:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 2 * * *' '1099206060' <<END_OF_TEST_RESULTS
last: 1099206060 2004-10-31 02:01:00 EST
next: 1099292400 2004-11-01 02:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 3 * * *' '1081054860' <<END_OF_TEST_RESULTS
last: 1081054860 2004-04-04 00:01:00 EST
next: 1081062000 2004-04-04 03:00:00 EDT
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 3 * * *' '1081058460' <<END_OF_TEST_RESULTS
last: 1081058460 2004-04-04 01:01:00 EST
next: 1081062000 2004-04-04 03:00:00 EDT
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 3 * * *' '1081062060' <<END_OF_TEST_RESULTS
last: 1081062060 2004-04-04 03:01:00 EDT
next: 1081148400 2004-04-05 03:00:00 EDT
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 3 * * *' '1099195260' <<END_OF_TEST_RESULTS
last: 1099195260 2004-10-31 00:01:00 EDT
next: 1099209600 2004-10-31 03:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 3 * * *' '1099198860' <<END_OF_TEST_RESULTS
last: 1099198860 2004-10-31 01:01:00 EDT
next: 1099209600 2004-10-31 03:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 3 * * *' '1099202460' <<END_OF_TEST_RESULTS
last: 1099202460 2004-10-31 01:01:00 EST
next: 1099209600 2004-10-31 03:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 3 * * *' '1099206060' <<END_OF_TEST_RESULTS
last: 1099206060 2004-10-31 02:01:00 EST
next: 1099209600 2004-10-31 03:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 0 1 * *' '1081054860' <<END_OF_TEST_RESULTS
last: 1081054860 2004-04-04 00:01:00 EST
next: 1083384000 2004-05-01 00:00:00 EDT
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 0 1 * *' '1081058460' <<END_OF_TEST_RESULTS
last: 1081058460 2004-04-04 01:01:00 EST
next: 1083384000 2004-05-01 00:00:00 EDT
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 0 1 * *' '1081062060' <<END_OF_TEST_RESULTS
last: 1081062060 2004-04-04 03:01:00 EDT
next: 1083384000 2004-05-01 00:00:00 EDT
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 0 1 * *' '1099195260' <<END_OF_TEST_RESULTS
last: 1099195260 2004-10-31 00:01:00 EDT
next: 1099285200 2004-11-01 00:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 0 1 * *' '1099198860' <<END_OF_TEST_RESULTS
last: 1099198860 2004-10-31 01:01:00 EDT
next: 1099285200 2004-11-01 00:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 0 1 * *' '1099202460' <<END_OF_TEST_RESULTS
last: 1099202460 2004-10-31 01:01:00 EST
next: 1099285200 2004-11-01 00:00:00 EST
END_OF_TEST_RESULTS

run_compare_test tests/sched-dst '0 0 1 * *' '1099206060' <<END_OF_TEST_RESULTS
last: 1099206060 2004-10-31 02:01:00 EST
next: 1099285200 2004-11-01 00:00:00 EST
END_OF_TEST_RESULTS


##### Test tests/spool-delete-nouser #####

runtest() {
echo -n "Rxyzzy$USER" | spoolcmd
}
run_compare_test tests/spool-delete-nouser  <<END_OF_TEST_RESULTS
28:DInvalid or unknown username,
END_OF_TEST_RESULTS


##### Test tests/spool-submit-baduser #####

runtest() {
printf "Sroot\\0* * * * * echo hello\\n" | spoolcmd
rm -f $CRONTABS/root
}
run_compare_test tests/spool-submit-baduser  <<END_OF_TEST_RESULTS
37:DUsername does not match invoking UID,
END_OF_TEST_RESULTS


##### Test tests/spool-filter #####

runtest() {
printf "S$USER\\0* * * * * echo hello\\n" | spoolcmd wc
cat $CRONTABS/$USER
rm -f $CRONTABS/$USER
}
run_compare_test tests/spool-filter  <<END_OF_TEST_RESULTS
29:KCrontab successfully written,
 1  7 21
END_OF_TEST_RESULTS


##### Test tests/spool-delete-good #####

runtest() {
touch $CRONTABS/$USER
echo -n "R$USER" | spoolcmd
test -e $CRONTABS/$USER && echo File still exists.
}
run_compare_test tests/spool-delete-good  <<END_OF_TEST_RESULTS
16:KCrontab removed,
END_OF_TEST_RESULTS


##### Test tests/sched-misc #####

runtest() {
local job="$1"
local start="$2"
export TZ=CST
sched "$job echo" $start
unset TZ
}
run_compare_test tests/sched-misc '*/10 * * * *' '1081058400' <<END_OF_TEST_RESULTS
last: 1081058400 2004-04-04 06:00:00 CST
next: 1081058400 2004-04-04 06:00:00 CST
END_OF_TEST_RESULTS

run_compare_test tests/sched-misc '*/10 * * * *' '1081058460' <<END_OF_TEST_RESULTS
last: 1081058460 2004-04-04 06:01:00 CST
next: 1081059000 2004-04-04 06:10:00 CST
END_OF_TEST_RESULTS

run_compare_test tests/sched-misc '1 1 1 Jan *' '1081058400' <<END_OF_TEST_RESULTS
last: 1081058400 2004-04-04 06:00:00 CST
next: 1104541260 2005-01-01 01:01:00 CST
END_OF_TEST_RESULTS

run_compare_test tests/sched-misc '1 1 1 Jan *' '1081058460' <<END_OF_TEST_RESULTS
last: 1081058460 2004-04-04 06:01:00 CST
next: 1104541260 2005-01-01 01:01:00 CST
END_OF_TEST_RESULTS

run_compare_test tests/sched-misc '1 1 * * Wed' '1081058400' <<END_OF_TEST_RESULTS
last: 1081058400 2004-04-04 06:00:00 CST
next: 1081299660 2004-04-07 01:01:00 CST
END_OF_TEST_RESULTS

run_compare_test tests/sched-misc '1 1 * * Wed' '1081058460' <<END_OF_TEST_RESULTS
last: 1081058460 2004-04-04 06:01:00 CST
next: 1081299660 2004-04-07 01:01:00 CST
END_OF_TEST_RESULTS

run_compare_test tests/sched-misc '3 1 2 * Wed' '1081058400' <<END_OF_TEST_RESULTS
last: 1081058400 2004-04-04 06:00:00 CST
next: 1086138180 2004-06-02 01:03:00 CST
END_OF_TEST_RESULTS

run_compare_test tests/sched-misc '3 1 2 * Wed' '1081058460' <<END_OF_TEST_RESULTS
last: 1081058460 2004-04-04 06:01:00 CST
next: 1086138180 2004-06-02 01:03:00 CST
END_OF_TEST_RESULTS


##### Test tests/spool-submit #####

runtest() {
printf "S$USER\\0* * * * * echo hello\\n" | spoolcmd
cat $CRONTABS/$USER
rm -f $CRONTABS/$USER
}
run_compare_test tests/spool-submit  <<END_OF_TEST_RESULTS
29:KCrontab successfully written,
* * * * * echo hello
END_OF_TEST_RESULTS


##### Test tests/spool-submit-nouser #####

runtest() {
printf "Sxyzzy$USER\\0* * * * * echo hello\\n" | spoolcmd
rm -f $CRONTABS/xyzzy$USER
}
run_compare_test tests/spool-submit-nouser  <<END_OF_TEST_RESULTS
28:DInvalid or unknown username,
END_OF_TEST_RESULTS


rm -rf $tmp
echo $tests_count tests executed, $tests_failed failures
if [ $tests_failed != 0 ]; then exit 1; fi
