/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ExprInstruction;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.Sequence;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public final class Comment
extends SimpleNodeConstructor {
    public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
        instructionDetails.setInstructionName("comment");
    }

    public SequenceType getResultType() {
        return new SequenceType(NodeKindTest.COMMENT, 512);
    }

    public void typeCheck(StaticContext staticContext) {
    }

    public void promoteInst(PromotionOffer promotionOffer) throws XPathException {
        if (this.select != null) {
            this.select = this.select.promote(promotionOffer);
        }
        if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                if (this.children[n] instanceof ExprInstruction) {
                    Expression expression = ((ExprInstruction)this.children[n]).promote(promotionOffer);
                    this.children[n] = expression instanceof Instruction ? (Instruction)((Object)expression) : new Sequence(expression, null);
                } else {
                    throw new IllegalStateException("Children of an ExprInstruction must themselves be ExprInstructions");
                }
                ++n;
            }
        }
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        int n;
        Controller controller = xPathContext.getController();
        String string = this.expandChildren(xPathContext).toString();
        while ((n = string.indexOf("--")) >= 0) {
            this.recoverableError("Invalid characters (--) in comment", controller);
            string = string.substring(0, n + 1) + " " + string.substring(n + 1);
        }
        if (string.length() > 0 && string.charAt(string.length() - 1) == '-') {
            this.recoverableError("Invalid character (-) at end of comment", controller);
            string = string + " ";
        }
        controller.getReceiver().comment(string, 0);
        return null;
    }

    public void display(int n, NamePool namePool) {
        System.err.println(ExpressionTool.indent(n) + "comment");
        super.display(n + 1, namePool);
    }
}

