!{\src2tex{textfont=tt}}
!!****f* ABINIT/calc_sig_ppm
!!
!! NAME
!! calc_sig_ppm
!!
!! FUNCTION
!! Calculating contributions to self-energy operator using a plasmon-pole model
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (FB, GMR, VO, LR, RWG)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  nomega=number of frequencies to be considered
!!  npwc= number of G vectors in the plasmon pole 
!!  npwc1=to be described (used if ppmod==3 .or. ==4)
!!  npwc2=to be described (used if ppmod==3 .or. ==4)
!!  npwx=number of G vectors in rhotwgp
!!  ppmodel=plasmon pole model
!!  theta_mu_minus_e0i= $\tetha(\mu-\epsilon_{k-q,b1,s}), defines if the state
!!   is occupied or not 
!!  zcut=small imaginary part to avoid the divergence. (see related input variable)
!!  omegame0i(nomega)=
!!  otq(npwc,npwc2)=plasmon pole parameters
!!  botsq(npwc,npwc1)=plasmon pole parameters
!!  eig(npwc,npwc)= to be described
!!  rhotwgp(npwx)=matrix elements of the oscillator: $\langle b1 k-q s | e^{-i(q+G)r | b2 k s \rangle$ 
!!
!! OUTPUT
!!  sigcme(nomega) (to be described), only relevant if ppm3 or ppm4
!!  ket(npwc,nomega) contains 
!!      Sum_G''     conjg(rhotw(G)) * Omega(G,G'') * rhotw(G'')
!!              ---------------------------------------------------
!!               omegatw(G,G'') (omega-E_i + omegatw(G,G'')(2f-1))
!!
!! NOTES
!! Taken from old routine
!!
!! PARENTS
!!      csigme
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine calc_sig_ppm(npwc,nomega,rhotwgp,botsq,otq,omegame0i,zcut,theta_mu_minus_e0i,ket,ppmodel,&
& eig,sigcme,npwx,npwc1,npwc2)

 use defs_basis

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nomega,npwc,npwc1,npwc2,npwx,ppmodel
 real(dp),intent(in) :: theta_mu_minus_e0i,zcut
!arrays
 real(dp),intent(in) :: omegame0i(nomega),otq(npwc,npwc2)
 complex,intent(in) :: botsq(npwc,npwc1),eig(npwc,npwc),rhotwgp(npwx)
 complex,intent(inout) :: ket(npwc,nomega)
 complex,intent(out) :: sigcme(nomega)

!Local variables-------------------------------
!scalars
 integer :: ig,igp,ii,ios
 real(dp) :: den,ff,inv_den,omegame0i_io,otw,reomegame0i,twofm1,twofm1_zcut
 complex :: ct,idelta,num,numf,rhotwgdp_igp,twofm1_idelta
 logical :: fully_occupied,totally_empty
!arrays
 complex :: rhotwgdpcc(npwx)

!*************************************************************************

!DEBUG
!write(6,*)' calc_sig_ppm : enter '
!ENDDEBUG

!DEBUG
! write(*,*) npwc,zcut
! write(*,*) rhotwgp(1),botsq(1,1),otq(1,1)
! write(*,*) reomegame0i
!ENDDEBUG

 if(ppmodel==1.or.ppmodel==2)then

  fully_occupied=(abs(theta_mu_minus_e0i-1.)<0.001)
  totally_empty=(abs(theta_mu_minus_e0i)<0.001)

  if(.not.(totally_empty)) then !not totally empty
   twofm1_zcut=zcut
   do ios=1,nomega
    omegame0i_io=omegame0i(ios)
    do igp=1,npwc
     rhotwgdp_igp=rhotwgp(igp)
     do ig=1,npwc
      otw=otq(ig,igp) !in principle otw -> otw - ieta
      num = botsq(ig,igp)*rhotwgdp_igp

      den = omegame0i_io+otw
      if(den**2>zcut**2)then
       ket(ig,ios) = ket(ig,ios) + num/(den*otw)*theta_mu_minus_e0i
      else
       ket(ig,ios) = ket(ig,ios) + num*cmplx(den,twofm1_zcut)/((den**2+twofm1_zcut**2)*otw)&
&                            *theta_mu_minus_e0i
      end if
     end do !ig
    end do !igp
   end do !ios
  end if !not totally empty

  if(.not.(fully_occupied)) then !not fully occupied
   twofm1_zcut=-zcut
   do ios=1,nomega
    omegame0i_io=omegame0i(ios)
    do igp=1,npwc
     rhotwgdp_igp=rhotwgp(igp)
     do ig=1,npwc
      otw=otq(ig,igp) !in principle otw -> otw - ieta
      num = botsq(ig,igp)*rhotwgdp_igp

      den = omegame0i_io-otw
      if(den**2>zcut**2)then
       ket(ig,ios) = ket(ig,ios) + num/(den*otw)*(1.-theta_mu_minus_e0i)
      else
       ket(ig,ios) = ket(ig,ios) + num*cmplx(den,twofm1_zcut)/((den**2+twofm1_zcut**2)*otw)&
&                           *(1.-theta_mu_minus_e0i)
      end if
     end do !ig
    end do !igp
   end do !ios
  end if !not fully occupied

  ket(:,:)=ket(:,:)*0.5

!DEBUG
! write(*,*) npwc,twofm1,ct
!ENDDEBUG

! following lines added by shaltaf for the implementation
! of PPM 3 and 4
! Shaltaf: warning : for insulating systems only
! to be generalized later for metalic systems ..
 else if(ppmodel==3.or.ppmodel==4)then
! rho-twiddle(G) is formed
! Now, introduce rhotwgdpcc, for speed reason
     idelta=cmplx(0,zcut)
     ff=theta_mu_minus_e0i  ! occupation number f (include poles if ...)
     twofm1=2*ff-1          ! 2f-1
     twofm1_zcut=twofm1*zcut
     rhotwgdpcc(:)=conjg(rhotwgp(:))
!DEBUG
!NOTE XG 060124 : reoimegame01, ct and twofm1 are undefined at this stage
!write(6,*)' calc_sig_ppm : Cannot continue without having resolved the conflict ...'
!stop
!ENDDEBUG

  do ios=1,nomega
   omegame0i_io=omegame0i(ios)
    ct = 0
   do ii=1,npwc   ! DM bands
    num=zero
!XG 060123 : I have separated the ppmodel cases, to speed up the execution.
    if(ppmodel==3)then
     do ig=1,npwc
      num=num+rhotwgdpcc(ig)*eig(ig,ii)
     end do
    else if(ppmodel==4)then
     do ig=1,npwc
      num=num+rhotwgdpcc(ig)*botsq(ig,ii)
     end do
    end if
    numf=num*conjg(num)
    if(ppmodel==3)numf=numf*botsq(ii,1)
    otw=dble(otq(ii,1)) ! in principle otw -> otw - ieta
    den = omegame0i_io+otw*twofm1
    if(den**2>zcut**2)then
     inv_den=one/(den)
     ct = ct + numf*inv_den
    else ! if den is small
     inv_den=one/((den**2+twofm1_zcut**2))
     ct = ct + numf*cmplx(den,twofm1_zcut)*inv_den
    end if
   end do ! ii=1,npwc DM bands
!   write(9,*)ct
   sigcme(ios)=ct/2.0
  end do
  end if
end subroutine calc_sig_ppm
!!***
