!{\src2tex{textfont=tt}}
!!****f* ABINIT/mkdenpos
!! NAME
!! mkdenpos
!!
!! FUNCTION
!! Make the ground-state density positive everywhere
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DCA, XG, GMR)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  nfft=(effective) number of FFT grid points (for this processor)
!!  ngrad : =1, only compute the density ; =2 also compute the
!!      gradient of the density. Note : ngrad**2 is also used to dimension rhonow
!!  nspden=number of spin-density components
!!
!! OUTPUT
!!  (see side effects)
!!
!! SIDE EFFECTS
!!  Input/output
!!  rhonow(nfft,nspden,ngrad*ngrad)=electron (spin)-density in real space and
!!     eventually its gradient, either on the unshifted grid (if ishift==0,
!!     then equal to rhor),or on the shifted grid
!!    rhonow(:,:,1)=electron density in electrons/bohr**3
!!    if ngrad==2 : rhonow(:,:,2:4)=gradient of electron density in electrons/bohr**4
!!
!! NOTES
!!  At this stage, rhonow(:,1:nspden,1) contains the density in real space,
!!  on the unshifted or shifted grid. Now test for negative densities
!!  Note that, ignoring model core charge, as long as boxcut>=2
!!  the shifted density is derivable from the square of a Fourier
!!  interpolated charge density => CANNOT go < 0.
!!  However, actually can go < 0 to within machine precision;
!!  do not print useless warnings in this case, just fix it.
!!  Fourier interpolated core charge can go < 0 due to Gibbs
!!  oscillations; could avoid this by recomputing the model core
!!  charge at the new real space grid points (future work).
!!  Note : no care has been taken of the gradients of the density
!!
!! PARENTS
!!      pawxc,pawxcm,rhohxc_coll
!!
!! CHILDREN
!!      wrtout
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine mkdenpos(nfft,ngrad,nspden,rhonow)

 use defs_basis

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: nfft,ngrad,nspden
!arrays
 real(dp),intent(inout) :: rhonow(nfft,nspden,ngrad*ngrad)

!Local variables-------------------------------
!scalars
 integer :: ifft,ispden,numneg
 real(dp) :: rhotmp,worst
 character(len=500) :: message
!arrays
 real(dp) :: rho(2)

! *************************************************************************

! DEBUG
!write(6,*)' mkdenpos : enter '
! ENDDEBUG

 numneg=0
 worst=zero

 if(nspden==1)then

! Non spin-polarized
!$OMP PARALLEL DO PRIVATE(ifft,rhotmp) &
!$OMP&REDUCTION(MIN:worst) &
!$OMP&REDUCTION(+:numneg) &
!$OMP&SHARED(nfft,rhonow)
  do ifft=1,nfft
   rhotmp=rhonow(ifft,1,1)
   if(rhotmp<tol14)then
    if(rhotmp<-tol14)then
!    This case is probably beyond machine precision considerations
     worst=min(worst,rhotmp)
     numneg=numneg+1
    end if
    rhonow(ifft,1,1)=tol14
   end if
  end do
!$OMP END PARALLEL DO
 else

! Spin-polarized
!$OMP PARALLEL DO PRIVATE(ifft,ispden,rho,rhotmp) &
!$OMP&REDUCTION(MIN:worst) &
!$OMP&REDUCTION(+:numneg) &
!$OMP&SHARED(nfft,nspden,rhonow)
  do ifft=1,nfft
!  For polarized case, rho(1) is spin-up density, rho(2) is spin-down density
   rho(1)=rhonow(ifft,2,1)
   rho(2)=rhonow(ifft,1,1)-rho(1)
   do ispden=1,nspden
    if (rho(ispden)<tol14) then
     if (rho(ispden)<-tol14) then
!     This case is probably beyond machine precision considerations
      worst=min(worst,rho(ispden))
      numneg=numneg+1
     end if
     rho(ispden)=tol14
    end if
   end do
   rhonow(ifft,1,1)=rho(1)+rho(2)
   rhonow(ifft,2,1)=rho(1)
  end do
!$OMP END PARALLEL DO

!End choice between non-spin polarized and spin-polarized.
 end if

 if (numneg>0) then
  write(message, '(a,a,a,a,i10,a,a,a,es10.2,a,e10.2,a,a,a,a)' ) ch10,&
&  ' mkdenpos : WARNING -',ch10,&
&  '  Density went < 0 at',numneg,' points',ch10,&
&  '  and was set to',tol14,'.  Lowest was ',worst,'.',ch10,&
&  '  Likely due to too low boxcut or too low ecut for',&
&            ' pseudopotential core charge.'
  call wrtout(06,message,'COLL')
 end if

!DEBUG
! write(6,'(a)') ' mkdenpos :  '
! write(6,'(a)')&
!& '   ir              rhonow(:,:,1:4)'
! do ir=1,nfft
!  write(message,'(i5,a,4es14.6)')ir,' ',&
!&  rhonow(ir,1,1:4)
!  call wrtout(06,message,'COLL')
!  if(nspden==2)then
!   write(message,'(a,2es14.6)')'               ',rhonow(ir,2,1:4)
!   call wrtout(06,message,'COLL')
!  end if
! end do
!ENDDEBUG

end subroutine mkdenpos
!!***
