/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_CHIPACCESS_H_
#define OPENDRIM_CHIPACCESS_H_

#include "PhysicalAsset_Common.h"

#include "OpenDRIM_Chip.h"

int PhysicalAsset_OpenDRIM_Chip_load(const CMPIBroker* broker, string& errorMessage);

int PhysicalAsset_OpenDRIM_Chip_unload(string& errorMessage);

int PhysicalAsset_OpenDRIM_Chip_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_Chip>& instances, const char** properties, string& errorMessage, const string& discriminant);

int PhysicalAsset_OpenDRIM_Chip_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_Chip& instance, const char** properties, string& errorMessage);

int PhysicalAsset_OpenDRIM_Chip_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Chip& newInstance, const OpenDRIM_Chip& oldInstance, const char** properties, string& errorMessage);

int PhysicalAsset_OpenDRIM_Chip_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Chip& instance, string& errorMessage);

int PhysicalAsset_OpenDRIM_Chip_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_Chip& instance, string& errorMessage);

int PhysicalAsset_OpenDRIM_Chip_populate(OpenDRIM_Chip& instance, string& errorMessage);

#endif /*OPENDRIM_CHIPACCESS_H_*/
