/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverter;
import java.awt.GraphicsEnvironment;

public class FontNameConverter
implements ObjectConverter {
    private boolean _ensureFontExistence = false;
    public static ConverterContext CONTEXT = new ConverterContext("FontName");

    @Override
    public String toString(Object object, ConverterContext converterContext) {
        if (object == null) {
            return "";
        }
        if (this.isEnsureFontExistence()) {
            String[] stringArray;
            for (String string : stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                if (!string.equals(object)) continue;
                return string;
            }
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        return "";
    }

    @Override
    public boolean supportToString(Object object, ConverterContext converterContext) {
        return true;
    }

    @Override
    public Object fromString(String string, ConverterContext converterContext) {
        if (string.length() == 0) {
            return null;
        }
        if (this.isEnsureFontExistence()) {
            String[] stringArray;
            for (String string2 : stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
                if (!string2.equals(string)) continue;
                return string;
            }
            return null;
        }
        return string;
    }

    @Override
    public boolean supportFromString(String string, ConverterContext converterContext) {
        return true;
    }

    public boolean isEnsureFontExistence() {
        return this._ensureFontExistence;
    }

    public void setEnsureFontExistence(boolean bl) {
        this._ensureFontExistence = bl;
    }
}

