; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+v \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefix=RV32
; RUN: sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+v \
; RUN:   -verify-machineinstrs | FileCheck %s --check-prefix=RV64

declare <vscale x 1 x i8> @llvm.riscv.vle.nxv1i8(
  <vscale x 1 x i8>,
  <vscale x 1 x i8>*,
  iXLen);

define <vscale x 1 x i8> @intrinsic_vle_v_tu_nxv1i8_nxv1i8(<vscale x 1 x i8> %0, <vscale x 1 x i8>* %1, iXLen %2) nounwind {
; RV32-LABEL: intrinsic_vle_v_tu_nxv1i8_nxv1i8:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetvli zero, a1, e8, mf8, tu, mu
; RV32-NEXT:    vle8.v v8, (a0)
; RV32-NEXT:    ret
;
; RV64-LABEL: intrinsic_vle_v_tu_nxv1i8_nxv1i8:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetvli zero, a1, e8, mf8, tu, mu
; RV64-NEXT:    vle8.v v8, (a0)
; RV64-NEXT:    ret
entry:
  %a = call <vscale x 1 x i8> @llvm.riscv.vle.nxv1i8(
    <vscale x 1 x i8> %0,
    <vscale x 1 x i8>* %1,
    iXLen %2)

  ret <vscale x 1 x i8> %a
}

declare <vscale x 1 x i8> @llvm.riscv.vlse(
  <vscale x 1 x i8>,
  <vscale x 1 x i8>*,
  iXLen,
  iXLen);


define <vscale x 1 x i8> @intrinsic_vlse_v_tu(<vscale x 1 x i8> %0, <vscale x 1 x i8>* %1, iXLen %2, iXLen %3) nounwind {
; RV32-LABEL: intrinsic_vlse_v_tu:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetvli zero, a2, e8, mf8, tu, mu
; RV32-NEXT:    vlse8.v v8, (a0), a1
; RV32-NEXT:    ret
;
; RV64-LABEL: intrinsic_vlse_v_tu:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetvli zero, a2, e8, mf8, tu, mu
; RV64-NEXT:    vlse8.v v8, (a0), a1
; RV64-NEXT:    ret
entry:
  %a = call <vscale x 1 x i8> @llvm.riscv.vlse(
    <vscale x 1 x i8> %0,
    <vscale x 1 x i8>* %1,
    iXLen %2,
    iXLen %3)

  ret <vscale x 1 x i8> %a
}

declare { <vscale x 1 x i8>, iXLen } @llvm.riscv.vleff(
  <vscale x 1 x i8>,
  <vscale x 1 x i8>*,
  iXLen);

define <vscale x 1 x i8> @intrinsic_vleff_v_tu(<vscale x 1 x i8> %0, <vscale x 1 x i8>* %1, iXLen %2, iXLen* %3) nounwind {
; RV32-LABEL: intrinsic_vleff_v_tu:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetvli zero, a1, e8, mf8, tu, mu
; RV32-NEXT:    vle8ff.v v8, (a0)
; RV32-NEXT:    csrr a0, vl
; RV32-NEXT:    sw a0, 0(a2)
; RV32-NEXT:    ret
;
; RV64-LABEL: intrinsic_vleff_v_tu:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetvli zero, a1, e8, mf8, tu, mu
; RV64-NEXT:    vle8ff.v v8, (a0)
; RV64-NEXT:    csrr a0, vl
; RV64-NEXT:    sd a0, 0(a2)
; RV64-NEXT:    ret
entry:
  %a = call { <vscale x 1 x i8>, iXLen } @llvm.riscv.vleff(
    <vscale x 1 x i8> %0,
    <vscale x 1 x i8>* %1,
    iXLen %2)
  %b = extractvalue { <vscale x 1 x i8>, iXLen } %a, 0
  %c = extractvalue { <vscale x 1 x i8>, iXLen } %a, 1
  store iXLen %c, iXLen* %3
  ret <vscale x 1 x i8> %b
}

declare <vscale x 1 x i8> @llvm.riscv.vloxei.nxv1i8(
  <vscale x 1 x i8>,
  <vscale x 1 x i8>*,
  <vscale x 1 x i8>,
  iXLen);

define <vscale x 1 x i8> @intrinsic_vloxei_v_tu_nxv1i8_nxv1i8(<vscale x 1 x i8> %0, <vscale x 1 x i8>* %1, <vscale x 1 x i8> %2, iXLen %3) nounwind {
; RV32-LABEL: intrinsic_vloxei_v_tu_nxv1i8_nxv1i8:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    vsetvli zero, a1, e8, mf8, tu, mu
; RV32-NEXT:    vloxei8.v v8, (a0), v9
; RV32-NEXT:    ret
;
; RV64-LABEL: intrinsic_vloxei_v_tu_nxv1i8_nxv1i8:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    vsetvli zero, a1, e8, mf8, tu, mu
; RV64-NEXT:    vloxei8.v v8, (a0), v9
; RV64-NEXT:    ret
entry:
  %a = call <vscale x 1 x i8> @llvm.riscv.vloxei.nxv1i8(
    <vscale x 1 x i8> %0,
    <vscale x 1 x i8>* %1,
    <vscale x 1 x i8> %2,
    iXLen %3)

  ret <vscale x 1 x i8> %a
}
