include(CheckSymbolExists)

check_symbol_exists("__i586__"     ""  X86_i586)
check_symbol_exists("__i686__"     ""  X86_i686)
check_symbol_exists("__X86__"     ""  X86_X86)
check_symbol_exists("_X86_"     ""  X86_X862)
check_symbol_exists("__I86__"     ""  X86_I86)
check_symbol_exists("__IA32__"     ""  X86_IA32)
check_symbol_exists("_M_IX86"  ""  X86_M_IX86)
check_symbol_exists("__amd64"  ""  X86_AMD64)
check_symbol_exists("__amd64__"  ""  X86_AMD642)
check_symbol_exists("__x86_64"  ""  X86_X86_64)
check_symbol_exists("__x86_64__"  ""  X86_X86_642)
check_symbol_exists("_M_X64"  ""  X86_X64)
check_symbol_exists("__ia64"  ""  X86_IA64)
check_symbol_exists("__ia64__"  ""  X86_IA642)
check_symbol_exists("_M_IA64"  ""  X86_M_IA64)
check_symbol_exists("_M_ARM64"     ""  MSVC_ARM64)
check_symbol_exists("__aarch64__"  ""  ARCH_ARM64)
check_symbol_exists("M_ARM" "" ARCH_M_ARM)
check_symbol_exists("_arm__" "" ARCH_ARM)
check_symbol_exists("_thumb__" "" ARCH_THUMB)
check_symbol_exists("_TARGET_ARCH_ARM" "" ARCH_ARM_TARGET)
check_symbol_exists("_TARGET_ARCH_THUMB" "" ARCH_ARM_TARGET_THUMB)


if (X86_i586 OR X86_i686 OR X86_X86 OR X86_X862 OR X86_I86 OR X86_IA32 OR
            X86_M_IX86 OR X86_AMD64 OR X86_AMD642 OR X86_X86_64 OR X86_X86_642 OR
            X86_X64 OR X86_IA64 OR X86_IA642 OR X86_M_IA64)
	set(HAVE_SSE_OR_AVX ON CACHE INTERNAL "internal")
else()
	set(HAVE_SSE_OR_AVX OFF CACHE INTERNAL "internal")
endif()

if (MSVC_ARM64 OR ARCH_ARM64 OR ARCH_M_ARM OR ARCH_ARM OR ARCH_THUMB OR ARCH_ARM_TARGET OR ARCH_ARM_TARGET_THUMB)
	set(HAVE_NEON ON CACHE INTERNAL "internal")
else()
	set(HAVE_NEON OFF CACHE INTERNAL "internal")
endif()

if (MSVC_ARM64 OR ARCH_ARM64)
	set(HAVE_NEON64 ON CACHE INTERNAL "internal")
else()
	set(HAVE_NEON64 OFF CACHE INTERNAL "internal")
endif()
