#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 584
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 331
#define ALIAS_COUNT 0
#define TOKEN_COUNT 167
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 51
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 125

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_module = 2,
  anon_sym_version = 3,
  anon_sym_is = 4,
  anon_sym_end = 5,
  anon_sym_import = 6,
  anon_sym_LBRACK = 7,
  anon_sym_RBRACK = 8,
  anon_sym_from = 9,
  anon_sym_COLON_COLON = 10,
  anon_sym_COLON_COLON2 = 11,
  anon_sym_as = 12,
  anon_sym_COLON = 13,
  anon_sym_AT = 14,
  anon_sym_EQ = 15,
  anon_sym_assert = 16,
  sym_controlled_language_tag = 17,
  anon_sym_LPAREN = 18,
  anon_sym_RPAREN = 19,
  anon_sym_COMMA = 20,
  sym_reserved_self = 21,
  anon_sym_with = 22,
  anon_sym_def = 23,
  anon_sym_LBRACE = 24,
  anon_sym_RBRACE = 25,
  sym_quoted_string = 26,
  sym_language_tag = 27,
  anon_sym_LT = 28,
  aux_sym_iri_token1 = 29,
  anon_sym_GT = 30,
  anon_sym_POUND_LBRACK = 31,
  sym_hex_byte = 32,
  sym_double = 33,
  sym_decimal = 34,
  sym_integer = 35,
  sym_rational = 36,
  sym_unsigned = 37,
  anon_sym_true = 38,
  anon_sym_u22a4 = 39,
  anon_sym_false = 40,
  anon_sym_u22a5 = 41,
  anon_sym_Thing = 42,
  anon_sym_Nothing = 43,
  anon_sym_real = 44,
  anon_sym_rational = 45,
  anon_sym_anyURI = 46,
  anon_sym_iri = 47,
  anon_sym_base64Binary = 48,
  anon_sym_boolean = 49,
  anon_sym_date = 50,
  anon_sym_dateTime = 51,
  anon_sym_decimal = 52,
  anon_sym_double = 53,
  anon_sym_duration = 54,
  anon_sym_float = 55,
  anon_sym_gDay = 56,
  anon_sym_gMonth = 57,
  anon_sym_gMonthDay = 58,
  anon_sym_gYearMonth = 59,
  anon_sym_gYear = 60,
  anon_sym_hexBinary = 61,
  anon_sym_binary = 62,
  anon_sym_string = 63,
  anon_sym_time = 64,
  anon_sym_dateTimeStamp = 65,
  anon_sym_dayTimeDuration = 66,
  anon_sym_yearMonthDuration = 67,
  anon_sym_integer = 68,
  anon_sym_long = 69,
  anon_sym_int = 70,
  anon_sym_short = 71,
  anon_sym_byte = 72,
  anon_sym_nonNegativeInteger = 73,
  anon_sym_positiveInteger = 74,
  anon_sym_unsignedLong = 75,
  anon_sym_unsignedInt = 76,
  anon_sym_unsigned = 77,
  anon_sym_unsignedShort = 78,
  anon_sym_unsignedByte = 79,
  anon_sym_nonPositiveInteger = 80,
  anon_sym_negativeInteger = 81,
  anon_sym_normalizedString = 82,
  anon_sym_token = 83,
  anon_sym_language = 84,
  anon_sym_without = 85,
  anon_sym_datatype = 86,
  sym_opaque = 87,
  anon_sym_length = 88,
  anon_sym_maxLength = 89,
  anon_sym_minLength = 90,
  anon_sym_fractionDigits = 91,
  anon_sym_totalDigits = 92,
  anon_sym_maxExclusive = 93,
  anon_sym_maxInclusive = 94,
  anon_sym_minExclusive = 95,
  anon_sym_minInclusive = 96,
  anon_sym_explicitTimezone = 97,
  anon_sym_required = 98,
  anon_sym_prohibited = 99,
  anon_sym_optional = 100,
  anon_sym_pattern = 101,
  sym_kw_is_fixed = 102,
  anon_sym_dimension = 103,
  anon_sym_source = 104,
  anon_sym_parent = 105,
  anon_sym_entity = 106,
  anon_sym_enum = 107,
  anon_sym_of = 108,
  anon_sym_event = 109,
  anon_sym_property = 110,
  anon_sym_rdf = 111,
  anon_sym_a = 112,
  anon_sym_type = 113,
  anon_sym_structure = 114,
  anon_sym_class = 115,
  sym_wildcard = 116,
  anon_sym_union = 117,
  anon_sym_identity = 118,
  anon_sym_ref = 119,
  sym_unknown_type = 120,
  anon_sym_ordered = 121,
  anon_sym_unordered = 122,
  anon_sym_unique = 123,
  anon_sym_nonunique = 124,
  anon_sym_DOT_DOT = 125,
  anon_sym_SLASH_EQ = 126,
  anon_sym_u2260 = 127,
  sym_op_less_than = 128,
  sym_op_greater_than = 129,
  anon_sym_LT_EQ = 130,
  anon_sym_u2264 = 131,
  anon_sym_GT_EQ = 132,
  anon_sym_u2265 = 133,
  anon_sym_not = 134,
  anon_sym_u00ac = 135,
  anon_sym_and = 136,
  anon_sym_u2227 = 137,
  anon_sym_or = 138,
  anon_sym_u2228 = 139,
  anon_sym_xor = 140,
  anon_sym_u22bb = 141,
  anon_sym_implies = 142,
  anon_sym_EQ_EQ_GT = 143,
  anon_sym_u21d2 = 144,
  anon_sym_iff = 145,
  anon_sym_LT_EQ_EQ_GT = 146,
  anon_sym_u21d4 = 147,
  anon_sym_forall = 148,
  anon_sym_u2200 = 149,
  anon_sym_exists = 150,
  anon_sym_u2203 = 151,
  anon_sym_in = 152,
  anon_sym_u2208 = 153,
  sym_set_op_builder = 154,
  anon_sym_u00b7 = 155,
  anon_sym_DOT = 156,
  anon_sym_COLON_EQ = 157,
  anon_sym_u2254 = 158,
  anon_sym_u2192 = 159,
  anon_sym_DASH_GT = 160,
  anon_sym_u2190 = 161,
  anon_sym_LT_DASH = 162,
  anon_sym_PLUS = 163,
  anon_sym_u2295 = 164,
  anon_sym_u2205 = 165,
  sym_line_comment = 166,
  sym_module = 167,
  sym__module_locations = 168,
  sym_module_body = 169,
  sym_import_statement = 170,
  sym_from_clause = 171,
  sym_module_path_root_only = 172,
  sym_module_path_absolute = 173,
  sym_module_path_relative = 174,
  sym__import = 175,
  sym__rename_import = 176,
  sym_member_import = 177,
  sym_module_import = 178,
  sym_qualified_identifier = 179,
  sym_identifier_reference = 180,
  sym_annotation = 181,
  sym_annotation_property = 182,
  sym_constraint = 183,
  sym_annotation_only_body = 184,
  sym_informal_constraint = 185,
  sym_formal_constraint = 186,
  sym_constraint_sentence = 187,
  sym_simple_sentence = 188,
  sym_atomic_sentence = 189,
  sym__actual_arguments = 190,
  sym_equation = 191,
  sym_inequation = 192,
  sym_boolean_sentence = 193,
  sym_unary_boolean_sentence = 194,
  sym_binary_boolean_sentence = 195,
  sym__logical_connective = 196,
  sym_quantified_sentence = 197,
  sym_quantified_variable_binding = 198,
  sym_quantified_variable = 199,
  sym_variable = 200,
  sym_term = 201,
  sym_functional_term = 202,
  sym_function_composition = 203,
  sym_predicate_value = 204,
  sym_sequence_of_predicate_values = 205,
  sym_constraint_environment = 206,
  sym_function_def = 207,
  sym_function_signature = 208,
  sym_function_parameter = 209,
  sym__function_type = 210,
  sym_function_type_reference = 211,
  sym_function_body = 212,
  sym_sequence_builder = 213,
  sym_sequence_builder_body = 214,
  sym_value = 215,
  sym_simple_value = 216,
  sym_string = 217,
  sym_iri = 218,
  sym_binary = 219,
  sym_boolean = 220,
  sym_boolean_truth = 221,
  sym_boolean_falsity = 222,
  sym_value_constructor = 223,
  sym_mapping_value = 224,
  sym_sequence_of_values = 225,
  sym__sequence_value_constraints = 226,
  sym_builtin_simple_type = 227,
  sym__owl_builtin_types = 228,
  sym__builtin_primitive_datatypes = 229,
  sym__derived_date_datetypes = 230,
  sym__derived_numeric_datatypes = 231,
  sym__derived_string_datatypes = 232,
  sym_definition = 233,
  sym_from_definition_clause = 234,
  sym_from_definition_with = 235,
  sym_from_definition_without = 236,
  sym__wildcard_or_identifier_or_sequence = 237,
  sym__identifier_or_sequence = 238,
  sym_data_type_def = 239,
  sym__datatype_base = 240,
  sym_datatype_def_restriction = 241,
  sym__restriction_facet = 242,
  sym_length_restriction_facet = 243,
  sym_digit_restriction_facet = 244,
  sym_value_restriction_facet = 245,
  sym_restriction_value = 246,
  sym_tz_restriction_facet = 247,
  sym_tz_restriction_value = 248,
  sym_pattern_restriction_facet = 249,
  sym_dimension_def = 250,
  sym_dimension_body = 251,
  sym_source_entity = 252,
  sym_dimension_parent = 253,
  sym_entity_def = 254,
  sym_entity_body = 255,
  sym_enum_def = 256,
  sym_enum_body = 257,
  sym_event_def = 258,
  sym_event_body = 259,
  sym_property_def = 260,
  sym_rdf_def = 261,
  sym_rdf_types = 262,
  sym_structure_def = 263,
  sym_structure_body = 264,
  sym_type_class_def = 265,
  sym_type_parameter = 266,
  sym_type_parameter_restriction = 267,
  sym_type_restriction_argument = 268,
  sym_type_class_body = 269,
  sym_method_def = 270,
  sym_union_def = 271,
  sym_union_body = 272,
  sym_entity_identity = 273,
  sym_member = 274,
  sym_member_def = 275,
  sym_property_ref = 276,
  sym__type_expression_to = 277,
  sym_type_reference = 278,
  sym_mapping_type = 279,
  sym_cardinality_expression = 280,
  sym_cardinality_reference_expression = 281,
  sym__cardinality_inner = 282,
  sym_sequence_ordering = 283,
  sym_sequence_uniqueness = 284,
  sym_cardinality_range = 285,
  sym_value_variant = 286,
  sym_type_variant = 287,
  sym_op_inequality = 288,
  sym_op_less_than_or_equal = 289,
  sym_op_greater_than_or_equal = 290,
  sym_logical_op_negation = 291,
  sym_logical_op_conjunction = 292,
  sym_logical_op_disjunction = 293,
  sym_logical_op_exclusive_disjunction = 294,
  sym_logical_op_implication = 295,
  sym_logical_op_biconditional = 296,
  sym_logical_quantifier_universal = 297,
  sym_logical_quantifier_existential = 298,
  sym_set_op_membership = 299,
  sym__function_op_composition = 300,
  sym__function_op_by_definition = 301,
  sym__type_op_has_type = 302,
  sym__type_op_type_restriction = 303,
  sym_type_op_combiner = 304,
  sym__value_empty_sequence = 305,
  aux_sym_module_body_repeat1 = 306,
  aux_sym_module_body_repeat2 = 307,
  aux_sym_module_body_repeat3 = 308,
  aux_sym_import_statement_repeat1 = 309,
  aux_sym_module_path_absolute_repeat1 = 310,
  aux_sym__actual_arguments_repeat1 = 311,
  aux_sym_function_composition_repeat1 = 312,
  aux_sym_sequence_of_predicate_values_repeat1 = 313,
  aux_sym_constraint_environment_repeat1 = 314,
  aux_sym_function_signature_repeat1 = 315,
  aux_sym_sequence_builder_repeat1 = 316,
  aux_sym_binary_repeat1 = 317,
  aux_sym_sequence_of_values_repeat1 = 318,
  aux_sym__wildcard_or_identifier_or_sequence_repeat1 = 319,
  aux_sym_datatype_def_restriction_repeat1 = 320,
  aux_sym_pattern_restriction_facet_repeat1 = 321,
  aux_sym_dimension_body_repeat1 = 322,
  aux_sym_dimension_body_repeat2 = 323,
  aux_sym_enum_body_repeat1 = 324,
  aux_sym_rdf_types_repeat1 = 325,
  aux_sym_type_class_def_repeat1 = 326,
  aux_sym_type_parameter_repeat1 = 327,
  aux_sym_type_parameter_restriction_repeat1 = 328,
  aux_sym_type_class_body_repeat1 = 329,
  aux_sym_union_body_repeat1 = 330,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_module] = "module",
  [anon_sym_version] = "version",
  [anon_sym_is] = "is",
  [anon_sym_end] = "end",
  [anon_sym_import] = "import",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_from] = "from",
  [anon_sym_COLON_COLON] = "::",
  [anon_sym_COLON_COLON2] = "::",
  [anon_sym_as] = "as",
  [anon_sym_COLON] = ":",
  [anon_sym_AT] = "@",
  [anon_sym_EQ] = "=",
  [anon_sym_assert] = "assert",
  [sym_controlled_language_tag] = "controlled_language_tag",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_COMMA] = ",",
  [sym_reserved_self] = "reserved_self",
  [anon_sym_with] = "with",
  [anon_sym_def] = "def",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [sym_quoted_string] = "quoted_string",
  [sym_language_tag] = "language_tag",
  [anon_sym_LT] = "<",
  [aux_sym_iri_token1] = "iri_token1",
  [anon_sym_GT] = ">",
  [anon_sym_POUND_LBRACK] = "#[",
  [sym_hex_byte] = "hex_byte",
  [sym_double] = "double",
  [sym_decimal] = "decimal",
  [sym_integer] = "integer",
  [sym_rational] = "rational",
  [sym_unsigned] = "unsigned",
  [anon_sym_true] = "true",
  [anon_sym_u22a4] = "\u22a4",
  [anon_sym_false] = "false",
  [anon_sym_u22a5] = "\u22a5",
  [anon_sym_Thing] = "Thing",
  [anon_sym_Nothing] = "Nothing",
  [anon_sym_real] = "real",
  [anon_sym_rational] = "rational",
  [anon_sym_anyURI] = "anyURI",
  [anon_sym_iri] = "iri",
  [anon_sym_base64Binary] = "base64Binary",
  [anon_sym_boolean] = "boolean",
  [anon_sym_date] = "date",
  [anon_sym_dateTime] = "dateTime",
  [anon_sym_decimal] = "decimal",
  [anon_sym_double] = "double",
  [anon_sym_duration] = "duration",
  [anon_sym_float] = "float",
  [anon_sym_gDay] = "gDay",
  [anon_sym_gMonth] = "gMonth",
  [anon_sym_gMonthDay] = "gMonthDay",
  [anon_sym_gYearMonth] = "gYearMonth",
  [anon_sym_gYear] = "gYear",
  [anon_sym_hexBinary] = "hexBinary",
  [anon_sym_binary] = "binary",
  [anon_sym_string] = "string",
  [anon_sym_time] = "time",
  [anon_sym_dateTimeStamp] = "dateTimeStamp",
  [anon_sym_dayTimeDuration] = "dayTimeDuration",
  [anon_sym_yearMonthDuration] = "yearMonthDuration",
  [anon_sym_integer] = "integer",
  [anon_sym_long] = "long",
  [anon_sym_int] = "int",
  [anon_sym_short] = "short",
  [anon_sym_byte] = "byte",
  [anon_sym_nonNegativeInteger] = "nonNegativeInteger",
  [anon_sym_positiveInteger] = "positiveInteger",
  [anon_sym_unsignedLong] = "unsignedLong",
  [anon_sym_unsignedInt] = "unsignedInt",
  [anon_sym_unsigned] = "unsigned",
  [anon_sym_unsignedShort] = "unsignedShort",
  [anon_sym_unsignedByte] = "unsignedByte",
  [anon_sym_nonPositiveInteger] = "nonPositiveInteger",
  [anon_sym_negativeInteger] = "negativeInteger",
  [anon_sym_normalizedString] = "normalizedString",
  [anon_sym_token] = "token",
  [anon_sym_language] = "language",
  [anon_sym_without] = "without",
  [anon_sym_datatype] = "datatype",
  [sym_opaque] = "opaque",
  [anon_sym_length] = "length",
  [anon_sym_maxLength] = "maxLength",
  [anon_sym_minLength] = "minLength",
  [anon_sym_fractionDigits] = "fractionDigits",
  [anon_sym_totalDigits] = "totalDigits",
  [anon_sym_maxExclusive] = "maxExclusive",
  [anon_sym_maxInclusive] = "maxInclusive",
  [anon_sym_minExclusive] = "minExclusive",
  [anon_sym_minInclusive] = "minInclusive",
  [anon_sym_explicitTimezone] = "explicitTimezone",
  [anon_sym_required] = "required",
  [anon_sym_prohibited] = "prohibited",
  [anon_sym_optional] = "optional",
  [anon_sym_pattern] = "pattern",
  [sym_kw_is_fixed] = "kw_is_fixed",
  [anon_sym_dimension] = "dimension",
  [anon_sym_source] = "source",
  [anon_sym_parent] = "parent",
  [anon_sym_entity] = "entity",
  [anon_sym_enum] = "enum",
  [anon_sym_of] = "of",
  [anon_sym_event] = "event",
  [anon_sym_property] = "property",
  [anon_sym_rdf] = "rdf",
  [anon_sym_a] = "a",
  [anon_sym_type] = "type",
  [anon_sym_structure] = "structure",
  [anon_sym_class] = "class",
  [sym_wildcard] = "wildcard",
  [anon_sym_union] = "union",
  [anon_sym_identity] = "identity",
  [anon_sym_ref] = "ref",
  [sym_unknown_type] = "unknown_type",
  [anon_sym_ordered] = "ordered",
  [anon_sym_unordered] = "unordered",
  [anon_sym_unique] = "unique",
  [anon_sym_nonunique] = "nonunique",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_u2260] = "\u2260",
  [sym_op_less_than] = "op_less_than",
  [sym_op_greater_than] = "op_greater_than",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_u2264] = "\u2264",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_u2265] = "\u2265",
  [anon_sym_not] = "not",
  [anon_sym_u00ac] = "\u00ac",
  [anon_sym_and] = "and",
  [anon_sym_u2227] = "\u2227",
  [anon_sym_or] = "or",
  [anon_sym_u2228] = "\u2228",
  [anon_sym_xor] = "xor",
  [anon_sym_u22bb] = "\u22bb",
  [anon_sym_implies] = "implies",
  [anon_sym_EQ_EQ_GT] = "==>",
  [anon_sym_u21d2] = "\u21d2",
  [anon_sym_iff] = "iff",
  [anon_sym_LT_EQ_EQ_GT] = "<==>",
  [anon_sym_u21d4] = "\u21d4",
  [anon_sym_forall] = "forall",
  [anon_sym_u2200] = "\u2200",
  [anon_sym_exists] = "exists",
  [anon_sym_u2203] = "\u2203",
  [anon_sym_in] = "in",
  [anon_sym_u2208] = "\u2208",
  [sym_set_op_builder] = "set_op_builder",
  [anon_sym_u00b7] = "\u00b7",
  [anon_sym_DOT] = ".",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_u2254] = "\u2254",
  [anon_sym_u2192] = "\u2192",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_u2190] = "\u2190",
  [anon_sym_LT_DASH] = "<-",
  [anon_sym_PLUS] = "+",
  [anon_sym_u2295] = "\u2295",
  [anon_sym_u2205] = "\u2205",
  [sym_line_comment] = "line_comment",
  [sym_module] = "module",
  [sym__module_locations] = "_module_locations",
  [sym_module_body] = "module_body",
  [sym_import_statement] = "import_statement",
  [sym_from_clause] = "from_clause",
  [sym_module_path_root_only] = "module_path_root_only",
  [sym_module_path_absolute] = "module_path_absolute",
  [sym_module_path_relative] = "module_path_relative",
  [sym__import] = "_import",
  [sym__rename_import] = "_rename_import",
  [sym_member_import] = "member_import",
  [sym_module_import] = "module_import",
  [sym_qualified_identifier] = "qualified_identifier",
  [sym_identifier_reference] = "identifier_reference",
  [sym_annotation] = "annotation",
  [sym_annotation_property] = "annotation_property",
  [sym_constraint] = "constraint",
  [sym_annotation_only_body] = "annotation_only_body",
  [sym_informal_constraint] = "informal_constraint",
  [sym_formal_constraint] = "formal_constraint",
  [sym_constraint_sentence] = "constraint_sentence",
  [sym_simple_sentence] = "simple_sentence",
  [sym_atomic_sentence] = "atomic_sentence",
  [sym__actual_arguments] = "_actual_arguments",
  [sym_equation] = "equation",
  [sym_inequation] = "inequation",
  [sym_boolean_sentence] = "boolean_sentence",
  [sym_unary_boolean_sentence] = "unary_boolean_sentence",
  [sym_binary_boolean_sentence] = "binary_boolean_sentence",
  [sym__logical_connective] = "_logical_connective",
  [sym_quantified_sentence] = "quantified_sentence",
  [sym_quantified_variable_binding] = "quantified_variable_binding",
  [sym_quantified_variable] = "quantified_variable",
  [sym_variable] = "variable",
  [sym_term] = "term",
  [sym_functional_term] = "functional_term",
  [sym_function_composition] = "function_composition",
  [sym_predicate_value] = "predicate_value",
  [sym_sequence_of_predicate_values] = "sequence_of_predicate_values",
  [sym_constraint_environment] = "constraint_environment",
  [sym_function_def] = "function_def",
  [sym_function_signature] = "function_signature",
  [sym_function_parameter] = "function_parameter",
  [sym__function_type] = "_function_type",
  [sym_function_type_reference] = "function_type_reference",
  [sym_function_body] = "function_body",
  [sym_sequence_builder] = "sequence_builder",
  [sym_sequence_builder_body] = "sequence_builder_body",
  [sym_value] = "value",
  [sym_simple_value] = "simple_value",
  [sym_string] = "string",
  [sym_iri] = "iri",
  [sym_binary] = "binary",
  [sym_boolean] = "boolean",
  [sym_boolean_truth] = "boolean_truth",
  [sym_boolean_falsity] = "boolean_falsity",
  [sym_value_constructor] = "value_constructor",
  [sym_mapping_value] = "mapping_value",
  [sym_sequence_of_values] = "sequence_of_values",
  [sym__sequence_value_constraints] = "_sequence_value_constraints",
  [sym_builtin_simple_type] = "builtin_simple_type",
  [sym__owl_builtin_types] = "_owl_builtin_types",
  [sym__builtin_primitive_datatypes] = "_builtin_primitive_datatypes",
  [sym__derived_date_datetypes] = "_derived_date_datetypes",
  [sym__derived_numeric_datatypes] = "_derived_numeric_datatypes",
  [sym__derived_string_datatypes] = "_derived_string_datatypes",
  [sym_definition] = "definition",
  [sym_from_definition_clause] = "from_definition_clause",
  [sym_from_definition_with] = "from_definition_with",
  [sym_from_definition_without] = "from_definition_without",
  [sym__wildcard_or_identifier_or_sequence] = "_wildcard_or_identifier_or_sequence",
  [sym__identifier_or_sequence] = "_identifier_or_sequence",
  [sym_data_type_def] = "data_type_def",
  [sym__datatype_base] = "_datatype_base",
  [sym_datatype_def_restriction] = "datatype_def_restriction",
  [sym__restriction_facet] = "_restriction_facet",
  [sym_length_restriction_facet] = "length_restriction_facet",
  [sym_digit_restriction_facet] = "digit_restriction_facet",
  [sym_value_restriction_facet] = "value_restriction_facet",
  [sym_restriction_value] = "restriction_value",
  [sym_tz_restriction_facet] = "tz_restriction_facet",
  [sym_tz_restriction_value] = "tz_restriction_value",
  [sym_pattern_restriction_facet] = "pattern_restriction_facet",
  [sym_dimension_def] = "dimension_def",
  [sym_dimension_body] = "dimension_body",
  [sym_source_entity] = "source_entity",
  [sym_dimension_parent] = "dimension_parent",
  [sym_entity_def] = "entity_def",
  [sym_entity_body] = "entity_body",
  [sym_enum_def] = "enum_def",
  [sym_enum_body] = "enum_body",
  [sym_event_def] = "event_def",
  [sym_event_body] = "event_body",
  [sym_property_def] = "property_def",
  [sym_rdf_def] = "rdf_def",
  [sym_rdf_types] = "rdf_types",
  [sym_structure_def] = "structure_def",
  [sym_structure_body] = "structure_body",
  [sym_type_class_def] = "type_class_def",
  [sym_type_parameter] = "type_parameter",
  [sym_type_parameter_restriction] = "type_parameter_restriction",
  [sym_type_restriction_argument] = "type_restriction_argument",
  [sym_type_class_body] = "type_class_body",
  [sym_method_def] = "method_def",
  [sym_union_def] = "union_def",
  [sym_union_body] = "union_body",
  [sym_entity_identity] = "entity_identity",
  [sym_member] = "member",
  [sym_member_def] = "member_def",
  [sym_property_ref] = "property_ref",
  [sym__type_expression_to] = "_type_expression_to",
  [sym_type_reference] = "type_reference",
  [sym_mapping_type] = "mapping_type",
  [sym_cardinality_expression] = "cardinality_expression",
  [sym_cardinality_reference_expression] = "cardinality_reference_expression",
  [sym__cardinality_inner] = "_cardinality_inner",
  [sym_sequence_ordering] = "sequence_ordering",
  [sym_sequence_uniqueness] = "sequence_uniqueness",
  [sym_cardinality_range] = "cardinality_range",
  [sym_value_variant] = "value_variant",
  [sym_type_variant] = "type_variant",
  [sym_op_inequality] = "op_inequality",
  [sym_op_less_than_or_equal] = "op_less_than_or_equal",
  [sym_op_greater_than_or_equal] = "op_greater_than_or_equal",
  [sym_logical_op_negation] = "logical_op_negation",
  [sym_logical_op_conjunction] = "logical_op_conjunction",
  [sym_logical_op_disjunction] = "logical_op_disjunction",
  [sym_logical_op_exclusive_disjunction] = "logical_op_exclusive_disjunction",
  [sym_logical_op_implication] = "logical_op_implication",
  [sym_logical_op_biconditional] = "logical_op_biconditional",
  [sym_logical_quantifier_universal] = "logical_quantifier_universal",
  [sym_logical_quantifier_existential] = "logical_quantifier_existential",
  [sym_set_op_membership] = "set_op_membership",
  [sym__function_op_composition] = "_function_op_composition",
  [sym__function_op_by_definition] = "_function_op_by_definition",
  [sym__type_op_has_type] = "_type_op_has_type",
  [sym__type_op_type_restriction] = "_type_op_type_restriction",
  [sym_type_op_combiner] = "type_op_combiner",
  [sym__value_empty_sequence] = "_value_empty_sequence",
  [aux_sym_module_body_repeat1] = "module_body_repeat1",
  [aux_sym_module_body_repeat2] = "module_body_repeat2",
  [aux_sym_module_body_repeat3] = "module_body_repeat3",
  [aux_sym_import_statement_repeat1] = "import_statement_repeat1",
  [aux_sym_module_path_absolute_repeat1] = "module_path_absolute_repeat1",
  [aux_sym__actual_arguments_repeat1] = "_actual_arguments_repeat1",
  [aux_sym_function_composition_repeat1] = "function_composition_repeat1",
  [aux_sym_sequence_of_predicate_values_repeat1] = "sequence_of_predicate_values_repeat1",
  [aux_sym_constraint_environment_repeat1] = "constraint_environment_repeat1",
  [aux_sym_function_signature_repeat1] = "function_signature_repeat1",
  [aux_sym_sequence_builder_repeat1] = "sequence_builder_repeat1",
  [aux_sym_binary_repeat1] = "binary_repeat1",
  [aux_sym_sequence_of_values_repeat1] = "sequence_of_values_repeat1",
  [aux_sym__wildcard_or_identifier_or_sequence_repeat1] = "_wildcard_or_identifier_or_sequence_repeat1",
  [aux_sym_datatype_def_restriction_repeat1] = "datatype_def_restriction_repeat1",
  [aux_sym_pattern_restriction_facet_repeat1] = "pattern_restriction_facet_repeat1",
  [aux_sym_dimension_body_repeat1] = "dimension_body_repeat1",
  [aux_sym_dimension_body_repeat2] = "dimension_body_repeat2",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym_rdf_types_repeat1] = "rdf_types_repeat1",
  [aux_sym_type_class_def_repeat1] = "type_class_def_repeat1",
  [aux_sym_type_parameter_repeat1] = "type_parameter_repeat1",
  [aux_sym_type_parameter_restriction_repeat1] = "type_parameter_restriction_repeat1",
  [aux_sym_type_class_body_repeat1] = "type_class_body_repeat1",
  [aux_sym_union_body_repeat1] = "union_body_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_module] = anon_sym_module,
  [anon_sym_version] = anon_sym_version,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_end] = anon_sym_end,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_COLON_COLON] = anon_sym_COLON_COLON,
  [anon_sym_COLON_COLON2] = anon_sym_COLON_COLON,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_assert] = anon_sym_assert,
  [sym_controlled_language_tag] = sym_controlled_language_tag,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [sym_reserved_self] = sym_reserved_self,
  [anon_sym_with] = anon_sym_with,
  [anon_sym_def] = anon_sym_def,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [sym_quoted_string] = sym_quoted_string,
  [sym_language_tag] = sym_language_tag,
  [anon_sym_LT] = anon_sym_LT,
  [aux_sym_iri_token1] = aux_sym_iri_token1,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_POUND_LBRACK] = anon_sym_POUND_LBRACK,
  [sym_hex_byte] = sym_hex_byte,
  [sym_double] = sym_double,
  [sym_decimal] = sym_decimal,
  [sym_integer] = sym_integer,
  [sym_rational] = sym_rational,
  [sym_unsigned] = sym_unsigned,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_u22a4] = anon_sym_u22a4,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_u22a5] = anon_sym_u22a5,
  [anon_sym_Thing] = anon_sym_Thing,
  [anon_sym_Nothing] = anon_sym_Nothing,
  [anon_sym_real] = anon_sym_real,
  [anon_sym_rational] = anon_sym_rational,
  [anon_sym_anyURI] = anon_sym_anyURI,
  [anon_sym_iri] = anon_sym_iri,
  [anon_sym_base64Binary] = anon_sym_base64Binary,
  [anon_sym_boolean] = anon_sym_boolean,
  [anon_sym_date] = anon_sym_date,
  [anon_sym_dateTime] = anon_sym_dateTime,
  [anon_sym_decimal] = anon_sym_decimal,
  [anon_sym_double] = anon_sym_double,
  [anon_sym_duration] = anon_sym_duration,
  [anon_sym_float] = anon_sym_float,
  [anon_sym_gDay] = anon_sym_gDay,
  [anon_sym_gMonth] = anon_sym_gMonth,
  [anon_sym_gMonthDay] = anon_sym_gMonthDay,
  [anon_sym_gYearMonth] = anon_sym_gYearMonth,
  [anon_sym_gYear] = anon_sym_gYear,
  [anon_sym_hexBinary] = anon_sym_hexBinary,
  [anon_sym_binary] = anon_sym_binary,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_time] = anon_sym_time,
  [anon_sym_dateTimeStamp] = anon_sym_dateTimeStamp,
  [anon_sym_dayTimeDuration] = anon_sym_dayTimeDuration,
  [anon_sym_yearMonthDuration] = anon_sym_yearMonthDuration,
  [anon_sym_integer] = anon_sym_integer,
  [anon_sym_long] = anon_sym_long,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_short] = anon_sym_short,
  [anon_sym_byte] = anon_sym_byte,
  [anon_sym_nonNegativeInteger] = anon_sym_nonNegativeInteger,
  [anon_sym_positiveInteger] = anon_sym_positiveInteger,
  [anon_sym_unsignedLong] = anon_sym_unsignedLong,
  [anon_sym_unsignedInt] = anon_sym_unsignedInt,
  [anon_sym_unsigned] = anon_sym_unsigned,
  [anon_sym_unsignedShort] = anon_sym_unsignedShort,
  [anon_sym_unsignedByte] = anon_sym_unsignedByte,
  [anon_sym_nonPositiveInteger] = anon_sym_nonPositiveInteger,
  [anon_sym_negativeInteger] = anon_sym_negativeInteger,
  [anon_sym_normalizedString] = anon_sym_normalizedString,
  [anon_sym_token] = anon_sym_token,
  [anon_sym_language] = anon_sym_language,
  [anon_sym_without] = anon_sym_without,
  [anon_sym_datatype] = anon_sym_datatype,
  [sym_opaque] = sym_opaque,
  [anon_sym_length] = anon_sym_length,
  [anon_sym_maxLength] = anon_sym_maxLength,
  [anon_sym_minLength] = anon_sym_minLength,
  [anon_sym_fractionDigits] = anon_sym_fractionDigits,
  [anon_sym_totalDigits] = anon_sym_totalDigits,
  [anon_sym_maxExclusive] = anon_sym_maxExclusive,
  [anon_sym_maxInclusive] = anon_sym_maxInclusive,
  [anon_sym_minExclusive] = anon_sym_minExclusive,
  [anon_sym_minInclusive] = anon_sym_minInclusive,
  [anon_sym_explicitTimezone] = anon_sym_explicitTimezone,
  [anon_sym_required] = anon_sym_required,
  [anon_sym_prohibited] = anon_sym_prohibited,
  [anon_sym_optional] = anon_sym_optional,
  [anon_sym_pattern] = anon_sym_pattern,
  [sym_kw_is_fixed] = sym_kw_is_fixed,
  [anon_sym_dimension] = anon_sym_dimension,
  [anon_sym_source] = anon_sym_source,
  [anon_sym_parent] = anon_sym_parent,
  [anon_sym_entity] = anon_sym_entity,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_of] = anon_sym_of,
  [anon_sym_event] = anon_sym_event,
  [anon_sym_property] = anon_sym_property,
  [anon_sym_rdf] = anon_sym_rdf,
  [anon_sym_a] = anon_sym_a,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_structure] = anon_sym_structure,
  [anon_sym_class] = anon_sym_class,
  [sym_wildcard] = sym_wildcard,
  [anon_sym_union] = anon_sym_union,
  [anon_sym_identity] = anon_sym_identity,
  [anon_sym_ref] = anon_sym_ref,
  [sym_unknown_type] = sym_unknown_type,
  [anon_sym_ordered] = anon_sym_ordered,
  [anon_sym_unordered] = anon_sym_unordered,
  [anon_sym_unique] = anon_sym_unique,
  [anon_sym_nonunique] = anon_sym_nonunique,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_u2260] = anon_sym_u2260,
  [sym_op_less_than] = sym_op_less_than,
  [sym_op_greater_than] = sym_op_greater_than,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_u2264] = anon_sym_u2264,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_u2265] = anon_sym_u2265,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_u00ac] = anon_sym_u00ac,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_u2227] = anon_sym_u2227,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_u2228] = anon_sym_u2228,
  [anon_sym_xor] = anon_sym_xor,
  [anon_sym_u22bb] = anon_sym_u22bb,
  [anon_sym_implies] = anon_sym_implies,
  [anon_sym_EQ_EQ_GT] = anon_sym_EQ_EQ_GT,
  [anon_sym_u21d2] = anon_sym_u21d2,
  [anon_sym_iff] = anon_sym_iff,
  [anon_sym_LT_EQ_EQ_GT] = anon_sym_LT_EQ_EQ_GT,
  [anon_sym_u21d4] = anon_sym_u21d4,
  [anon_sym_forall] = anon_sym_forall,
  [anon_sym_u2200] = anon_sym_u2200,
  [anon_sym_exists] = anon_sym_exists,
  [anon_sym_u2203] = anon_sym_u2203,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_u2208] = anon_sym_u2208,
  [sym_set_op_builder] = sym_set_op_builder,
  [anon_sym_u00b7] = anon_sym_u00b7,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_u2254] = anon_sym_u2254,
  [anon_sym_u2192] = anon_sym_u2192,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_u2190] = anon_sym_u2190,
  [anon_sym_LT_DASH] = anon_sym_LT_DASH,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_u2295] = anon_sym_u2295,
  [anon_sym_u2205] = anon_sym_u2205,
  [sym_line_comment] = sym_line_comment,
  [sym_module] = sym_module,
  [sym__module_locations] = sym__module_locations,
  [sym_module_body] = sym_module_body,
  [sym_import_statement] = sym_import_statement,
  [sym_from_clause] = sym_from_clause,
  [sym_module_path_root_only] = sym_module_path_root_only,
  [sym_module_path_absolute] = sym_module_path_absolute,
  [sym_module_path_relative] = sym_module_path_relative,
  [sym__import] = sym__import,
  [sym__rename_import] = sym__rename_import,
  [sym_member_import] = sym_member_import,
  [sym_module_import] = sym_module_import,
  [sym_qualified_identifier] = sym_qualified_identifier,
  [sym_identifier_reference] = sym_identifier_reference,
  [sym_annotation] = sym_annotation,
  [sym_annotation_property] = sym_annotation_property,
  [sym_constraint] = sym_constraint,
  [sym_annotation_only_body] = sym_annotation_only_body,
  [sym_informal_constraint] = sym_informal_constraint,
  [sym_formal_constraint] = sym_formal_constraint,
  [sym_constraint_sentence] = sym_constraint_sentence,
  [sym_simple_sentence] = sym_simple_sentence,
  [sym_atomic_sentence] = sym_atomic_sentence,
  [sym__actual_arguments] = sym__actual_arguments,
  [sym_equation] = sym_equation,
  [sym_inequation] = sym_inequation,
  [sym_boolean_sentence] = sym_boolean_sentence,
  [sym_unary_boolean_sentence] = sym_unary_boolean_sentence,
  [sym_binary_boolean_sentence] = sym_binary_boolean_sentence,
  [sym__logical_connective] = sym__logical_connective,
  [sym_quantified_sentence] = sym_quantified_sentence,
  [sym_quantified_variable_binding] = sym_quantified_variable_binding,
  [sym_quantified_variable] = sym_quantified_variable,
  [sym_variable] = sym_variable,
  [sym_term] = sym_term,
  [sym_functional_term] = sym_functional_term,
  [sym_function_composition] = sym_function_composition,
  [sym_predicate_value] = sym_predicate_value,
  [sym_sequence_of_predicate_values] = sym_sequence_of_predicate_values,
  [sym_constraint_environment] = sym_constraint_environment,
  [sym_function_def] = sym_function_def,
  [sym_function_signature] = sym_function_signature,
  [sym_function_parameter] = sym_function_parameter,
  [sym__function_type] = sym__function_type,
  [sym_function_type_reference] = sym_function_type_reference,
  [sym_function_body] = sym_function_body,
  [sym_sequence_builder] = sym_sequence_builder,
  [sym_sequence_builder_body] = sym_sequence_builder_body,
  [sym_value] = sym_value,
  [sym_simple_value] = sym_simple_value,
  [sym_string] = sym_string,
  [sym_iri] = sym_iri,
  [sym_binary] = sym_binary,
  [sym_boolean] = sym_boolean,
  [sym_boolean_truth] = sym_boolean_truth,
  [sym_boolean_falsity] = sym_boolean_falsity,
  [sym_value_constructor] = sym_value_constructor,
  [sym_mapping_value] = sym_mapping_value,
  [sym_sequence_of_values] = sym_sequence_of_values,
  [sym__sequence_value_constraints] = sym__sequence_value_constraints,
  [sym_builtin_simple_type] = sym_builtin_simple_type,
  [sym__owl_builtin_types] = sym__owl_builtin_types,
  [sym__builtin_primitive_datatypes] = sym__builtin_primitive_datatypes,
  [sym__derived_date_datetypes] = sym__derived_date_datetypes,
  [sym__derived_numeric_datatypes] = sym__derived_numeric_datatypes,
  [sym__derived_string_datatypes] = sym__derived_string_datatypes,
  [sym_definition] = sym_definition,
  [sym_from_definition_clause] = sym_from_definition_clause,
  [sym_from_definition_with] = sym_from_definition_with,
  [sym_from_definition_without] = sym_from_definition_without,
  [sym__wildcard_or_identifier_or_sequence] = sym__wildcard_or_identifier_or_sequence,
  [sym__identifier_or_sequence] = sym__identifier_or_sequence,
  [sym_data_type_def] = sym_data_type_def,
  [sym__datatype_base] = sym__datatype_base,
  [sym_datatype_def_restriction] = sym_datatype_def_restriction,
  [sym__restriction_facet] = sym__restriction_facet,
  [sym_length_restriction_facet] = sym_length_restriction_facet,
  [sym_digit_restriction_facet] = sym_digit_restriction_facet,
  [sym_value_restriction_facet] = sym_value_restriction_facet,
  [sym_restriction_value] = sym_restriction_value,
  [sym_tz_restriction_facet] = sym_tz_restriction_facet,
  [sym_tz_restriction_value] = sym_tz_restriction_value,
  [sym_pattern_restriction_facet] = sym_pattern_restriction_facet,
  [sym_dimension_def] = sym_dimension_def,
  [sym_dimension_body] = sym_dimension_body,
  [sym_source_entity] = sym_source_entity,
  [sym_dimension_parent] = sym_dimension_parent,
  [sym_entity_def] = sym_entity_def,
  [sym_entity_body] = sym_entity_body,
  [sym_enum_def] = sym_enum_def,
  [sym_enum_body] = sym_enum_body,
  [sym_event_def] = sym_event_def,
  [sym_event_body] = sym_event_body,
  [sym_property_def] = sym_property_def,
  [sym_rdf_def] = sym_rdf_def,
  [sym_rdf_types] = sym_rdf_types,
  [sym_structure_def] = sym_structure_def,
  [sym_structure_body] = sym_structure_body,
  [sym_type_class_def] = sym_type_class_def,
  [sym_type_parameter] = sym_type_parameter,
  [sym_type_parameter_restriction] = sym_type_parameter_restriction,
  [sym_type_restriction_argument] = sym_type_restriction_argument,
  [sym_type_class_body] = sym_type_class_body,
  [sym_method_def] = sym_method_def,
  [sym_union_def] = sym_union_def,
  [sym_union_body] = sym_union_body,
  [sym_entity_identity] = sym_entity_identity,
  [sym_member] = sym_member,
  [sym_member_def] = sym_member_def,
  [sym_property_ref] = sym_property_ref,
  [sym__type_expression_to] = sym__type_expression_to,
  [sym_type_reference] = sym_type_reference,
  [sym_mapping_type] = sym_mapping_type,
  [sym_cardinality_expression] = sym_cardinality_expression,
  [sym_cardinality_reference_expression] = sym_cardinality_reference_expression,
  [sym__cardinality_inner] = sym__cardinality_inner,
  [sym_sequence_ordering] = sym_sequence_ordering,
  [sym_sequence_uniqueness] = sym_sequence_uniqueness,
  [sym_cardinality_range] = sym_cardinality_range,
  [sym_value_variant] = sym_value_variant,
  [sym_type_variant] = sym_type_variant,
  [sym_op_inequality] = sym_op_inequality,
  [sym_op_less_than_or_equal] = sym_op_less_than_or_equal,
  [sym_op_greater_than_or_equal] = sym_op_greater_than_or_equal,
  [sym_logical_op_negation] = sym_logical_op_negation,
  [sym_logical_op_conjunction] = sym_logical_op_conjunction,
  [sym_logical_op_disjunction] = sym_logical_op_disjunction,
  [sym_logical_op_exclusive_disjunction] = sym_logical_op_exclusive_disjunction,
  [sym_logical_op_implication] = sym_logical_op_implication,
  [sym_logical_op_biconditional] = sym_logical_op_biconditional,
  [sym_logical_quantifier_universal] = sym_logical_quantifier_universal,
  [sym_logical_quantifier_existential] = sym_logical_quantifier_existential,
  [sym_set_op_membership] = sym_set_op_membership,
  [sym__function_op_composition] = sym__function_op_composition,
  [sym__function_op_by_definition] = sym__function_op_by_definition,
  [sym__type_op_has_type] = sym__type_op_has_type,
  [sym__type_op_type_restriction] = sym__type_op_type_restriction,
  [sym_type_op_combiner] = sym_type_op_combiner,
  [sym__value_empty_sequence] = sym__value_empty_sequence,
  [aux_sym_module_body_repeat1] = aux_sym_module_body_repeat1,
  [aux_sym_module_body_repeat2] = aux_sym_module_body_repeat2,
  [aux_sym_module_body_repeat3] = aux_sym_module_body_repeat3,
  [aux_sym_import_statement_repeat1] = aux_sym_import_statement_repeat1,
  [aux_sym_module_path_absolute_repeat1] = aux_sym_module_path_absolute_repeat1,
  [aux_sym__actual_arguments_repeat1] = aux_sym__actual_arguments_repeat1,
  [aux_sym_function_composition_repeat1] = aux_sym_function_composition_repeat1,
  [aux_sym_sequence_of_predicate_values_repeat1] = aux_sym_sequence_of_predicate_values_repeat1,
  [aux_sym_constraint_environment_repeat1] = aux_sym_constraint_environment_repeat1,
  [aux_sym_function_signature_repeat1] = aux_sym_function_signature_repeat1,
  [aux_sym_sequence_builder_repeat1] = aux_sym_sequence_builder_repeat1,
  [aux_sym_binary_repeat1] = aux_sym_binary_repeat1,
  [aux_sym_sequence_of_values_repeat1] = aux_sym_sequence_of_values_repeat1,
  [aux_sym__wildcard_or_identifier_or_sequence_repeat1] = aux_sym__wildcard_or_identifier_or_sequence_repeat1,
  [aux_sym_datatype_def_restriction_repeat1] = aux_sym_datatype_def_restriction_repeat1,
  [aux_sym_pattern_restriction_facet_repeat1] = aux_sym_pattern_restriction_facet_repeat1,
  [aux_sym_dimension_body_repeat1] = aux_sym_dimension_body_repeat1,
  [aux_sym_dimension_body_repeat2] = aux_sym_dimension_body_repeat2,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym_rdf_types_repeat1] = aux_sym_rdf_types_repeat1,
  [aux_sym_type_class_def_repeat1] = aux_sym_type_class_def_repeat1,
  [aux_sym_type_parameter_repeat1] = aux_sym_type_parameter_repeat1,
  [aux_sym_type_parameter_restriction_repeat1] = aux_sym_type_parameter_restriction_repeat1,
  [aux_sym_type_class_body_repeat1] = aux_sym_type_class_body_repeat1,
  [aux_sym_union_body_repeat1] = aux_sym_union_body_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_module] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_version] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_end] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_COLON2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assert] = {
    .visible = true,
    .named = false,
  },
  [sym_controlled_language_tag] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [sym_reserved_self] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_with] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_def] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym_quoted_string] = {
    .visible = true,
    .named = true,
  },
  [sym_language_tag] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_iri_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_POUND_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [sym_hex_byte] = {
    .visible = true,
    .named = true,
  },
  [sym_double] = {
    .visible = true,
    .named = true,
  },
  [sym_decimal] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_rational] = {
    .visible = true,
    .named = true,
  },
  [sym_unsigned] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u22a4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u22a5] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Thing] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Nothing] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_real] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rational] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_anyURI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iri] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_base64Binary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_boolean] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_date] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dateTime] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_decimal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_double] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_duration] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_float] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gDay] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gMonth] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gMonthDay] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gYearMonth] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gYear] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hexBinary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_binary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_time] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dateTimeStamp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_dayTimeDuration] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_yearMonthDuration] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_integer] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_long] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_short] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonNegativeInteger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_positiveInteger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsignedLong] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsignedInt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsigned] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsignedShort] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unsignedByte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonPositiveInteger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_negativeInteger] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_normalizedString] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_token] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_language] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_without] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_datatype] = {
    .visible = true,
    .named = false,
  },
  [sym_opaque] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_length] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_maxLength] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_minLength] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fractionDigits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_totalDigits] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_maxExclusive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_maxInclusive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_minExclusive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_minInclusive] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_explicitTimezone] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_required] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_prohibited] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_optional] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pattern] = {
    .visible = true,
    .named = false,
  },
  [sym_kw_is_fixed] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_dimension] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_source] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_parent] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_entity] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_of] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_event] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_property] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_rdf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_a] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_structure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [sym_wildcard] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_union] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_identity] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ref] = {
    .visible = true,
    .named = false,
  },
  [sym_unknown_type] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_ordered] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unordered] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_unique] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nonunique] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2260] = {
    .visible = true,
    .named = false,
  },
  [sym_op_less_than] = {
    .visible = true,
    .named = true,
  },
  [sym_op_greater_than] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2264] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2265] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u00ac] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2227] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2228] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u22bb] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_implies] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u21d2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iff] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u21d4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_forall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2200] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exists] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2203] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2208] = {
    .visible = true,
    .named = false,
  },
  [sym_set_op_builder] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_u00b7] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2254] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2192] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2190] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2295] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_u2205] = {
    .visible = true,
    .named = false,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_module] = {
    .visible = true,
    .named = true,
  },
  [sym__module_locations] = {
    .visible = false,
    .named = true,
  },
  [sym_module_body] = {
    .visible = true,
    .named = true,
  },
  [sym_import_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_from_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_module_path_root_only] = {
    .visible = true,
    .named = true,
  },
  [sym_module_path_absolute] = {
    .visible = true,
    .named = true,
  },
  [sym_module_path_relative] = {
    .visible = true,
    .named = true,
  },
  [sym__import] = {
    .visible = false,
    .named = true,
  },
  [sym__rename_import] = {
    .visible = false,
    .named = true,
  },
  [sym_member_import] = {
    .visible = true,
    .named = true,
  },
  [sym_module_import] = {
    .visible = true,
    .named = true,
  },
  [sym_qualified_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_property] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation_only_body] = {
    .visible = true,
    .named = true,
  },
  [sym_informal_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_formal_constraint] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_atomic_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym__actual_arguments] = {
    .visible = false,
    .named = true,
  },
  [sym_equation] = {
    .visible = true,
    .named = true,
  },
  [sym_inequation] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_boolean_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_boolean_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym__logical_connective] = {
    .visible = false,
    .named = true,
  },
  [sym_quantified_sentence] = {
    .visible = true,
    .named = true,
  },
  [sym_quantified_variable_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_quantified_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_term] = {
    .visible = true,
    .named = true,
  },
  [sym_functional_term] = {
    .visible = true,
    .named = true,
  },
  [sym_function_composition] = {
    .visible = true,
    .named = true,
  },
  [sym_predicate_value] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_of_predicate_values] = {
    .visible = true,
    .named = true,
  },
  [sym_constraint_environment] = {
    .visible = true,
    .named = true,
  },
  [sym_function_def] = {
    .visible = true,
    .named = true,
  },
  [sym_function_signature] = {
    .visible = true,
    .named = true,
  },
  [sym_function_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__function_type] = {
    .visible = false,
    .named = true,
  },
  [sym_function_type_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_builder] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_builder_body] = {
    .visible = true,
    .named = true,
  },
  [sym_value] = {
    .visible = true,
    .named = true,
  },
  [sym_simple_value] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_iri] = {
    .visible = true,
    .named = true,
  },
  [sym_binary] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_truth] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_falsity] = {
    .visible = true,
    .named = true,
  },
  [sym_value_constructor] = {
    .visible = true,
    .named = true,
  },
  [sym_mapping_value] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_of_values] = {
    .visible = true,
    .named = true,
  },
  [sym__sequence_value_constraints] = {
    .visible = false,
    .named = true,
  },
  [sym_builtin_simple_type] = {
    .visible = true,
    .named = true,
  },
  [sym__owl_builtin_types] = {
    .visible = false,
    .named = true,
  },
  [sym__builtin_primitive_datatypes] = {
    .visible = false,
    .named = true,
  },
  [sym__derived_date_datetypes] = {
    .visible = false,
    .named = true,
  },
  [sym__derived_numeric_datatypes] = {
    .visible = false,
    .named = true,
  },
  [sym__derived_string_datatypes] = {
    .visible = false,
    .named = true,
  },
  [sym_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_from_definition_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_from_definition_with] = {
    .visible = true,
    .named = true,
  },
  [sym_from_definition_without] = {
    .visible = true,
    .named = true,
  },
  [sym__wildcard_or_identifier_or_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym__identifier_or_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym_data_type_def] = {
    .visible = true,
    .named = true,
  },
  [sym__datatype_base] = {
    .visible = false,
    .named = true,
  },
  [sym_datatype_def_restriction] = {
    .visible = true,
    .named = true,
  },
  [sym__restriction_facet] = {
    .visible = false,
    .named = true,
  },
  [sym_length_restriction_facet] = {
    .visible = true,
    .named = true,
  },
  [sym_digit_restriction_facet] = {
    .visible = true,
    .named = true,
  },
  [sym_value_restriction_facet] = {
    .visible = true,
    .named = true,
  },
  [sym_restriction_value] = {
    .visible = true,
    .named = true,
  },
  [sym_tz_restriction_facet] = {
    .visible = true,
    .named = true,
  },
  [sym_tz_restriction_value] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_restriction_facet] = {
    .visible = true,
    .named = true,
  },
  [sym_dimension_def] = {
    .visible = true,
    .named = true,
  },
  [sym_dimension_body] = {
    .visible = true,
    .named = true,
  },
  [sym_source_entity] = {
    .visible = true,
    .named = true,
  },
  [sym_dimension_parent] = {
    .visible = true,
    .named = true,
  },
  [sym_entity_def] = {
    .visible = true,
    .named = true,
  },
  [sym_entity_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_def] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_event_def] = {
    .visible = true,
    .named = true,
  },
  [sym_event_body] = {
    .visible = true,
    .named = true,
  },
  [sym_property_def] = {
    .visible = true,
    .named = true,
  },
  [sym_rdf_def] = {
    .visible = true,
    .named = true,
  },
  [sym_rdf_types] = {
    .visible = true,
    .named = true,
  },
  [sym_structure_def] = {
    .visible = true,
    .named = true,
  },
  [sym_structure_body] = {
    .visible = true,
    .named = true,
  },
  [sym_type_class_def] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_restriction] = {
    .visible = true,
    .named = true,
  },
  [sym_type_restriction_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_type_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym_method_def] = {
    .visible = true,
    .named = true,
  },
  [sym_union_def] = {
    .visible = true,
    .named = true,
  },
  [sym_union_body] = {
    .visible = true,
    .named = true,
  },
  [sym_entity_identity] = {
    .visible = true,
    .named = true,
  },
  [sym_member] = {
    .visible = true,
    .named = true,
  },
  [sym_member_def] = {
    .visible = true,
    .named = true,
  },
  [sym_property_ref] = {
    .visible = true,
    .named = true,
  },
  [sym__type_expression_to] = {
    .visible = false,
    .named = true,
  },
  [sym_type_reference] = {
    .visible = true,
    .named = true,
  },
  [sym_mapping_type] = {
    .visible = true,
    .named = true,
  },
  [sym_cardinality_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_cardinality_reference_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__cardinality_inner] = {
    .visible = false,
    .named = true,
  },
  [sym_sequence_ordering] = {
    .visible = true,
    .named = true,
  },
  [sym_sequence_uniqueness] = {
    .visible = true,
    .named = true,
  },
  [sym_cardinality_range] = {
    .visible = true,
    .named = true,
  },
  [sym_value_variant] = {
    .visible = true,
    .named = true,
  },
  [sym_type_variant] = {
    .visible = true,
    .named = true,
  },
  [sym_op_inequality] = {
    .visible = true,
    .named = true,
  },
  [sym_op_less_than_or_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_op_greater_than_or_equal] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_op_negation] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_op_conjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_op_disjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_op_exclusive_disjunction] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_op_implication] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_op_biconditional] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_quantifier_universal] = {
    .visible = true,
    .named = true,
  },
  [sym_logical_quantifier_existential] = {
    .visible = true,
    .named = true,
  },
  [sym_set_op_membership] = {
    .visible = true,
    .named = true,
  },
  [sym__function_op_composition] = {
    .visible = false,
    .named = true,
  },
  [sym__function_op_by_definition] = {
    .visible = false,
    .named = true,
  },
  [sym__type_op_has_type] = {
    .visible = false,
    .named = true,
  },
  [sym__type_op_type_restriction] = {
    .visible = false,
    .named = true,
  },
  [sym_type_op_combiner] = {
    .visible = true,
    .named = true,
  },
  [sym__value_empty_sequence] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_module_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_body_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_body_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_import_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_module_path_absolute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__actual_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_composition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sequence_of_predicate_values_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constraint_environment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_signature_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sequence_builder_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_binary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_sequence_of_values_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__wildcard_or_identifier_or_sequence_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_datatype_def_restriction_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_restriction_facet_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimension_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dimension_body_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_rdf_types_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_class_def_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_restriction_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_union_body_repeat1] = {
    .visible = false,
    .named = false,
  },
};

enum ts_field_identifiers {
  field_argument = 1,
  field_base = 2,
  field_binding = 3,
  field_body = 4,
  field_byte = 5,
  field_cardinality = 6,
  field_class = 7,
  field_domain = 8,
  field_element = 9,
  field_empty = 10,
  field_entity = 11,
  field_environment = 12,
  field_facet = 13,
  field_from = 14,
  field_function = 15,
  field_identity = 16,
  field_is_fixed = 17,
  field_language = 18,
  field_lhs = 19,
  field_max = 20,
  field_member = 21,
  field_method = 22,
  field_min = 23,
  field_module = 24,
  field_name = 25,
  field_opaque = 26,
  field_operator = 27,
  field_ordering = 28,
  field_parameter = 29,
  field_parent = 30,
  field_predicate = 31,
  field_property = 32,
  field_quantifier = 33,
  field_range = 34,
  field_relation = 35,
  field_rename = 36,
  field_restriction = 37,
  field_rhs = 38,
  field_segment = 39,
  field_signature = 40,
  field_source = 41,
  field_subject = 42,
  field_target = 43,
  field_type = 44,
  field_types = 45,
  field_uniqueness = 46,
  field_value = 47,
  field_variable = 48,
  field_version_info = 49,
  field_version_uri = 50,
  field_wildcard = 51,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_argument] = "argument",
  [field_base] = "base",
  [field_binding] = "binding",
  [field_body] = "body",
  [field_byte] = "byte",
  [field_cardinality] = "cardinality",
  [field_class] = "class",
  [field_domain] = "domain",
  [field_element] = "element",
  [field_empty] = "empty",
  [field_entity] = "entity",
  [field_environment] = "environment",
  [field_facet] = "facet",
  [field_from] = "from",
  [field_function] = "function",
  [field_identity] = "identity",
  [field_is_fixed] = "is_fixed",
  [field_language] = "language",
  [field_lhs] = "lhs",
  [field_max] = "max",
  [field_member] = "member",
  [field_method] = "method",
  [field_min] = "min",
  [field_module] = "module",
  [field_name] = "name",
  [field_opaque] = "opaque",
  [field_operator] = "operator",
  [field_ordering] = "ordering",
  [field_parameter] = "parameter",
  [field_parent] = "parent",
  [field_predicate] = "predicate",
  [field_property] = "property",
  [field_quantifier] = "quantifier",
  [field_range] = "range",
  [field_relation] = "relation",
  [field_rename] = "rename",
  [field_restriction] = "restriction",
  [field_rhs] = "rhs",
  [field_segment] = "segment",
  [field_signature] = "signature",
  [field_source] = "source",
  [field_subject] = "subject",
  [field_target] = "target",
  [field_type] = "type",
  [field_types] = "types",
  [field_uniqueness] = "uniqueness",
  [field_value] = "value",
  [field_variable] = "variable",
  [field_version_info] = "version_info",
  [field_version_uri] = "version_uri",
  [field_wildcard] = "wildcard",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 2},
  [2] = {.index = 2, .length = 1},
  [3] = {.index = 3, .length = 5},
  [4] = {.index = 8, .length = 1},
  [5] = {.index = 9, .length = 1},
  [6] = {.index = 10, .length = 1},
  [7] = {.index = 11, .length = 1},
  [8] = {.index = 12, .length = 2},
  [9] = {.index = 14, .length = 2},
  [10] = {.index = 16, .length = 2},
  [11] = {.index = 18, .length = 1},
  [12] = {.index = 19, .length = 2},
  [13] = {.index = 21, .length = 2},
  [14] = {.index = 23, .length = 3},
  [15] = {.index = 26, .length = 2},
  [16] = {.index = 28, .length = 3},
  [17] = {.index = 31, .length = 1},
  [18] = {.index = 32, .length = 2},
  [19] = {.index = 34, .length = 3},
  [20] = {.index = 37, .length = 2},
  [21] = {.index = 39, .length = 2},
  [22] = {.index = 41, .length = 2},
  [23] = {.index = 43, .length = 1},
  [24] = {.index = 44, .length = 1},
  [25] = {.index = 45, .length = 2},
  [26] = {.index = 47, .length = 3},
  [27] = {.index = 50, .length = 4},
  [28] = {.index = 54, .length = 1},
  [29] = {.index = 55, .length = 1},
  [30] = {.index = 56, .length = 3},
  [31] = {.index = 59, .length = 1},
  [32] = {.index = 60, .length = 1},
  [33] = {.index = 61, .length = 1},
  [34] = {.index = 62, .length = 1},
  [35] = {.index = 63, .length = 1},
  [36] = {.index = 64, .length = 1},
  [37] = {.index = 65, .length = 3},
  [38] = {.index = 68, .length = 2},
  [39] = {.index = 70, .length = 1},
  [40] = {.index = 71, .length = 1},
  [41] = {.index = 72, .length = 2},
  [42] = {.index = 74, .length = 2},
  [43] = {.index = 76, .length = 2},
  [44] = {.index = 78, .length = 2},
  [45] = {.index = 80, .length = 2},
  [46] = {.index = 82, .length = 2},
  [47] = {.index = 84, .length = 3},
  [48] = {.index = 87, .length = 3},
  [49] = {.index = 90, .length = 3},
  [50] = {.index = 93, .length = 1},
  [51] = {.index = 94, .length = 1},
  [52] = {.index = 95, .length = 1},
  [53] = {.index = 96, .length = 2},
  [54] = {.index = 98, .length = 1},
  [55] = {.index = 99, .length = 2},
  [56] = {.index = 101, .length = 1},
  [57] = {.index = 102, .length = 1},
  [58] = {.index = 103, .length = 1},
  [59] = {.index = 104, .length = 2},
  [60] = {.index = 106, .length = 2},
  [61] = {.index = 108, .length = 2},
  [62] = {.index = 110, .length = 1},
  [63] = {.index = 111, .length = 2},
  [64] = {.index = 113, .length = 1},
  [65] = {.index = 114, .length = 1},
  [66] = {.index = 115, .length = 1},
  [67] = {.index = 116, .length = 2},
  [68] = {.index = 118, .length = 2},
  [69] = {.index = 120, .length = 2},
  [70] = {.index = 122, .length = 2},
  [71] = {.index = 124, .length = 2},
  [72] = {.index = 126, .length = 3},
  [73] = {.index = 129, .length = 2},
  [74] = {.index = 131, .length = 2},
  [75] = {.index = 133, .length = 1},
  [76] = {.index = 134, .length = 3},
  [77] = {.index = 137, .length = 3},
  [78] = {.index = 140, .length = 2},
  [79] = {.index = 142, .length = 4},
  [80] = {.index = 146, .length = 4},
  [81] = {.index = 150, .length = 4},
  [82] = {.index = 154, .length = 1},
  [83] = {.index = 155, .length = 1},
  [84] = {.index = 156, .length = 1},
  [85] = {.index = 157, .length = 2},
  [86] = {.index = 159, .length = 1},
  [87] = {.index = 160, .length = 2},
  [88] = {.index = 162, .length = 2},
  [89] = {.index = 164, .length = 1},
  [90] = {.index = 165, .length = 2},
  [91] = {.index = 167, .length = 1},
  [92] = {.index = 168, .length = 1},
  [93] = {.index = 169, .length = 3},
  [94] = {.index = 172, .length = 3},
  [95] = {.index = 175, .length = 2},
  [96] = {.index = 177, .length = 2},
  [97] = {.index = 179, .length = 2},
  [98] = {.index = 181, .length = 3},
  [99] = {.index = 184, .length = 2},
  [100] = {.index = 186, .length = 1},
  [101] = {.index = 187, .length = 2},
  [102] = {.index = 189, .length = 2},
  [103] = {.index = 191, .length = 5},
  [104] = {.index = 196, .length = 2},
  [105] = {.index = 198, .length = 1},
  [106] = {.index = 199, .length = 3},
  [107] = {.index = 202, .length = 3},
  [108] = {.index = 205, .length = 2},
  [109] = {.index = 207, .length = 4},
  [110] = {.index = 211, .length = 3},
  [111] = {.index = 214, .length = 2},
  [112] = {.index = 216, .length = 2},
  [113] = {.index = 218, .length = 1},
  [114] = {.index = 219, .length = 2},
  [115] = {.index = 221, .length = 2},
  [116] = {.index = 223, .length = 2},
  [117] = {.index = 225, .length = 4},
  [118] = {.index = 229, .length = 4},
  [119] = {.index = 233, .length = 3},
  [120] = {.index = 236, .length = 2},
  [121] = {.index = 238, .length = 3},
  [122] = {.index = 241, .length = 2},
  [123] = {.index = 243, .length = 3},
  [124] = {.index = 246, .length = 3},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_body, 2},
    {field_name, 1},
  [2] =
    {field_base, 0},
  [3] =
    {field_base, 2, .inherited = true},
    {field_body, 3},
    {field_name, 1},
    {field_version_info, 2, .inherited = true},
    {field_version_uri, 2, .inherited = true},
  [8] =
    {field_name, 0},
  [9] =
    {field_segment, 0},
  [10] =
    {field_name, 1},
  [11] =
    {field_member, 1},
  [12] =
    {field_base, 0},
    {field_version_uri, 2},
  [14] =
    {field_name, 0},
    {field_rename, 1, .inherited = true},
  [16] =
    {field_name, 0},
    {field_version_uri, 1},
  [18] =
    {field_segment, 1},
  [19] =
    {field_segment, 0},
    {field_segment, 1, .inherited = true},
  [21] =
    {field_from, 2},
    {field_name, 1},
  [23] =
    {field_cardinality, 1, .inherited = true},
    {field_name, 0},
    {field_target, 1, .inherited = true},
  [26] =
    {field_name, 1},
    {field_types, 2},
  [28] =
    {field_base, 0},
    {field_version_info, 2},
    {field_version_uri, 3},
  [31] =
    {field_rename, 1},
  [32] =
    {field_member, 2},
    {field_module, 0},
  [34] =
    {field_name, 0},
    {field_rename, 2, .inherited = true},
    {field_version_uri, 1},
  [37] =
    {field_segment, 1},
    {field_segment, 2, .inherited = true},
  [39] =
    {field_segment, 0, .inherited = true},
    {field_segment, 1, .inherited = true},
  [41] =
    {field_name, 1},
    {field_value, 3},
  [43] =
    {field_empty, 0},
  [44] =
    {field_value, 1},
  [45] =
    {field_base, 3},
    {field_name, 1},
  [47] =
    {field_body, 3},
    {field_from, 2},
    {field_name, 1},
  [50] =
    {field_body, 2},
    {field_cardinality, 1, .inherited = true},
    {field_name, 0},
    {field_target, 1, .inherited = true},
  [54] =
    {field_target, 1},
  [55] =
    {field_type, 1},
  [56] =
    {field_body, 3},
    {field_name, 1},
    {field_types, 2},
  [59] =
    {field_signature, 0},
  [60] =
    {field_method, 0},
  [61] =
    {field_parameter, 0},
  [62] =
    {field_element, 0},
  [63] =
    {field_language, 1},
  [64] =
    {field_byte, 0},
  [65] =
    {field_empty, 1},
    {field_ordering, 0, .inherited = true},
    {field_uniqueness, 0, .inherited = true},
  [68] =
    {field_name, 1, .inherited = true},
    {field_subject, 0},
  [70] =
    {field_variable, 0},
  [71] =
    {field_body, 1},
  [72] =
    {field_argument, 1, .inherited = true},
    {field_predicate, 0},
  [74] =
    {field_argument, 1, .inherited = true},
    {field_function, 0},
  [76] =
    {field_operator, 0},
    {field_rhs, 1},
  [78] =
    {field_binding, 1},
    {field_quantifier, 0},
  [80] =
    {field_language, 2},
    {field_value, 1},
  [82] =
    {field_body, 1},
    {field_signature, 0},
  [84] =
    {field_base, 4},
    {field_name, 1},
    {field_opaque, 3},
  [87] =
    {field_base, 3},
    {field_body, 4},
    {field_name, 1},
  [90] =
    {field_base, 3},
    {field_name, 1},
    {field_restriction, 4},
  [93] =
    {field_entity, 1},
  [94] =
    {field_identity, 1},
  [95] =
    {field_from, 1},
  [96] =
    {field_body, 1},
    {field_name, 0},
  [98] =
    {field_min, 0},
  [99] =
    {field_cardinality, 1},
    {field_target, 2},
  [101] =
    {field_type, 0},
  [102] =
    {field_property, 1},
  [103] =
    {field_method, 1, .inherited = true},
  [104] =
    {field_method, 0, .inherited = true},
    {field_method, 1, .inherited = true},
  [106] =
    {field_name, 1},
    {field_parameter, 3, .inherited = true},
  [108] =
    {field_parameter, 0, .inherited = true},
    {field_parameter, 1, .inherited = true},
  [110] =
    {field_element, 1, .inherited = true},
  [111] =
    {field_element, 0, .inherited = true},
    {field_element, 1, .inherited = true},
  [113] =
    {field_ordering, 1},
  [114] =
    {field_uniqueness, 1},
  [115] =
    {field_byte, 1, .inherited = true},
  [116] =
    {field_byte, 0, .inherited = true},
    {field_byte, 1, .inherited = true},
  [118] =
    {field_domain, 0},
    {field_range, 2},
  [120] =
    {field_ordering, 0, .inherited = true},
    {field_uniqueness, 0, .inherited = true},
  [122] =
    {field_name, 0, .inherited = true},
    {field_name, 1, .inherited = true},
  [124] =
    {field_variable, 0, .inherited = true},
    {field_variable, 1, .inherited = true},
  [126] =
    {field_lhs, 0},
    {field_operator, 1},
    {field_rhs, 2},
  [129] =
    {field_binding, 0},
    {field_body, 2},
  [131] =
    {field_lhs, 0},
    {field_rhs, 2},
  [133] =
    {field_argument, 0},
  [134] =
    {field_lhs, 0},
    {field_relation, 1},
    {field_rhs, 2},
  [137] =
    {field_cardinality, 2, .inherited = true},
    {field_name, 1},
    {field_target, 2, .inherited = true},
  [140] =
    {field_body, 2},
    {field_environment, 0},
  [142] =
    {field_base, 4},
    {field_body, 5},
    {field_name, 1},
    {field_opaque, 3},
  [146] =
    {field_base, 4},
    {field_name, 1},
    {field_opaque, 3},
    {field_restriction, 5},
  [150] =
    {field_base, 3},
    {field_body, 5},
    {field_name, 1},
    {field_restriction, 4},
  [154] =
    {field_identity, 2},
  [155] =
    {field_member, 0},
  [156] =
    {field_wildcard, 0},
  [157] =
    {field_member, 1, .inherited = true},
    {field_wildcard, 1, .inherited = true},
  [159] =
    {field_member, 1, .inherited = true},
  [160] =
    {field_min, 0},
    {field_range, 1},
  [162] =
    {field_min, 1, .inherited = true},
    {field_range, 1, .inherited = true},
  [164] =
    {field_type, 2, .inherited = true},
  [165] =
    {field_type, 0, .inherited = true},
    {field_type, 1, .inherited = true},
  [167] =
    {field_method, 2, .inherited = true},
  [168] =
    {field_class, 0},
  [169] =
    {field_from, 5},
    {field_name, 1},
    {field_parameter, 3, .inherited = true},
  [172] =
    {field_body, 5},
    {field_name, 1},
    {field_parameter, 3, .inherited = true},
  [175] =
    {field_name, 0},
    {field_rename, 2},
  [177] =
    {field_ordering, 1},
    {field_uniqueness, 2},
  [179] =
    {field_name, 0},
    {field_value, 2},
  [181] =
    {field_element, 2, .inherited = true},
    {field_ordering, 0, .inherited = true},
    {field_uniqueness, 0, .inherited = true},
  [184] =
    {field_name, 0},
    {field_range, 2},
  [186] =
    {field_argument, 1, .inherited = true},
  [187] =
    {field_argument, 0, .inherited = true},
    {field_argument, 1, .inherited = true},
  [189] =
    {field_source, 2},
    {field_variable, 0},
  [191] =
    {field_base, 4},
    {field_body, 6},
    {field_name, 1},
    {field_opaque, 3},
    {field_restriction, 5},
  [196] =
    {field_entity, 1},
    {field_member, 3, .inherited = true},
  [198] =
    {field_max, 1},
  [199] =
    {field_min, 2, .inherited = true},
    {field_ordering, 1},
    {field_range, 2, .inherited = true},
  [202] =
    {field_min, 2, .inherited = true},
    {field_range, 2, .inherited = true},
    {field_uniqueness, 1},
  [205] =
    {field_cardinality, 0},
    {field_class, 1},
  [207] =
    {field_body, 6},
    {field_from, 5},
    {field_name, 1},
    {field_parameter, 3, .inherited = true},
  [211] =
    {field_body, 3},
    {field_name, 0},
    {field_rename, 2},
  [214] =
    {field_body, 3},
    {field_variable, 1, .inherited = true},
  [216] =
    {field_facet, 0},
    {field_value, 2},
  [218] =
    {field_value, 2},
  [219] =
    {field_name, 1},
    {field_parent, 3},
  [221] =
    {field_member, 0, .inherited = true},
    {field_member, 1, .inherited = true},
  [223] =
    {field_domain, 1},
    {field_range, 3},
  [225] =
    {field_min, 3, .inherited = true},
    {field_ordering, 1},
    {field_range, 3, .inherited = true},
    {field_uniqueness, 2},
  [229] =
    {field_cardinality, 5, .inherited = true},
    {field_name, 1},
    {field_parameter, 3, .inherited = true},
    {field_target, 5, .inherited = true},
  [233] =
    {field_facet, 0},
    {field_is_fixed, 2},
    {field_value, 3},
  [236] =
    {field_is_fixed, 2},
    {field_value, 3},
  [238] =
    {field_body, 4},
    {field_name, 1},
    {field_parent, 3},
  [241] =
    {field_argument, 2, .inherited = true},
    {field_class, 0},
  [243] =
    {field_value, 2},
    {field_value, 3},
    {field_value, 4},
  [246] =
    {field_argument, 3, .inherited = true},
    {field_cardinality, 0},
    {field_class, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 12,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 20,
  [21] = 21,
  [22] = 22,
  [23] = 23,
  [24] = 19,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 23,
  [29] = 27,
  [30] = 20,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 47,
  [50] = 46,
  [51] = 51,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 67,
  [72] = 70,
  [73] = 69,
  [74] = 65,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 80,
  [81] = 79,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 5,
  [102] = 2,
  [103] = 103,
  [104] = 96,
  [105] = 105,
  [106] = 96,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 66,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 3,
  [120] = 75,
  [121] = 76,
  [122] = 4,
  [123] = 77,
  [124] = 78,
  [125] = 8,
  [126] = 126,
  [127] = 9,
  [128] = 128,
  [129] = 7,
  [130] = 14,
  [131] = 12,
  [132] = 10,
  [133] = 13,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 137,
  [138] = 82,
  [139] = 139,
  [140] = 134,
  [141] = 141,
  [142] = 141,
  [143] = 136,
  [144] = 144,
  [145] = 95,
  [146] = 89,
  [147] = 86,
  [148] = 87,
  [149] = 149,
  [150] = 85,
  [151] = 91,
  [152] = 135,
  [153] = 153,
  [154] = 94,
  [155] = 155,
  [156] = 88,
  [157] = 157,
  [158] = 155,
  [159] = 90,
  [160] = 92,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 45,
  [168] = 168,
  [169] = 169,
  [170] = 93,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 182,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 225,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 327,
  [329] = 325,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 45,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 153,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 199,
  [430] = 183,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 436,
  [437] = 437,
  [438] = 419,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 463,
  [464] = 464,
  [465] = 452,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 469,
  [470] = 467,
  [471] = 471,
  [472] = 472,
  [473] = 473,
  [474] = 474,
  [475] = 469,
  [476] = 476,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 480,
  [481] = 474,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 518,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 522,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 523,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 562,
  [563] = 563,
  [564] = 553,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 572,
  [573] = 573,
  [574] = 555,
  [575] = 535,
  [576] = 547,
  [577] = 577,
  [578] = 545,
  [579] = 579,
  [580] = 580,
  [581] = 581,
  [582] = 582,
  [583] = 583,
};

static TSCharacterRange sym_identifier_character_set_1[] = {
  {'A', 'Z'}, {'a', 'z'}, {0xb5, 0xb5}, {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x1ba}, {0x1bc, 0x1bf}, {0x1c4, 0x1c4},
  {0x1c6, 0x1c7}, {0x1c9, 0x1ca}, {0x1cc, 0x1f1}, {0x1f3, 0x293}, {0x295, 0x2af}, {0x370, 0x373}, {0x376, 0x377}, {0x37b, 0x37d},
  {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5}, {0x3f7, 0x481}, {0x48a, 0x52f},
  {0x531, 0x556}, {0x560, 0x588}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7}, {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fd, 0x10ff}, {0x13a0, 0x13f5},
  {0x13f8, 0x13fd}, {0x1c80, 0x1c88}, {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1d00, 0x1d2b}, {0x1d6b, 0x1d77}, {0x1d79, 0x1d9a}, {0x1e00, 0x1f15},
  {0x1f18, 0x1f1d}, {0x1f20, 0x1f45}, {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d},
  {0x1f80, 0x1f87}, {0x1f90, 0x1f97}, {0x1fa0, 0x1fa7}, {0x1fb0, 0x1fb4}, {0x1fb6, 0x1fbb}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcb},
  {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb}, {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffb}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113},
  {0x2115, 0x2115}, {0x2119, 0x211d}, {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x212d}, {0x212f, 0x2134}, {0x2139, 0x2139},
  {0x213c, 0x213f}, {0x2145, 0x2149}, {0x214e, 0x214e}, {0x2183, 0x2184}, {0x2c00, 0x2c7b}, {0x2c7e, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3},
  {0x2d00, 0x2d25}, {0x2d27, 0x2d27}, {0x2d2d, 0x2d2d}, {0xa640, 0xa66d}, {0xa680, 0xa69b}, {0xa722, 0xa76f}, {0xa771, 0xa787}, {0xa78b, 0xa78e},
  {0xa790, 0xa7ca}, {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f5, 0xa7f6}, {0xa7fa, 0xa7fa}, {0xab30, 0xab5a}, {0xab60, 0xab68},
  {0xab70, 0xabbf}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0x10400, 0x1044f}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb},
  {0x10570, 0x1057a}, {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
};

static TSCharacterRange sym_identifier_character_set_2[] = {
  {'0', '9'}, {'A', 'Z'}, {'_', '_'}, {'a', 'z'}, {0xb5, 0xb5}, {0xc0, 0xd6}, {0xd8, 0xf6}, {0xf8, 0x1ba},
  {0x1bc, 0x1bf}, {0x1c4, 0x1c4}, {0x1c6, 0x1c7}, {0x1c9, 0x1ca}, {0x1cc, 0x1f1}, {0x1f3, 0x293}, {0x295, 0x2af}, {0x370, 0x373},
  {0x376, 0x377}, {0x37b, 0x37d}, {0x37f, 0x37f}, {0x386, 0x386}, {0x388, 0x38a}, {0x38c, 0x38c}, {0x38e, 0x3a1}, {0x3a3, 0x3f5},
  {0x3f7, 0x481}, {0x48a, 0x52f}, {0x531, 0x556}, {0x560, 0x588}, {0x660, 0x669}, {0x6f0, 0x6f9}, {0x7c0, 0x7c9}, {0x966, 0x96f},
  {0x9e6, 0x9ef}, {0xa66, 0xa6f}, {0xae6, 0xaef}, {0xb66, 0xb6f}, {0xbe6, 0xbef}, {0xc66, 0xc6f}, {0xce6, 0xcef}, {0xd66, 0xd6f},
  {0xde6, 0xdef}, {0xe50, 0xe59}, {0xed0, 0xed9}, {0xf20, 0xf29}, {0x1040, 0x1049}, {0x1090, 0x1099}, {0x10a0, 0x10c5}, {0x10c7, 0x10c7},
  {0x10cd, 0x10cd}, {0x10d0, 0x10fa}, {0x10fd, 0x10ff}, {0x13a0, 0x13f5}, {0x13f8, 0x13fd}, {0x17e0, 0x17e9}, {0x1810, 0x1819}, {0x1946, 0x194f},
  {0x19d0, 0x19d9}, {0x1a80, 0x1a89}, {0x1a90, 0x1a99}, {0x1b50, 0x1b59}, {0x1bb0, 0x1bb9}, {0x1c40, 0x1c49}, {0x1c50, 0x1c59}, {0x1c80, 0x1c88},
  {0x1c90, 0x1cba}, {0x1cbd, 0x1cbf}, {0x1d00, 0x1d2b}, {0x1d6b, 0x1d77}, {0x1d79, 0x1d9a}, {0x1e00, 0x1f15}, {0x1f18, 0x1f1d}, {0x1f20, 0x1f45},
  {0x1f48, 0x1f4d}, {0x1f50, 0x1f57}, {0x1f59, 0x1f59}, {0x1f5b, 0x1f5b}, {0x1f5d, 0x1f5d}, {0x1f5f, 0x1f7d}, {0x1f80, 0x1f87}, {0x1f90, 0x1f97},
  {0x1fa0, 0x1fa7}, {0x1fb0, 0x1fb4}, {0x1fb6, 0x1fbb}, {0x1fbe, 0x1fbe}, {0x1fc2, 0x1fc4}, {0x1fc6, 0x1fcb}, {0x1fd0, 0x1fd3}, {0x1fd6, 0x1fdb},
  {0x1fe0, 0x1fec}, {0x1ff2, 0x1ff4}, {0x1ff6, 0x1ffb}, {0x2102, 0x2102}, {0x2107, 0x2107}, {0x210a, 0x2113}, {0x2115, 0x2115}, {0x2119, 0x211d},
  {0x2124, 0x2124}, {0x2126, 0x2126}, {0x2128, 0x2128}, {0x212a, 0x212d}, {0x212f, 0x2134}, {0x2139, 0x2139}, {0x213c, 0x213f}, {0x2145, 0x2149},
  {0x214e, 0x214e}, {0x2183, 0x2184}, {0x2c00, 0x2c7b}, {0x2c7e, 0x2ce4}, {0x2ceb, 0x2cee}, {0x2cf2, 0x2cf3}, {0x2d00, 0x2d25}, {0x2d27, 0x2d27},
  {0x2d2d, 0x2d2d}, {0xa620, 0xa629}, {0xa640, 0xa66d}, {0xa680, 0xa69b}, {0xa722, 0xa76f}, {0xa771, 0xa787}, {0xa78b, 0xa78e}, {0xa790, 0xa7ca},
  {0xa7d0, 0xa7d1}, {0xa7d3, 0xa7d3}, {0xa7d5, 0xa7d9}, {0xa7f5, 0xa7f6}, {0xa7fa, 0xa7fa}, {0xa8d0, 0xa8d9}, {0xa900, 0xa909}, {0xa9d0, 0xa9d9},
  {0xa9f0, 0xa9f9}, {0xaa50, 0xaa59}, {0xab30, 0xab5a}, {0xab60, 0xab68}, {0xab70, 0xabbf}, {0xabf0, 0xabf9}, {0xfb00, 0xfb06}, {0xfb13, 0xfb17},
  {0xff10, 0xff19}, {0xff21, 0xff3a}, {0xff41, 0xff5a}, {0x10400, 0x1044f}, {0x104a0, 0x104a9}, {0x104b0, 0x104d3}, {0x104d8, 0x104fb}, {0x10570, 0x1057a},
  {0x1057c, 0x1058a}, {0x1058c, 0x10592}, {0x10594, 0x10595}, {0x10597, 0x105a1}, {0x105a3, 0x105b1}, {0x105b3, 0x105b9}, {0x105bb, 0x105bc},
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(71);
      ADVANCE_MAP(
        '"', 5,
        '#', 29,
        '(', 96,
        ')', 97,
        '+', 171,
        ',', 98,
        '-', 14,
        '.', 164,
        '/', 23,
        '0', 132,
        ':', 79,
        ';', 183,
        '<', 143,
        '=', 84,
        '>', 145,
        '@', 82,
        '[', 72,
        '\\', 16,
        ']', 73,
        '_', 139,
        '{', 99,
        '|', 161,
        '}', 100,
        0xac, 150,
        0xb7, 162,
        0x2190, 169,
        0x2192, 167,
        0x21d2, 155,
        0x21d4, 157,
        0x2200, 158,
        0x2203, 159,
        0x2205, 173,
        0x2208, 160,
        0x2227, 151,
        0x2228, 152,
        0x2254, 166,
        0x2260, 142,
        0x2264, 147,
        0x2265, 149,
        0x2295, 172,
        0x22a4, 137,
        0x22a5, 138,
        0x22bb, 153,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(70);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(131);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(76);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(77);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '"', 5,
        '#', 29,
        '(', 96,
        ')', 97,
        '+', 15,
        '-', 14,
        '.', 163,
        '0', 129,
        ':', 78,
        ';', 183,
        '<', 117,
        '>', 121,
        '@', 81,
        '[', 72,
        '\\', 16,
        ']', 73,
        '{', 99,
        '}', 100,
        0xac, 150,
        0xb7, 162,
        0x2192, 167,
        0x2200, 158,
        0x2203, 159,
        0x2205, 173,
        0x22a4, 137,
        0x22a5, 138,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(130);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(77);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '"', 5,
        '#', 29,
        '(', 96,
        ')', 97,
        '+', 15,
        '-', 14,
        '0', 129,
        ':', 19,
        ';', 183,
        '<', 117,
        '@', 66,
        '[', 72,
        '\\', 16,
        ']', 73,
        '{', 99,
        0x2192, 167,
        0x2205, 173,
        0x22a4, 137,
        0x22a5, 138,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(130);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(77);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '"', 5,
        '#', 29,
        '(', 96,
        ')', 97,
        '+', 15,
        '-', 14,
        '0', 129,
        ';', 183,
        '<', 117,
        '@', 81,
        '[', 72,
        '\\', 16,
        ']', 73,
        '{', 99,
        '}', 100,
        0xac, 150,
        0x2192, 167,
        0x2200, 158,
        0x2203, 159,
        0x2205, 173,
        0x22a4, 137,
        0x22a5, 138,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(130);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(77);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '"', 5,
        '#', 29,
        '(', 96,
        ')', 97,
        '+', 15,
        '-', 14,
        '0', 129,
        ';', 183,
        '<', 117,
        '[', 72,
        '\\', 16,
        ']', 73,
        '{', 99,
        0x2192, 167,
        0x2205, 173,
        0x22a4, 137,
        0x22a5, 138,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(130);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(77);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(101);
      if (lookahead == '\\') ADVANCE(31);
      if (lookahead > 0x08 &&
          (lookahead < 0x0b || 0x1f < lookahead) &&
          lookahead != 0x7f) ADVANCE(5);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '(', 96,
        ')', 97,
        '+', 171,
        ',', 98,
        '-', 25,
        '.', 163,
        '/', 23,
        '0', 135,
        ':', 80,
        ';', 183,
        '<', 144,
        '=', 84,
        '>', 145,
        '@', 81,
        '[', 72,
        ']', 73,
        '_', 139,
        '{', 99,
        '|', 161,
        '}', 100,
        0xb7, 162,
        0x2192, 167,
        0x21d2, 155,
        0x21d4, 157,
        0x2200, 158,
        0x2203, 159,
        0x2208, 160,
        0x2227, 151,
        0x2228, 152,
        0x2254, 166,
        0x2260, 142,
        0x2264, 147,
        0x2265, 149,
        0x2295, 172,
        0x22bb, 153,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(136);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(77);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '(', 96,
        ')', 97,
        '+', 171,
        ',', 98,
        '-', 25,
        '/', 23,
        '0', 135,
        ':', 24,
        ';', 183,
        '<', 144,
        '=', 84,
        '>', 145,
        '@', 81,
        '[', 72,
        ']', 73,
        '_', 139,
        '{', 99,
        '|', 161,
        '}', 100,
        0x2192, 167,
        0x21d2, 155,
        0x21d4, 157,
        0x2200, 158,
        0x2203, 159,
        0x2208, 160,
        0x2227, 151,
        0x2228, 152,
        0x2254, 166,
        0x2260, 142,
        0x2264, 147,
        0x2265, 149,
        0x2295, 172,
        0x22bb, 153,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(136);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(77);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '(', 96,
        ')', 97,
        ',', 98,
        '-', 25,
        '.', 13,
        '/', 23,
        ':', 20,
        ';', 183,
        '<', 144,
        '=', 84,
        '>', 145,
        '@', 81,
        '}', 100,
        0x2192, 167,
        0x21d2, 155,
        0x21d4, 157,
        0x2227, 151,
        0x2228, 152,
        0x2260, 142,
        0x2264, 147,
        0x2265, 149,
        0x22bb, 153,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(77);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '(', 96,
        ')', 97,
        ',', 98,
        '-', 25,
        '.', 13,
        '/', 23,
        ':', 20,
        ';', 183,
        '<', 144,
        '=', 84,
        '>', 145,
        '@', 83,
        '}', 100,
        0x2192, 167,
        0x21d2, 155,
        0x21d4, 157,
        0x2227, 151,
        0x2228, 152,
        0x2260, 142,
        0x2264, 147,
        0x2265, 149,
        0x22bb, 153,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(77);
      END_STATE();
    case 10:
      if (lookahead == ')') ADVANCE(97);
      if (lookahead == ';') ADVANCE(183);
      if (lookahead == '<') ADVANCE(12);
      if (lookahead == '@') ADVANCE(82);
      if (lookahead == 0x2190) ADVANCE(169);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(77);
      END_STATE();
    case 11:
      if (lookahead == ')') ADVANCE(97);
      if (lookahead == ';') ADVANCE(183);
      if (lookahead == '<') ADVANCE(12);
      if (lookahead == '@') ADVANCE(81);
      if (lookahead == 0x2190) ADVANCE(169);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(77);
      END_STATE();
    case 12:
      if (lookahead == '-') ADVANCE(170);
      END_STATE();
    case 13:
      if (lookahead == '.') ADVANCE(140);
      END_STATE();
    case 14:
      if (lookahead == '0') ADVANCE(129);
      if (lookahead == '>') ADVANCE(168);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(130);
      END_STATE();
    case 15:
      if (lookahead == '0') ADVANCE(129);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(130);
      END_STATE();
    case 16:
      if (lookahead == '0') ADVANCE(128);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(133);
      END_STATE();
    case 17:
      if (lookahead == '0') ADVANCE(125);
      if (lookahead == '+' ||
          lookahead == '-' ||
          lookahead == '\\') ADVANCE(18);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(126);
      END_STATE();
    case 18:
      if (lookahead == '0') ADVANCE(125);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(126);
      END_STATE();
    case 19:
      if (lookahead == ':') ADVANCE(75);
      END_STATE();
    case 20:
      if (lookahead == ':') ADVANCE(74);
      END_STATE();
    case 21:
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == '=') ADVANCE(165);
      END_STATE();
    case 22:
      if (lookahead == ';') ADVANCE(183);
      if (lookahead == ']') ADVANCE(73);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(22);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 23:
      if (lookahead == '=') ADVANCE(141);
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(165);
      END_STATE();
    case 25:
      if (lookahead == '>') ADVANCE(168);
      END_STATE();
    case 26:
      if (lookahead == '>') ADVANCE(154);
      END_STATE();
    case 27:
      if (lookahead == '>') ADVANCE(156);
      END_STATE();
    case 28:
      if (lookahead == 'U') ADVANCE(57);
      if (lookahead == 'u') ADVANCE(53);
      END_STATE();
    case 29:
      if (lookahead == '[') ADVANCE(122);
      END_STATE();
    case 30:
      if (lookahead == '_') ADVANCE(30);
      if (set_contains(sym_identifier_character_set_2, 151, lookahead)) ADVANCE(77);
      END_STATE();
    case 31:
      ADVANCE_MAP(
        'u', 32,
        '"', 5,
        '/', 5,
        '\\', 5,
        'a', 5,
        'b', 5,
        'e', 5,
        'f', 5,
        'n', 5,
        'r', 5,
        't', 5,
        'v', 5,
      );
      END_STATE();
    case 32:
      if (lookahead == '{') ADVANCE(50);
      END_STATE();
    case 33:
      if (lookahead == '}') ADVANCE(5);
      END_STATE();
    case 34:
      if (lookahead == '}') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(33);
      END_STATE();
    case 35:
      if (lookahead == '}') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(34);
      END_STATE();
    case 36:
      if (lookahead == '}') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(35);
      END_STATE();
    case 37:
      if (lookahead == '}') ADVANCE(5);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 38:
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(134);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(127);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(102);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(59);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(60);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(61);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(62);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(46);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(63);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(40);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(123);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(37);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(119);
      END_STATE();
    case 50:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 51:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 52:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(51);
      END_STATE();
    case 53:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(52);
      END_STATE();
    case 54:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(53);
      END_STATE();
    case 55:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(54);
      END_STATE();
    case 56:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 57:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(56);
      END_STATE();
    case 58:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(69);
      END_STATE();
    case 59:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(114);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(68);
      END_STATE();
    case 60:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(102);
      END_STATE();
    case 61:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(102);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(68);
      END_STATE();
    case 62:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(115);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(68);
      END_STATE();
    case 63:
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(116);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(68);
      END_STATE();
    case 64:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(87);
      END_STATE();
    case 65:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(108);
      END_STATE();
    case 66:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(65);
      END_STATE();
    case 67:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(110);
      END_STATE();
    case 68:
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(67);
      END_STATE();
    case 69:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(95);
      END_STATE();
    case 70:
      if (eof) ADVANCE(71);
      ADVANCE_MAP(
        '"', 5,
        '#', 29,
        '(', 96,
        ')', 97,
        '+', 171,
        ',', 98,
        '-', 14,
        '.', 13,
        '/', 23,
        '0', 132,
        ':', 21,
        ';', 183,
        '<', 143,
        '=', 84,
        '>', 145,
        '@', 81,
        '[', 72,
        '\\', 16,
        ']', 73,
        '_', 139,
        '{', 99,
        '|', 161,
        '}', 100,
        0xac, 150,
        0x2190, 169,
        0x2192, 167,
        0x21d2, 155,
        0x21d4, 157,
        0x2200, 158,
        0x2203, 159,
        0x2205, 173,
        0x2208, 160,
        0x2227, 151,
        0x2228, 152,
        0x2254, 166,
        0x2260, 142,
        0x2264, 147,
        0x2265, 149,
        0x2295, 172,
        0x22a4, 137,
        0x22a5, 138,
        0x22bb, 153,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(70);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(131);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(76);
      if (set_contains(sym_identifier_character_set_1, 112, lookahead)) ADVANCE(77);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_COLON_COLON);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_COLON_COLON2);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(30);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(77);
      if (set_contains(sym_identifier_character_set_2, 151, lookahead)) ADVANCE(77);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '_') ADVANCE(30);
      if (set_contains(sym_identifier_character_set_2, 151, lookahead)) ADVANCE(77);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == ':') ADVANCE(75);
      if (lookahead == '=') ADVANCE(165);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(165);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_AT);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(64);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_AT);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(65);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(26);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (lookahead == '-') ADVANCE(58);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (lookahead == '-') ADVANCE(58);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(86);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(85);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(88);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(89);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(90);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(91);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(92);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(93);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_controlled_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(94);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_quoted_string);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_language_tag);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(41);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(41);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(109);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(41);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(104);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(41);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(105);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(41);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(106);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(41);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(107);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(41);
      if (('a' <= lookahead && lookahead <= 'z')) ADVANCE(103);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(42);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(43);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(44);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_language_tag);
      if (lookahead == '-') ADVANCE(45);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(113);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(111);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_language_tag);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(112);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_LT);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(aux_sym_iri_token1);
      if (lookahead == ';') ADVANCE(120);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead > ' ' &&
          lookahead != '"' &&
          lookahead != ';' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(119);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(aux_sym_iri_token1);
      if (lookahead == '\\') ADVANCE(28);
      if (lookahead > ' ' &&
          lookahead != '"' &&
          lookahead != '<' &&
          lookahead != '>' &&
          lookahead != '^' &&
          lookahead != '`' &&
          (lookahead < '{' || '}' < lookahead)) ADVANCE(119);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(aux_sym_iri_token1);
      if (lookahead == '\\') ADVANCE(174);
      if ((!eof && lookahead <= '\t') ||
          (0x0b <= lookahead && lookahead <= ' ') ||
          lookahead == '"' ||
          lookahead == '<' ||
          lookahead == '>' ||
          lookahead == '^' ||
          lookahead == '`' ||
          ('{' <= lookahead && lookahead <= '}')) ADVANCE(183);
      if (lookahead > ' ') ADVANCE(120);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_POUND_LBRACK);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_hex_byte);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_hex_byte);
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == '/') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(130);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_double);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_double);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(126);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_decimal);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(17);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(127);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(39);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == '/') ADVANCE(38);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == '/') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(130);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == '/') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(124);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(123);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == '/') ADVANCE(38);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(123);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(133);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_rational);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(134);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_unsigned);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym_unsigned);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(136);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_u22a4);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_u22a5);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(sym_wildcard);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_u2260);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym_op_less_than);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym_op_less_than);
      if (lookahead == '=') ADVANCE(146);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_op_greater_than);
      if (lookahead == '=') ADVANCE(148);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      if (lookahead == '=') ADVANCE(27);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_u2264);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_u2265);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_u00ac);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_u2227);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_u2228);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_u22bb);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_EQ_EQ_GT);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_u21d2);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(anon_sym_LT_EQ_EQ_GT);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(anon_sym_u21d4);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(anon_sym_u2200);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_u2203);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(anon_sym_u2208);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_set_op_builder);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_u00b7);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(140);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(anon_sym_u2254);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(anon_sym_u2192);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(anon_sym_u2190);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_LT_DASH);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_u2295);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_u2205);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead == 'U') ADVANCE(182);
      if (lookahead == 'u') ADVANCE(178);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(183);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(120);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(183);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(175);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(183);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(176);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(183);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(177);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(183);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(178);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(183);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(179);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(183);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(180);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(183);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_line_comment);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(181);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(183);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(183);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'N', 1,
        'T', 2,
        'a', 3,
        'b', 4,
        'c', 5,
        'd', 6,
        'e', 7,
        'f', 8,
        'g', 9,
        'h', 10,
        'i', 11,
        'l', 12,
        'm', 13,
        'n', 14,
        'o', 15,
        'p', 16,
        'r', 17,
        's', 18,
        't', 19,
        'u', 20,
        'v', 21,
        'w', 22,
        'x', 23,
        'y', 24,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'o') ADVANCE(25);
      END_STATE();
    case 2:
      if (lookahead == 'h') ADVANCE(26);
      END_STATE();
    case 3:
      ACCEPT_TOKEN(anon_sym_a);
      if (lookahead == 'n') ADVANCE(27);
      if (lookahead == 's') ADVANCE(28);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(29);
      if (lookahead == 'i') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      if (lookahead == 'y') ADVANCE(32);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(33);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(34);
      if (lookahead == 'e') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(36);
      if (lookahead == 'o') ADVANCE(37);
      if (lookahead == 'u') ADVANCE(38);
      END_STATE();
    case 7:
      if (lookahead == 'n') ADVANCE(39);
      if (lookahead == 'v') ADVANCE(40);
      if (lookahead == 'x') ADVANCE(41);
      END_STATE();
    case 8:
      if (lookahead == 'a') ADVANCE(42);
      if (lookahead == 'i') ADVANCE(43);
      if (lookahead == 'l') ADVANCE(44);
      if (lookahead == 'o') ADVANCE(45);
      if (lookahead == 'r') ADVANCE(46);
      END_STATE();
    case 9:
      if (lookahead == 'D') ADVANCE(47);
      if (lookahead == 'M') ADVANCE(48);
      if (lookahead == 'Y') ADVANCE(49);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(50);
      END_STATE();
    case 11:
      if (lookahead == 'd') ADVANCE(51);
      if (lookahead == 'f') ADVANCE(52);
      if (lookahead == 'm') ADVANCE(53);
      if (lookahead == 'n') ADVANCE(54);
      if (lookahead == 'r') ADVANCE(55);
      if (lookahead == 's') ADVANCE(56);
      END_STATE();
    case 12:
      if (lookahead == 'a') ADVANCE(57);
      if (lookahead == 'e') ADVANCE(58);
      if (lookahead == 'o') ADVANCE(59);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(60);
      if (lookahead == 'i') ADVANCE(61);
      if (lookahead == 'o') ADVANCE(62);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(63);
      if (lookahead == 'o') ADVANCE(64);
      END_STATE();
    case 15:
      if (lookahead == 'f') ADVANCE(65);
      if (lookahead == 'p') ADVANCE(66);
      if (lookahead == 'r') ADVANCE(67);
      END_STATE();
    case 16:
      if (lookahead == 'a') ADVANCE(68);
      if (lookahead == 'o') ADVANCE(69);
      if (lookahead == 'r') ADVANCE(70);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(71);
      if (lookahead == 'd') ADVANCE(72);
      if (lookahead == 'e') ADVANCE(73);
      END_STATE();
    case 18:
      if (lookahead == 'e') ADVANCE(74);
      if (lookahead == 'h') ADVANCE(75);
      if (lookahead == 'o') ADVANCE(76);
      if (lookahead == 't') ADVANCE(77);
      END_STATE();
    case 19:
      if (lookahead == 'i') ADVANCE(78);
      if (lookahead == 'o') ADVANCE(79);
      if (lookahead == 'r') ADVANCE(80);
      if (lookahead == 'y') ADVANCE(81);
      END_STATE();
    case 20:
      if (lookahead == 'n') ADVANCE(82);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(83);
      END_STATE();
    case 22:
      if (lookahead == 'i') ADVANCE(84);
      END_STATE();
    case 23:
      if (lookahead == 'o') ADVANCE(85);
      END_STATE();
    case 24:
      if (lookahead == 'e') ADVANCE(86);
      END_STATE();
    case 25:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 26:
      if (lookahead == 'i') ADVANCE(88);
      END_STATE();
    case 27:
      if (lookahead == 'd') ADVANCE(89);
      if (lookahead == 'y') ADVANCE(90);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(91);
      END_STATE();
    case 29:
      if (lookahead == 's') ADVANCE(92);
      END_STATE();
    case 30:
      if (lookahead == 'n') ADVANCE(93);
      END_STATE();
    case 31:
      if (lookahead == 'o') ADVANCE(94);
      END_STATE();
    case 32:
      if (lookahead == 't') ADVANCE(95);
      END_STATE();
    case 33:
      if (lookahead == 'a') ADVANCE(96);
      END_STATE();
    case 34:
      if (lookahead == 't') ADVANCE(97);
      if (lookahead == 'y') ADVANCE(98);
      END_STATE();
    case 35:
      if (lookahead == 'c') ADVANCE(99);
      if (lookahead == 'f') ADVANCE(100);
      END_STATE();
    case 36:
      if (lookahead == 'm') ADVANCE(101);
      END_STATE();
    case 37:
      if (lookahead == 'u') ADVANCE(102);
      END_STATE();
    case 38:
      if (lookahead == 'r') ADVANCE(103);
      END_STATE();
    case 39:
      if (lookahead == 'd') ADVANCE(104);
      if (lookahead == 't') ADVANCE(105);
      if (lookahead == 'u') ADVANCE(106);
      END_STATE();
    case 40:
      if (lookahead == 'e') ADVANCE(107);
      END_STATE();
    case 41:
      if (lookahead == 'i') ADVANCE(108);
      if (lookahead == 'p') ADVANCE(109);
      END_STATE();
    case 42:
      if (lookahead == 'l') ADVANCE(110);
      END_STATE();
    case 43:
      if (lookahead == 'x') ADVANCE(111);
      END_STATE();
    case 44:
      if (lookahead == 'o') ADVANCE(112);
      END_STATE();
    case 45:
      if (lookahead == 'r') ADVANCE(113);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(114);
      if (lookahead == 'o') ADVANCE(115);
      END_STATE();
    case 47:
      if (lookahead == 'a') ADVANCE(116);
      END_STATE();
    case 48:
      if (lookahead == 'o') ADVANCE(117);
      END_STATE();
    case 49:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 50:
      if (lookahead == 'x') ADVANCE(119);
      END_STATE();
    case 51:
      if (lookahead == 'e') ADVANCE(120);
      END_STATE();
    case 52:
      if (lookahead == 'f') ADVANCE(121);
      END_STATE();
    case 53:
      if (lookahead == 'p') ADVANCE(122);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_in);
      if (lookahead == 't') ADVANCE(123);
      END_STATE();
    case 55:
      if (lookahead == 'i') ADVANCE(124);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 57:
      if (lookahead == 'n') ADVANCE(125);
      END_STATE();
    case 58:
      if (lookahead == 'n') ADVANCE(126);
      END_STATE();
    case 59:
      if (lookahead == 'n') ADVANCE(127);
      END_STATE();
    case 60:
      if (lookahead == 'x') ADVANCE(128);
      END_STATE();
    case 61:
      if (lookahead == 'n') ADVANCE(129);
      END_STATE();
    case 62:
      if (lookahead == 'd') ADVANCE(130);
      END_STATE();
    case 63:
      if (lookahead == 'g') ADVANCE(131);
      END_STATE();
    case 64:
      if (lookahead == 'n') ADVANCE(132);
      if (lookahead == 'r') ADVANCE(133);
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_of);
      END_STATE();
    case 66:
      if (lookahead == 'a') ADVANCE(135);
      if (lookahead == 't') ADVANCE(136);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == 'd') ADVANCE(137);
      END_STATE();
    case 68:
      if (lookahead == 'r') ADVANCE(138);
      if (lookahead == 't') ADVANCE(139);
      END_STATE();
    case 69:
      if (lookahead == 's') ADVANCE(140);
      END_STATE();
    case 70:
      if (lookahead == 'o') ADVANCE(141);
      END_STATE();
    case 71:
      if (lookahead == 't') ADVANCE(142);
      END_STATE();
    case 72:
      if (lookahead == 'f') ADVANCE(143);
      END_STATE();
    case 73:
      if (lookahead == 'a') ADVANCE(144);
      if (lookahead == 'f') ADVANCE(145);
      if (lookahead == 'q') ADVANCE(146);
      END_STATE();
    case 74:
      if (lookahead == 'l') ADVANCE(147);
      END_STATE();
    case 75:
      if (lookahead == 'o') ADVANCE(148);
      END_STATE();
    case 76:
      if (lookahead == 'u') ADVANCE(149);
      END_STATE();
    case 77:
      if (lookahead == 'r') ADVANCE(150);
      END_STATE();
    case 78:
      if (lookahead == 'm') ADVANCE(151);
      END_STATE();
    case 79:
      if (lookahead == 'k') ADVANCE(152);
      if (lookahead == 't') ADVANCE(153);
      END_STATE();
    case 80:
      if (lookahead == 'u') ADVANCE(154);
      END_STATE();
    case 81:
      if (lookahead == 'p') ADVANCE(155);
      END_STATE();
    case 82:
      if (lookahead == 'i') ADVANCE(156);
      if (lookahead == 'k') ADVANCE(157);
      if (lookahead == 'o') ADVANCE(158);
      if (lookahead == 's') ADVANCE(159);
      END_STATE();
    case 83:
      if (lookahead == 'r') ADVANCE(160);
      END_STATE();
    case 84:
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 85:
      if (lookahead == 'r') ADVANCE(162);
      END_STATE();
    case 86:
      if (lookahead == 'a') ADVANCE(163);
      END_STATE();
    case 87:
      if (lookahead == 'h') ADVANCE(164);
      END_STATE();
    case 88:
      if (lookahead == 'n') ADVANCE(165);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 90:
      if (lookahead == 'U') ADVANCE(166);
      END_STATE();
    case 91:
      if (lookahead == 'e') ADVANCE(167);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(168);
      END_STATE();
    case 93:
      if (lookahead == 'a') ADVANCE(169);
      END_STATE();
    case 94:
      if (lookahead == 'l') ADVANCE(170);
      END_STATE();
    case 95:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 96:
      if (lookahead == 's') ADVANCE(172);
      END_STATE();
    case 97:
      if (lookahead == 'a') ADVANCE(173);
      if (lookahead == 'e') ADVANCE(174);
      END_STATE();
    case 98:
      if (lookahead == 'T') ADVANCE(175);
      END_STATE();
    case 99:
      if (lookahead == 'i') ADVANCE(176);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_def);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(177);
      END_STATE();
    case 102:
      if (lookahead == 'b') ADVANCE(178);
      END_STATE();
    case 103:
      if (lookahead == 'a') ADVANCE(179);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_end);
      END_STATE();
    case 105:
      if (lookahead == 'i') ADVANCE(180);
      END_STATE();
    case 106:
      if (lookahead == 'm') ADVANCE(181);
      END_STATE();
    case 107:
      if (lookahead == 'n') ADVANCE(182);
      END_STATE();
    case 108:
      if (lookahead == 's') ADVANCE(183);
      END_STATE();
    case 109:
      if (lookahead == 'l') ADVANCE(184);
      END_STATE();
    case 110:
      if (lookahead == 's') ADVANCE(185);
      END_STATE();
    case 111:
      if (lookahead == 'e') ADVANCE(186);
      END_STATE();
    case 112:
      if (lookahead == 'a') ADVANCE(187);
      END_STATE();
    case 113:
      if (lookahead == 'a') ADVANCE(188);
      END_STATE();
    case 114:
      if (lookahead == 'c') ADVANCE(189);
      END_STATE();
    case 115:
      if (lookahead == 'm') ADVANCE(190);
      END_STATE();
    case 116:
      if (lookahead == 'y') ADVANCE(191);
      END_STATE();
    case 117:
      if (lookahead == 'n') ADVANCE(192);
      END_STATE();
    case 118:
      if (lookahead == 'a') ADVANCE(193);
      END_STATE();
    case 119:
      if (lookahead == 'B') ADVANCE(194);
      END_STATE();
    case 120:
      if (lookahead == 'n') ADVANCE(195);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_iff);
      END_STATE();
    case 122:
      if (lookahead == 'l') ADVANCE(196);
      if (lookahead == 'o') ADVANCE(197);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_int);
      if (lookahead == 'e') ADVANCE(198);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_iri);
      END_STATE();
    case 125:
      if (lookahead == 'g') ADVANCE(199);
      END_STATE();
    case 126:
      if (lookahead == 'g') ADVANCE(200);
      END_STATE();
    case 127:
      if (lookahead == 'g') ADVANCE(201);
      END_STATE();
    case 128:
      if (lookahead == 'E') ADVANCE(202);
      if (lookahead == 'I') ADVANCE(203);
      if (lookahead == 'L') ADVANCE(204);
      END_STATE();
    case 129:
      if (lookahead == 'E') ADVANCE(205);
      if (lookahead == 'I') ADVANCE(206);
      if (lookahead == 'L') ADVANCE(207);
      END_STATE();
    case 130:
      if (lookahead == 'u') ADVANCE(208);
      END_STATE();
    case 131:
      if (lookahead == 'a') ADVANCE(209);
      END_STATE();
    case 132:
      if (lookahead == 'N') ADVANCE(210);
      if (lookahead == 'P') ADVANCE(211);
      if (lookahead == 'u') ADVANCE(212);
      END_STATE();
    case 133:
      if (lookahead == 'm') ADVANCE(213);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 135:
      if (lookahead == 'q') ADVANCE(214);
      END_STATE();
    case 136:
      if (lookahead == 'i') ADVANCE(215);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(216);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(217);
      END_STATE();
    case 139:
      if (lookahead == 't') ADVANCE(218);
      END_STATE();
    case 140:
      if (lookahead == 'i') ADVANCE(219);
      END_STATE();
    case 141:
      if (lookahead == 'h') ADVANCE(220);
      if (lookahead == 'p') ADVANCE(221);
      END_STATE();
    case 142:
      if (lookahead == 'i') ADVANCE(222);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_rdf);
      END_STATE();
    case 144:
      if (lookahead == 'l') ADVANCE(223);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_ref);
      END_STATE();
    case 146:
      if (lookahead == 'u') ADVANCE(224);
      END_STATE();
    case 147:
      if (lookahead == 'f') ADVANCE(225);
      END_STATE();
    case 148:
      if (lookahead == 'r') ADVANCE(226);
      END_STATE();
    case 149:
      if (lookahead == 'r') ADVANCE(227);
      END_STATE();
    case 150:
      if (lookahead == 'i') ADVANCE(228);
      if (lookahead == 'u') ADVANCE(229);
      END_STATE();
    case 151:
      if (lookahead == 'e') ADVANCE(230);
      END_STATE();
    case 152:
      if (lookahead == 'e') ADVANCE(231);
      END_STATE();
    case 153:
      if (lookahead == 'a') ADVANCE(232);
      END_STATE();
    case 154:
      if (lookahead == 'e') ADVANCE(233);
      END_STATE();
    case 155:
      if (lookahead == 'e') ADVANCE(234);
      END_STATE();
    case 156:
      if (lookahead == 'o') ADVANCE(235);
      if (lookahead == 'q') ADVANCE(236);
      END_STATE();
    case 157:
      if (lookahead == 'n') ADVANCE(237);
      END_STATE();
    case 158:
      if (lookahead == 'r') ADVANCE(238);
      END_STATE();
    case 159:
      if (lookahead == 'i') ADVANCE(239);
      END_STATE();
    case 160:
      if (lookahead == 's') ADVANCE(240);
      END_STATE();
    case 161:
      if (lookahead == 'h') ADVANCE(241);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_xor);
      END_STATE();
    case 163:
      if (lookahead == 'r') ADVANCE(242);
      END_STATE();
    case 164:
      if (lookahead == 'i') ADVANCE(243);
      END_STATE();
    case 165:
      if (lookahead == 'g') ADVANCE(244);
      END_STATE();
    case 166:
      if (lookahead == 'R') ADVANCE(245);
      END_STATE();
    case 167:
      if (lookahead == 'r') ADVANCE(246);
      END_STATE();
    case 168:
      if (lookahead == '6') ADVANCE(247);
      END_STATE();
    case 169:
      if (lookahead == 'r') ADVANCE(248);
      END_STATE();
    case 170:
      if (lookahead == 'e') ADVANCE(249);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_byte);
      END_STATE();
    case 172:
      if (lookahead == 's') ADVANCE(250);
      END_STATE();
    case 173:
      if (lookahead == 't') ADVANCE(251);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(anon_sym_date);
      if (lookahead == 'T') ADVANCE(252);
      END_STATE();
    case 175:
      if (lookahead == 'i') ADVANCE(253);
      END_STATE();
    case 176:
      if (lookahead == 'm') ADVANCE(254);
      END_STATE();
    case 177:
      if (lookahead == 'n') ADVANCE(255);
      END_STATE();
    case 178:
      if (lookahead == 'l') ADVANCE(256);
      END_STATE();
    case 179:
      if (lookahead == 't') ADVANCE(257);
      END_STATE();
    case 180:
      if (lookahead == 't') ADVANCE(258);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 182:
      if (lookahead == 't') ADVANCE(259);
      END_STATE();
    case 183:
      if (lookahead == 't') ADVANCE(260);
      END_STATE();
    case 184:
      if (lookahead == 'i') ADVANCE(261);
      END_STATE();
    case 185:
      if (lookahead == 'e') ADVANCE(262);
      END_STATE();
    case 186:
      if (lookahead == 'd') ADVANCE(263);
      END_STATE();
    case 187:
      if (lookahead == 't') ADVANCE(264);
      END_STATE();
    case 188:
      if (lookahead == 'l') ADVANCE(265);
      END_STATE();
    case 189:
      if (lookahead == 't') ADVANCE(266);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(anon_sym_gDay);
      END_STATE();
    case 192:
      if (lookahead == 't') ADVANCE(267);
      END_STATE();
    case 193:
      if (lookahead == 'r') ADVANCE(268);
      END_STATE();
    case 194:
      if (lookahead == 'i') ADVANCE(269);
      END_STATE();
    case 195:
      if (lookahead == 't') ADVANCE(270);
      END_STATE();
    case 196:
      if (lookahead == 'i') ADVANCE(271);
      END_STATE();
    case 197:
      if (lookahead == 'r') ADVANCE(272);
      END_STATE();
    case 198:
      if (lookahead == 'g') ADVANCE(273);
      END_STATE();
    case 199:
      if (lookahead == 'u') ADVANCE(274);
      END_STATE();
    case 200:
      if (lookahead == 't') ADVANCE(275);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(anon_sym_long);
      END_STATE();
    case 202:
      if (lookahead == 'x') ADVANCE(276);
      END_STATE();
    case 203:
      if (lookahead == 'n') ADVANCE(277);
      END_STATE();
    case 204:
      if (lookahead == 'e') ADVANCE(278);
      END_STATE();
    case 205:
      if (lookahead == 'x') ADVANCE(279);
      END_STATE();
    case 206:
      if (lookahead == 'n') ADVANCE(280);
      END_STATE();
    case 207:
      if (lookahead == 'e') ADVANCE(281);
      END_STATE();
    case 208:
      if (lookahead == 'l') ADVANCE(282);
      END_STATE();
    case 209:
      if (lookahead == 't') ADVANCE(283);
      END_STATE();
    case 210:
      if (lookahead == 'e') ADVANCE(284);
      END_STATE();
    case 211:
      if (lookahead == 'o') ADVANCE(285);
      END_STATE();
    case 212:
      if (lookahead == 'n') ADVANCE(286);
      END_STATE();
    case 213:
      if (lookahead == 'a') ADVANCE(287);
      END_STATE();
    case 214:
      if (lookahead == 'u') ADVANCE(288);
      END_STATE();
    case 215:
      if (lookahead == 'o') ADVANCE(289);
      END_STATE();
    case 216:
      if (lookahead == 'r') ADVANCE(290);
      END_STATE();
    case 217:
      if (lookahead == 'n') ADVANCE(291);
      END_STATE();
    case 218:
      if (lookahead == 'e') ADVANCE(292);
      END_STATE();
    case 219:
      if (lookahead == 't') ADVANCE(293);
      END_STATE();
    case 220:
      if (lookahead == 'i') ADVANCE(294);
      END_STATE();
    case 221:
      if (lookahead == 'e') ADVANCE(295);
      END_STATE();
    case 222:
      if (lookahead == 'o') ADVANCE(296);
      END_STATE();
    case 223:
      ACCEPT_TOKEN(anon_sym_real);
      END_STATE();
    case 224:
      if (lookahead == 'i') ADVANCE(297);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(sym_reserved_self);
      END_STATE();
    case 226:
      if (lookahead == 't') ADVANCE(298);
      END_STATE();
    case 227:
      if (lookahead == 'c') ADVANCE(299);
      END_STATE();
    case 228:
      if (lookahead == 'n') ADVANCE(300);
      END_STATE();
    case 229:
      if (lookahead == 'c') ADVANCE(301);
      END_STATE();
    case 230:
      ACCEPT_TOKEN(anon_sym_time);
      END_STATE();
    case 231:
      if (lookahead == 'n') ADVANCE(302);
      END_STATE();
    case 232:
      if (lookahead == 'l') ADVANCE(303);
      END_STATE();
    case 233:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 234:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 235:
      if (lookahead == 'n') ADVANCE(304);
      END_STATE();
    case 236:
      if (lookahead == 'u') ADVANCE(305);
      END_STATE();
    case 237:
      if (lookahead == 'o') ADVANCE(306);
      END_STATE();
    case 238:
      if (lookahead == 'd') ADVANCE(307);
      END_STATE();
    case 239:
      if (lookahead == 'g') ADVANCE(308);
      END_STATE();
    case 240:
      if (lookahead == 'i') ADVANCE(309);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_with);
      if (lookahead == 'o') ADVANCE(310);
      END_STATE();
    case 242:
      if (lookahead == 'M') ADVANCE(311);
      END_STATE();
    case 243:
      if (lookahead == 'n') ADVANCE(312);
      END_STATE();
    case 244:
      ACCEPT_TOKEN(anon_sym_Thing);
      END_STATE();
    case 245:
      if (lookahead == 'I') ADVANCE(313);
      END_STATE();
    case 246:
      if (lookahead == 't') ADVANCE(314);
      END_STATE();
    case 247:
      if (lookahead == '4') ADVANCE(315);
      END_STATE();
    case 248:
      if (lookahead == 'y') ADVANCE(316);
      END_STATE();
    case 249:
      if (lookahead == 'a') ADVANCE(317);
      END_STATE();
    case 250:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 251:
      if (lookahead == 'y') ADVANCE(318);
      END_STATE();
    case 252:
      if (lookahead == 'i') ADVANCE(319);
      END_STATE();
    case 253:
      if (lookahead == 'm') ADVANCE(320);
      END_STATE();
    case 254:
      if (lookahead == 'a') ADVANCE(321);
      END_STATE();
    case 255:
      if (lookahead == 's') ADVANCE(322);
      END_STATE();
    case 256:
      if (lookahead == 'e') ADVANCE(323);
      END_STATE();
    case 257:
      if (lookahead == 'i') ADVANCE(324);
      END_STATE();
    case 258:
      if (lookahead == 'y') ADVANCE(325);
      END_STATE();
    case 259:
      ACCEPT_TOKEN(anon_sym_event);
      END_STATE();
    case 260:
      if (lookahead == 's') ADVANCE(326);
      END_STATE();
    case 261:
      if (lookahead == 'c') ADVANCE(327);
      END_STATE();
    case 262:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(sym_kw_is_fixed);
      END_STATE();
    case 264:
      ACCEPT_TOKEN(anon_sym_float);
      END_STATE();
    case 265:
      if (lookahead == 'l') ADVANCE(328);
      END_STATE();
    case 266:
      if (lookahead == 'i') ADVANCE(329);
      END_STATE();
    case 267:
      if (lookahead == 'h') ADVANCE(330);
      END_STATE();
    case 268:
      ACCEPT_TOKEN(anon_sym_gYear);
      if (lookahead == 'M') ADVANCE(331);
      END_STATE();
    case 269:
      if (lookahead == 'n') ADVANCE(332);
      END_STATE();
    case 270:
      if (lookahead == 'i') ADVANCE(333);
      END_STATE();
    case 271:
      if (lookahead == 'e') ADVANCE(334);
      END_STATE();
    case 272:
      if (lookahead == 't') ADVANCE(335);
      END_STATE();
    case 273:
      if (lookahead == 'e') ADVANCE(336);
      END_STATE();
    case 274:
      if (lookahead == 'a') ADVANCE(337);
      END_STATE();
    case 275:
      if (lookahead == 'h') ADVANCE(338);
      END_STATE();
    case 276:
      if (lookahead == 'c') ADVANCE(339);
      END_STATE();
    case 277:
      if (lookahead == 'c') ADVANCE(340);
      END_STATE();
    case 278:
      if (lookahead == 'n') ADVANCE(341);
      END_STATE();
    case 279:
      if (lookahead == 'c') ADVANCE(342);
      END_STATE();
    case 280:
      if (lookahead == 'c') ADVANCE(343);
      END_STATE();
    case 281:
      if (lookahead == 'n') ADVANCE(344);
      END_STATE();
    case 282:
      if (lookahead == 'e') ADVANCE(345);
      END_STATE();
    case 283:
      if (lookahead == 'i') ADVANCE(346);
      END_STATE();
    case 284:
      if (lookahead == 'g') ADVANCE(347);
      END_STATE();
    case 285:
      if (lookahead == 's') ADVANCE(348);
      END_STATE();
    case 286:
      if (lookahead == 'i') ADVANCE(349);
      END_STATE();
    case 287:
      if (lookahead == 'l') ADVANCE(350);
      END_STATE();
    case 288:
      if (lookahead == 'e') ADVANCE(351);
      END_STATE();
    case 289:
      if (lookahead == 'n') ADVANCE(352);
      END_STATE();
    case 290:
      if (lookahead == 'e') ADVANCE(353);
      END_STATE();
    case 291:
      if (lookahead == 't') ADVANCE(354);
      END_STATE();
    case 292:
      if (lookahead == 'r') ADVANCE(355);
      END_STATE();
    case 293:
      if (lookahead == 'i') ADVANCE(356);
      END_STATE();
    case 294:
      if (lookahead == 'b') ADVANCE(357);
      END_STATE();
    case 295:
      if (lookahead == 'r') ADVANCE(358);
      END_STATE();
    case 296:
      if (lookahead == 'n') ADVANCE(359);
      END_STATE();
    case 297:
      if (lookahead == 'r') ADVANCE(360);
      END_STATE();
    case 298:
      ACCEPT_TOKEN(anon_sym_short);
      END_STATE();
    case 299:
      if (lookahead == 'e') ADVANCE(361);
      END_STATE();
    case 300:
      if (lookahead == 'g') ADVANCE(362);
      END_STATE();
    case 301:
      if (lookahead == 't') ADVANCE(363);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_token);
      END_STATE();
    case 303:
      if (lookahead == 'D') ADVANCE(364);
      END_STATE();
    case 304:
      ACCEPT_TOKEN(anon_sym_union);
      END_STATE();
    case 305:
      if (lookahead == 'e') ADVANCE(365);
      END_STATE();
    case 306:
      if (lookahead == 'w') ADVANCE(366);
      END_STATE();
    case 307:
      if (lookahead == 'e') ADVANCE(367);
      END_STATE();
    case 308:
      if (lookahead == 'n') ADVANCE(368);
      END_STATE();
    case 309:
      if (lookahead == 'o') ADVANCE(369);
      END_STATE();
    case 310:
      if (lookahead == 'u') ADVANCE(370);
      END_STATE();
    case 311:
      if (lookahead == 'o') ADVANCE(371);
      END_STATE();
    case 312:
      if (lookahead == 'g') ADVANCE(372);
      END_STATE();
    case 313:
      ACCEPT_TOKEN(anon_sym_anyURI);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_assert);
      END_STATE();
    case 315:
      if (lookahead == 'B') ADVANCE(373);
      END_STATE();
    case 316:
      ACCEPT_TOKEN(anon_sym_binary);
      END_STATE();
    case 317:
      if (lookahead == 'n') ADVANCE(374);
      END_STATE();
    case 318:
      if (lookahead == 'p') ADVANCE(375);
      END_STATE();
    case 319:
      if (lookahead == 'm') ADVANCE(376);
      END_STATE();
    case 320:
      if (lookahead == 'e') ADVANCE(377);
      END_STATE();
    case 321:
      if (lookahead == 'l') ADVANCE(378);
      END_STATE();
    case 322:
      if (lookahead == 'i') ADVANCE(379);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_double);
      END_STATE();
    case 324:
      if (lookahead == 'o') ADVANCE(380);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_entity);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_exists);
      END_STATE();
    case 327:
      if (lookahead == 'i') ADVANCE(381);
      END_STATE();
    case 328:
      ACCEPT_TOKEN(anon_sym_forall);
      END_STATE();
    case 329:
      if (lookahead == 'o') ADVANCE(382);
      END_STATE();
    case 330:
      ACCEPT_TOKEN(anon_sym_gMonth);
      if (lookahead == 'D') ADVANCE(383);
      END_STATE();
    case 331:
      if (lookahead == 'o') ADVANCE(384);
      END_STATE();
    case 332:
      if (lookahead == 'a') ADVANCE(385);
      END_STATE();
    case 333:
      if (lookahead == 't') ADVANCE(386);
      END_STATE();
    case 334:
      if (lookahead == 's') ADVANCE(387);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 336:
      if (lookahead == 'r') ADVANCE(388);
      END_STATE();
    case 337:
      if (lookahead == 'g') ADVANCE(389);
      END_STATE();
    case 338:
      ACCEPT_TOKEN(anon_sym_length);
      END_STATE();
    case 339:
      if (lookahead == 'l') ADVANCE(390);
      END_STATE();
    case 340:
      if (lookahead == 'l') ADVANCE(391);
      END_STATE();
    case 341:
      if (lookahead == 'g') ADVANCE(392);
      END_STATE();
    case 342:
      if (lookahead == 'l') ADVANCE(393);
      END_STATE();
    case 343:
      if (lookahead == 'l') ADVANCE(394);
      END_STATE();
    case 344:
      if (lookahead == 'g') ADVANCE(395);
      END_STATE();
    case 345:
      ACCEPT_TOKEN(anon_sym_module);
      END_STATE();
    case 346:
      if (lookahead == 'v') ADVANCE(396);
      END_STATE();
    case 347:
      if (lookahead == 'a') ADVANCE(397);
      END_STATE();
    case 348:
      if (lookahead == 'i') ADVANCE(398);
      END_STATE();
    case 349:
      if (lookahead == 'q') ADVANCE(399);
      END_STATE();
    case 350:
      if (lookahead == 'i') ADVANCE(400);
      END_STATE();
    case 351:
      ACCEPT_TOKEN(sym_opaque);
      END_STATE();
    case 352:
      if (lookahead == 'a') ADVANCE(401);
      END_STATE();
    case 353:
      if (lookahead == 'd') ADVANCE(402);
      END_STATE();
    case 354:
      ACCEPT_TOKEN(anon_sym_parent);
      END_STATE();
    case 355:
      if (lookahead == 'n') ADVANCE(403);
      END_STATE();
    case 356:
      if (lookahead == 'v') ADVANCE(404);
      END_STATE();
    case 357:
      if (lookahead == 'i') ADVANCE(405);
      END_STATE();
    case 358:
      if (lookahead == 't') ADVANCE(406);
      END_STATE();
    case 359:
      if (lookahead == 'a') ADVANCE(407);
      END_STATE();
    case 360:
      if (lookahead == 'e') ADVANCE(408);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_source);
      END_STATE();
    case 362:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 363:
      if (lookahead == 'u') ADVANCE(409);
      END_STATE();
    case 364:
      if (lookahead == 'i') ADVANCE(410);
      END_STATE();
    case 365:
      ACCEPT_TOKEN(anon_sym_unique);
      END_STATE();
    case 366:
      if (lookahead == 'n') ADVANCE(411);
      END_STATE();
    case 367:
      if (lookahead == 'r') ADVANCE(412);
      END_STATE();
    case 368:
      if (lookahead == 'e') ADVANCE(413);
      END_STATE();
    case 369:
      if (lookahead == 'n') ADVANCE(414);
      END_STATE();
    case 370:
      if (lookahead == 't') ADVANCE(415);
      END_STATE();
    case 371:
      if (lookahead == 'n') ADVANCE(416);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_Nothing);
      END_STATE();
    case 373:
      if (lookahead == 'i') ADVANCE(417);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(anon_sym_boolean);
      END_STATE();
    case 375:
      if (lookahead == 'e') ADVANCE(418);
      END_STATE();
    case 376:
      if (lookahead == 'e') ADVANCE(419);
      END_STATE();
    case 377:
      if (lookahead == 'D') ADVANCE(420);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_decimal);
      END_STATE();
    case 379:
      if (lookahead == 'o') ADVANCE(421);
      END_STATE();
    case 380:
      if (lookahead == 'n') ADVANCE(422);
      END_STATE();
    case 381:
      if (lookahead == 't') ADVANCE(423);
      END_STATE();
    case 382:
      if (lookahead == 'n') ADVANCE(424);
      END_STATE();
    case 383:
      if (lookahead == 'a') ADVANCE(425);
      END_STATE();
    case 384:
      if (lookahead == 'n') ADVANCE(426);
      END_STATE();
    case 385:
      if (lookahead == 'r') ADVANCE(427);
      END_STATE();
    case 386:
      if (lookahead == 'y') ADVANCE(428);
      END_STATE();
    case 387:
      ACCEPT_TOKEN(anon_sym_implies);
      END_STATE();
    case 388:
      ACCEPT_TOKEN(anon_sym_integer);
      END_STATE();
    case 389:
      if (lookahead == 'e') ADVANCE(429);
      END_STATE();
    case 390:
      if (lookahead == 'u') ADVANCE(430);
      END_STATE();
    case 391:
      if (lookahead == 'u') ADVANCE(431);
      END_STATE();
    case 392:
      if (lookahead == 't') ADVANCE(432);
      END_STATE();
    case 393:
      if (lookahead == 'u') ADVANCE(433);
      END_STATE();
    case 394:
      if (lookahead == 'u') ADVANCE(434);
      END_STATE();
    case 395:
      if (lookahead == 't') ADVANCE(435);
      END_STATE();
    case 396:
      if (lookahead == 'e') ADVANCE(436);
      END_STATE();
    case 397:
      if (lookahead == 't') ADVANCE(437);
      END_STATE();
    case 398:
      if (lookahead == 't') ADVANCE(438);
      END_STATE();
    case 399:
      if (lookahead == 'u') ADVANCE(439);
      END_STATE();
    case 400:
      if (lookahead == 'z') ADVANCE(440);
      END_STATE();
    case 401:
      if (lookahead == 'l') ADVANCE(441);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_ordered);
      END_STATE();
    case 403:
      ACCEPT_TOKEN(anon_sym_pattern);
      END_STATE();
    case 404:
      if (lookahead == 'e') ADVANCE(442);
      END_STATE();
    case 405:
      if (lookahead == 't') ADVANCE(443);
      END_STATE();
    case 406:
      if (lookahead == 'y') ADVANCE(444);
      END_STATE();
    case 407:
      if (lookahead == 'l') ADVANCE(445);
      END_STATE();
    case 408:
      if (lookahead == 'd') ADVANCE(446);
      END_STATE();
    case 409:
      if (lookahead == 'r') ADVANCE(447);
      END_STATE();
    case 410:
      if (lookahead == 'g') ADVANCE(448);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(sym_unknown_type);
      END_STATE();
    case 412:
      if (lookahead == 'e') ADVANCE(449);
      END_STATE();
    case 413:
      if (lookahead == 'd') ADVANCE(450);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(anon_sym_version);
      END_STATE();
    case 415:
      ACCEPT_TOKEN(anon_sym_without);
      END_STATE();
    case 416:
      if (lookahead == 't') ADVANCE(451);
      END_STATE();
    case 417:
      if (lookahead == 'n') ADVANCE(452);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(anon_sym_datatype);
      END_STATE();
    case 419:
      ACCEPT_TOKEN(anon_sym_dateTime);
      if (lookahead == 'S') ADVANCE(453);
      END_STATE();
    case 420:
      if (lookahead == 'u') ADVANCE(454);
      END_STATE();
    case 421:
      if (lookahead == 'n') ADVANCE(455);
      END_STATE();
    case 422:
      ACCEPT_TOKEN(anon_sym_duration);
      END_STATE();
    case 423:
      if (lookahead == 'T') ADVANCE(456);
      END_STATE();
    case 424:
      if (lookahead == 'D') ADVANCE(457);
      END_STATE();
    case 425:
      if (lookahead == 'y') ADVANCE(458);
      END_STATE();
    case 426:
      if (lookahead == 't') ADVANCE(459);
      END_STATE();
    case 427:
      if (lookahead == 'y') ADVANCE(460);
      END_STATE();
    case 428:
      ACCEPT_TOKEN(anon_sym_identity);
      END_STATE();
    case 429:
      ACCEPT_TOKEN(anon_sym_language);
      END_STATE();
    case 430:
      if (lookahead == 's') ADVANCE(461);
      END_STATE();
    case 431:
      if (lookahead == 's') ADVANCE(462);
      END_STATE();
    case 432:
      if (lookahead == 'h') ADVANCE(463);
      END_STATE();
    case 433:
      if (lookahead == 's') ADVANCE(464);
      END_STATE();
    case 434:
      if (lookahead == 's') ADVANCE(465);
      END_STATE();
    case 435:
      if (lookahead == 'h') ADVANCE(466);
      END_STATE();
    case 436:
      if (lookahead == 'I') ADVANCE(467);
      END_STATE();
    case 437:
      if (lookahead == 'i') ADVANCE(468);
      END_STATE();
    case 438:
      if (lookahead == 'i') ADVANCE(469);
      END_STATE();
    case 439:
      if (lookahead == 'e') ADVANCE(470);
      END_STATE();
    case 440:
      if (lookahead == 'e') ADVANCE(471);
      END_STATE();
    case 441:
      ACCEPT_TOKEN(anon_sym_optional);
      END_STATE();
    case 442:
      if (lookahead == 'I') ADVANCE(472);
      END_STATE();
    case 443:
      if (lookahead == 'e') ADVANCE(473);
      END_STATE();
    case 444:
      ACCEPT_TOKEN(anon_sym_property);
      END_STATE();
    case 445:
      ACCEPT_TOKEN(anon_sym_rational);
      END_STATE();
    case 446:
      ACCEPT_TOKEN(anon_sym_required);
      END_STATE();
    case 447:
      if (lookahead == 'e') ADVANCE(474);
      END_STATE();
    case 448:
      if (lookahead == 'i') ADVANCE(475);
      END_STATE();
    case 449:
      if (lookahead == 'd') ADVANCE(476);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(anon_sym_unsigned);
      if (lookahead == 'B') ADVANCE(477);
      if (lookahead == 'I') ADVANCE(478);
      if (lookahead == 'L') ADVANCE(479);
      if (lookahead == 'S') ADVANCE(480);
      END_STATE();
    case 451:
      if (lookahead == 'h') ADVANCE(481);
      END_STATE();
    case 452:
      if (lookahead == 'a') ADVANCE(482);
      END_STATE();
    case 453:
      if (lookahead == 't') ADVANCE(483);
      END_STATE();
    case 454:
      if (lookahead == 'r') ADVANCE(484);
      END_STATE();
    case 455:
      ACCEPT_TOKEN(anon_sym_dimension);
      END_STATE();
    case 456:
      if (lookahead == 'i') ADVANCE(485);
      END_STATE();
    case 457:
      if (lookahead == 'i') ADVANCE(486);
      END_STATE();
    case 458:
      ACCEPT_TOKEN(anon_sym_gMonthDay);
      END_STATE();
    case 459:
      if (lookahead == 'h') ADVANCE(487);
      END_STATE();
    case 460:
      ACCEPT_TOKEN(anon_sym_hexBinary);
      END_STATE();
    case 461:
      if (lookahead == 'i') ADVANCE(488);
      END_STATE();
    case 462:
      if (lookahead == 'i') ADVANCE(489);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(anon_sym_maxLength);
      END_STATE();
    case 464:
      if (lookahead == 'i') ADVANCE(490);
      END_STATE();
    case 465:
      if (lookahead == 'i') ADVANCE(491);
      END_STATE();
    case 466:
      ACCEPT_TOKEN(anon_sym_minLength);
      END_STATE();
    case 467:
      if (lookahead == 'n') ADVANCE(492);
      END_STATE();
    case 468:
      if (lookahead == 'v') ADVANCE(493);
      END_STATE();
    case 469:
      if (lookahead == 'v') ADVANCE(494);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(anon_sym_nonunique);
      END_STATE();
    case 471:
      if (lookahead == 'd') ADVANCE(495);
      END_STATE();
    case 472:
      if (lookahead == 'n') ADVANCE(496);
      END_STATE();
    case 473:
      if (lookahead == 'd') ADVANCE(497);
      END_STATE();
    case 474:
      ACCEPT_TOKEN(anon_sym_structure);
      END_STATE();
    case 475:
      if (lookahead == 't') ADVANCE(498);
      END_STATE();
    case 476:
      ACCEPT_TOKEN(anon_sym_unordered);
      END_STATE();
    case 477:
      if (lookahead == 'y') ADVANCE(499);
      END_STATE();
    case 478:
      if (lookahead == 'n') ADVANCE(500);
      END_STATE();
    case 479:
      if (lookahead == 'o') ADVANCE(501);
      END_STATE();
    case 480:
      if (lookahead == 'h') ADVANCE(502);
      END_STATE();
    case 481:
      if (lookahead == 'D') ADVANCE(503);
      END_STATE();
    case 482:
      if (lookahead == 'r') ADVANCE(504);
      END_STATE();
    case 483:
      if (lookahead == 'a') ADVANCE(505);
      END_STATE();
    case 484:
      if (lookahead == 'a') ADVANCE(506);
      END_STATE();
    case 485:
      if (lookahead == 'm') ADVANCE(507);
      END_STATE();
    case 486:
      if (lookahead == 'g') ADVANCE(508);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(anon_sym_gYearMonth);
      END_STATE();
    case 488:
      if (lookahead == 'v') ADVANCE(509);
      END_STATE();
    case 489:
      if (lookahead == 'v') ADVANCE(510);
      END_STATE();
    case 490:
      if (lookahead == 'v') ADVANCE(511);
      END_STATE();
    case 491:
      if (lookahead == 'v') ADVANCE(512);
      END_STATE();
    case 492:
      if (lookahead == 't') ADVANCE(513);
      END_STATE();
    case 493:
      if (lookahead == 'e') ADVANCE(514);
      END_STATE();
    case 494:
      if (lookahead == 'e') ADVANCE(515);
      END_STATE();
    case 495:
      if (lookahead == 'S') ADVANCE(516);
      END_STATE();
    case 496:
      if (lookahead == 't') ADVANCE(517);
      END_STATE();
    case 497:
      ACCEPT_TOKEN(anon_sym_prohibited);
      END_STATE();
    case 498:
      if (lookahead == 's') ADVANCE(518);
      END_STATE();
    case 499:
      if (lookahead == 't') ADVANCE(519);
      END_STATE();
    case 500:
      if (lookahead == 't') ADVANCE(520);
      END_STATE();
    case 501:
      if (lookahead == 'n') ADVANCE(521);
      END_STATE();
    case 502:
      if (lookahead == 'o') ADVANCE(522);
      END_STATE();
    case 503:
      if (lookahead == 'u') ADVANCE(523);
      END_STATE();
    case 504:
      if (lookahead == 'y') ADVANCE(524);
      END_STATE();
    case 505:
      if (lookahead == 'm') ADVANCE(525);
      END_STATE();
    case 506:
      if (lookahead == 't') ADVANCE(526);
      END_STATE();
    case 507:
      if (lookahead == 'e') ADVANCE(527);
      END_STATE();
    case 508:
      if (lookahead == 'i') ADVANCE(528);
      END_STATE();
    case 509:
      if (lookahead == 'e') ADVANCE(529);
      END_STATE();
    case 510:
      if (lookahead == 'e') ADVANCE(530);
      END_STATE();
    case 511:
      if (lookahead == 'e') ADVANCE(531);
      END_STATE();
    case 512:
      if (lookahead == 'e') ADVANCE(532);
      END_STATE();
    case 513:
      if (lookahead == 'e') ADVANCE(533);
      END_STATE();
    case 514:
      if (lookahead == 'I') ADVANCE(534);
      END_STATE();
    case 515:
      if (lookahead == 'I') ADVANCE(535);
      END_STATE();
    case 516:
      if (lookahead == 't') ADVANCE(536);
      END_STATE();
    case 517:
      if (lookahead == 'e') ADVANCE(537);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(anon_sym_totalDigits);
      END_STATE();
    case 519:
      if (lookahead == 'e') ADVANCE(538);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(anon_sym_unsignedInt);
      END_STATE();
    case 521:
      if (lookahead == 'g') ADVANCE(539);
      END_STATE();
    case 522:
      if (lookahead == 'r') ADVANCE(540);
      END_STATE();
    case 523:
      if (lookahead == 'r') ADVANCE(541);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(anon_sym_base64Binary);
      END_STATE();
    case 525:
      if (lookahead == 'p') ADVANCE(542);
      END_STATE();
    case 526:
      if (lookahead == 'i') ADVANCE(543);
      END_STATE();
    case 527:
      if (lookahead == 'z') ADVANCE(544);
      END_STATE();
    case 528:
      if (lookahead == 't') ADVANCE(545);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(anon_sym_maxExclusive);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(anon_sym_maxInclusive);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(anon_sym_minExclusive);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(anon_sym_minInclusive);
      END_STATE();
    case 533:
      if (lookahead == 'g') ADVANCE(546);
      END_STATE();
    case 534:
      if (lookahead == 'n') ADVANCE(547);
      END_STATE();
    case 535:
      if (lookahead == 'n') ADVANCE(548);
      END_STATE();
    case 536:
      if (lookahead == 'r') ADVANCE(549);
      END_STATE();
    case 537:
      if (lookahead == 'g') ADVANCE(550);
      END_STATE();
    case 538:
      ACCEPT_TOKEN(anon_sym_unsignedByte);
      END_STATE();
    case 539:
      ACCEPT_TOKEN(anon_sym_unsignedLong);
      END_STATE();
    case 540:
      if (lookahead == 't') ADVANCE(551);
      END_STATE();
    case 541:
      if (lookahead == 'a') ADVANCE(552);
      END_STATE();
    case 542:
      ACCEPT_TOKEN(anon_sym_dateTimeStamp);
      END_STATE();
    case 543:
      if (lookahead == 'o') ADVANCE(553);
      END_STATE();
    case 544:
      if (lookahead == 'o') ADVANCE(554);
      END_STATE();
    case 545:
      if (lookahead == 's') ADVANCE(555);
      END_STATE();
    case 546:
      if (lookahead == 'e') ADVANCE(556);
      END_STATE();
    case 547:
      if (lookahead == 't') ADVANCE(557);
      END_STATE();
    case 548:
      if (lookahead == 't') ADVANCE(558);
      END_STATE();
    case 549:
      if (lookahead == 'i') ADVANCE(559);
      END_STATE();
    case 550:
      if (lookahead == 'e') ADVANCE(560);
      END_STATE();
    case 551:
      ACCEPT_TOKEN(anon_sym_unsignedShort);
      END_STATE();
    case 552:
      if (lookahead == 't') ADVANCE(561);
      END_STATE();
    case 553:
      if (lookahead == 'n') ADVANCE(562);
      END_STATE();
    case 554:
      if (lookahead == 'n') ADVANCE(563);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(anon_sym_fractionDigits);
      END_STATE();
    case 556:
      if (lookahead == 'r') ADVANCE(564);
      END_STATE();
    case 557:
      if (lookahead == 'e') ADVANCE(565);
      END_STATE();
    case 558:
      if (lookahead == 'e') ADVANCE(566);
      END_STATE();
    case 559:
      if (lookahead == 'n') ADVANCE(567);
      END_STATE();
    case 560:
      if (lookahead == 'r') ADVANCE(568);
      END_STATE();
    case 561:
      if (lookahead == 'i') ADVANCE(569);
      END_STATE();
    case 562:
      ACCEPT_TOKEN(anon_sym_dayTimeDuration);
      END_STATE();
    case 563:
      if (lookahead == 'e') ADVANCE(570);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(anon_sym_negativeInteger);
      END_STATE();
    case 565:
      if (lookahead == 'g') ADVANCE(571);
      END_STATE();
    case 566:
      if (lookahead == 'g') ADVANCE(572);
      END_STATE();
    case 567:
      if (lookahead == 'g') ADVANCE(573);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(anon_sym_positiveInteger);
      END_STATE();
    case 569:
      if (lookahead == 'o') ADVANCE(574);
      END_STATE();
    case 570:
      ACCEPT_TOKEN(anon_sym_explicitTimezone);
      END_STATE();
    case 571:
      if (lookahead == 'e') ADVANCE(575);
      END_STATE();
    case 572:
      if (lookahead == 'e') ADVANCE(576);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(anon_sym_normalizedString);
      END_STATE();
    case 574:
      if (lookahead == 'n') ADVANCE(577);
      END_STATE();
    case 575:
      if (lookahead == 'r') ADVANCE(578);
      END_STATE();
    case 576:
      if (lookahead == 'r') ADVANCE(579);
      END_STATE();
    case 577:
      ACCEPT_TOKEN(anon_sym_yearMonthDuration);
      END_STATE();
    case 578:
      ACCEPT_TOKEN(anon_sym_nonNegativeInteger);
      END_STATE();
    case 579:
      ACCEPT_TOKEN(anon_sym_nonPositiveInteger);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 6},
  [2] = {.lex_state = 6},
  [3] = {.lex_state = 6},
  [4] = {.lex_state = 9},
  [5] = {.lex_state = 6},
  [6] = {.lex_state = 6},
  [7] = {.lex_state = 6},
  [8] = {.lex_state = 6},
  [9] = {.lex_state = 6},
  [10] = {.lex_state = 6},
  [11] = {.lex_state = 6},
  [12] = {.lex_state = 6},
  [13] = {.lex_state = 6},
  [14] = {.lex_state = 6},
  [15] = {.lex_state = 6},
  [16] = {.lex_state = 6},
  [17] = {.lex_state = 6},
  [18] = {.lex_state = 6},
  [19] = {.lex_state = 1},
  [20] = {.lex_state = 1},
  [21] = {.lex_state = 1},
  [22] = {.lex_state = 1},
  [23] = {.lex_state = 1},
  [24] = {.lex_state = 1},
  [25] = {.lex_state = 6},
  [26] = {.lex_state = 1},
  [27] = {.lex_state = 1},
  [28] = {.lex_state = 1},
  [29] = {.lex_state = 1},
  [30] = {.lex_state = 1},
  [31] = {.lex_state = 6},
  [32] = {.lex_state = 6},
  [33] = {.lex_state = 1},
  [34] = {.lex_state = 6},
  [35] = {.lex_state = 6},
  [36] = {.lex_state = 6},
  [37] = {.lex_state = 6},
  [38] = {.lex_state = 6},
  [39] = {.lex_state = 6},
  [40] = {.lex_state = 6},
  [41] = {.lex_state = 6},
  [42] = {.lex_state = 6},
  [43] = {.lex_state = 6},
  [44] = {.lex_state = 6},
  [45] = {.lex_state = 6},
  [46] = {.lex_state = 1},
  [47] = {.lex_state = 1},
  [48] = {.lex_state = 1},
  [49] = {.lex_state = 1},
  [50] = {.lex_state = 1},
  [51] = {.lex_state = 1},
  [52] = {.lex_state = 1},
  [53] = {.lex_state = 6},
  [54] = {.lex_state = 1},
  [55] = {.lex_state = 1},
  [56] = {.lex_state = 1},
  [57] = {.lex_state = 1},
  [58] = {.lex_state = 1},
  [59] = {.lex_state = 6},
  [60] = {.lex_state = 1},
  [61] = {.lex_state = 1},
  [62] = {.lex_state = 1},
  [63] = {.lex_state = 1},
  [64] = {.lex_state = 1},
  [65] = {.lex_state = 1},
  [66] = {.lex_state = 6},
  [67] = {.lex_state = 1},
  [68] = {.lex_state = 1},
  [69] = {.lex_state = 1},
  [70] = {.lex_state = 1},
  [71] = {.lex_state = 1},
  [72] = {.lex_state = 1},
  [73] = {.lex_state = 1},
  [74] = {.lex_state = 1},
  [75] = {.lex_state = 6},
  [76] = {.lex_state = 6},
  [77] = {.lex_state = 6},
  [78] = {.lex_state = 6},
  [79] = {.lex_state = 1},
  [80] = {.lex_state = 1},
  [81] = {.lex_state = 1},
  [82] = {.lex_state = 6},
  [83] = {.lex_state = 6},
  [84] = {.lex_state = 6},
  [85] = {.lex_state = 6},
  [86] = {.lex_state = 6},
  [87] = {.lex_state = 6},
  [88] = {.lex_state = 6},
  [89] = {.lex_state = 6},
  [90] = {.lex_state = 6},
  [91] = {.lex_state = 6},
  [92] = {.lex_state = 6},
  [93] = {.lex_state = 6},
  [94] = {.lex_state = 6},
  [95] = {.lex_state = 6},
  [96] = {.lex_state = 6},
  [97] = {.lex_state = 1},
  [98] = {.lex_state = 1},
  [99] = {.lex_state = 1},
  [100] = {.lex_state = 1},
  [101] = {.lex_state = 1},
  [102] = {.lex_state = 1},
  [103] = {.lex_state = 1},
  [104] = {.lex_state = 6},
  [105] = {.lex_state = 1},
  [106] = {.lex_state = 6},
  [107] = {.lex_state = 1},
  [108] = {.lex_state = 1},
  [109] = {.lex_state = 1},
  [110] = {.lex_state = 1},
  [111] = {.lex_state = 1},
  [112] = {.lex_state = 1},
  [113] = {.lex_state = 1},
  [114] = {.lex_state = 1},
  [115] = {.lex_state = 6},
  [116] = {.lex_state = 6},
  [117] = {.lex_state = 6},
  [118] = {.lex_state = 6},
  [119] = {.lex_state = 1},
  [120] = {.lex_state = 1},
  [121] = {.lex_state = 1},
  [122] = {.lex_state = 2},
  [123] = {.lex_state = 1},
  [124] = {.lex_state = 1},
  [125] = {.lex_state = 1},
  [126] = {.lex_state = 6},
  [127] = {.lex_state = 1},
  [128] = {.lex_state = 6},
  [129] = {.lex_state = 1},
  [130] = {.lex_state = 1},
  [131] = {.lex_state = 1},
  [132] = {.lex_state = 1},
  [133] = {.lex_state = 1},
  [134] = {.lex_state = 6},
  [135] = {.lex_state = 6},
  [136] = {.lex_state = 6},
  [137] = {.lex_state = 6},
  [138] = {.lex_state = 1},
  [139] = {.lex_state = 6},
  [140] = {.lex_state = 6},
  [141] = {.lex_state = 6},
  [142] = {.lex_state = 6},
  [143] = {.lex_state = 6},
  [144] = {.lex_state = 1},
  [145] = {.lex_state = 1},
  [146] = {.lex_state = 1},
  [147] = {.lex_state = 1},
  [148] = {.lex_state = 1},
  [149] = {.lex_state = 1},
  [150] = {.lex_state = 1},
  [151] = {.lex_state = 1},
  [152] = {.lex_state = 1},
  [153] = {.lex_state = 1},
  [154] = {.lex_state = 1},
  [155] = {.lex_state = 1},
  [156] = {.lex_state = 1},
  [157] = {.lex_state = 6},
  [158] = {.lex_state = 6},
  [159] = {.lex_state = 1},
  [160] = {.lex_state = 1},
  [161] = {.lex_state = 6},
  [162] = {.lex_state = 1},
  [163] = {.lex_state = 6},
  [164] = {.lex_state = 10},
  [165] = {.lex_state = 6},
  [166] = {.lex_state = 6},
  [167] = {.lex_state = 1},
  [168] = {.lex_state = 6},
  [169] = {.lex_state = 6},
  [170] = {.lex_state = 1},
  [171] = {.lex_state = 6},
  [172] = {.lex_state = 1},
  [173] = {.lex_state = 6},
  [174] = {.lex_state = 6},
  [175] = {.lex_state = 6},
  [176] = {.lex_state = 6},
  [177] = {.lex_state = 6},
  [178] = {.lex_state = 6},
  [179] = {.lex_state = 6},
  [180] = {.lex_state = 6},
  [181] = {.lex_state = 6},
  [182] = {.lex_state = 6},
  [183] = {.lex_state = 6},
  [184] = {.lex_state = 6},
  [185] = {.lex_state = 6},
  [186] = {.lex_state = 6},
  [187] = {.lex_state = 6},
  [188] = {.lex_state = 6},
  [189] = {.lex_state = 6},
  [190] = {.lex_state = 1},
  [191] = {.lex_state = 6},
  [192] = {.lex_state = 1},
  [193] = {.lex_state = 6},
  [194] = {.lex_state = 1},
  [195] = {.lex_state = 1},
  [196] = {.lex_state = 6},
  [197] = {.lex_state = 1},
  [198] = {.lex_state = 1},
  [199] = {.lex_state = 6},
  [200] = {.lex_state = 6},
  [201] = {.lex_state = 6},
  [202] = {.lex_state = 6},
  [203] = {.lex_state = 6},
  [204] = {.lex_state = 6},
  [205] = {.lex_state = 6},
  [206] = {.lex_state = 6},
  [207] = {.lex_state = 6},
  [208] = {.lex_state = 6},
  [209] = {.lex_state = 6},
  [210] = {.lex_state = 6},
  [211] = {.lex_state = 6},
  [212] = {.lex_state = 6},
  [213] = {.lex_state = 1},
  [214] = {.lex_state = 6},
  [215] = {.lex_state = 6},
  [216] = {.lex_state = 6},
  [217] = {.lex_state = 6},
  [218] = {.lex_state = 6},
  [219] = {.lex_state = 6},
  [220] = {.lex_state = 6},
  [221] = {.lex_state = 6},
  [222] = {.lex_state = 6},
  [223] = {.lex_state = 6},
  [224] = {.lex_state = 1},
  [225] = {.lex_state = 6},
  [226] = {.lex_state = 6},
  [227] = {.lex_state = 6},
  [228] = {.lex_state = 6},
  [229] = {.lex_state = 6},
  [230] = {.lex_state = 6},
  [231] = {.lex_state = 6},
  [232] = {.lex_state = 6},
  [233] = {.lex_state = 6},
  [234] = {.lex_state = 6},
  [235] = {.lex_state = 6},
  [236] = {.lex_state = 6},
  [237] = {.lex_state = 6},
  [238] = {.lex_state = 6},
  [239] = {.lex_state = 6},
  [240] = {.lex_state = 6},
  [241] = {.lex_state = 6},
  [242] = {.lex_state = 6},
  [243] = {.lex_state = 6},
  [244] = {.lex_state = 6},
  [245] = {.lex_state = 6},
  [246] = {.lex_state = 6},
  [247] = {.lex_state = 6},
  [248] = {.lex_state = 6},
  [249] = {.lex_state = 6},
  [250] = {.lex_state = 6},
  [251] = {.lex_state = 6},
  [252] = {.lex_state = 6},
  [253] = {.lex_state = 6},
  [254] = {.lex_state = 6},
  [255] = {.lex_state = 6},
  [256] = {.lex_state = 6},
  [257] = {.lex_state = 6},
  [258] = {.lex_state = 6},
  [259] = {.lex_state = 6},
  [260] = {.lex_state = 6},
  [261] = {.lex_state = 6},
  [262] = {.lex_state = 6},
  [263] = {.lex_state = 6},
  [264] = {.lex_state = 6},
  [265] = {.lex_state = 6},
  [266] = {.lex_state = 6},
  [267] = {.lex_state = 6},
  [268] = {.lex_state = 6},
  [269] = {.lex_state = 6},
  [270] = {.lex_state = 6},
  [271] = {.lex_state = 6},
  [272] = {.lex_state = 6},
  [273] = {.lex_state = 6},
  [274] = {.lex_state = 6},
  [275] = {.lex_state = 6},
  [276] = {.lex_state = 6},
  [277] = {.lex_state = 6},
  [278] = {.lex_state = 6},
  [279] = {.lex_state = 6},
  [280] = {.lex_state = 6},
  [281] = {.lex_state = 6},
  [282] = {.lex_state = 6},
  [283] = {.lex_state = 6},
  [284] = {.lex_state = 6},
  [285] = {.lex_state = 6},
  [286] = {.lex_state = 6},
  [287] = {.lex_state = 6},
  [288] = {.lex_state = 6},
  [289] = {.lex_state = 6},
  [290] = {.lex_state = 6},
  [291] = {.lex_state = 6},
  [292] = {.lex_state = 6},
  [293] = {.lex_state = 6},
  [294] = {.lex_state = 6},
  [295] = {.lex_state = 6},
  [296] = {.lex_state = 6},
  [297] = {.lex_state = 6},
  [298] = {.lex_state = 6},
  [299] = {.lex_state = 6},
  [300] = {.lex_state = 6},
  [301] = {.lex_state = 6},
  [302] = {.lex_state = 6},
  [303] = {.lex_state = 6},
  [304] = {.lex_state = 6},
  [305] = {.lex_state = 6},
  [306] = {.lex_state = 6},
  [307] = {.lex_state = 6},
  [308] = {.lex_state = 6},
  [309] = {.lex_state = 6},
  [310] = {.lex_state = 6},
  [311] = {.lex_state = 6},
  [312] = {.lex_state = 6},
  [313] = {.lex_state = 6},
  [314] = {.lex_state = 6},
  [315] = {.lex_state = 6},
  [316] = {.lex_state = 6},
  [317] = {.lex_state = 6},
  [318] = {.lex_state = 6},
  [319] = {.lex_state = 6},
  [320] = {.lex_state = 6},
  [321] = {.lex_state = 6},
  [322] = {.lex_state = 6},
  [323] = {.lex_state = 6},
  [324] = {.lex_state = 6},
  [325] = {.lex_state = 6},
  [326] = {.lex_state = 6},
  [327] = {.lex_state = 6},
  [328] = {.lex_state = 6},
  [329] = {.lex_state = 6},
  [330] = {.lex_state = 6},
  [331] = {.lex_state = 6},
  [332] = {.lex_state = 6},
  [333] = {.lex_state = 6},
  [334] = {.lex_state = 6},
  [335] = {.lex_state = 6},
  [336] = {.lex_state = 6},
  [337] = {.lex_state = 6},
  [338] = {.lex_state = 6},
  [339] = {.lex_state = 6},
  [340] = {.lex_state = 6},
  [341] = {.lex_state = 6},
  [342] = {.lex_state = 6},
  [343] = {.lex_state = 6},
  [344] = {.lex_state = 6},
  [345] = {.lex_state = 6},
  [346] = {.lex_state = 6},
  [347] = {.lex_state = 6},
  [348] = {.lex_state = 6},
  [349] = {.lex_state = 6},
  [350] = {.lex_state = 6},
  [351] = {.lex_state = 6},
  [352] = {.lex_state = 6},
  [353] = {.lex_state = 6},
  [354] = {.lex_state = 6},
  [355] = {.lex_state = 6},
  [356] = {.lex_state = 6},
  [357] = {.lex_state = 6},
  [358] = {.lex_state = 6},
  [359] = {.lex_state = 1},
  [360] = {.lex_state = 6},
  [361] = {.lex_state = 6},
  [362] = {.lex_state = 6},
  [363] = {.lex_state = 6},
  [364] = {.lex_state = 6},
  [365] = {.lex_state = 6},
  [366] = {.lex_state = 6},
  [367] = {.lex_state = 6},
  [368] = {.lex_state = 6},
  [369] = {.lex_state = 6},
  [370] = {.lex_state = 6},
  [371] = {.lex_state = 6},
  [372] = {.lex_state = 6},
  [373] = {.lex_state = 6},
  [374] = {.lex_state = 6},
  [375] = {.lex_state = 6},
  [376] = {.lex_state = 6},
  [377] = {.lex_state = 6},
  [378] = {.lex_state = 6},
  [379] = {.lex_state = 1},
  [380] = {.lex_state = 6},
  [381] = {.lex_state = 6},
  [382] = {.lex_state = 9},
  [383] = {.lex_state = 0},
  [384] = {.lex_state = 6},
  [385] = {.lex_state = 6},
  [386] = {.lex_state = 6},
  [387] = {.lex_state = 6},
  [388] = {.lex_state = 6},
  [389] = {.lex_state = 6},
  [390] = {.lex_state = 6},
  [391] = {.lex_state = 6},
  [392] = {.lex_state = 6},
  [393] = {.lex_state = 10},
  [394] = {.lex_state = 6},
  [395] = {.lex_state = 6},
  [396] = {.lex_state = 6},
  [397] = {.lex_state = 6},
  [398] = {.lex_state = 6},
  [399] = {.lex_state = 6},
  [400] = {.lex_state = 6},
  [401] = {.lex_state = 6},
  [402] = {.lex_state = 6},
  [403] = {.lex_state = 6},
  [404] = {.lex_state = 6},
  [405] = {.lex_state = 6},
  [406] = {.lex_state = 6},
  [407] = {.lex_state = 0},
  [408] = {.lex_state = 6},
  [409] = {.lex_state = 6},
  [410] = {.lex_state = 6},
  [411] = {.lex_state = 6},
  [412] = {.lex_state = 6},
  [413] = {.lex_state = 6},
  [414] = {.lex_state = 6},
  [415] = {.lex_state = 6},
  [416] = {.lex_state = 6},
  [417] = {.lex_state = 0},
  [418] = {.lex_state = 6},
  [419] = {.lex_state = 6},
  [420] = {.lex_state = 6},
  [421] = {.lex_state = 6},
  [422] = {.lex_state = 6},
  [423] = {.lex_state = 6},
  [424] = {.lex_state = 6},
  [425] = {.lex_state = 6},
  [426] = {.lex_state = 6},
  [427] = {.lex_state = 6},
  [428] = {.lex_state = 6},
  [429] = {.lex_state = 6},
  [430] = {.lex_state = 6},
  [431] = {.lex_state = 0},
  [432] = {.lex_state = 6},
  [433] = {.lex_state = 6},
  [434] = {.lex_state = 6},
  [435] = {.lex_state = 6},
  [436] = {.lex_state = 6},
  [437] = {.lex_state = 0},
  [438] = {.lex_state = 6},
  [439] = {.lex_state = 6},
  [440] = {.lex_state = 6},
  [441] = {.lex_state = 6},
  [442] = {.lex_state = 6},
  [443] = {.lex_state = 6},
  [444] = {.lex_state = 6},
  [445] = {.lex_state = 6},
  [446] = {.lex_state = 0},
  [447] = {.lex_state = 2},
  [448] = {.lex_state = 9},
  [449] = {.lex_state = 6},
  [450] = {.lex_state = 6},
  [451] = {.lex_state = 0},
  [452] = {.lex_state = 0},
  [453] = {.lex_state = 6},
  [454] = {.lex_state = 6},
  [455] = {.lex_state = 6},
  [456] = {.lex_state = 6},
  [457] = {.lex_state = 2},
  [458] = {.lex_state = 10},
  [459] = {.lex_state = 0},
  [460] = {.lex_state = 6},
  [461] = {.lex_state = 1},
  [462] = {.lex_state = 0},
  [463] = {.lex_state = 2},
  [464] = {.lex_state = 22},
  [465] = {.lex_state = 0},
  [466] = {.lex_state = 6},
  [467] = {.lex_state = 0},
  [468] = {.lex_state = 6},
  [469] = {.lex_state = 22},
  [470] = {.lex_state = 0},
  [471] = {.lex_state = 6},
  [472] = {.lex_state = 6},
  [473] = {.lex_state = 6},
  [474] = {.lex_state = 22},
  [475] = {.lex_state = 22},
  [476] = {.lex_state = 2},
  [477] = {.lex_state = 6},
  [478] = {.lex_state = 0},
  [479] = {.lex_state = 2},
  [480] = {.lex_state = 6},
  [481] = {.lex_state = 22},
  [482] = {.lex_state = 6},
  [483] = {.lex_state = 6},
  [484] = {.lex_state = 6},
  [485] = {.lex_state = 6},
  [486] = {.lex_state = 6},
  [487] = {.lex_state = 6},
  [488] = {.lex_state = 6},
  [489] = {.lex_state = 2},
  [490] = {.lex_state = 6},
  [491] = {.lex_state = 6},
  [492] = {.lex_state = 6},
  [493] = {.lex_state = 6},
  [494] = {.lex_state = 6},
  [495] = {.lex_state = 0},
  [496] = {.lex_state = 6},
  [497] = {.lex_state = 0},
  [498] = {.lex_state = 6},
  [499] = {.lex_state = 6},
  [500] = {.lex_state = 6},
  [501] = {.lex_state = 6},
  [502] = {.lex_state = 6},
  [503] = {.lex_state = 22},
  [504] = {.lex_state = 0},
  [505] = {.lex_state = 6},
  [506] = {.lex_state = 6},
  [507] = {.lex_state = 6},
  [508] = {.lex_state = 6},
  [509] = {.lex_state = 0},
  [510] = {.lex_state = 6},
  [511] = {.lex_state = 6},
  [512] = {.lex_state = 6},
  [513] = {.lex_state = 1},
  [514] = {.lex_state = 6},
  [515] = {.lex_state = 0},
  [516] = {.lex_state = 6},
  [517] = {.lex_state = 0},
  [518] = {.lex_state = 6},
  [519] = {.lex_state = 0},
  [520] = {.lex_state = 6},
  [521] = {.lex_state = 0},
  [522] = {.lex_state = 0},
  [523] = {.lex_state = 6},
  [524] = {.lex_state = 0},
  [525] = {.lex_state = 0},
  [526] = {.lex_state = 6},
  [527] = {.lex_state = 6},
  [528] = {.lex_state = 6},
  [529] = {.lex_state = 6},
  [530] = {.lex_state = 6},
  [531] = {.lex_state = 6},
  [532] = {.lex_state = 0},
  [533] = {.lex_state = 6},
  [534] = {.lex_state = 0},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 6},
  [538] = {.lex_state = 6},
  [539] = {.lex_state = 6},
  [540] = {.lex_state = 0},
  [541] = {.lex_state = 6},
  [542] = {.lex_state = 6},
  [543] = {.lex_state = 0},
  [544] = {.lex_state = 0},
  [545] = {.lex_state = 0},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 118},
  [548] = {.lex_state = 6},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 0},
  [551] = {.lex_state = 0},
  [552] = {.lex_state = 0},
  [553] = {.lex_state = 6},
  [554] = {.lex_state = 0},
  [555] = {.lex_state = 1},
  [556] = {.lex_state = 6},
  [557] = {.lex_state = 0},
  [558] = {.lex_state = 0},
  [559] = {.lex_state = 6},
  [560] = {.lex_state = 0},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 0},
  [563] = {.lex_state = 0},
  [564] = {.lex_state = 6},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 0},
  [567] = {.lex_state = 6},
  [568] = {.lex_state = 6},
  [569] = {.lex_state = 0},
  [570] = {.lex_state = 0},
  [571] = {.lex_state = 6},
  [572] = {.lex_state = 0},
  [573] = {.lex_state = 6},
  [574] = {.lex_state = 1},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 118},
  [577] = {.lex_state = 0},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 6},
  [580] = {.lex_state = 0},
  [581] = {.lex_state = 6},
  [582] = {.lex_state = 6},
  [583] = {.lex_state = 6},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_module] = ACTIONS(1),
    [anon_sym_version] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_end] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_COLON_COLON] = ACTIONS(1),
    [anon_sym_COLON_COLON2] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_assert] = ACTIONS(1),
    [sym_controlled_language_tag] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [sym_reserved_self] = ACTIONS(1),
    [anon_sym_with] = ACTIONS(1),
    [anon_sym_def] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [sym_quoted_string] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_POUND_LBRACK] = ACTIONS(1),
    [sym_hex_byte] = ACTIONS(1),
    [sym_double] = ACTIONS(1),
    [sym_decimal] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [sym_rational] = ACTIONS(1),
    [sym_unsigned] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_u22a4] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_u22a5] = ACTIONS(1),
    [anon_sym_Thing] = ACTIONS(1),
    [anon_sym_Nothing] = ACTIONS(1),
    [anon_sym_real] = ACTIONS(1),
    [anon_sym_rational] = ACTIONS(1),
    [anon_sym_anyURI] = ACTIONS(1),
    [anon_sym_iri] = ACTIONS(1),
    [anon_sym_base64Binary] = ACTIONS(1),
    [anon_sym_boolean] = ACTIONS(1),
    [anon_sym_date] = ACTIONS(1),
    [anon_sym_dateTime] = ACTIONS(1),
    [anon_sym_decimal] = ACTIONS(1),
    [anon_sym_double] = ACTIONS(1),
    [anon_sym_duration] = ACTIONS(1),
    [anon_sym_float] = ACTIONS(1),
    [anon_sym_gDay] = ACTIONS(1),
    [anon_sym_gMonth] = ACTIONS(1),
    [anon_sym_gMonthDay] = ACTIONS(1),
    [anon_sym_gYearMonth] = ACTIONS(1),
    [anon_sym_gYear] = ACTIONS(1),
    [anon_sym_hexBinary] = ACTIONS(1),
    [anon_sym_binary] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_time] = ACTIONS(1),
    [anon_sym_dateTimeStamp] = ACTIONS(1),
    [anon_sym_dayTimeDuration] = ACTIONS(1),
    [anon_sym_yearMonthDuration] = ACTIONS(1),
    [anon_sym_integer] = ACTIONS(1),
    [anon_sym_long] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_short] = ACTIONS(1),
    [anon_sym_byte] = ACTIONS(1),
    [anon_sym_nonNegativeInteger] = ACTIONS(1),
    [anon_sym_positiveInteger] = ACTIONS(1),
    [anon_sym_unsignedLong] = ACTIONS(1),
    [anon_sym_unsignedInt] = ACTIONS(1),
    [anon_sym_unsigned] = ACTIONS(1),
    [anon_sym_unsignedShort] = ACTIONS(1),
    [anon_sym_unsignedByte] = ACTIONS(1),
    [anon_sym_nonPositiveInteger] = ACTIONS(1),
    [anon_sym_negativeInteger] = ACTIONS(1),
    [anon_sym_normalizedString] = ACTIONS(1),
    [anon_sym_token] = ACTIONS(1),
    [anon_sym_language] = ACTIONS(1),
    [anon_sym_without] = ACTIONS(1),
    [anon_sym_datatype] = ACTIONS(1),
    [sym_opaque] = ACTIONS(1),
    [anon_sym_length] = ACTIONS(1),
    [anon_sym_maxLength] = ACTIONS(1),
    [anon_sym_minLength] = ACTIONS(1),
    [anon_sym_fractionDigits] = ACTIONS(1),
    [anon_sym_totalDigits] = ACTIONS(1),
    [anon_sym_maxExclusive] = ACTIONS(1),
    [anon_sym_maxInclusive] = ACTIONS(1),
    [anon_sym_minExclusive] = ACTIONS(1),
    [anon_sym_minInclusive] = ACTIONS(1),
    [anon_sym_explicitTimezone] = ACTIONS(1),
    [anon_sym_required] = ACTIONS(1),
    [anon_sym_prohibited] = ACTIONS(1),
    [anon_sym_optional] = ACTIONS(1),
    [anon_sym_pattern] = ACTIONS(1),
    [sym_kw_is_fixed] = ACTIONS(1),
    [anon_sym_dimension] = ACTIONS(1),
    [anon_sym_source] = ACTIONS(1),
    [anon_sym_parent] = ACTIONS(1),
    [anon_sym_entity] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_of] = ACTIONS(1),
    [anon_sym_event] = ACTIONS(1),
    [anon_sym_property] = ACTIONS(1),
    [anon_sym_rdf] = ACTIONS(1),
    [anon_sym_a] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_structure] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [sym_wildcard] = ACTIONS(1),
    [anon_sym_union] = ACTIONS(1),
    [anon_sym_identity] = ACTIONS(1),
    [anon_sym_ref] = ACTIONS(1),
    [sym_unknown_type] = ACTIONS(1),
    [anon_sym_ordered] = ACTIONS(1),
    [anon_sym_unordered] = ACTIONS(1),
    [anon_sym_unique] = ACTIONS(1),
    [anon_sym_nonunique] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_u2260] = ACTIONS(1),
    [sym_op_less_than] = ACTIONS(1),
    [sym_op_greater_than] = ACTIONS(1),
    [anon_sym_u2264] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_u2265] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_u00ac] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_u2227] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_u2228] = ACTIONS(1),
    [anon_sym_xor] = ACTIONS(1),
    [anon_sym_u22bb] = ACTIONS(1),
    [anon_sym_implies] = ACTIONS(1),
    [anon_sym_EQ_EQ_GT] = ACTIONS(1),
    [anon_sym_u21d2] = ACTIONS(1),
    [anon_sym_iff] = ACTIONS(1),
    [anon_sym_u21d4] = ACTIONS(1),
    [anon_sym_forall] = ACTIONS(1),
    [anon_sym_u2200] = ACTIONS(1),
    [anon_sym_exists] = ACTIONS(1),
    [anon_sym_u2203] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_u2208] = ACTIONS(1),
    [sym_set_op_builder] = ACTIONS(1),
    [anon_sym_u00b7] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_u2254] = ACTIONS(1),
    [anon_sym_u2192] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_u2190] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_u2295] = ACTIONS(1),
    [anon_sym_u2205] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_module] = STATE(544),
    [anon_sym_module] = ACTIONS(5),
    [sym_line_comment] = ACTIONS(3),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 7,
      anon_sym_as,
      sym_identifier,
      anon_sym_EQ,
      anon_sym_with,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(9), 54,
      anon_sym_is,
      anon_sym_end,
      anon_sym_import,
      anon_sym_RBRACK,
      anon_sym_from,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_without,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_u2208,
      sym_set_op_builder,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
      anon_sym_u2192,
      anon_sym_DASH_GT,
      anon_sym_PLUS,
      anon_sym_u2295,
  [69] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(11), 6,
      anon_sym_as,
      sym_identifier,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(13), 55,
      anon_sym_version,
      anon_sym_is,
      anon_sym_end,
      anon_sym_import,
      anon_sym_from,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [138] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(19), 1,
      sym_language_tag,
    ACTIONS(15), 6,
      sym_identifier,
      anon_sym_AT,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(17), 51,
      anon_sym_is,
      anon_sym_end,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [206] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(21), 6,
      sym_identifier,
      anon_sym_EQ,
      anon_sym_with,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(23), 52,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_without,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_in,
      anon_sym_u2208,
      sym_set_op_builder,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
      anon_sym_u2192,
      anon_sym_DASH_GT,
      anon_sym_PLUS,
      anon_sym_u2295,
  [272] = 12,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(25), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(29), 1,
      anon_sym_LBRACE,
    ACTIONS(35), 1,
      sym_unknown_type,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(16), 1,
      sym_cardinality_expression,
    STATE(211), 1,
      sym_type_reference,
    STATE(177), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    STATE(128), 5,
      sym__owl_builtin_types,
      sym__builtin_primitive_datatypes,
      sym__derived_date_datetypes,
      sym__derived_numeric_datatypes,
      sym__derived_string_datatypes,
    ACTIONS(33), 6,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(31), 37,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
  [356] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(37), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(39), 52,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [421] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(41), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(43), 52,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [486] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(45), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(47), 52,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [551] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(49), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(51), 52,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [616] = 11,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(25), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(18), 1,
      sym_cardinality_reference_expression,
    STATE(345), 1,
      sym_function_type_reference,
    STATE(344), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    STATE(128), 5,
      sym__owl_builtin_types,
      sym__builtin_primitive_datatypes,
      sym__derived_date_datetypes,
      sym__derived_numeric_datatypes,
      sym__derived_string_datatypes,
    ACTIONS(33), 6,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(31), 37,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
  [697] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(55), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(57), 52,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [762] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(59), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(61), 52,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [827] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(63), 5,
      sym_identifier,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(65), 52,
      anon_sym_is,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_datatype,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [892] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(25), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_unknown_type,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(446), 1,
      sym_type_reference,
    STATE(177), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    STATE(128), 5,
      sym__owl_builtin_types,
      sym__builtin_primitive_datatypes,
      sym__derived_date_datetypes,
      sym__derived_numeric_datatypes,
      sym__derived_string_datatypes,
    ACTIONS(33), 6,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(31), 37,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
  [970] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(25), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_unknown_type,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(209), 1,
      sym_type_reference,
    STATE(177), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    STATE(128), 5,
      sym__owl_builtin_types,
      sym__builtin_primitive_datatypes,
      sym__derived_date_datetypes,
      sym__derived_numeric_datatypes,
      sym__derived_string_datatypes,
    ACTIONS(33), 6,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(31), 37,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
  [1048] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(25), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    ACTIONS(35), 1,
      sym_unknown_type,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(552), 1,
      sym_type_reference,
    STATE(177), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    STATE(128), 5,
      sym__owl_builtin_types,
      sym__builtin_primitive_datatypes,
      sym__derived_date_datetypes,
      sym__derived_numeric_datatypes,
      sym__derived_string_datatypes,
    ACTIONS(33), 6,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(31), 37,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
  [1126] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(25), 1,
      sym_identifier,
    ACTIONS(27), 1,
      anon_sym_LPAREN,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(341), 1,
      sym_function_type_reference,
    STATE(344), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym_mapping_type,
    STATE(128), 5,
      sym__owl_builtin_types,
      sym__builtin_primitive_datatypes,
      sym__derived_date_datetypes,
      sym__derived_numeric_datatypes,
      sym__derived_string_datatypes,
    ACTIONS(33), 6,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(31), 37,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
  [1201] = 34,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(71), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym_reserved_self,
    ACTIONS(75), 1,
      anon_sym_LBRACE,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(97), 1,
      anon_sym_u2205,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(29), 1,
      sym_logical_op_negation,
    STATE(95), 1,
      sym__value_empty_sequence,
    STATE(137), 1,
      sym_constraint_sentence,
    STATE(182), 1,
      sym_term,
    STATE(184), 1,
      sym_simple_sentence,
    STATE(187), 1,
      sym_boolean_sentence,
    STATE(189), 1,
      sym_quantified_sentence,
    STATE(470), 1,
      sym__sequence_value_constraints,
    STATE(578), 1,
      sym_quantified_variable_binding,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    ACTIONS(91), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(93), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(95), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(94), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(188), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(473), 2,
      sym_logical_quantifier_universal,
      sym_logical_quantifier_existential,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(185), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(93), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [1325] = 34,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(71), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym_reserved_self,
    ACTIONS(75), 1,
      anon_sym_LBRACE,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(97), 1,
      anon_sym_u2205,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(27), 1,
      sym_logical_op_negation,
    STATE(95), 1,
      sym__value_empty_sequence,
    STATE(140), 1,
      sym_constraint_sentence,
    STATE(184), 1,
      sym_simple_sentence,
    STATE(187), 1,
      sym_boolean_sentence,
    STATE(189), 1,
      sym_quantified_sentence,
    STATE(226), 1,
      sym_term,
    STATE(470), 1,
      sym__sequence_value_constraints,
    STATE(545), 1,
      sym_quantified_variable_binding,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    ACTIONS(91), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(93), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(95), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(94), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(188), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(473), 2,
      sym_logical_quantifier_universal,
      sym_logical_quantifier_existential,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(185), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(93), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [1449] = 34,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(71), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym_reserved_self,
    ACTIONS(75), 1,
      anon_sym_LBRACE,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(97), 1,
      anon_sym_u2205,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(27), 1,
      sym_logical_op_negation,
    STATE(95), 1,
      sym__value_empty_sequence,
    STATE(169), 1,
      sym_constraint_sentence,
    STATE(184), 1,
      sym_simple_sentence,
    STATE(187), 1,
      sym_boolean_sentence,
    STATE(189), 1,
      sym_quantified_sentence,
    STATE(226), 1,
      sym_term,
    STATE(470), 1,
      sym__sequence_value_constraints,
    STATE(545), 1,
      sym_quantified_variable_binding,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    ACTIONS(91), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(93), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(95), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(94), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(188), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(473), 2,
      sym_logical_quantifier_universal,
      sym_logical_quantifier_existential,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(185), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(93), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [1573] = 34,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(71), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym_reserved_self,
    ACTIONS(75), 1,
      anon_sym_LBRACE,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(97), 1,
      anon_sym_u2205,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(27), 1,
      sym_logical_op_negation,
    STATE(95), 1,
      sym__value_empty_sequence,
    STATE(166), 1,
      sym_constraint_sentence,
    STATE(184), 1,
      sym_simple_sentence,
    STATE(187), 1,
      sym_boolean_sentence,
    STATE(189), 1,
      sym_quantified_sentence,
    STATE(226), 1,
      sym_term,
    STATE(470), 1,
      sym__sequence_value_constraints,
    STATE(545), 1,
      sym_quantified_variable_binding,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    ACTIONS(91), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(93), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(95), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(94), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(188), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(473), 2,
      sym_logical_quantifier_universal,
      sym_logical_quantifier_existential,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(185), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(93), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [1697] = 34,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(71), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym_reserved_self,
    ACTIONS(75), 1,
      anon_sym_LBRACE,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(97), 1,
      anon_sym_u2205,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(27), 1,
      sym_logical_op_negation,
    STATE(95), 1,
      sym__value_empty_sequence,
    STATE(136), 1,
      sym_constraint_sentence,
    STATE(184), 1,
      sym_simple_sentence,
    STATE(187), 1,
      sym_boolean_sentence,
    STATE(189), 1,
      sym_quantified_sentence,
    STATE(226), 1,
      sym_term,
    STATE(470), 1,
      sym__sequence_value_constraints,
    STATE(545), 1,
      sym_quantified_variable_binding,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    ACTIONS(91), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(93), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(95), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(94), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(188), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(473), 2,
      sym_logical_quantifier_universal,
      sym_logical_quantifier_existential,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(185), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(93), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [1821] = 34,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(71), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym_reserved_self,
    ACTIONS(75), 1,
      anon_sym_LBRACE,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(97), 1,
      anon_sym_u2205,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(29), 1,
      sym_logical_op_negation,
    STATE(95), 1,
      sym__value_empty_sequence,
    STATE(137), 1,
      sym_constraint_sentence,
    STATE(184), 1,
      sym_simple_sentence,
    STATE(187), 1,
      sym_boolean_sentence,
    STATE(189), 1,
      sym_quantified_sentence,
    STATE(200), 1,
      sym_term,
    STATE(470), 1,
      sym__sequence_value_constraints,
    STATE(578), 1,
      sym_quantified_variable_binding,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    ACTIONS(91), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(93), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(95), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(94), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(188), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(473), 2,
      sym_logical_quantifier_universal,
      sym_logical_quantifier_existential,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(185), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(93), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [1945] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(25), 1,
      sym_identifier,
    ACTIONS(99), 1,
      sym_opaque,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(219), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym__datatype_base,
    STATE(128), 5,
      sym__owl_builtin_types,
      sym__builtin_primitive_datatypes,
      sym__derived_date_datetypes,
      sym__derived_numeric_datatypes,
      sym__derived_string_datatypes,
    ACTIONS(33), 6,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(31), 37,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
  [2017] = 34,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(71), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym_reserved_self,
    ACTIONS(75), 1,
      anon_sym_LBRACE,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(97), 1,
      anon_sym_u2205,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(27), 1,
      sym_logical_op_negation,
    STATE(95), 1,
      sym__value_empty_sequence,
    STATE(165), 1,
      sym_constraint_sentence,
    STATE(184), 1,
      sym_simple_sentence,
    STATE(187), 1,
      sym_boolean_sentence,
    STATE(189), 1,
      sym_quantified_sentence,
    STATE(226), 1,
      sym_term,
    STATE(470), 1,
      sym__sequence_value_constraints,
    STATE(545), 1,
      sym_quantified_variable_binding,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    ACTIONS(91), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(93), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(95), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(94), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(188), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(473), 2,
      sym_logical_quantifier_universal,
      sym_logical_quantifier_existential,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(185), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(93), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [2141] = 34,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(71), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym_reserved_self,
    ACTIONS(75), 1,
      anon_sym_LBRACE,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(97), 1,
      anon_sym_u2205,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(27), 1,
      sym_logical_op_negation,
    STATE(95), 1,
      sym__value_empty_sequence,
    STATE(141), 1,
      sym_constraint_sentence,
    STATE(184), 1,
      sym_simple_sentence,
    STATE(187), 1,
      sym_boolean_sentence,
    STATE(189), 1,
      sym_quantified_sentence,
    STATE(226), 1,
      sym_term,
    STATE(470), 1,
      sym__sequence_value_constraints,
    STATE(545), 1,
      sym_quantified_variable_binding,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    ACTIONS(91), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(93), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(95), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(94), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(188), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(473), 2,
      sym_logical_quantifier_universal,
      sym_logical_quantifier_existential,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(185), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(93), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [2265] = 34,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(71), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym_reserved_self,
    ACTIONS(75), 1,
      anon_sym_LBRACE,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(97), 1,
      anon_sym_u2205,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(29), 1,
      sym_logical_op_negation,
    STATE(95), 1,
      sym__value_empty_sequence,
    STATE(143), 1,
      sym_constraint_sentence,
    STATE(184), 1,
      sym_simple_sentence,
    STATE(187), 1,
      sym_boolean_sentence,
    STATE(189), 1,
      sym_quantified_sentence,
    STATE(225), 1,
      sym_term,
    STATE(470), 1,
      sym__sequence_value_constraints,
    STATE(578), 1,
      sym_quantified_variable_binding,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    ACTIONS(91), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(93), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(95), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(94), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(188), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(473), 2,
      sym_logical_quantifier_universal,
      sym_logical_quantifier_existential,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(185), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(93), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [2389] = 34,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(71), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym_reserved_self,
    ACTIONS(75), 1,
      anon_sym_LBRACE,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(97), 1,
      anon_sym_u2205,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(29), 1,
      sym_logical_op_negation,
    STATE(95), 1,
      sym__value_empty_sequence,
    STATE(142), 1,
      sym_constraint_sentence,
    STATE(184), 1,
      sym_simple_sentence,
    STATE(187), 1,
      sym_boolean_sentence,
    STATE(189), 1,
      sym_quantified_sentence,
    STATE(225), 1,
      sym_term,
    STATE(470), 1,
      sym__sequence_value_constraints,
    STATE(578), 1,
      sym_quantified_variable_binding,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    ACTIONS(91), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(93), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(95), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(94), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(188), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(473), 2,
      sym_logical_quantifier_universal,
      sym_logical_quantifier_existential,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(185), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(93), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [2513] = 34,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(71), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym_reserved_self,
    ACTIONS(75), 1,
      anon_sym_LBRACE,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(97), 1,
      anon_sym_u2205,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(29), 1,
      sym_logical_op_negation,
    STATE(95), 1,
      sym__value_empty_sequence,
    STATE(134), 1,
      sym_constraint_sentence,
    STATE(184), 1,
      sym_simple_sentence,
    STATE(187), 1,
      sym_boolean_sentence,
    STATE(189), 1,
      sym_quantified_sentence,
    STATE(225), 1,
      sym_term,
    STATE(470), 1,
      sym__sequence_value_constraints,
    STATE(578), 1,
      sym_quantified_variable_binding,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    ACTIONS(91), 2,
      anon_sym_not,
      anon_sym_u00ac,
    ACTIONS(93), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(95), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(94), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    STATE(188), 2,
      sym_unary_boolean_sentence,
      sym_binary_boolean_sentence,
    STATE(473), 2,
      sym_logical_quantifier_universal,
      sym_logical_quantifier_existential,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(185), 3,
      sym_atomic_sentence,
      sym_equation,
      sym_inequation,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(93), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [2637] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(25), 1,
      sym_identifier,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(210), 3,
      sym_identifier_reference,
      sym_builtin_simple_type,
      sym__datatype_base,
    STATE(128), 5,
      sym__owl_builtin_types,
      sym__builtin_primitive_datatypes,
      sym__derived_date_datetypes,
      sym__derived_numeric_datatypes,
      sym__derived_string_datatypes,
    ACTIONS(33), 6,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(31), 37,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
  [2706] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(101), 7,
      sym_identifier,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(103), 39,
      anon_sym_LPAREN,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
      sym_unknown_type,
  [2760] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(105), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(107), 42,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2205,
  [2814] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(109), 7,
      sym_identifier,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(111), 39,
      anon_sym_LPAREN,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
      sym_unknown_type,
  [2868] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(113), 7,
      sym_identifier,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(115), 39,
      anon_sym_LPAREN,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
      sym_unknown_type,
  [2922] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(117), 7,
      sym_identifier,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(119), 39,
      anon_sym_LPAREN,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
      sym_unknown_type,
  [2976] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(121), 7,
      sym_identifier,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(123), 38,
      anon_sym_LPAREN,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
  [3029] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(125), 7,
      sym_identifier,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(127), 38,
      anon_sym_LPAREN,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
  [3082] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(129), 7,
      sym_identifier,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(131), 38,
      anon_sym_LPAREN,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
  [3135] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(133), 7,
      sym_identifier,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(135), 38,
      anon_sym_LPAREN,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
  [3188] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(137), 7,
      sym_identifier,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(139), 38,
      anon_sym_LPAREN,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
  [3241] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(141), 7,
      sym_identifier,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(143), 38,
      anon_sym_LPAREN,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
  [3294] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(145), 7,
      sym_identifier,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(147), 38,
      anon_sym_LPAREN,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
  [3347] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(149), 7,
      sym_identifier,
      anon_sym_date,
      anon_sym_dateTime,
      anon_sym_gMonth,
      anon_sym_gYear,
      anon_sym_int,
      anon_sym_unsigned,
    ACTIONS(151), 38,
      anon_sym_LPAREN,
      anon_sym_Thing,
      anon_sym_Nothing,
      anon_sym_real,
      anon_sym_rational,
      anon_sym_anyURI,
      anon_sym_iri,
      anon_sym_base64Binary,
      anon_sym_boolean,
      anon_sym_decimal,
      anon_sym_double,
      anon_sym_duration,
      anon_sym_float,
      anon_sym_gDay,
      anon_sym_gMonthDay,
      anon_sym_gYearMonth,
      anon_sym_hexBinary,
      anon_sym_binary,
      anon_sym_string,
      anon_sym_time,
      anon_sym_dateTimeStamp,
      anon_sym_dayTimeDuration,
      anon_sym_yearMonthDuration,
      anon_sym_integer,
      anon_sym_long,
      anon_sym_short,
      anon_sym_byte,
      anon_sym_nonNegativeInteger,
      anon_sym_positiveInteger,
      anon_sym_unsignedLong,
      anon_sym_unsignedInt,
      anon_sym_unsignedShort,
      anon_sym_unsignedByte,
      anon_sym_nonPositiveInteger,
      anon_sym_negativeInteger,
      anon_sym_normalizedString,
      anon_sym_token,
      anon_sym_language,
  [3400] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      anon_sym_COLON,
    ACTIONS(21), 2,
      sym_identifier,
      anon_sym_with,
    ACTIONS(23), 34,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_EQ,
      anon_sym_assert,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_LBRACE,
      anon_sym_without,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_in,
      anon_sym_u2208,
      sym_set_op_builder,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
      anon_sym_u2192,
      anon_sym_DASH_GT,
      anon_sym_PLUS,
      anon_sym_u2295,
  [3447] = 23,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(155), 1,
      sym_identifier,
    ACTIONS(157), 1,
      anon_sym_LBRACK,
    ACTIONS(159), 1,
      anon_sym_RPAREN,
    ACTIONS(161), 1,
      sym_reserved_self,
    ACTIONS(163), 1,
      anon_sym_LBRACE,
    ACTIONS(165), 1,
      sym_quoted_string,
    ACTIONS(167), 1,
      anon_sym_LT,
    ACTIONS(169), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(179), 1,
      anon_sym_u2205,
    STATE(48), 1,
      aux_sym__actual_arguments_repeat1,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(144), 1,
      sym_term,
    STATE(145), 1,
      sym__value_empty_sequence,
    STATE(467), 1,
      sym__sequence_value_constraints,
    ACTIONS(171), 2,
      sym_double,
      sym_rational,
    ACTIONS(175), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(177), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(154), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(173), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(170), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [3531] = 23,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(155), 1,
      sym_identifier,
    ACTIONS(157), 1,
      anon_sym_LBRACK,
    ACTIONS(161), 1,
      sym_reserved_self,
    ACTIONS(163), 1,
      anon_sym_LBRACE,
    ACTIONS(165), 1,
      sym_quoted_string,
    ACTIONS(167), 1,
      anon_sym_LT,
    ACTIONS(169), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(179), 1,
      anon_sym_u2205,
    ACTIONS(181), 1,
      anon_sym_RPAREN,
    STATE(46), 1,
      aux_sym__actual_arguments_repeat1,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(144), 1,
      sym_term,
    STATE(145), 1,
      sym__value_empty_sequence,
    STATE(467), 1,
      sym__sequence_value_constraints,
    ACTIONS(171), 2,
      sym_double,
      sym_rational,
    ACTIONS(175), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(177), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(154), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(173), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(170), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [3615] = 23,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(183), 1,
      sym_identifier,
    ACTIONS(186), 1,
      anon_sym_LBRACK,
    ACTIONS(189), 1,
      anon_sym_RPAREN,
    ACTIONS(191), 1,
      sym_reserved_self,
    ACTIONS(194), 1,
      anon_sym_LBRACE,
    ACTIONS(197), 1,
      sym_quoted_string,
    ACTIONS(200), 1,
      anon_sym_LT,
    ACTIONS(203), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(218), 1,
      anon_sym_u2205,
    STATE(48), 1,
      aux_sym__actual_arguments_repeat1,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(144), 1,
      sym_term,
    STATE(145), 1,
      sym__value_empty_sequence,
    STATE(467), 1,
      sym__sequence_value_constraints,
    ACTIONS(206), 2,
      sym_double,
      sym_rational,
    ACTIONS(212), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(215), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(154), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(209), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(170), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [3699] = 23,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(155), 1,
      sym_identifier,
    ACTIONS(157), 1,
      anon_sym_LBRACK,
    ACTIONS(161), 1,
      sym_reserved_self,
    ACTIONS(163), 1,
      anon_sym_LBRACE,
    ACTIONS(165), 1,
      sym_quoted_string,
    ACTIONS(167), 1,
      anon_sym_LT,
    ACTIONS(169), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(179), 1,
      anon_sym_u2205,
    ACTIONS(221), 1,
      anon_sym_RPAREN,
    STATE(50), 1,
      aux_sym__actual_arguments_repeat1,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(144), 1,
      sym_term,
    STATE(145), 1,
      sym__value_empty_sequence,
    STATE(467), 1,
      sym__sequence_value_constraints,
    ACTIONS(171), 2,
      sym_double,
      sym_rational,
    ACTIONS(175), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(177), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(154), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(173), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(170), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [3783] = 23,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(155), 1,
      sym_identifier,
    ACTIONS(157), 1,
      anon_sym_LBRACK,
    ACTIONS(161), 1,
      sym_reserved_self,
    ACTIONS(163), 1,
      anon_sym_LBRACE,
    ACTIONS(165), 1,
      sym_quoted_string,
    ACTIONS(167), 1,
      anon_sym_LT,
    ACTIONS(169), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(179), 1,
      anon_sym_u2205,
    ACTIONS(223), 1,
      anon_sym_RPAREN,
    STATE(48), 1,
      aux_sym__actual_arguments_repeat1,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(144), 1,
      sym_term,
    STATE(145), 1,
      sym__value_empty_sequence,
    STATE(467), 1,
      sym__sequence_value_constraints,
    ACTIONS(171), 2,
      sym_double,
      sym_rational,
    ACTIONS(175), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(177), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(154), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(173), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(170), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [3867] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(229), 1,
      anon_sym_LPAREN,
    ACTIONS(225), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(227), 30,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2205,
  [3912] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(231), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(233), 30,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2205,
  [3954] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(235), 1,
      anon_sym_end,
    ACTIONS(237), 1,
      anon_sym_import,
    ACTIONS(239), 1,
      anon_sym_from,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(245), 1,
      anon_sym_datatype,
    ACTIONS(247), 1,
      anon_sym_dimension,
    ACTIONS(249), 1,
      anon_sym_entity,
    ACTIONS(251), 1,
      anon_sym_enum,
    ACTIONS(253), 1,
      anon_sym_event,
    ACTIONS(255), 1,
      anon_sym_property,
    ACTIONS(257), 1,
      anon_sym_rdf,
    ACTIONS(259), 1,
      anon_sym_structure,
    ACTIONS(261), 1,
      anon_sym_class,
    ACTIONS(263), 1,
      anon_sym_union,
    STATE(542), 1,
      sym_from_clause,
    STATE(83), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(116), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(171), 2,
      sym_import_statement,
      aux_sym_module_body_repeat1,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(310), 10,
      sym_data_type_def,
      sym_dimension_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_rdf_def,
      sym_structure_def,
      sym_type_class_def,
      sym_union_def,
  [4034] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(265), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(267), 30,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2205,
  [4076] = 21,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym_reserved_self,
    ACTIONS(75), 1,
      anon_sym_LBRACE,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(97), 1,
      anon_sym_u2205,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(95), 1,
      sym__value_empty_sequence,
    STATE(451), 1,
      sym_term,
    STATE(470), 1,
      sym__sequence_value_constraints,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(94), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(93), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [4154] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(269), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(271), 30,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2205,
  [4196] = 21,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym_reserved_self,
    ACTIONS(75), 1,
      anon_sym_LBRACE,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(97), 1,
      anon_sym_u2205,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(95), 1,
      sym__value_empty_sequence,
    STATE(163), 1,
      sym_term,
    STATE(470), 1,
      sym__sequence_value_constraints,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(94), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(93), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [4274] = 21,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(67), 1,
      sym_identifier,
    ACTIONS(69), 1,
      anon_sym_LBRACK,
    ACTIONS(73), 1,
      sym_reserved_self,
    ACTIONS(75), 1,
      anon_sym_LBRACE,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(97), 1,
      anon_sym_u2205,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(95), 1,
      sym__value_empty_sequence,
    STATE(161), 1,
      sym_term,
    STATE(470), 1,
      sym__sequence_value_constraints,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(94), 2,
      sym_sequence_of_predicate_values,
      sym_simple_value,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
    STATE(93), 5,
      sym_identifier_reference,
      sym_functional_term,
      sym_function_composition,
      sym_predicate_value,
      sym_sequence_builder,
  [4352] = 22,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(237), 1,
      anon_sym_import,
    ACTIONS(239), 1,
      anon_sym_from,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(245), 1,
      anon_sym_datatype,
    ACTIONS(247), 1,
      anon_sym_dimension,
    ACTIONS(249), 1,
      anon_sym_entity,
    ACTIONS(251), 1,
      anon_sym_enum,
    ACTIONS(253), 1,
      anon_sym_event,
    ACTIONS(255), 1,
      anon_sym_property,
    ACTIONS(257), 1,
      anon_sym_rdf,
    ACTIONS(259), 1,
      anon_sym_structure,
    ACTIONS(261), 1,
      anon_sym_class,
    ACTIONS(263), 1,
      anon_sym_union,
    ACTIONS(273), 1,
      anon_sym_end,
    STATE(542), 1,
      sym_from_clause,
    STATE(53), 2,
      sym_import_statement,
      aux_sym_module_body_repeat1,
    STATE(84), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(117), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(310), 10,
      sym_data_type_def,
      sym_dimension_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_rdf_def,
      sym_structure_def,
      sym_type_class_def,
      sym_union_def,
  [4432] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(225), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(227), 30,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2205,
  [4474] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(275), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(277), 30,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2205,
  [4516] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(279), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(281), 30,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2205,
  [4558] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(283), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(285), 30,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2205,
  [4600] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(287), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(289), 30,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
      anon_sym_u2205,
  [4642] = 23,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(157), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      sym_quoted_string,
    ACTIONS(167), 1,
      anon_sym_LT,
    ACTIONS(169), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(179), 1,
      anon_sym_u2205,
    ACTIONS(291), 1,
      sym_identifier,
    ACTIONS(293), 1,
      anon_sym_RBRACK,
    ACTIONS(295), 1,
      anon_sym_LBRACE,
    STATE(68), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(145), 1,
      sym__value_empty_sequence,
    STATE(149), 1,
      sym_simple_value,
    STATE(154), 1,
      sym_sequence_of_predicate_values,
    STATE(172), 1,
      sym_identifier_reference,
    STATE(467), 1,
      sym__sequence_value_constraints,
    ACTIONS(171), 2,
      sym_double,
      sym_rational,
    ACTIONS(175), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(177), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(173), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(194), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [4723] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(297), 1,
      anon_sym_COLON,
    STATE(76), 1,
      aux_sym_function_composition_repeat1,
    STATE(553), 1,
      sym__function_op_composition,
    ACTIONS(299), 2,
      anon_sym_u00b7,
      anon_sym_DOT,
    ACTIONS(21), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(23), 24,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [4772] = 23,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(157), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      sym_quoted_string,
    ACTIONS(167), 1,
      anon_sym_LT,
    ACTIONS(169), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(179), 1,
      anon_sym_u2205,
    ACTIONS(291), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LBRACE,
    ACTIONS(301), 1,
      anon_sym_RBRACK,
    STATE(68), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(145), 1,
      sym__value_empty_sequence,
    STATE(149), 1,
      sym_simple_value,
    STATE(154), 1,
      sym_sequence_of_predicate_values,
    STATE(172), 1,
      sym_identifier_reference,
    STATE(467), 1,
      sym__sequence_value_constraints,
    ACTIONS(171), 2,
      sym_double,
      sym_rational,
    ACTIONS(175), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(177), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(173), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(194), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [4853] = 23,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(303), 1,
      sym_identifier,
    ACTIONS(306), 1,
      anon_sym_LBRACK,
    ACTIONS(309), 1,
      anon_sym_RBRACK,
    ACTIONS(311), 1,
      anon_sym_LBRACE,
    ACTIONS(314), 1,
      sym_quoted_string,
    ACTIONS(317), 1,
      anon_sym_LT,
    ACTIONS(320), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(335), 1,
      anon_sym_u2205,
    STATE(68), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(145), 1,
      sym__value_empty_sequence,
    STATE(149), 1,
      sym_simple_value,
    STATE(154), 1,
      sym_sequence_of_predicate_values,
    STATE(172), 1,
      sym_identifier_reference,
    STATE(467), 1,
      sym__sequence_value_constraints,
    ACTIONS(323), 2,
      sym_double,
      sym_rational,
    ACTIONS(329), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(332), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(326), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(194), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [4934] = 23,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(157), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      sym_quoted_string,
    ACTIONS(167), 1,
      anon_sym_LT,
    ACTIONS(169), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(179), 1,
      anon_sym_u2205,
    ACTIONS(291), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LBRACE,
    ACTIONS(338), 1,
      anon_sym_RBRACK,
    STATE(71), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(145), 1,
      sym__value_empty_sequence,
    STATE(149), 1,
      sym_simple_value,
    STATE(154), 1,
      sym_sequence_of_predicate_values,
    STATE(172), 1,
      sym_identifier_reference,
    STATE(467), 1,
      sym__sequence_value_constraints,
    ACTIONS(171), 2,
      sym_double,
      sym_rational,
    ACTIONS(175), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(177), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(173), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(194), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [5015] = 23,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(157), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      sym_quoted_string,
    ACTIONS(167), 1,
      anon_sym_LT,
    ACTIONS(169), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(179), 1,
      anon_sym_u2205,
    ACTIONS(291), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LBRACE,
    ACTIONS(340), 1,
      anon_sym_RBRACK,
    STATE(65), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(145), 1,
      sym__value_empty_sequence,
    STATE(149), 1,
      sym_simple_value,
    STATE(154), 1,
      sym_sequence_of_predicate_values,
    STATE(172), 1,
      sym_identifier_reference,
    STATE(467), 1,
      sym__sequence_value_constraints,
    ACTIONS(171), 2,
      sym_double,
      sym_rational,
    ACTIONS(175), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(177), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(173), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(194), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [5096] = 23,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(157), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      sym_quoted_string,
    ACTIONS(167), 1,
      anon_sym_LT,
    ACTIONS(169), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(179), 1,
      anon_sym_u2205,
    ACTIONS(291), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LBRACE,
    ACTIONS(342), 1,
      anon_sym_RBRACK,
    STATE(68), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(145), 1,
      sym__value_empty_sequence,
    STATE(149), 1,
      sym_simple_value,
    STATE(154), 1,
      sym_sequence_of_predicate_values,
    STATE(172), 1,
      sym_identifier_reference,
    STATE(467), 1,
      sym__sequence_value_constraints,
    ACTIONS(171), 2,
      sym_double,
      sym_rational,
    ACTIONS(175), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(177), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(173), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(194), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [5177] = 23,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(157), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      sym_quoted_string,
    ACTIONS(167), 1,
      anon_sym_LT,
    ACTIONS(169), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(179), 1,
      anon_sym_u2205,
    ACTIONS(291), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LBRACE,
    ACTIONS(344), 1,
      anon_sym_RBRACK,
    STATE(74), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(145), 1,
      sym__value_empty_sequence,
    STATE(149), 1,
      sym_simple_value,
    STATE(154), 1,
      sym_sequence_of_predicate_values,
    STATE(172), 1,
      sym_identifier_reference,
    STATE(467), 1,
      sym__sequence_value_constraints,
    ACTIONS(171), 2,
      sym_double,
      sym_rational,
    ACTIONS(175), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(177), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(173), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(194), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [5258] = 23,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(157), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      sym_quoted_string,
    ACTIONS(167), 1,
      anon_sym_LT,
    ACTIONS(169), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(179), 1,
      anon_sym_u2205,
    ACTIONS(291), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LBRACE,
    ACTIONS(346), 1,
      anon_sym_RBRACK,
    STATE(67), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(145), 1,
      sym__value_empty_sequence,
    STATE(149), 1,
      sym_simple_value,
    STATE(154), 1,
      sym_sequence_of_predicate_values,
    STATE(172), 1,
      sym_identifier_reference,
    STATE(467), 1,
      sym__sequence_value_constraints,
    ACTIONS(171), 2,
      sym_double,
      sym_rational,
    ACTIONS(175), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(177), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(173), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(194), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [5339] = 23,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(157), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      sym_quoted_string,
    ACTIONS(167), 1,
      anon_sym_LT,
    ACTIONS(169), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(179), 1,
      anon_sym_u2205,
    ACTIONS(291), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LBRACE,
    ACTIONS(348), 1,
      anon_sym_RBRACK,
    STATE(68), 1,
      aux_sym_sequence_of_predicate_values_repeat1,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(145), 1,
      sym__value_empty_sequence,
    STATE(149), 1,
      sym_simple_value,
    STATE(154), 1,
      sym_sequence_of_predicate_values,
    STATE(172), 1,
      sym_identifier_reference,
    STATE(467), 1,
      sym__sequence_value_constraints,
    ACTIONS(171), 2,
      sym_double,
      sym_rational,
    ACTIONS(175), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(177), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(173), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(194), 3,
      sym_predicate_value,
      sym_value_constructor,
      sym_mapping_value,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [5420] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(77), 1,
      aux_sym_function_composition_repeat1,
    STATE(553), 1,
      sym__function_op_composition,
    ACTIONS(299), 2,
      anon_sym_u00b7,
      anon_sym_DOT,
    ACTIONS(352), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(350), 24,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [5466] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(78), 1,
      aux_sym_function_composition_repeat1,
    STATE(553), 1,
      sym__function_op_composition,
    ACTIONS(299), 2,
      anon_sym_u00b7,
      anon_sym_DOT,
    ACTIONS(356), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(354), 24,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [5512] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(78), 1,
      aux_sym_function_composition_repeat1,
    STATE(553), 1,
      sym__function_op_composition,
    ACTIONS(299), 2,
      anon_sym_u00b7,
      anon_sym_DOT,
    ACTIONS(356), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(354), 24,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [5558] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(78), 1,
      aux_sym_function_composition_repeat1,
    STATE(553), 1,
      sym__function_op_composition,
    ACTIONS(362), 2,
      anon_sym_u00b7,
      anon_sym_DOT,
    ACTIONS(360), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(358), 24,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [5604] = 21,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(25), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(295), 1,
      anon_sym_LBRACE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(367), 1,
      anon_sym_u2205,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(51), 1,
      sym_identifier_reference,
    STATE(52), 1,
      sym_value,
    STATE(62), 1,
      sym__value_empty_sequence,
    STATE(135), 1,
      sym_simple_value,
    STATE(452), 1,
      sym__sequence_value_constraints,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(60), 3,
      sym_value_constructor,
      sym_mapping_value,
      sym_sequence_of_values,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [5679] = 21,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(25), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(295), 1,
      anon_sym_LBRACE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(367), 1,
      anon_sym_u2205,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(51), 1,
      sym_identifier_reference,
    STATE(62), 1,
      sym__value_empty_sequence,
    STATE(135), 1,
      sym_simple_value,
    STATE(175), 1,
      sym_value,
    STATE(452), 1,
      sym__sequence_value_constraints,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(60), 3,
      sym_value_constructor,
      sym_mapping_value,
      sym_sequence_of_values,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [5754] = 21,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(165), 1,
      sym_quoted_string,
    ACTIONS(167), 1,
      anon_sym_LT,
    ACTIONS(169), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(291), 1,
      sym_identifier,
    ACTIONS(295), 1,
      anon_sym_LBRACE,
    ACTIONS(365), 1,
      anon_sym_LBRACK,
    ACTIONS(367), 1,
      anon_sym_u2205,
    STATE(51), 1,
      sym_identifier_reference,
    STATE(52), 1,
      sym_value,
    STATE(62), 1,
      sym__value_empty_sequence,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(152), 1,
      sym_simple_value,
    STATE(465), 1,
      sym__sequence_value_constraints,
    ACTIONS(171), 2,
      sym_double,
      sym_rational,
    ACTIONS(175), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(177), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(173), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(60), 3,
      sym_value_constructor,
      sym_mapping_value,
      sym_sequence_of_values,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [5829] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(371), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(369), 26,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
      anon_sym_u00b7,
      anon_sym_DOT,
  [5867] = 18,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(245), 1,
      anon_sym_datatype,
    ACTIONS(247), 1,
      anon_sym_dimension,
    ACTIONS(249), 1,
      anon_sym_entity,
    ACTIONS(251), 1,
      anon_sym_enum,
    ACTIONS(253), 1,
      anon_sym_event,
    ACTIONS(255), 1,
      anon_sym_property,
    ACTIONS(257), 1,
      anon_sym_rdf,
    ACTIONS(259), 1,
      anon_sym_structure,
    ACTIONS(261), 1,
      anon_sym_class,
    ACTIONS(263), 1,
      anon_sym_union,
    ACTIONS(373), 1,
      anon_sym_end,
    STATE(118), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(126), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(310), 10,
      sym_data_type_def,
      sym_dimension_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_rdf_def,
      sym_structure_def,
      sym_type_class_def,
      sym_union_def,
  [5934] = 18,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(235), 1,
      anon_sym_end,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(245), 1,
      anon_sym_datatype,
    ACTIONS(247), 1,
      anon_sym_dimension,
    ACTIONS(249), 1,
      anon_sym_entity,
    ACTIONS(251), 1,
      anon_sym_enum,
    ACTIONS(253), 1,
      anon_sym_event,
    ACTIONS(255), 1,
      anon_sym_property,
    ACTIONS(257), 1,
      anon_sym_rdf,
    ACTIONS(259), 1,
      anon_sym_structure,
    ACTIONS(261), 1,
      anon_sym_class,
    ACTIONS(263), 1,
      anon_sym_union,
    STATE(116), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(126), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(310), 10,
      sym_data_type_def,
      sym_dimension_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_rdf_def,
      sym_structure_def,
      sym_type_class_def,
      sym_union_def,
  [6001] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(377), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(375), 24,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [6037] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(381), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(379), 24,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [6073] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(385), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(383), 24,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [6109] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(389), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(387), 24,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [6145] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(393), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(391), 24,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [6181] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(397), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(395), 24,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [6217] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(401), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(399), 24,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [6253] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(405), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(403), 24,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [6289] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(352), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(350), 24,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [6325] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(409), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(407), 24,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [6361] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(413), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(411), 24,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [6397] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(419), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(415), 8,
      anon_sym_is,
      anon_sym_LPAREN,
      anon_sym_def,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
    ACTIONS(417), 15,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [6434] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(421), 1,
      sym_identifier,
    ACTIONS(424), 1,
      anon_sym_RBRACK,
    ACTIONS(426), 1,
      sym_quoted_string,
    ACTIONS(429), 1,
      anon_sym_LT,
    ACTIONS(432), 1,
      anon_sym_POUND_LBRACK,
    STATE(97), 1,
      aux_sym_sequence_of_values_repeat1,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(192), 1,
      sym_simple_value,
    STATE(213), 1,
      sym_identifier_reference,
    ACTIONS(435), 2,
      sym_double,
      sym_rational,
    ACTIONS(441), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(444), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(224), 2,
      sym_value_constructor,
      sym_mapping_value,
    ACTIONS(438), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [6496] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(165), 1,
      sym_quoted_string,
    ACTIONS(167), 1,
      anon_sym_LT,
    ACTIONS(169), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(291), 1,
      sym_identifier,
    ACTIONS(447), 1,
      anon_sym_RBRACK,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(103), 1,
      aux_sym_sequence_of_values_repeat1,
    STATE(192), 1,
      sym_simple_value,
    STATE(213), 1,
      sym_identifier_reference,
    ACTIONS(171), 2,
      sym_double,
      sym_rational,
    ACTIONS(175), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(177), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(224), 2,
      sym_value_constructor,
      sym_mapping_value,
    ACTIONS(173), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [6558] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(165), 1,
      sym_quoted_string,
    ACTIONS(167), 1,
      anon_sym_LT,
    ACTIONS(169), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(291), 1,
      sym_identifier,
    ACTIONS(449), 1,
      anon_sym_RBRACK,
    STATE(100), 1,
      aux_sym_sequence_of_values_repeat1,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(192), 1,
      sym_simple_value,
    STATE(213), 1,
      sym_identifier_reference,
    ACTIONS(171), 2,
      sym_double,
      sym_rational,
    ACTIONS(175), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(177), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(224), 2,
      sym_value_constructor,
      sym_mapping_value,
    ACTIONS(173), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [6620] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(165), 1,
      sym_quoted_string,
    ACTIONS(167), 1,
      anon_sym_LT,
    ACTIONS(169), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(291), 1,
      sym_identifier,
    ACTIONS(451), 1,
      anon_sym_RBRACK,
    STATE(97), 1,
      aux_sym_sequence_of_values_repeat1,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(192), 1,
      sym_simple_value,
    STATE(213), 1,
      sym_identifier_reference,
    ACTIONS(171), 2,
      sym_double,
      sym_rational,
    ACTIONS(175), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(177), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(224), 2,
      sym_value_constructor,
      sym_mapping_value,
    ACTIONS(173), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [6682] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(21), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(23), 22,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_as,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_with,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_parent,
      anon_sym_ref,
      anon_sym_u2205,
  [6716] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(9), 22,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_as,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_with,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_parent,
      anon_sym_ref,
      anon_sym_u2205,
  [6750] = 17,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(165), 1,
      sym_quoted_string,
    ACTIONS(167), 1,
      anon_sym_LT,
    ACTIONS(169), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(291), 1,
      sym_identifier,
    ACTIONS(453), 1,
      anon_sym_RBRACK,
    STATE(97), 1,
      aux_sym_sequence_of_values_repeat1,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(192), 1,
      sym_simple_value,
    STATE(213), 1,
      sym_identifier_reference,
    ACTIONS(171), 2,
      sym_double,
      sym_rational,
    ACTIONS(175), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(177), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(130), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(224), 2,
      sym_value_constructor,
      sym_mapping_value,
    ACTIONS(173), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(125), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [6812] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(419), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(415), 6,
      anon_sym_LPAREN,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
    ACTIONS(417), 15,
      anon_sym_is,
      anon_sym_end,
      anon_sym_def,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [6847] = 16,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(25), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    ACTIONS(455), 1,
      sym_kw_is_fixed,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(257), 1,
      sym_restriction_value,
    STATE(549), 1,
      sym_identifier_reference,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(256), 2,
      sym_simple_value,
      sym_value_constructor,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [6906] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(419), 4,
      anon_sym_EQ,
      sym_op_less_than,
      sym_op_greater_than,
      anon_sym_LT_EQ,
    ACTIONS(415), 9,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_def,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
      anon_sym_u2264,
      anon_sym_GT_EQ,
      anon_sym_u2265,
    ACTIONS(417), 12,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [6941] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(457), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(459), 20,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
  [6973] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(461), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(463), 20,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
  [7005] = 15,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(25), 1,
      sym_identifier,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(255), 1,
      sym_restriction_value,
    STATE(549), 1,
      sym_identifier_reference,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    STATE(256), 2,
      sym_simple_value,
      sym_value_constructor,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [7061] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(465), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(467), 20,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
  [7093] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(469), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(471), 20,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
  [7125] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(473), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(475), 20,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
  [7157] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(477), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(479), 20,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_not,
      anon_sym_u00ac,
      anon_sym_forall,
      anon_sym_u2200,
      anon_sym_exists,
      anon_sym_u2203,
      anon_sym_u2205,
  [7189] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(481), 1,
      anon_sym_COLON,
    STATE(121), 1,
      aux_sym_function_composition_repeat1,
    STATE(564), 1,
      sym__function_op_composition,
    ACTIONS(483), 2,
      anon_sym_u00b7,
      anon_sym_DOT,
    ACTIONS(21), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(23), 15,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [7229] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(485), 1,
      anon_sym_end,
    ACTIONS(487), 1,
      anon_sym_datatype,
    ACTIONS(490), 1,
      anon_sym_dimension,
    ACTIONS(493), 1,
      anon_sym_entity,
    ACTIONS(496), 1,
      anon_sym_enum,
    ACTIONS(499), 1,
      anon_sym_event,
    ACTIONS(502), 1,
      anon_sym_property,
    ACTIONS(505), 1,
      anon_sym_rdf,
    ACTIONS(508), 1,
      anon_sym_structure,
    ACTIONS(511), 1,
      anon_sym_class,
    ACTIONS(514), 1,
      anon_sym_union,
    STATE(115), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(310), 10,
      sym_data_type_def,
      sym_dimension_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_rdf_def,
      sym_structure_def,
      sym_type_class_def,
      sym_union_def,
  [7282] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(245), 1,
      anon_sym_datatype,
    ACTIONS(247), 1,
      anon_sym_dimension,
    ACTIONS(249), 1,
      anon_sym_entity,
    ACTIONS(251), 1,
      anon_sym_enum,
    ACTIONS(253), 1,
      anon_sym_event,
    ACTIONS(255), 1,
      anon_sym_property,
    ACTIONS(257), 1,
      anon_sym_rdf,
    ACTIONS(259), 1,
      anon_sym_structure,
    ACTIONS(261), 1,
      anon_sym_class,
    ACTIONS(263), 1,
      anon_sym_union,
    ACTIONS(373), 1,
      anon_sym_end,
    STATE(115), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(310), 10,
      sym_data_type_def,
      sym_dimension_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_rdf_def,
      sym_structure_def,
      sym_type_class_def,
      sym_union_def,
  [7335] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(235), 1,
      anon_sym_end,
    ACTIONS(245), 1,
      anon_sym_datatype,
    ACTIONS(247), 1,
      anon_sym_dimension,
    ACTIONS(249), 1,
      anon_sym_entity,
    ACTIONS(251), 1,
      anon_sym_enum,
    ACTIONS(253), 1,
      anon_sym_event,
    ACTIONS(255), 1,
      anon_sym_property,
    ACTIONS(257), 1,
      anon_sym_rdf,
    ACTIONS(259), 1,
      anon_sym_structure,
    ACTIONS(261), 1,
      anon_sym_class,
    ACTIONS(263), 1,
      anon_sym_union,
    STATE(115), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(310), 10,
      sym_data_type_def,
      sym_dimension_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_rdf_def,
      sym_structure_def,
      sym_type_class_def,
      sym_union_def,
  [7388] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(245), 1,
      anon_sym_datatype,
    ACTIONS(247), 1,
      anon_sym_dimension,
    ACTIONS(249), 1,
      anon_sym_entity,
    ACTIONS(251), 1,
      anon_sym_enum,
    ACTIONS(253), 1,
      anon_sym_event,
    ACTIONS(255), 1,
      anon_sym_property,
    ACTIONS(257), 1,
      anon_sym_rdf,
    ACTIONS(259), 1,
      anon_sym_structure,
    ACTIONS(261), 1,
      anon_sym_class,
    ACTIONS(263), 1,
      anon_sym_union,
    ACTIONS(517), 1,
      anon_sym_end,
    STATE(115), 2,
      sym_definition,
      aux_sym_module_body_repeat3,
    STATE(310), 10,
      sym_data_type_def,
      sym_dimension_def,
      sym_entity_def,
      sym_enum_def,
      sym_event_def,
      sym_property_def,
      sym_rdf_def,
      sym_structure_def,
      sym_type_class_def,
      sym_union_def,
  [7441] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(11), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(13), 19,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_as,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
      anon_sym_u2205,
  [7472] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(123), 1,
      aux_sym_function_composition_repeat1,
    STATE(564), 1,
      sym__function_op_composition,
    ACTIONS(483), 2,
      anon_sym_u00b7,
      anon_sym_DOT,
    ACTIONS(352), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(350), 15,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [7509] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(124), 1,
      aux_sym_function_composition_repeat1,
    STATE(564), 1,
      sym__function_op_composition,
    ACTIONS(483), 2,
      anon_sym_u00b7,
      anon_sym_DOT,
    ACTIONS(356), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(354), 15,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [7546] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(519), 1,
      sym_language_tag,
    ACTIONS(15), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(17), 18,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
      anon_sym_u2205,
  [7579] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(124), 1,
      aux_sym_function_composition_repeat1,
    STATE(564), 1,
      sym__function_op_composition,
    ACTIONS(483), 2,
      anon_sym_u00b7,
      anon_sym_DOT,
    ACTIONS(356), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(354), 15,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [7616] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(124), 1,
      aux_sym_function_composition_repeat1,
    STATE(564), 1,
      sym__function_op_composition,
    ACTIONS(521), 2,
      anon_sym_u00b7,
      anon_sym_DOT,
    ACTIONS(360), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(358), 15,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [7653] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(41), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(43), 18,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
      anon_sym_u2205,
  [7683] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(524), 1,
      sym_identifier,
    ACTIONS(528), 1,
      anon_sym_AT,
    ACTIONS(531), 1,
      anon_sym_assert,
    STATE(126), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
    ACTIONS(526), 15,
      anon_sym_end,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
  [7721] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(45), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(47), 18,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
      anon_sym_u2205,
  [7751] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(534), 1,
      sym_identifier,
    ACTIONS(536), 21,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_LBRACE,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_ref,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [7781] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(37), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(39), 18,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
      anon_sym_u2205,
  [7811] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(63), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(65), 18,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
      anon_sym_u2205,
  [7841] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(55), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(57), 18,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
      anon_sym_u2205,
  [7871] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(49), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(51), 18,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
      anon_sym_u2205,
  [7901] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(59), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(61), 18,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2192,
      anon_sym_DASH_GT,
      anon_sym_u2205,
  [7931] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(540), 2,
      anon_sym_and,
      anon_sym_u2227,
    ACTIONS(542), 2,
      anon_sym_or,
      anon_sym_u2228,
    ACTIONS(544), 2,
      anon_sym_xor,
      anon_sym_u22bb,
    ACTIONS(538), 3,
      anon_sym_is,
      anon_sym_end,
      anon_sym_def,
    ACTIONS(546), 3,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(548), 3,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
    STATE(28), 6,
      sym__logical_connective,
      sym_logical_op_conjunction,
      sym_logical_op_disjunction,
      sym_logical_op_exclusive_disjunction,
      sym_logical_op_implication,
      sym_logical_op_biconditional,
  [7970] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(225), 1,
      sym_identifier,
    STATE(79), 1,
      sym__type_op_has_type,
    ACTIONS(550), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    ACTIONS(227), 17,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
  [8003] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(23), 6,
      sym__logical_connective,
      sym_logical_op_conjunction,
      sym_logical_op_disjunction,
      sym_logical_op_exclusive_disjunction,
      sym_logical_op_implication,
      sym_logical_op_biconditional,
    ACTIONS(552), 15,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [8032] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(540), 2,
      anon_sym_and,
      anon_sym_u2227,
    ACTIONS(542), 2,
      anon_sym_or,
      anon_sym_u2228,
    ACTIONS(544), 2,
      anon_sym_xor,
      anon_sym_u22bb,
    ACTIONS(546), 3,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(548), 3,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
    ACTIONS(554), 3,
      anon_sym_is,
      anon_sym_end,
      anon_sym_def,
    STATE(28), 6,
      sym__logical_connective,
      sym_logical_op_conjunction,
      sym_logical_op_disjunction,
      sym_logical_op_exclusive_disjunction,
      sym_logical_op_implication,
      sym_logical_op_biconditional,
  [8071] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(371), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(369), 17,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u00b7,
      anon_sym_DOT,
      anon_sym_u2205,
  [8100] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(556), 1,
      sym_identifier,
    ACTIONS(558), 20,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_ref,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [8129] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(540), 2,
      anon_sym_and,
      anon_sym_u2227,
    ACTIONS(542), 2,
      anon_sym_or,
      anon_sym_u2228,
    ACTIONS(544), 2,
      anon_sym_xor,
      anon_sym_u22bb,
    ACTIONS(538), 3,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(546), 3,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(548), 3,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
    STATE(23), 6,
      sym__logical_connective,
      sym_logical_op_conjunction,
      sym_logical_op_disjunction,
      sym_logical_op_exclusive_disjunction,
      sym_logical_op_implication,
      sym_logical_op_biconditional,
  [8168] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(23), 6,
      sym__logical_connective,
      sym_logical_op_conjunction,
      sym_logical_op_disjunction,
      sym_logical_op_exclusive_disjunction,
      sym_logical_op_implication,
      sym_logical_op_biconditional,
    ACTIONS(560), 15,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [8197] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(28), 6,
      sym__logical_connective,
      sym_logical_op_conjunction,
      sym_logical_op_disjunction,
      sym_logical_op_exclusive_disjunction,
      sym_logical_op_implication,
      sym_logical_op_biconditional,
    ACTIONS(560), 15,
      anon_sym_is,
      anon_sym_end,
      anon_sym_def,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [8226] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(28), 6,
      sym__logical_connective,
      sym_logical_op_conjunction,
      sym_logical_op_disjunction,
      sym_logical_op_exclusive_disjunction,
      sym_logical_op_implication,
      sym_logical_op_biconditional,
    ACTIONS(552), 15,
      anon_sym_is,
      anon_sym_end,
      anon_sym_def,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [8255] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(566), 1,
      anon_sym_LPAREN,
    STATE(155), 1,
      sym__actual_arguments,
    ACTIONS(562), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(564), 14,
      anon_sym_LBRACK,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [8287] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(413), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(411), 16,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [8315] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(393), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(391), 16,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [8343] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(381), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(379), 16,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [8371] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(385), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(383), 16,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [8399] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(81), 1,
      sym__type_op_has_type,
    ACTIONS(568), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    ACTIONS(409), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(407), 13,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [8431] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(377), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(375), 16,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [8459] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(401), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(399), 16,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [8487] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(81), 1,
      sym__type_op_has_type,
    ACTIONS(568), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    ACTIONS(225), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(227), 13,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [8519] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(297), 1,
      anon_sym_COLON,
    ACTIONS(572), 1,
      anon_sym_as,
    STATE(183), 1,
      sym_iri,
    STATE(191), 1,
      sym__rename_import,
    ACTIONS(570), 15,
      anon_sym_end,
      anon_sym_import,
      anon_sym_from,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [8555] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(409), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(407), 16,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [8583] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(419), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(415), 15,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [8610] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(389), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(387), 15,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [8637] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(574), 1,
      anon_sym_RBRACE,
    ACTIONS(582), 1,
      anon_sym_explicitTimezone,
    ACTIONS(584), 1,
      anon_sym_pattern,
    ACTIONS(578), 2,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
    ACTIONS(576), 3,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
    ACTIONS(580), 4,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
    STATE(168), 7,
      sym__restriction_facet,
      sym_length_restriction_facet,
      sym_digit_restriction_facet,
      sym_value_restriction_facet,
      sym_tz_restriction_facet,
      sym_pattern_restriction_facet,
      aux_sym_datatype_def_restriction_repeat1,
  [8674] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(415), 19,
      anon_sym_is,
      anon_sym_end,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [8699] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(397), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(395), 15,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [8726] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(405), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(403), 15,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [8753] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(588), 1,
      anon_sym_LPAREN,
    STATE(158), 1,
      sym__actual_arguments,
    ACTIONS(586), 17,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [8782] = 11,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(77), 1,
      sym_quoted_string,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(81), 1,
      anon_sym_POUND_LBRACK,
    STATE(524), 1,
      sym_simple_value,
    ACTIONS(83), 2,
      sym_double,
      sym_rational,
    ACTIONS(87), 2,
      anon_sym_true,
      anon_sym_u22a4,
    ACTIONS(89), 2,
      anon_sym_false,
      anon_sym_u22a5,
    STATE(14), 2,
      sym_boolean_truth,
      sym_boolean_falsity,
    ACTIONS(85), 3,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    STATE(8), 4,
      sym_string,
      sym_iri,
      sym_binary,
      sym_boolean,
  [8825] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(588), 1,
      anon_sym_LPAREN,
    STATE(158), 1,
      sym__actual_arguments,
    ACTIONS(590), 17,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [8854] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(596), 1,
      sym_controlled_language_tag,
    ACTIONS(592), 2,
      sym_identifier,
      anon_sym_AT,
    ACTIONS(594), 16,
      anon_sym_end,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
  [8883] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(598), 1,
      anon_sym_end,
    ACTIONS(540), 2,
      anon_sym_and,
      anon_sym_u2227,
    ACTIONS(542), 2,
      anon_sym_or,
      anon_sym_u2228,
    ACTIONS(544), 2,
      anon_sym_xor,
      anon_sym_u22bb,
    ACTIONS(546), 3,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(548), 3,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
    STATE(23), 6,
      sym__logical_connective,
      sym_logical_op_conjunction,
      sym_logical_op_disjunction,
      sym_logical_op_exclusive_disjunction,
      sym_logical_op_implication,
      sym_logical_op_biconditional,
  [8920] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(600), 1,
      anon_sym_RPAREN,
    ACTIONS(540), 2,
      anon_sym_and,
      anon_sym_u2227,
    ACTIONS(542), 2,
      anon_sym_or,
      anon_sym_u2228,
    ACTIONS(544), 2,
      anon_sym_xor,
      anon_sym_u22bb,
    ACTIONS(546), 3,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(548), 3,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
    STATE(23), 6,
      sym__logical_connective,
      sym_logical_op_conjunction,
      sym_logical_op_disjunction,
      sym_logical_op_exclusive_disjunction,
      sym_logical_op_implication,
      sym_logical_op_biconditional,
  [8957] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(481), 1,
      anon_sym_COLON,
    ACTIONS(21), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(23), 14,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [8986] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(602), 1,
      anon_sym_RBRACE,
    ACTIONS(613), 1,
      anon_sym_explicitTimezone,
    ACTIONS(616), 1,
      anon_sym_pattern,
    ACTIONS(607), 2,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
    ACTIONS(604), 3,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
    ACTIONS(610), 4,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
    STATE(168), 7,
      sym__restriction_facet,
      sym_length_restriction_facet,
      sym_digit_restriction_facet,
      sym_value_restriction_facet,
      sym_tz_restriction_facet,
      sym_pattern_restriction_facet,
      aux_sym_datatype_def_restriction_repeat1,
  [9023] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(619), 1,
      anon_sym_end,
    ACTIONS(540), 2,
      anon_sym_and,
      anon_sym_u2227,
    ACTIONS(542), 2,
      anon_sym_or,
      anon_sym_u2228,
    ACTIONS(544), 2,
      anon_sym_xor,
      anon_sym_u22bb,
    ACTIONS(546), 3,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
    ACTIONS(548), 3,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
    STATE(23), 6,
      sym__logical_connective,
      sym_logical_op_conjunction,
      sym_logical_op_disjunction,
      sym_logical_op_exclusive_disjunction,
      sym_logical_op_implication,
      sym_logical_op_biconditional,
  [9060] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(352), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(350), 15,
      anon_sym_LBRACK,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [9087] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(623), 1,
      anon_sym_import,
    ACTIONS(626), 1,
      anon_sym_from,
    STATE(542), 1,
      sym_from_clause,
    STATE(171), 2,
      sym_import_statement,
      aux_sym_module_body_repeat1,
    ACTIONS(621), 13,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [9119] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(229), 1,
      anon_sym_LPAREN,
    ACTIONS(629), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(631), 13,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [9147] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(633), 1,
      sym_identifier,
    ACTIONS(635), 17,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
  [9173] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(637), 1,
      sym_identifier,
    ACTIONS(639), 17,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
  [9199] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(641), 1,
      sym_identifier,
    ACTIONS(643), 17,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
  [9225] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(645), 1,
      sym_identifier,
    ACTIONS(647), 17,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
  [9251] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(649), 1,
      sym_identifier,
    ACTIONS(651), 17,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_ref,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [9277] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(582), 1,
      anon_sym_explicitTimezone,
    ACTIONS(584), 1,
      anon_sym_pattern,
    ACTIONS(578), 2,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
    ACTIONS(576), 3,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
    ACTIONS(580), 4,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
    STATE(157), 7,
      sym__restriction_facet,
      sym_length_restriction_facet,
      sym_digit_restriction_facet,
      sym_value_restriction_facet,
      sym_tz_restriction_facet,
      sym_pattern_restriction_facet,
      aux_sym_datatype_def_restriction_repeat1,
  [9311] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(653), 1,
      sym_identifier,
    ACTIONS(655), 17,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
  [9337] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(657), 1,
      sym_identifier,
    ACTIONS(659), 17,
      anon_sym_end,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_source,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_identity,
      anon_sym_ref,
  [9363] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(661), 1,
      sym_identifier,
    ACTIONS(663), 16,
      anon_sym_end,
      anon_sym_import,
      anon_sym_RBRACK,
      anon_sym_from,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [9388] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(588), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_EQ,
    STATE(106), 1,
      sym__actual_arguments,
    ACTIONS(667), 2,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
    ACTIONS(669), 2,
      sym_op_less_than,
      sym_op_greater_than,
    ACTIONS(671), 2,
      anon_sym_LT_EQ,
      anon_sym_u2264,
    ACTIONS(673), 2,
      anon_sym_GT_EQ,
      anon_sym_u2265,
    ACTIONS(554), 3,
      anon_sym_is,
      anon_sym_end,
      anon_sym_def,
    STATE(58), 3,
      sym_op_inequality,
      sym_op_less_than_or_equal,
      sym_op_greater_than_or_equal,
  [9427] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(572), 1,
      anon_sym_as,
    STATE(193), 1,
      sym__rename_import,
    ACTIONS(675), 15,
      anon_sym_end,
      anon_sym_import,
      anon_sym_from,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [9454] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(677), 17,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [9477] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(679), 17,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [9500] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(681), 17,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [9523] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(677), 17,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [9546] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(683), 17,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [9569] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(677), 17,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_RBRACE,
      anon_sym_and,
      anon_sym_u2227,
      anon_sym_or,
      anon_sym_u2228,
      anon_sym_xor,
      anon_sym_u22bb,
      anon_sym_implies,
      anon_sym_EQ_EQ_GT,
      anon_sym_u21d2,
      anon_sym_iff,
      anon_sym_LT_EQ_EQ_GT,
      anon_sym_u21d4,
  [9592] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(685), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(687), 13,
      anon_sym_LBRACK,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [9617] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(689), 1,
      sym_identifier,
    ACTIONS(691), 16,
      anon_sym_end,
      anon_sym_import,
      anon_sym_RBRACK,
      anon_sym_from,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [9642] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(81), 1,
      sym__type_op_has_type,
    ACTIONS(568), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    ACTIONS(693), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(695), 10,
      anon_sym_RBRACK,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [9671] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(697), 1,
      sym_identifier,
    ACTIONS(699), 16,
      anon_sym_end,
      anon_sym_import,
      anon_sym_RBRACK,
      anon_sym_from,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [9696] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(629), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(631), 13,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [9721] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(701), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(703), 13,
      anon_sym_LBRACK,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [9746] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(705), 1,
      sym_identifier,
    ACTIONS(707), 16,
      anon_sym_end,
      anon_sym_import,
      anon_sym_RBRACK,
      anon_sym_from,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [9771] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(709), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(711), 13,
      anon_sym_LBRACK,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [9796] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(713), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(715), 13,
      anon_sym_LBRACK,
      sym_reserved_self,
      anon_sym_LBRACE,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
      anon_sym_u2205,
  [9821] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(572), 1,
      anon_sym_as,
    STATE(181), 1,
      sym__rename_import,
    ACTIONS(717), 15,
      anon_sym_end,
      anon_sym_import,
      anon_sym_from,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [9848] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(588), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_EQ,
    STATE(96), 1,
      sym__actual_arguments,
    ACTIONS(554), 2,
      anon_sym_is,
      anon_sym_def,
    ACTIONS(667), 2,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
    ACTIONS(669), 2,
      sym_op_less_than,
      sym_op_greater_than,
    ACTIONS(671), 2,
      anon_sym_LT_EQ,
      anon_sym_u2264,
    ACTIONS(673), 2,
      anon_sym_GT_EQ,
      anon_sym_u2265,
    STATE(58), 3,
      sym_op_inequality,
      sym_op_less_than_or_equal,
      sym_op_greater_than_or_equal,
  [9886] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(719), 1,
      sym_identifier,
    ACTIONS(721), 15,
      anon_sym_is,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_of,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_ref,
  [9910] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(723), 1,
      sym_identifier,
    ACTIONS(725), 15,
      anon_sym_is,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_of,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_ref,
  [9934] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(727), 1,
      anon_sym_is,
    ACTIONS(731), 1,
      anon_sym_from,
    ACTIONS(733), 1,
      anon_sym_LPAREN,
    STATE(236), 1,
      sym_from_definition_clause,
    STATE(299), 1,
      sym_type_class_body,
    ACTIONS(729), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [9966] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(735), 1,
      sym_identifier,
    ACTIONS(737), 1,
      anon_sym_is,
    STATE(223), 1,
      sym_annotation_only_body,
    ACTIONS(739), 13,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_ref,
  [9994] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(737), 1,
      anon_sym_is,
    STATE(233), 1,
      sym_rdf_types,
    STATE(316), 1,
      sym_annotation_only_body,
    ACTIONS(743), 2,
      anon_sym_a,
      anon_sym_type,
    ACTIONS(741), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10024] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(745), 15,
      anon_sym_end,
      anon_sym_import,
      anon_sym_from,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10045] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(731), 1,
      anon_sym_from,
    ACTIONS(749), 1,
      anon_sym_of,
    STATE(243), 1,
      sym_from_definition_clause,
    STATE(269), 1,
      sym_enum_body,
    ACTIONS(747), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10074] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(731), 1,
      anon_sym_from,
    ACTIONS(751), 1,
      anon_sym_is,
    STATE(240), 1,
      sym_from_definition_clause,
    STATE(268), 1,
      sym_event_body,
    ACTIONS(753), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10103] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(755), 1,
      sym_identifier,
    ACTIONS(757), 14,
      anon_sym_is,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_ref,
  [10126] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(737), 1,
      anon_sym_is,
    ACTIONS(761), 1,
      anon_sym_LBRACE,
    STATE(228), 1,
      sym_datatype_def_restriction,
    STATE(271), 1,
      sym_annotation_only_body,
    ACTIONS(759), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10155] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(763), 1,
      sym_identifier,
    ACTIONS(765), 14,
      anon_sym_is,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_ref,
  [10178] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(767), 1,
      sym_identifier,
    ACTIONS(769), 14,
      anon_sym_end,
      anon_sym_def,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_ref,
  [10201] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(229), 1,
      anon_sym_LPAREN,
    ACTIONS(693), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(695), 10,
      anon_sym_RBRACK,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [10226] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(727), 1,
      anon_sym_is,
    ACTIONS(731), 1,
      anon_sym_from,
    STATE(230), 1,
      sym_from_definition_clause,
    STATE(302), 1,
      sym_type_class_body,
    ACTIONS(771), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10255] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(773), 15,
      anon_sym_end,
      anon_sym_import,
      anon_sym_from,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10276] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(731), 1,
      anon_sym_from,
    ACTIONS(775), 1,
      anon_sym_is,
    STATE(235), 1,
      sym_from_definition_clause,
    STATE(295), 1,
      sym_structure_body,
    ACTIONS(777), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10305] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(779), 15,
      anon_sym_end,
      anon_sym_import,
      anon_sym_from,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10326] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(731), 1,
      anon_sym_from,
    ACTIONS(781), 1,
      anon_sym_is,
    STATE(239), 1,
      sym_from_definition_clause,
    STATE(313), 1,
      sym_dimension_body,
    ACTIONS(783), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10355] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(737), 1,
      anon_sym_is,
    ACTIONS(761), 1,
      anon_sym_LBRACE,
    STATE(227), 1,
      sym_datatype_def_restriction,
    STATE(294), 1,
      sym_annotation_only_body,
    ACTIONS(785), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10384] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(731), 1,
      anon_sym_from,
    ACTIONS(789), 1,
      anon_sym_of,
    STATE(238), 1,
      sym_from_definition_clause,
    STATE(301), 1,
      sym_union_body,
    ACTIONS(787), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10413] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(731), 1,
      anon_sym_from,
    ACTIONS(791), 1,
      anon_sym_is,
    STATE(242), 1,
      sym_from_definition_clause,
    STATE(265), 1,
      sym_entity_body,
    ACTIONS(793), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10442] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(795), 15,
      anon_sym_end,
      anon_sym_import,
      anon_sym_from,
      anon_sym_AT,
      anon_sym_assert,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10463] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(797), 1,
      sym_identifier,
    ACTIONS(799), 13,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_parent,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
      anon_sym_ref,
  [10485] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(693), 4,
      sym_identifier,
      sym_decimal,
      sym_integer,
      sym_unsigned,
    ACTIONS(695), 10,
      anon_sym_RBRACK,
      sym_quoted_string,
      anon_sym_LT,
      anon_sym_POUND_LBRACK,
      sym_double,
      sym_rational,
      anon_sym_true,
      anon_sym_u22a4,
      anon_sym_false,
      anon_sym_u22a5,
  [10507] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(588), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_EQ,
    STATE(104), 1,
      sym__actual_arguments,
    ACTIONS(667), 2,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
    ACTIONS(669), 2,
      sym_op_less_than,
      sym_op_greater_than,
    ACTIONS(671), 2,
      anon_sym_LT_EQ,
      anon_sym_u2264,
    ACTIONS(673), 2,
      anon_sym_GT_EQ,
      anon_sym_u2265,
    STATE(58), 3,
      sym_op_inequality,
      sym_op_less_than_or_equal,
      sym_op_greater_than_or_equal,
  [10541] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(588), 1,
      anon_sym_LPAREN,
    ACTIONS(665), 1,
      anon_sym_EQ,
    STATE(96), 1,
      sym__actual_arguments,
    ACTIONS(667), 2,
      anon_sym_SLASH_EQ,
      anon_sym_u2260,
    ACTIONS(669), 2,
      sym_op_less_than,
      sym_op_greater_than,
    ACTIONS(671), 2,
      anon_sym_LT_EQ,
      anon_sym_u2264,
    ACTIONS(673), 2,
      anon_sym_GT_EQ,
      anon_sym_u2265,
    STATE(58), 3,
      sym_op_inequality,
      sym_op_less_than_or_equal,
      sym_op_greater_than_or_equal,
  [10575] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(737), 1,
      anon_sym_is,
    STATE(273), 1,
      sym_annotation_only_body,
    ACTIONS(801), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10598] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(737), 1,
      anon_sym_is,
    STATE(307), 1,
      sym_annotation_only_body,
    ACTIONS(803), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10621] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(807), 1,
      anon_sym_end,
    ACTIONS(809), 1,
      anon_sym_ref,
    STATE(126), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(353), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [10656] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(727), 1,
      anon_sym_is,
    STATE(266), 1,
      sym_type_class_body,
    ACTIONS(811), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10679] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(813), 13,
      anon_sym_is,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_of,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10698] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(815), 13,
      anon_sym_is,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_of,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10717] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(737), 1,
      anon_sym_is,
    STATE(274), 1,
      sym_annotation_only_body,
    ACTIONS(817), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10740] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    ACTIONS(819), 1,
      anon_sym_end,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(229), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(354), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [10775] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(775), 1,
      anon_sym_is,
    STATE(279), 1,
      sym_structure_body,
    ACTIONS(821), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10798] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(727), 1,
      anon_sym_is,
    STATE(283), 1,
      sym_type_class_body,
    ACTIONS(823), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10821] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(825), 13,
      anon_sym_is,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_of,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10840] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(789), 1,
      anon_sym_of,
    STATE(286), 1,
      sym_union_body,
    ACTIONS(827), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10863] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(781), 1,
      anon_sym_is,
    STATE(293), 1,
      sym_dimension_body,
    ACTIONS(829), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10886] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(751), 1,
      anon_sym_is,
    STATE(308), 1,
      sym_event_body,
    ACTIONS(831), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10909] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(833), 13,
      anon_sym_is,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_of,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10928] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(791), 1,
      anon_sym_is,
    STATE(304), 1,
      sym_entity_body,
    ACTIONS(835), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10951] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(749), 1,
      anon_sym_of,
    STATE(306), 1,
      sym_enum_body,
    ACTIONS(837), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10974] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(839), 13,
      anon_sym_is,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_of,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [10993] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(841), 13,
      anon_sym_is,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_of,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11012] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(843), 12,
      anon_sym_is,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11030] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(845), 12,
      anon_sym_is,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11048] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(847), 1,
      sym_identifier,
    ACTIONS(849), 1,
      anon_sym_end,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(399), 1,
      sym_identifier_reference,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(263), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(362), 2,
      sym_type_variant,
      aux_sym_union_body_repeat1,
  [11082] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(851), 12,
      anon_sym_is,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11100] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(853), 12,
      anon_sym_is,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11118] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(855), 12,
      anon_sym_RBRACE,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
  [11136] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(857), 12,
      anon_sym_RBRACE,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
  [11154] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(859), 12,
      anon_sym_RBRACE,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
  [11172] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(861), 12,
      anon_sym_RBRACE,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
  [11190] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(863), 12,
      anon_sym_RBRACE,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
  [11208] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(865), 12,
      anon_sym_RBRACE,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
  [11226] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(867), 12,
      anon_sym_RBRACE,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
  [11244] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(869), 12,
      anon_sym_RBRACE,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
  [11262] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(871), 12,
      anon_sym_RBRACE,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
  [11280] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(873), 12,
      anon_sym_RBRACE,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
  [11298] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(875), 12,
      anon_sym_RBRACE,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
  [11316] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(877), 12,
      anon_sym_RBRACE,
      anon_sym_length,
      anon_sym_maxLength,
      anon_sym_minLength,
      anon_sym_fractionDigits,
      anon_sym_totalDigits,
      anon_sym_maxExclusive,
      anon_sym_maxInclusive,
      anon_sym_minExclusive,
      anon_sym_minInclusive,
      anon_sym_explicitTimezone,
      anon_sym_pattern,
  [11334] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(847), 1,
      sym_identifier,
    ACTIONS(879), 1,
      anon_sym_end,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(399), 1,
      sym_identifier_reference,
    STATE(126), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(367), 2,
      sym_type_variant,
      aux_sym_union_body_repeat1,
  [11368] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(881), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11385] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(883), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11402] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(885), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11419] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(887), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11436] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(889), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11453] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(891), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11470] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(893), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11487] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(895), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11504] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(897), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11521] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(899), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11538] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(901), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11555] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(903), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11572] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(905), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11589] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(907), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11606] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(909), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11623] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(911), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11640] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(913), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11657] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(915), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11674] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(917), 1,
      anon_sym_end,
    ACTIONS(919), 1,
      anon_sym_def,
    STATE(334), 1,
      sym_function_signature,
    STATE(394), 1,
      aux_sym_type_class_body_repeat1,
    STATE(510), 1,
      sym_method_def,
    STATE(126), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
  [11707] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(921), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11724] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(923), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11741] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(925), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11758] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(927), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11775] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(929), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11792] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(931), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11809] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(933), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11826] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(935), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11843] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(937), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11860] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(939), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11877] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(941), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11894] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(943), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11911] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(945), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11928] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(919), 1,
      anon_sym_def,
    ACTIONS(947), 1,
      anon_sym_end,
    STATE(334), 1,
      sym_function_signature,
    STATE(392), 1,
      aux_sym_type_class_body_repeat1,
    STATE(510), 1,
      sym_method_def,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(282), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
  [11961] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(949), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11978] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(951), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [11995] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(953), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [12012] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(955), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [12029] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(957), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [12046] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(959), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [12063] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(961), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [12080] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(963), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [12097] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(965), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [12114] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(967), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [12131] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(969), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [12148] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(971), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [12165] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(973), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [12182] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(975), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [12199] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(977), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [12216] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(979), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [12233] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(981), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [12250] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(983), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [12267] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(985), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [12284] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(987), 11,
      anon_sym_end,
      anon_sym_datatype,
      anon_sym_dimension,
      anon_sym_entity,
      anon_sym_enum,
      anon_sym_event,
      anon_sym_property,
      anon_sym_rdf,
      anon_sym_structure,
      anon_sym_class,
      anon_sym_union,
  [12301] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(989), 1,
      sym_identifier,
    ACTIONS(991), 1,
      anon_sym_end,
    STATE(126), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(412), 2,
      sym_value_variant,
      aux_sym_enum_body_repeat1,
  [12329] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    ACTIONS(993), 1,
      anon_sym_end,
    ACTIONS(995), 1,
      anon_sym_parent,
    STATE(319), 2,
      sym_dimension_parent,
      aux_sym_dimension_body_repeat1,
    STATE(338), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [12357] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    ACTIONS(995), 1,
      anon_sym_parent,
    ACTIONS(997), 1,
      anon_sym_end,
    STATE(350), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(361), 2,
      sym_dimension_parent,
      aux_sym_dimension_body_repeat1,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [12385] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    ACTIONS(995), 1,
      anon_sym_parent,
    ACTIONS(999), 1,
      anon_sym_end,
    STATE(321), 2,
      sym_dimension_parent,
      aux_sym_dimension_body_repeat1,
    STATE(356), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [12413] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    ACTIONS(995), 1,
      anon_sym_parent,
    ACTIONS(1001), 1,
      anon_sym_end,
    STATE(358), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(361), 2,
      sym_dimension_parent,
      aux_sym_dimension_body_repeat1,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [12441] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(1003), 1,
      anon_sym_source,
    ACTIONS(1005), 1,
      anon_sym_identity,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(318), 2,
      sym_source_entity,
      sym_entity_identity,
    STATE(324), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
  [12469] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(989), 1,
      sym_identifier,
    ACTIONS(1007), 1,
      anon_sym_end,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(317), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(439), 2,
      sym_value_variant,
      aux_sym_enum_body_repeat1,
  [12497] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(1003), 1,
      anon_sym_source,
    ACTIONS(1005), 1,
      anon_sym_identity,
    STATE(126), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(320), 2,
      sym_source_entity,
      sym_entity_identity,
  [12525] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1009), 1,
      sym_identifier,
    STATE(433), 1,
      sym_sequence_ordering,
    STATE(438), 1,
      aux_sym_sequence_builder_repeat1,
    STATE(508), 1,
      sym_variable,
    STATE(536), 1,
      sym_sequence_uniqueness,
    ACTIONS(1011), 2,
      anon_sym_ordered,
      anon_sym_unordered,
    ACTIONS(1013), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [12552] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1015), 1,
      anon_sym_RBRACE,
    ACTIONS(1017), 1,
      sym_unsigned,
    STATE(377), 1,
      sym_sequence_ordering,
    STATE(445), 1,
      sym_sequence_uniqueness,
    STATE(562), 1,
      sym__cardinality_inner,
    ACTIONS(1011), 2,
      anon_sym_ordered,
      anon_sym_unordered,
    ACTIONS(1013), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [12579] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(535), 1,
      sym_sequence_builder_body,
    STATE(545), 1,
      sym_quantified_variable_binding,
    STATE(557), 1,
      sym_quantified_sentence,
    ACTIONS(93), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(95), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(473), 2,
      sym_logical_quantifier_universal,
      sym_logical_quantifier_existential,
  [12604] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(545), 1,
      sym_quantified_variable_binding,
    STATE(557), 1,
      sym_quantified_sentence,
    STATE(575), 1,
      sym_sequence_builder_body,
    ACTIONS(93), 2,
      anon_sym_forall,
      anon_sym_u2200,
    ACTIONS(95), 2,
      anon_sym_exists,
      anon_sym_u2203,
    STATE(473), 2,
      sym_logical_quantifier_universal,
      sym_logical_quantifier_existential,
  [12629] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1009), 1,
      sym_identifier,
    STATE(419), 1,
      aux_sym_sequence_builder_repeat1,
    STATE(433), 1,
      sym_sequence_ordering,
    STATE(508), 1,
      sym_variable,
    STATE(536), 1,
      sym_sequence_uniqueness,
    ACTIONS(1011), 2,
      anon_sym_ordered,
      anon_sym_unordered,
    ACTIONS(1013), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [12656] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(1003), 1,
      anon_sym_source,
    STATE(343), 1,
      sym_source_entity,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(331), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
  [12680] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(1003), 1,
      anon_sym_source,
    STATE(360), 1,
      sym_source_entity,
    STATE(126), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
  [12704] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(1005), 1,
      anon_sym_identity,
    STATE(351), 1,
      sym_entity_identity,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(333), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
  [12728] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(1005), 1,
      anon_sym_identity,
    STATE(337), 1,
      sym_entity_identity,
    STATE(126), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
  [12752] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(737), 1,
      anon_sym_is,
    STATE(19), 1,
      sym__function_op_by_definition,
    STATE(422), 1,
      sym_function_body,
    STATE(498), 1,
      sym_annotation_only_body,
    ACTIONS(1019), 2,
      anon_sym_end,
      anon_sym_def,
    ACTIONS(1021), 2,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [12776] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1017), 1,
      sym_unsigned,
    STATE(390), 1,
      sym_sequence_ordering,
    STATE(500), 1,
      sym_sequence_uniqueness,
    STATE(570), 1,
      sym__cardinality_inner,
    ACTIONS(1011), 2,
      anon_sym_ordered,
      anon_sym_unordered,
    ACTIONS(1013), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [12800] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(21), 1,
      sym_identifier,
    ACTIONS(481), 1,
      anon_sym_COLON,
    ACTIONS(23), 6,
      anon_sym_is,
      anon_sym_end,
      anon_sym_as,
      anon_sym_with,
      anon_sym_parent,
      anon_sym_ref,
  [12818] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    ACTIONS(1023), 1,
      anon_sym_end,
    STATE(342), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [12839] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    ACTIONS(997), 1,
      anon_sym_end,
    STATE(355), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [12860] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1025), 1,
      sym_identifier,
    ACTIONS(1027), 1,
      anon_sym_RBRACK,
    STATE(429), 1,
      sym_qualified_identifier,
    STATE(349), 4,
      sym__import,
      sym_member_import,
      sym_module_import,
      aux_sym_import_statement_repeat1,
  [12879] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    ACTIONS(1029), 1,
      anon_sym_end,
    STATE(355), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [12900] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1031), 1,
      sym_identifier,
    ACTIONS(1033), 6,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [12915] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    ACTIONS(1035), 1,
      anon_sym_end,
    STATE(355), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [12936] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    ACTIONS(1037), 1,
      anon_sym_end,
    STATE(348), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [12957] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1039), 1,
      sym_identifier,
    ACTIONS(1041), 6,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [12972] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1043), 1,
      sym_identifier,
    ACTIONS(1045), 6,
      anon_sym_is,
      anon_sym_end,
      anon_sym_RPAREN,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [12987] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1025), 1,
      sym_identifier,
    ACTIONS(1047), 1,
      anon_sym_RBRACK,
    STATE(429), 1,
      sym_qualified_identifier,
    STATE(349), 4,
      sym__import,
      sym_member_import,
      sym_module_import,
      aux_sym_import_statement_repeat1,
  [13006] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    ACTIONS(1049), 1,
      anon_sym_end,
    STATE(126), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
  [13027] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    ACTIONS(1051), 1,
      anon_sym_end,
    STATE(355), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [13048] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1053), 1,
      sym_identifier,
    ACTIONS(1056), 1,
      anon_sym_RBRACK,
    STATE(429), 1,
      sym_qualified_identifier,
    STATE(349), 4,
      sym__import,
      sym_member_import,
      sym_module_import,
      aux_sym_import_statement_repeat1,
  [13067] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    ACTIONS(1058), 1,
      anon_sym_end,
    STATE(355), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [13088] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    ACTIONS(1060), 1,
      anon_sym_end,
    STATE(340), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [13109] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1062), 1,
      sym_identifier,
    STATE(468), 1,
      sym__type_op_has_type,
    ACTIONS(1066), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
    ACTIONS(1064), 3,
      anon_sym_in,
      anon_sym_u2208,
      sym_set_op_builder,
  [13128] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    ACTIONS(1068), 1,
      anon_sym_end,
    STATE(355), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [13149] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(807), 1,
      anon_sym_end,
    ACTIONS(809), 1,
      anon_sym_ref,
    STATE(355), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [13170] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1070), 1,
      sym_identifier,
    ACTIONS(1073), 1,
      anon_sym_end,
    ACTIONS(1075), 1,
      anon_sym_ref,
    STATE(355), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [13191] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    ACTIONS(1001), 1,
      anon_sym_end,
    STATE(355), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [13212] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    ACTIONS(1078), 1,
      anon_sym_end,
    STATE(355), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [13233] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    ACTIONS(1080), 1,
      anon_sym_end,
    STATE(355), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [13254] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(167), 1,
      anon_sym_LT,
    ACTIONS(481), 1,
      anon_sym_COLON,
    ACTIONS(570), 1,
      anon_sym_RBRACK,
    ACTIONS(1082), 1,
      sym_identifier,
    ACTIONS(1084), 1,
      anon_sym_as,
    STATE(191), 1,
      sym__rename_import,
    STATE(430), 1,
      sym_iri,
  [13279] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    ACTIONS(1086), 1,
      anon_sym_end,
    STATE(357), 2,
      sym_member,
      aux_sym_dimension_body_repeat2,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [13300] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1088), 1,
      sym_identifier,
    ACTIONS(1092), 1,
      anon_sym_parent,
    ACTIONS(1090), 2,
      anon_sym_end,
      anon_sym_ref,
    STATE(361), 2,
      sym_dimension_parent,
      aux_sym_dimension_body_repeat1,
  [13318] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(847), 1,
      sym_identifier,
    ACTIONS(879), 1,
      anon_sym_end,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(399), 1,
      sym_identifier_reference,
    STATE(371), 2,
      sym_type_variant,
      aux_sym_union_body_repeat1,
  [13338] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(1095), 1,
      sym_identifier,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(370), 1,
      sym_type_parameter_restriction,
    STATE(384), 1,
      sym_identifier_reference,
    STATE(444), 1,
      sym_cardinality_reference_expression,
  [13360] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(433), 1,
      sym_sequence_ordering,
    STATE(536), 1,
      sym_sequence_uniqueness,
    ACTIONS(1011), 2,
      anon_sym_ordered,
      anon_sym_unordered,
    ACTIONS(1013), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [13378] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1097), 1,
      sym_identifier,
    ACTIONS(1099), 1,
      anon_sym_LBRACK,
    STATE(199), 1,
      sym_qualified_identifier,
    STATE(215), 3,
      sym__import,
      sym_member_import,
      sym_module_import,
  [13396] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(368), 1,
      aux_sym_type_parameter_repeat1,
    STATE(378), 1,
      sym_type_op_combiner,
    ACTIONS(1101), 2,
      sym_identifier,
      anon_sym_RPAREN,
    ACTIONS(1103), 2,
      anon_sym_PLUS,
      anon_sym_u2295,
  [13414] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(847), 1,
      sym_identifier,
    ACTIONS(1105), 1,
      anon_sym_end,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(399), 1,
      sym_identifier_reference,
    STATE(371), 2,
      sym_type_variant,
      aux_sym_union_body_repeat1,
  [13434] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(368), 1,
      aux_sym_type_parameter_repeat1,
    STATE(378), 1,
      sym_type_op_combiner,
    ACTIONS(1107), 2,
      sym_identifier,
      anon_sym_RPAREN,
    ACTIONS(1109), 2,
      anon_sym_PLUS,
      anon_sym_u2295,
  [13452] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(241), 1,
      anon_sym_AT,
    ACTIONS(243), 1,
      anon_sym_assert,
    STATE(173), 2,
      sym_annotation_property,
      sym_constraint,
    STATE(347), 2,
      sym_annotation,
      aux_sym_module_body_repeat2,
  [13470] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(366), 1,
      aux_sym_type_parameter_repeat1,
    STATE(378), 1,
      sym_type_op_combiner,
    ACTIONS(1103), 2,
      anon_sym_PLUS,
      anon_sym_u2295,
    ACTIONS(1112), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [13488] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1114), 1,
      sym_identifier,
    ACTIONS(1117), 1,
      anon_sym_end,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(399), 1,
      sym_identifier_reference,
    STATE(371), 2,
      sym_type_variant,
      aux_sym_union_body_repeat1,
  [13508] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1097), 1,
      sym_identifier,
    ACTIONS(1119), 1,
      anon_sym_LBRACK,
    STATE(199), 1,
      sym_qualified_identifier,
    STATE(222), 3,
      sym__import,
      sym_member_import,
      sym_module_import,
  [13526] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1025), 1,
      sym_identifier,
    STATE(429), 1,
      sym_qualified_identifier,
    STATE(346), 4,
      sym__import,
      sym_member_import,
      sym_module_import,
      aux_sym_import_statement_repeat1,
  [13542] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(737), 1,
      anon_sym_is,
    ACTIONS(1121), 1,
      sym_identifier,
    STATE(426), 1,
      sym_annotation_only_body,
    ACTIONS(1123), 3,
      anon_sym_end,
      anon_sym_parent,
      anon_sym_ref,
  [13560] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1125), 1,
      anon_sym_is,
    ACTIONS(1127), 1,
      anon_sym_EQ,
    ACTIONS(1129), 1,
      anon_sym_with,
    STATE(581), 1,
      sym_constraint_environment,
    STATE(180), 2,
      sym_informal_constraint,
      sym_formal_constraint,
  [13580] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1025), 1,
      sym_identifier,
    STATE(429), 1,
      sym_qualified_identifier,
    STATE(339), 4,
      sym__import,
      sym_member_import,
      sym_module_import,
      aux_sym_import_statement_repeat1,
  [13596] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1017), 1,
      sym_unsigned,
    ACTIONS(1131), 1,
      anon_sym_RBRACE,
    STATE(454), 1,
      sym_sequence_uniqueness,
    STATE(534), 1,
      sym__cardinality_inner,
    ACTIONS(1013), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [13616] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(53), 1,
      anon_sym_LBRACE,
    ACTIONS(1095), 1,
      sym_identifier,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(384), 1,
      sym_identifier_reference,
    STATE(423), 1,
      sym_type_parameter_restriction,
    STATE(444), 1,
      sym_cardinality_reference_expression,
  [13638] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(1133), 1,
      anon_sym_is,
    STATE(505), 1,
      sym__module_locations,
    STATE(507), 1,
      sym_iri,
    STATE(554), 1,
      sym_module_body,
  [13657] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(919), 1,
      anon_sym_def,
    ACTIONS(1135), 1,
      anon_sym_is,
    STATE(437), 1,
      sym_function_signature,
    STATE(385), 2,
      sym_function_def,
      aux_sym_constraint_environment_repeat1,
  [13674] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1137), 1,
      sym_identifier,
    ACTIONS(1140), 1,
      anon_sym_RBRACK,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      aux_sym_rdf_types_repeat1,
    STATE(506), 1,
      sym_identifier_reference,
  [13693] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1142), 1,
      sym_identifier,
    ACTIONS(1144), 1,
      anon_sym_COLON_COLON,
    STATE(571), 3,
      sym_module_path_root_only,
      sym_module_path_absolute,
      sym_module_path_relative,
  [13708] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1146), 1,
      anon_sym_LPAREN,
    STATE(11), 1,
      sym__type_op_has_type,
    STATE(402), 1,
      sym__function_type,
    ACTIONS(1148), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [13725] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1152), 1,
      anon_sym_LPAREN,
    ACTIONS(1150), 4,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_u2295,
  [13738] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1154), 1,
      anon_sym_is,
    ACTIONS(1156), 1,
      anon_sym_def,
    STATE(437), 1,
      sym_function_signature,
    STATE(385), 2,
      sym_function_def,
      aux_sym_constraint_environment_repeat1,
  [13755] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1159), 1,
      sym_identifier,
    ACTIONS(1163), 1,
      anon_sym_with,
    ACTIONS(1161), 3,
      anon_sym_end,
      anon_sym_parent,
      anon_sym_ref,
  [13770] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1167), 1,
      sym_kw_is_fixed,
    STATE(260), 1,
      sym_tz_restriction_value,
    ACTIONS(1165), 3,
      anon_sym_required,
      anon_sym_prohibited,
      anon_sym_optional,
  [13785] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1095), 1,
      sym_identifier,
    ACTIONS(1169), 1,
      anon_sym_RBRACK,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(391), 1,
      aux_sym_rdf_types_repeat1,
    STATE(506), 1,
      sym_identifier_reference,
  [13804] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1173), 1,
      anon_sym_LPAREN,
    ACTIONS(1171), 4,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_u2295,
  [13817] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1017), 1,
      sym_unsigned,
    STATE(485), 1,
      sym_sequence_uniqueness,
    STATE(532), 1,
      sym__cardinality_inner,
    ACTIONS(1013), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [13834] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1095), 1,
      sym_identifier,
    ACTIONS(1175), 1,
      anon_sym_RBRACK,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(381), 1,
      aux_sym_rdf_types_repeat1,
    STATE(506), 1,
      sym_identifier_reference,
  [13853] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(919), 1,
      anon_sym_def,
    ACTIONS(1177), 1,
      anon_sym_end,
    STATE(334), 1,
      sym_function_signature,
    STATE(395), 1,
      aux_sym_type_class_body_repeat1,
    STATE(510), 1,
      sym_method_def,
  [13872] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(363), 1,
      sym__type_op_type_restriction,
    ACTIONS(1179), 2,
      sym_identifier,
      anon_sym_RPAREN,
    ACTIONS(1181), 2,
      anon_sym_u2190,
      anon_sym_LT_DASH,
  [13887] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(919), 1,
      anon_sym_def,
    ACTIONS(1183), 1,
      anon_sym_end,
    STATE(334), 1,
      sym_function_signature,
    STATE(395), 1,
      aux_sym_type_class_body_repeat1,
    STATE(510), 1,
      sym_method_def,
  [13906] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1185), 1,
      anon_sym_end,
    ACTIONS(1187), 1,
      anon_sym_def,
    STATE(334), 1,
      sym_function_signature,
    STATE(395), 1,
      aux_sym_type_class_body_repeat1,
    STATE(510), 1,
      sym_method_def,
  [13925] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(805), 1,
      sym_identifier,
    ACTIONS(809), 1,
      anon_sym_ref,
    STATE(406), 1,
      sym_member,
    STATE(414), 2,
      sym_member_def,
      sym_property_ref,
  [13942] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1192), 1,
      anon_sym_RPAREN,
    STATE(400), 1,
      aux_sym_type_parameter_restriction_repeat1,
    STATE(456), 1,
      sym_type_restriction_argument,
    ACTIONS(1190), 2,
      sym_identifier,
      sym_wildcard,
  [13959] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1194), 5,
      anon_sym_is,
      anon_sym_end,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [13970] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(737), 1,
      anon_sym_is,
    ACTIONS(1196), 1,
      sym_identifier,
    ACTIONS(1198), 1,
      anon_sym_end,
    ACTIONS(1200), 1,
      anon_sym_as,
    STATE(488), 1,
      sym_annotation_only_body,
  [13989] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1205), 1,
      anon_sym_RPAREN,
    STATE(400), 1,
      aux_sym_type_parameter_restriction_repeat1,
    STATE(456), 1,
      sym_type_restriction_argument,
    ACTIONS(1202), 2,
      sym_identifier,
      sym_wildcard,
  [14006] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1207), 1,
      anon_sym_RPAREN,
    STATE(400), 1,
      aux_sym_type_parameter_restriction_repeat1,
    STATE(456), 1,
      sym_type_restriction_argument,
    ACTIONS(1190), 2,
      sym_identifier,
      sym_wildcard,
  [14023] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1209), 5,
      anon_sym_is,
      anon_sym_end,
      anon_sym_def,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [14034] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1211), 1,
      sym_identifier,
    ACTIONS(1213), 1,
      anon_sym_RPAREN,
    STATE(425), 1,
      aux_sym_type_class_def_repeat1,
    STATE(484), 1,
      sym_type_parameter,
  [14050] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(737), 1,
      anon_sym_is,
    ACTIONS(1215), 1,
      sym_identifier,
    ACTIONS(1217), 1,
      anon_sym_end,
    STATE(491), 1,
      sym_annotation_only_body,
  [14066] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1219), 1,
      sym_identifier,
    ACTIONS(1221), 3,
      anon_sym_in,
      anon_sym_u2208,
      sym_set_op_builder,
  [14078] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1223), 1,
      sym_identifier,
    ACTIONS(1225), 3,
      anon_sym_end,
      anon_sym_parent,
      anon_sym_ref,
  [14090] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(11), 1,
      sym__type_op_has_type,
    STATE(493), 1,
      sym__function_type,
    ACTIONS(1148), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [14104] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1227), 1,
      sym_identifier,
    ACTIONS(1229), 1,
      anon_sym_RPAREN,
    STATE(418), 1,
      aux_sym_function_signature_repeat1,
    STATE(483), 1,
      sym_function_parameter,
  [14120] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1231), 1,
      sym_identifier,
    ACTIONS(1233), 1,
      anon_sym_LBRACK,
    ACTIONS(1235), 1,
      sym_wildcard,
    STATE(231), 1,
      sym__wildcard_or_identifier_or_sequence,
  [14136] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1237), 1,
      sym_identifier,
    ACTIONS(1239), 3,
      anon_sym_end,
      anon_sym_parent,
      anon_sym_ref,
  [14148] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(919), 1,
      anon_sym_def,
    STATE(437), 1,
      sym_function_signature,
    STATE(380), 2,
      sym_function_def,
      aux_sym_constraint_environment_repeat1,
  [14162] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(989), 1,
      sym_identifier,
    ACTIONS(1241), 1,
      anon_sym_end,
    STATE(413), 2,
      sym_value_variant,
      aux_sym_enum_body_repeat1,
  [14176] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1243), 1,
      sym_identifier,
    ACTIONS(1246), 1,
      anon_sym_end,
    STATE(413), 2,
      sym_value_variant,
      aux_sym_enum_body_repeat1,
  [14190] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1248), 1,
      sym_identifier,
    ACTIONS(1250), 3,
      anon_sym_end,
      anon_sym_parent,
      anon_sym_ref,
  [14202] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(397), 1,
      aux_sym_type_parameter_restriction_repeat1,
    STATE(456), 1,
      sym_type_restriction_argument,
    ACTIONS(1190), 2,
      sym_identifier,
      sym_wildcard,
  [14216] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(737), 1,
      anon_sym_is,
    ACTIONS(1252), 1,
      sym_identifier,
    ACTIONS(1254), 1,
      anon_sym_end,
    STATE(502), 1,
      sym_annotation_only_body,
  [14232] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(11), 1,
      sym__type_op_has_type,
    STATE(398), 1,
      sym__function_type,
    ACTIONS(1148), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [14246] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1256), 1,
      sym_identifier,
    ACTIONS(1259), 1,
      anon_sym_RPAREN,
    STATE(418), 1,
      aux_sym_function_signature_repeat1,
    STATE(483), 1,
      sym_function_parameter,
  [14262] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1261), 1,
      sym_identifier,
    ACTIONS(1263), 1,
      sym_set_op_builder,
    STATE(434), 1,
      aux_sym_sequence_builder_repeat1,
    STATE(508), 1,
      sym_variable,
  [14278] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(259), 1,
      sym_tz_restriction_value,
    ACTIONS(1165), 3,
      anon_sym_required,
      anon_sym_prohibited,
      anon_sym_optional,
  [14290] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1265), 1,
      sym_identifier,
    ACTIONS(1267), 3,
      anon_sym_end,
      anon_sym_parent,
      anon_sym_ref,
  [14302] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(737), 1,
      anon_sym_is,
    STATE(492), 1,
      sym_annotation_only_body,
    ACTIONS(1269), 2,
      anon_sym_end,
      anon_sym_def,
  [14316] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1107), 4,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_u2295,
  [14326] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(401), 1,
      aux_sym_type_parameter_restriction_repeat1,
    STATE(456), 1,
      sym_type_restriction_argument,
    ACTIONS(1190), 2,
      sym_identifier,
      sym_wildcard,
  [14340] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1271), 1,
      sym_identifier,
    ACTIONS(1274), 1,
      anon_sym_RPAREN,
    STATE(425), 1,
      aux_sym_type_class_def_repeat1,
    STATE(484), 1,
      sym_type_parameter,
  [14356] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1276), 1,
      sym_identifier,
    ACTIONS(1278), 3,
      anon_sym_end,
      anon_sym_parent,
      anon_sym_ref,
  [14368] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1280), 4,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_u2295,
  [14378] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1282), 4,
      sym_identifier,
      anon_sym_RPAREN,
      anon_sym_PLUS,
      anon_sym_u2295,
  [14388] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(717), 1,
      anon_sym_RBRACK,
    ACTIONS(1084), 1,
      anon_sym_as,
    ACTIONS(1284), 1,
      sym_identifier,
    STATE(181), 1,
      sym__rename_import,
  [14404] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(675), 1,
      anon_sym_RBRACK,
    ACTIONS(1084), 1,
      anon_sym_as,
    ACTIONS(1286), 1,
      sym_identifier,
    STATE(193), 1,
      sym__rename_import,
  [14420] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(6), 1,
      sym__type_op_has_type,
    STATE(204), 1,
      sym__type_expression_to,
    ACTIONS(1288), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [14434] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1290), 4,
      anon_sym_RBRACE,
      sym_unsigned,
      anon_sym_unique,
      anon_sym_nonunique,
  [14444] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1292), 1,
      anon_sym_RBRACE,
    STATE(519), 1,
      sym_sequence_uniqueness,
    ACTIONS(1013), 2,
      anon_sym_unique,
      anon_sym_nonunique,
  [14458] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1294), 1,
      sym_identifier,
    ACTIONS(1297), 1,
      sym_set_op_builder,
    STATE(434), 1,
      aux_sym_sequence_builder_repeat1,
    STATE(508), 1,
      sym_variable,
  [14474] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1095), 1,
      sym_identifier,
    ACTIONS(1299), 1,
      anon_sym_LBRACK,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(247), 1,
      sym_identifier_reference,
  [14490] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1301), 1,
      anon_sym_with,
    ACTIONS(1303), 1,
      anon_sym_without,
    STATE(237), 2,
      sym_from_definition_with,
      sym_from_definition_without,
  [14504] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(24), 1,
      sym__function_op_by_definition,
    STATE(511), 1,
      sym_function_body,
    ACTIONS(1305), 2,
      anon_sym_COLON_EQ,
      anon_sym_u2254,
  [14518] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1261), 1,
      sym_identifier,
    ACTIONS(1307), 1,
      sym_set_op_builder,
    STATE(434), 1,
      aux_sym_sequence_builder_repeat1,
    STATE(508), 1,
      sym_variable,
  [14534] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(989), 1,
      sym_identifier,
    ACTIONS(991), 1,
      anon_sym_end,
    STATE(413), 2,
      sym_value_variant,
      aux_sym_enum_body_repeat1,
  [14548] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(55), 1,
      sym_set_op_membership,
    ACTIONS(1309), 2,
      anon_sym_in,
      anon_sym_u2208,
  [14559] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1311), 1,
      sym_identifier,
    ACTIONS(1313), 1,
      anon_sym_RBRACK,
    STATE(453), 1,
      aux_sym__wildcard_or_identifier_or_sequence_repeat1,
  [14572] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1311), 1,
      sym_identifier,
    ACTIONS(1315), 1,
      anon_sym_RBRACK,
    STATE(453), 1,
      aux_sym__wildcard_or_identifier_or_sequence_repeat1,
  [14585] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1095), 1,
      sym_identifier,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(421), 1,
      sym_identifier_reference,
  [14598] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1095), 1,
      sym_identifier,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(389), 1,
      sym_identifier_reference,
  [14611] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1017), 1,
      sym_unsigned,
    ACTIONS(1317), 1,
      anon_sym_RBRACE,
    STATE(569), 1,
      sym__cardinality_inner,
  [14624] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(17), 1,
      sym__type_op_has_type,
    ACTIONS(1319), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [14635] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1321), 1,
      anon_sym_import,
    ACTIONS(1323), 1,
      anon_sym_COLON_COLON2,
    STATE(447), 1,
      aux_sym_module_path_absolute_repeat1,
  [14648] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1326), 1,
      anon_sym_RBRACE,
    ACTIONS(1328), 1,
      anon_sym_DOT_DOT,
    STATE(572), 1,
      sym_cardinality_range,
  [14661] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1095), 1,
      sym_identifier,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(436), 1,
      sym_identifier_reference,
  [14674] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1095), 1,
      sym_identifier,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(550), 1,
      sym_identifier_reference,
  [14687] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(588), 1,
      anon_sym_LPAREN,
    ACTIONS(1330), 1,
      anon_sym_COMMA,
    STATE(158), 1,
      sym__actual_arguments,
  [14700] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1332), 1,
      anon_sym_LBRACK,
    ACTIONS(1334), 1,
      anon_sym_u2205,
    STATE(54), 1,
      sym__value_empty_sequence,
  [14713] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1336), 1,
      sym_identifier,
    ACTIONS(1339), 1,
      anon_sym_RBRACK,
    STATE(453), 1,
      aux_sym__wildcard_or_identifier_or_sequence_repeat1,
  [14726] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1017), 1,
      sym_unsigned,
    ACTIONS(1341), 1,
      anon_sym_RBRACE,
    STATE(558), 1,
      sym__cardinality_inner,
  [14739] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1343), 3,
      sym_identifier,
      anon_sym_RPAREN,
      sym_wildcard,
  [14748] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1345), 3,
      sym_identifier,
      anon_sym_RPAREN,
      sym_wildcard,
  [14757] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1347), 1,
      anon_sym_import,
    ACTIONS(1349), 1,
      anon_sym_COLON_COLON2,
    STATE(476), 1,
      aux_sym_module_path_absolute_repeat1,
  [14770] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(25), 1,
      sym__type_op_type_restriction,
    ACTIONS(1351), 2,
      anon_sym_u2190,
      anon_sym_LT_DASH,
  [14781] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1353), 1,
      anon_sym_RBRACK,
    ACTIONS(1355), 1,
      sym_quoted_string,
    STATE(462), 1,
      aux_sym_pattern_restriction_facet_repeat1,
  [14794] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1357), 1,
      sym_identifier,
    STATE(101), 1,
      sym_qualified_identifier,
    STATE(386), 1,
      sym_identifier_reference,
  [14807] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      anon_sym_LT,
    ACTIONS(1359), 1,
      sym_quoted_string,
    STATE(531), 1,
      sym_iri,
  [14820] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1361), 1,
      anon_sym_RBRACK,
    ACTIONS(1363), 1,
      sym_quoted_string,
    STATE(462), 1,
      aux_sym_pattern_restriction_facet_repeat1,
  [14833] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1349), 1,
      anon_sym_COLON_COLON2,
    ACTIONS(1366), 1,
      anon_sym_import,
    STATE(447), 1,
      aux_sym_module_path_absolute_repeat1,
  [14846] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1368), 1,
      anon_sym_RBRACK,
    ACTIONS(1370), 1,
      sym_hex_byte,
    STATE(464), 1,
      aux_sym_binary_repeat1,
  [14859] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1332), 1,
      anon_sym_LBRACK,
    ACTIONS(1334), 1,
      anon_sym_u2205,
    STATE(54), 1,
      sym__value_empty_sequence,
  [14872] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1373), 1,
      sym_identifier,
    ACTIONS(1375), 1,
      anon_sym_LBRACK,
    STATE(241), 1,
      sym__identifier_or_sequence,
  [14885] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1377), 1,
      anon_sym_LBRACK,
    ACTIONS(1379), 1,
      anon_sym_u2205,
    STATE(147), 1,
      sym__value_empty_sequence,
  [14898] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1095), 1,
      sym_identifier,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(405), 1,
      sym_identifier_reference,
  [14911] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1381), 1,
      anon_sym_RBRACK,
    ACTIONS(1383), 1,
      sym_hex_byte,
    STATE(464), 1,
      aux_sym_binary_repeat1,
  [14924] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1385), 1,
      anon_sym_LBRACK,
    ACTIONS(1387), 1,
      anon_sym_u2205,
    STATE(86), 1,
      sym__value_empty_sequence,
  [14937] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1227), 1,
      sym_identifier,
    STATE(408), 1,
      aux_sym_function_signature_repeat1,
    STATE(483), 1,
      sym_function_parameter,
  [14950] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1095), 1,
      sym_identifier,
    STATE(5), 1,
      sym_qualified_identifier,
    STATE(374), 1,
      sym_identifier_reference,
  [14963] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1261), 1,
      sym_identifier,
    STATE(440), 1,
      sym_variable,
    STATE(551), 1,
      sym_quantified_variable,
  [14976] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1383), 1,
      sym_hex_byte,
    ACTIONS(1389), 1,
      anon_sym_RBRACK,
    STATE(475), 1,
      aux_sym_binary_repeat1,
  [14989] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1383), 1,
      sym_hex_byte,
    ACTIONS(1391), 1,
      anon_sym_RBRACK,
    STATE(464), 1,
      aux_sym_binary_repeat1,
  [15002] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1349), 1,
      anon_sym_COLON_COLON2,
    ACTIONS(1393), 1,
      anon_sym_import,
    STATE(447), 1,
      aux_sym_module_path_absolute_repeat1,
  [15015] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1373), 1,
      sym_identifier,
    ACTIONS(1375), 1,
      anon_sym_LBRACK,
    STATE(410), 1,
      sym__identifier_or_sequence,
  [15028] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(472), 1,
      sym__type_op_has_type,
    ACTIONS(1395), 2,
      anon_sym_u2192,
      anon_sym_DASH_GT,
  [15039] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1349), 1,
      anon_sym_COLON_COLON2,
    ACTIONS(1397), 1,
      anon_sym_import,
    STATE(463), 1,
      aux_sym_module_path_absolute_repeat1,
  [15052] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1211), 1,
      sym_identifier,
    STATE(403), 1,
      aux_sym_type_class_def_repeat1,
    STATE(484), 1,
      sym_type_parameter,
  [15065] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1383), 1,
      sym_hex_byte,
    ACTIONS(1399), 1,
      anon_sym_RBRACK,
    STATE(469), 1,
      aux_sym_binary_repeat1,
  [15078] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1401), 1,
      sym_unsigned,
    ACTIONS(1403), 1,
      sym_kw_is_fixed,
  [15088] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1405), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [15096] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1407), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [15104] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1017), 1,
      sym_unsigned,
    STATE(540), 1,
      sym__cardinality_inner,
  [15114] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1409), 2,
      sym_identifier,
      anon_sym_LBRACE,
  [15122] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1411), 1,
      sym_identifier,
    ACTIONS(1413), 1,
      anon_sym_import,
  [15132] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1415), 1,
      sym_identifier,
    ACTIONS(1417), 1,
      anon_sym_end,
  [15142] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1419), 2,
      anon_sym_import,
      anon_sym_COLON_COLON2,
  [15150] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1311), 1,
      sym_identifier,
    STATE(442), 1,
      aux_sym__wildcard_or_identifier_or_sequence_repeat1,
  [15160] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1421), 1,
      sym_identifier,
    ACTIONS(1423), 1,
      anon_sym_end,
  [15170] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1425), 2,
      anon_sym_end,
      anon_sym_def,
  [15178] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1427), 2,
      sym_identifier,
      anon_sym_RPAREN,
  [15186] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1429), 1,
      sym_identifier,
    STATE(270), 1,
      sym_member_def,
  [15196] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1431), 2,
      anon_sym_LBRACK,
      anon_sym_u2205,
  [15204] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1433), 1,
      sym_unsigned,
    ACTIONS(1435), 1,
      sym_kw_is_fixed,
  [15214] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1437), 2,
      anon_sym_LBRACK,
      anon_sym_u2205,
  [15222] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1439), 2,
      anon_sym_end,
      anon_sym_def,
  [15230] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1441), 2,
      anon_sym_RBRACE,
      sym_unsigned,
  [15238] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1017), 1,
      sym_unsigned,
    STATE(580), 1,
      sym__cardinality_inner,
  [15248] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1443), 2,
      anon_sym_RBRACK,
      sym_identifier,
  [15256] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1445), 1,
      sym_identifier,
    ACTIONS(1447), 1,
      anon_sym_end,
  [15266] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1449), 2,
      anon_sym_RBRACK,
      sym_hex_byte,
  [15274] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1451), 2,
      anon_sym_LBRACK,
      anon_sym_u2205,
  [15282] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1133), 1,
      anon_sym_is,
    STATE(577), 1,
      sym_module_body,
  [15292] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1453), 2,
      anon_sym_RBRACK,
      sym_identifier,
  [15300] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1455), 1,
      anon_sym_version,
    ACTIONS(1457), 1,
      anon_sym_is,
  [15310] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1459), 2,
      sym_identifier,
      sym_set_op_builder,
  [15318] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1461), 1,
      sym_quoted_string,
    STATE(459), 1,
      aux_sym_pattern_restriction_facet_repeat1,
  [15328] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1463), 2,
      anon_sym_end,
      anon_sym_def,
  [15336] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1465), 2,
      anon_sym_is,
      anon_sym_def,
  [15344] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1467), 1,
      anon_sym_RBRACE,
    ACTIONS(1469), 1,
      sym_unsigned,
  [15354] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      anon_sym_LT,
    STATE(537), 1,
      sym_iri,
  [15364] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1311), 1,
      sym_identifier,
    STATE(441), 1,
      aux_sym__wildcard_or_identifier_or_sequence_repeat1,
  [15374] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1471), 1,
      anon_sym_LBRACK,
    ACTIONS(1473), 1,
      sym_quoted_string,
  [15384] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1475), 1,
      sym_unsigned,
  [15391] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1477), 1,
      anon_sym_RBRACE,
  [15398] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1479), 1,
      sym_identifier,
  [15405] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1481), 1,
      anon_sym_RBRACE,
  [15412] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1483), 1,
      sym_identifier,
  [15419] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1485), 1,
      ts_builtin_sym_end,
  [15426] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1487), 1,
      ts_builtin_sym_end,
  [15433] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1489), 1,
      sym_identifier,
  [15440] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1491), 1,
      anon_sym_RPAREN,
  [15447] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1493), 1,
      ts_builtin_sym_end,
  [15454] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1495), 1,
      sym_identifier,
  [15461] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1497), 1,
      sym_identifier,
  [15468] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1499), 1,
      sym_identifier,
  [15475] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1501), 1,
      sym_identifier,
  [15482] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1503), 1,
      sym_identifier,
  [15489] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1505), 1,
      anon_sym_is,
  [15496] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1507), 1,
      anon_sym_RBRACE,
  [15503] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1509), 1,
      sym_identifier,
  [15510] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1511), 1,
      anon_sym_RBRACE,
  [15517] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1513), 1,
      anon_sym_RBRACE,
  [15524] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1515), 1,
      anon_sym_RBRACE,
  [15531] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1517), 1,
      anon_sym_is,
  [15538] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1519), 1,
      sym_identifier,
  [15545] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1521), 1,
      sym_identifier,
  [15552] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1523), 1,
      anon_sym_RBRACE,
  [15559] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1525), 1,
      sym_unsigned,
  [15566] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1527), 1,
      anon_sym_import,
  [15573] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1529), 1,
      sym_quoted_string,
  [15580] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1531), 1,
      ts_builtin_sym_end,
  [15587] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1533), 1,
      anon_sym_COMMA,
  [15594] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1535), 1,
      ts_builtin_sym_end,
  [15601] = 2,
    ACTIONS(1537), 1,
      aux_sym_iri_token1,
    ACTIONS(1539), 1,
      sym_line_comment,
  [15608] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1541), 1,
      sym_identifier,
  [15615] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(229), 1,
      anon_sym_LPAREN,
  [15622] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1543), 1,
      anon_sym_EQ,
  [15629] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1545), 1,
      anon_sym_COMMA,
  [15636] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1547), 1,
      anon_sym_RPAREN,
  [15643] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1549), 1,
      sym_identifier,
  [15650] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1551), 1,
      ts_builtin_sym_end,
  [15657] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1553), 1,
      anon_sym_GT,
  [15664] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1555), 1,
      sym_identifier,
  [15671] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1557), 1,
      anon_sym_RBRACE,
  [15678] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1559), 1,
      anon_sym_RBRACE,
  [15685] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1561), 1,
      sym_identifier,
  [15692] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1563), 1,
      anon_sym_EQ,
  [15699] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1565), 1,
      anon_sym_EQ,
  [15706] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1567), 1,
      anon_sym_RBRACE,
  [15713] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1569), 1,
      anon_sym_EQ,
  [15720] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1571), 1,
      sym_identifier,
  [15727] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1573), 1,
      anon_sym_EQ,
  [15734] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1575), 1,
      anon_sym_EQ,
  [15741] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1577), 1,
      sym_identifier,
  [15748] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1579), 1,
      sym_identifier,
  [15755] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1581), 1,
      anon_sym_RBRACE,
  [15762] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1583), 1,
      anon_sym_RBRACE,
  [15769] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1585), 1,
      anon_sym_import,
  [15776] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1587), 1,
      anon_sym_RBRACE,
  [15783] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1589), 1,
      sym_identifier,
  [15790] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1591), 1,
      anon_sym_GT,
  [15797] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1593), 1,
      anon_sym_RBRACE,
  [15804] = 2,
    ACTIONS(1539), 1,
      sym_line_comment,
    ACTIONS(1595), 1,
      aux_sym_iri_token1,
  [15811] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1597), 1,
      ts_builtin_sym_end,
  [15818] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1599), 1,
      anon_sym_COMMA,
  [15825] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1601), 1,
      sym_identifier,
  [15832] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1603), 1,
      anon_sym_RBRACE,
  [15839] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1605), 1,
      anon_sym_is,
  [15846] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1607), 1,
      sym_identifier,
  [15853] = 2,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1609), 1,
      sym_identifier,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 69,
  [SMALL_STATE(4)] = 138,
  [SMALL_STATE(5)] = 206,
  [SMALL_STATE(6)] = 272,
  [SMALL_STATE(7)] = 356,
  [SMALL_STATE(8)] = 421,
  [SMALL_STATE(9)] = 486,
  [SMALL_STATE(10)] = 551,
  [SMALL_STATE(11)] = 616,
  [SMALL_STATE(12)] = 697,
  [SMALL_STATE(13)] = 762,
  [SMALL_STATE(14)] = 827,
  [SMALL_STATE(15)] = 892,
  [SMALL_STATE(16)] = 970,
  [SMALL_STATE(17)] = 1048,
  [SMALL_STATE(18)] = 1126,
  [SMALL_STATE(19)] = 1201,
  [SMALL_STATE(20)] = 1325,
  [SMALL_STATE(21)] = 1449,
  [SMALL_STATE(22)] = 1573,
  [SMALL_STATE(23)] = 1697,
  [SMALL_STATE(24)] = 1821,
  [SMALL_STATE(25)] = 1945,
  [SMALL_STATE(26)] = 2017,
  [SMALL_STATE(27)] = 2141,
  [SMALL_STATE(28)] = 2265,
  [SMALL_STATE(29)] = 2389,
  [SMALL_STATE(30)] = 2513,
  [SMALL_STATE(31)] = 2637,
  [SMALL_STATE(32)] = 2706,
  [SMALL_STATE(33)] = 2760,
  [SMALL_STATE(34)] = 2814,
  [SMALL_STATE(35)] = 2868,
  [SMALL_STATE(36)] = 2922,
  [SMALL_STATE(37)] = 2976,
  [SMALL_STATE(38)] = 3029,
  [SMALL_STATE(39)] = 3082,
  [SMALL_STATE(40)] = 3135,
  [SMALL_STATE(41)] = 3188,
  [SMALL_STATE(42)] = 3241,
  [SMALL_STATE(43)] = 3294,
  [SMALL_STATE(44)] = 3347,
  [SMALL_STATE(45)] = 3400,
  [SMALL_STATE(46)] = 3447,
  [SMALL_STATE(47)] = 3531,
  [SMALL_STATE(48)] = 3615,
  [SMALL_STATE(49)] = 3699,
  [SMALL_STATE(50)] = 3783,
  [SMALL_STATE(51)] = 3867,
  [SMALL_STATE(52)] = 3912,
  [SMALL_STATE(53)] = 3954,
  [SMALL_STATE(54)] = 4034,
  [SMALL_STATE(55)] = 4076,
  [SMALL_STATE(56)] = 4154,
  [SMALL_STATE(57)] = 4196,
  [SMALL_STATE(58)] = 4274,
  [SMALL_STATE(59)] = 4352,
  [SMALL_STATE(60)] = 4432,
  [SMALL_STATE(61)] = 4474,
  [SMALL_STATE(62)] = 4516,
  [SMALL_STATE(63)] = 4558,
  [SMALL_STATE(64)] = 4600,
  [SMALL_STATE(65)] = 4642,
  [SMALL_STATE(66)] = 4723,
  [SMALL_STATE(67)] = 4772,
  [SMALL_STATE(68)] = 4853,
  [SMALL_STATE(69)] = 4934,
  [SMALL_STATE(70)] = 5015,
  [SMALL_STATE(71)] = 5096,
  [SMALL_STATE(72)] = 5177,
  [SMALL_STATE(73)] = 5258,
  [SMALL_STATE(74)] = 5339,
  [SMALL_STATE(75)] = 5420,
  [SMALL_STATE(76)] = 5466,
  [SMALL_STATE(77)] = 5512,
  [SMALL_STATE(78)] = 5558,
  [SMALL_STATE(79)] = 5604,
  [SMALL_STATE(80)] = 5679,
  [SMALL_STATE(81)] = 5754,
  [SMALL_STATE(82)] = 5829,
  [SMALL_STATE(83)] = 5867,
  [SMALL_STATE(84)] = 5934,
  [SMALL_STATE(85)] = 6001,
  [SMALL_STATE(86)] = 6037,
  [SMALL_STATE(87)] = 6073,
  [SMALL_STATE(88)] = 6109,
  [SMALL_STATE(89)] = 6145,
  [SMALL_STATE(90)] = 6181,
  [SMALL_STATE(91)] = 6217,
  [SMALL_STATE(92)] = 6253,
  [SMALL_STATE(93)] = 6289,
  [SMALL_STATE(94)] = 6325,
  [SMALL_STATE(95)] = 6361,
  [SMALL_STATE(96)] = 6397,
  [SMALL_STATE(97)] = 6434,
  [SMALL_STATE(98)] = 6496,
  [SMALL_STATE(99)] = 6558,
  [SMALL_STATE(100)] = 6620,
  [SMALL_STATE(101)] = 6682,
  [SMALL_STATE(102)] = 6716,
  [SMALL_STATE(103)] = 6750,
  [SMALL_STATE(104)] = 6812,
  [SMALL_STATE(105)] = 6847,
  [SMALL_STATE(106)] = 6906,
  [SMALL_STATE(107)] = 6941,
  [SMALL_STATE(108)] = 6973,
  [SMALL_STATE(109)] = 7005,
  [SMALL_STATE(110)] = 7061,
  [SMALL_STATE(111)] = 7093,
  [SMALL_STATE(112)] = 7125,
  [SMALL_STATE(113)] = 7157,
  [SMALL_STATE(114)] = 7189,
  [SMALL_STATE(115)] = 7229,
  [SMALL_STATE(116)] = 7282,
  [SMALL_STATE(117)] = 7335,
  [SMALL_STATE(118)] = 7388,
  [SMALL_STATE(119)] = 7441,
  [SMALL_STATE(120)] = 7472,
  [SMALL_STATE(121)] = 7509,
  [SMALL_STATE(122)] = 7546,
  [SMALL_STATE(123)] = 7579,
  [SMALL_STATE(124)] = 7616,
  [SMALL_STATE(125)] = 7653,
  [SMALL_STATE(126)] = 7683,
  [SMALL_STATE(127)] = 7721,
  [SMALL_STATE(128)] = 7751,
  [SMALL_STATE(129)] = 7781,
  [SMALL_STATE(130)] = 7811,
  [SMALL_STATE(131)] = 7841,
  [SMALL_STATE(132)] = 7871,
  [SMALL_STATE(133)] = 7901,
  [SMALL_STATE(134)] = 7931,
  [SMALL_STATE(135)] = 7970,
  [SMALL_STATE(136)] = 8003,
  [SMALL_STATE(137)] = 8032,
  [SMALL_STATE(138)] = 8071,
  [SMALL_STATE(139)] = 8100,
  [SMALL_STATE(140)] = 8129,
  [SMALL_STATE(141)] = 8168,
  [SMALL_STATE(142)] = 8197,
  [SMALL_STATE(143)] = 8226,
  [SMALL_STATE(144)] = 8255,
  [SMALL_STATE(145)] = 8287,
  [SMALL_STATE(146)] = 8315,
  [SMALL_STATE(147)] = 8343,
  [SMALL_STATE(148)] = 8371,
  [SMALL_STATE(149)] = 8399,
  [SMALL_STATE(150)] = 8431,
  [SMALL_STATE(151)] = 8459,
  [SMALL_STATE(152)] = 8487,
  [SMALL_STATE(153)] = 8519,
  [SMALL_STATE(154)] = 8555,
  [SMALL_STATE(155)] = 8583,
  [SMALL_STATE(156)] = 8610,
  [SMALL_STATE(157)] = 8637,
  [SMALL_STATE(158)] = 8674,
  [SMALL_STATE(159)] = 8699,
  [SMALL_STATE(160)] = 8726,
  [SMALL_STATE(161)] = 8753,
  [SMALL_STATE(162)] = 8782,
  [SMALL_STATE(163)] = 8825,
  [SMALL_STATE(164)] = 8854,
  [SMALL_STATE(165)] = 8883,
  [SMALL_STATE(166)] = 8920,
  [SMALL_STATE(167)] = 8957,
  [SMALL_STATE(168)] = 8986,
  [SMALL_STATE(169)] = 9023,
  [SMALL_STATE(170)] = 9060,
  [SMALL_STATE(171)] = 9087,
  [SMALL_STATE(172)] = 9119,
  [SMALL_STATE(173)] = 9147,
  [SMALL_STATE(174)] = 9173,
  [SMALL_STATE(175)] = 9199,
  [SMALL_STATE(176)] = 9225,
  [SMALL_STATE(177)] = 9251,
  [SMALL_STATE(178)] = 9277,
  [SMALL_STATE(179)] = 9311,
  [SMALL_STATE(180)] = 9337,
  [SMALL_STATE(181)] = 9363,
  [SMALL_STATE(182)] = 9388,
  [SMALL_STATE(183)] = 9427,
  [SMALL_STATE(184)] = 9454,
  [SMALL_STATE(185)] = 9477,
  [SMALL_STATE(186)] = 9500,
  [SMALL_STATE(187)] = 9523,
  [SMALL_STATE(188)] = 9546,
  [SMALL_STATE(189)] = 9569,
  [SMALL_STATE(190)] = 9592,
  [SMALL_STATE(191)] = 9617,
  [SMALL_STATE(192)] = 9642,
  [SMALL_STATE(193)] = 9671,
  [SMALL_STATE(194)] = 9696,
  [SMALL_STATE(195)] = 9721,
  [SMALL_STATE(196)] = 9746,
  [SMALL_STATE(197)] = 9771,
  [SMALL_STATE(198)] = 9796,
  [SMALL_STATE(199)] = 9821,
  [SMALL_STATE(200)] = 9848,
  [SMALL_STATE(201)] = 9886,
  [SMALL_STATE(202)] = 9910,
  [SMALL_STATE(203)] = 9934,
  [SMALL_STATE(204)] = 9966,
  [SMALL_STATE(205)] = 9994,
  [SMALL_STATE(206)] = 10024,
  [SMALL_STATE(207)] = 10045,
  [SMALL_STATE(208)] = 10074,
  [SMALL_STATE(209)] = 10103,
  [SMALL_STATE(210)] = 10126,
  [SMALL_STATE(211)] = 10155,
  [SMALL_STATE(212)] = 10178,
  [SMALL_STATE(213)] = 10201,
  [SMALL_STATE(214)] = 10226,
  [SMALL_STATE(215)] = 10255,
  [SMALL_STATE(216)] = 10276,
  [SMALL_STATE(217)] = 10305,
  [SMALL_STATE(218)] = 10326,
  [SMALL_STATE(219)] = 10355,
  [SMALL_STATE(220)] = 10384,
  [SMALL_STATE(221)] = 10413,
  [SMALL_STATE(222)] = 10442,
  [SMALL_STATE(223)] = 10463,
  [SMALL_STATE(224)] = 10485,
  [SMALL_STATE(225)] = 10507,
  [SMALL_STATE(226)] = 10541,
  [SMALL_STATE(227)] = 10575,
  [SMALL_STATE(228)] = 10598,
  [SMALL_STATE(229)] = 10621,
  [SMALL_STATE(230)] = 10656,
  [SMALL_STATE(231)] = 10679,
  [SMALL_STATE(232)] = 10698,
  [SMALL_STATE(233)] = 10717,
  [SMALL_STATE(234)] = 10740,
  [SMALL_STATE(235)] = 10775,
  [SMALL_STATE(236)] = 10798,
  [SMALL_STATE(237)] = 10821,
  [SMALL_STATE(238)] = 10840,
  [SMALL_STATE(239)] = 10863,
  [SMALL_STATE(240)] = 10886,
  [SMALL_STATE(241)] = 10909,
  [SMALL_STATE(242)] = 10928,
  [SMALL_STATE(243)] = 10951,
  [SMALL_STATE(244)] = 10974,
  [SMALL_STATE(245)] = 10993,
  [SMALL_STATE(246)] = 11012,
  [SMALL_STATE(247)] = 11030,
  [SMALL_STATE(248)] = 11048,
  [SMALL_STATE(249)] = 11082,
  [SMALL_STATE(250)] = 11100,
  [SMALL_STATE(251)] = 11118,
  [SMALL_STATE(252)] = 11136,
  [SMALL_STATE(253)] = 11154,
  [SMALL_STATE(254)] = 11172,
  [SMALL_STATE(255)] = 11190,
  [SMALL_STATE(256)] = 11208,
  [SMALL_STATE(257)] = 11226,
  [SMALL_STATE(258)] = 11244,
  [SMALL_STATE(259)] = 11262,
  [SMALL_STATE(260)] = 11280,
  [SMALL_STATE(261)] = 11298,
  [SMALL_STATE(262)] = 11316,
  [SMALL_STATE(263)] = 11334,
  [SMALL_STATE(264)] = 11368,
  [SMALL_STATE(265)] = 11385,
  [SMALL_STATE(266)] = 11402,
  [SMALL_STATE(267)] = 11419,
  [SMALL_STATE(268)] = 11436,
  [SMALL_STATE(269)] = 11453,
  [SMALL_STATE(270)] = 11470,
  [SMALL_STATE(271)] = 11487,
  [SMALL_STATE(272)] = 11504,
  [SMALL_STATE(273)] = 11521,
  [SMALL_STATE(274)] = 11538,
  [SMALL_STATE(275)] = 11555,
  [SMALL_STATE(276)] = 11572,
  [SMALL_STATE(277)] = 11589,
  [SMALL_STATE(278)] = 11606,
  [SMALL_STATE(279)] = 11623,
  [SMALL_STATE(280)] = 11640,
  [SMALL_STATE(281)] = 11657,
  [SMALL_STATE(282)] = 11674,
  [SMALL_STATE(283)] = 11707,
  [SMALL_STATE(284)] = 11724,
  [SMALL_STATE(285)] = 11741,
  [SMALL_STATE(286)] = 11758,
  [SMALL_STATE(287)] = 11775,
  [SMALL_STATE(288)] = 11792,
  [SMALL_STATE(289)] = 11809,
  [SMALL_STATE(290)] = 11826,
  [SMALL_STATE(291)] = 11843,
  [SMALL_STATE(292)] = 11860,
  [SMALL_STATE(293)] = 11877,
  [SMALL_STATE(294)] = 11894,
  [SMALL_STATE(295)] = 11911,
  [SMALL_STATE(296)] = 11928,
  [SMALL_STATE(297)] = 11961,
  [SMALL_STATE(298)] = 11978,
  [SMALL_STATE(299)] = 11995,
  [SMALL_STATE(300)] = 12012,
  [SMALL_STATE(301)] = 12029,
  [SMALL_STATE(302)] = 12046,
  [SMALL_STATE(303)] = 12063,
  [SMALL_STATE(304)] = 12080,
  [SMALL_STATE(305)] = 12097,
  [SMALL_STATE(306)] = 12114,
  [SMALL_STATE(307)] = 12131,
  [SMALL_STATE(308)] = 12148,
  [SMALL_STATE(309)] = 12165,
  [SMALL_STATE(310)] = 12182,
  [SMALL_STATE(311)] = 12199,
  [SMALL_STATE(312)] = 12216,
  [SMALL_STATE(313)] = 12233,
  [SMALL_STATE(314)] = 12250,
  [SMALL_STATE(315)] = 12267,
  [SMALL_STATE(316)] = 12284,
  [SMALL_STATE(317)] = 12301,
  [SMALL_STATE(318)] = 12329,
  [SMALL_STATE(319)] = 12357,
  [SMALL_STATE(320)] = 12385,
  [SMALL_STATE(321)] = 12413,
  [SMALL_STATE(322)] = 12441,
  [SMALL_STATE(323)] = 12469,
  [SMALL_STATE(324)] = 12497,
  [SMALL_STATE(325)] = 12525,
  [SMALL_STATE(326)] = 12552,
  [SMALL_STATE(327)] = 12579,
  [SMALL_STATE(328)] = 12604,
  [SMALL_STATE(329)] = 12629,
  [SMALL_STATE(330)] = 12656,
  [SMALL_STATE(331)] = 12680,
  [SMALL_STATE(332)] = 12704,
  [SMALL_STATE(333)] = 12728,
  [SMALL_STATE(334)] = 12752,
  [SMALL_STATE(335)] = 12776,
  [SMALL_STATE(336)] = 12800,
  [SMALL_STATE(337)] = 12818,
  [SMALL_STATE(338)] = 12839,
  [SMALL_STATE(339)] = 12860,
  [SMALL_STATE(340)] = 12879,
  [SMALL_STATE(341)] = 12900,
  [SMALL_STATE(342)] = 12915,
  [SMALL_STATE(343)] = 12936,
  [SMALL_STATE(344)] = 12957,
  [SMALL_STATE(345)] = 12972,
  [SMALL_STATE(346)] = 12987,
  [SMALL_STATE(347)] = 13006,
  [SMALL_STATE(348)] = 13027,
  [SMALL_STATE(349)] = 13048,
  [SMALL_STATE(350)] = 13067,
  [SMALL_STATE(351)] = 13088,
  [SMALL_STATE(352)] = 13109,
  [SMALL_STATE(353)] = 13128,
  [SMALL_STATE(354)] = 13149,
  [SMALL_STATE(355)] = 13170,
  [SMALL_STATE(356)] = 13191,
  [SMALL_STATE(357)] = 13212,
  [SMALL_STATE(358)] = 13233,
  [SMALL_STATE(359)] = 13254,
  [SMALL_STATE(360)] = 13279,
  [SMALL_STATE(361)] = 13300,
  [SMALL_STATE(362)] = 13318,
  [SMALL_STATE(363)] = 13338,
  [SMALL_STATE(364)] = 13360,
  [SMALL_STATE(365)] = 13378,
  [SMALL_STATE(366)] = 13396,
  [SMALL_STATE(367)] = 13414,
  [SMALL_STATE(368)] = 13434,
  [SMALL_STATE(369)] = 13452,
  [SMALL_STATE(370)] = 13470,
  [SMALL_STATE(371)] = 13488,
  [SMALL_STATE(372)] = 13508,
  [SMALL_STATE(373)] = 13526,
  [SMALL_STATE(374)] = 13542,
  [SMALL_STATE(375)] = 13560,
  [SMALL_STATE(376)] = 13580,
  [SMALL_STATE(377)] = 13596,
  [SMALL_STATE(378)] = 13616,
  [SMALL_STATE(379)] = 13638,
  [SMALL_STATE(380)] = 13657,
  [SMALL_STATE(381)] = 13674,
  [SMALL_STATE(382)] = 13693,
  [SMALL_STATE(383)] = 13708,
  [SMALL_STATE(384)] = 13725,
  [SMALL_STATE(385)] = 13738,
  [SMALL_STATE(386)] = 13755,
  [SMALL_STATE(387)] = 13770,
  [SMALL_STATE(388)] = 13785,
  [SMALL_STATE(389)] = 13804,
  [SMALL_STATE(390)] = 13817,
  [SMALL_STATE(391)] = 13834,
  [SMALL_STATE(392)] = 13853,
  [SMALL_STATE(393)] = 13872,
  [SMALL_STATE(394)] = 13887,
  [SMALL_STATE(395)] = 13906,
  [SMALL_STATE(396)] = 13925,
  [SMALL_STATE(397)] = 13942,
  [SMALL_STATE(398)] = 13959,
  [SMALL_STATE(399)] = 13970,
  [SMALL_STATE(400)] = 13989,
  [SMALL_STATE(401)] = 14006,
  [SMALL_STATE(402)] = 14023,
  [SMALL_STATE(403)] = 14034,
  [SMALL_STATE(404)] = 14050,
  [SMALL_STATE(405)] = 14066,
  [SMALL_STATE(406)] = 14078,
  [SMALL_STATE(407)] = 14090,
  [SMALL_STATE(408)] = 14104,
  [SMALL_STATE(409)] = 14120,
  [SMALL_STATE(410)] = 14136,
  [SMALL_STATE(411)] = 14148,
  [SMALL_STATE(412)] = 14162,
  [SMALL_STATE(413)] = 14176,
  [SMALL_STATE(414)] = 14190,
  [SMALL_STATE(415)] = 14202,
  [SMALL_STATE(416)] = 14216,
  [SMALL_STATE(417)] = 14232,
  [SMALL_STATE(418)] = 14246,
  [SMALL_STATE(419)] = 14262,
  [SMALL_STATE(420)] = 14278,
  [SMALL_STATE(421)] = 14290,
  [SMALL_STATE(422)] = 14302,
  [SMALL_STATE(423)] = 14316,
  [SMALL_STATE(424)] = 14326,
  [SMALL_STATE(425)] = 14340,
  [SMALL_STATE(426)] = 14356,
  [SMALL_STATE(427)] = 14368,
  [SMALL_STATE(428)] = 14378,
  [SMALL_STATE(429)] = 14388,
  [SMALL_STATE(430)] = 14404,
  [SMALL_STATE(431)] = 14420,
  [SMALL_STATE(432)] = 14434,
  [SMALL_STATE(433)] = 14444,
  [SMALL_STATE(434)] = 14458,
  [SMALL_STATE(435)] = 14474,
  [SMALL_STATE(436)] = 14490,
  [SMALL_STATE(437)] = 14504,
  [SMALL_STATE(438)] = 14518,
  [SMALL_STATE(439)] = 14534,
  [SMALL_STATE(440)] = 14548,
  [SMALL_STATE(441)] = 14559,
  [SMALL_STATE(442)] = 14572,
  [SMALL_STATE(443)] = 14585,
  [SMALL_STATE(444)] = 14598,
  [SMALL_STATE(445)] = 14611,
  [SMALL_STATE(446)] = 14624,
  [SMALL_STATE(447)] = 14635,
  [SMALL_STATE(448)] = 14648,
  [SMALL_STATE(449)] = 14661,
  [SMALL_STATE(450)] = 14674,
  [SMALL_STATE(451)] = 14687,
  [SMALL_STATE(452)] = 14700,
  [SMALL_STATE(453)] = 14713,
  [SMALL_STATE(454)] = 14726,
  [SMALL_STATE(455)] = 14739,
  [SMALL_STATE(456)] = 14748,
  [SMALL_STATE(457)] = 14757,
  [SMALL_STATE(458)] = 14770,
  [SMALL_STATE(459)] = 14781,
  [SMALL_STATE(460)] = 14794,
  [SMALL_STATE(461)] = 14807,
  [SMALL_STATE(462)] = 14820,
  [SMALL_STATE(463)] = 14833,
  [SMALL_STATE(464)] = 14846,
  [SMALL_STATE(465)] = 14859,
  [SMALL_STATE(466)] = 14872,
  [SMALL_STATE(467)] = 14885,
  [SMALL_STATE(468)] = 14898,
  [SMALL_STATE(469)] = 14911,
  [SMALL_STATE(470)] = 14924,
  [SMALL_STATE(471)] = 14937,
  [SMALL_STATE(472)] = 14950,
  [SMALL_STATE(473)] = 14963,
  [SMALL_STATE(474)] = 14976,
  [SMALL_STATE(475)] = 14989,
  [SMALL_STATE(476)] = 15002,
  [SMALL_STATE(477)] = 15015,
  [SMALL_STATE(478)] = 15028,
  [SMALL_STATE(479)] = 15039,
  [SMALL_STATE(480)] = 15052,
  [SMALL_STATE(481)] = 15065,
  [SMALL_STATE(482)] = 15078,
  [SMALL_STATE(483)] = 15088,
  [SMALL_STATE(484)] = 15096,
  [SMALL_STATE(485)] = 15104,
  [SMALL_STATE(486)] = 15114,
  [SMALL_STATE(487)] = 15122,
  [SMALL_STATE(488)] = 15132,
  [SMALL_STATE(489)] = 15142,
  [SMALL_STATE(490)] = 15150,
  [SMALL_STATE(491)] = 15160,
  [SMALL_STATE(492)] = 15170,
  [SMALL_STATE(493)] = 15178,
  [SMALL_STATE(494)] = 15186,
  [SMALL_STATE(495)] = 15196,
  [SMALL_STATE(496)] = 15204,
  [SMALL_STATE(497)] = 15214,
  [SMALL_STATE(498)] = 15222,
  [SMALL_STATE(499)] = 15230,
  [SMALL_STATE(500)] = 15238,
  [SMALL_STATE(501)] = 15248,
  [SMALL_STATE(502)] = 15256,
  [SMALL_STATE(503)] = 15266,
  [SMALL_STATE(504)] = 15274,
  [SMALL_STATE(505)] = 15282,
  [SMALL_STATE(506)] = 15292,
  [SMALL_STATE(507)] = 15300,
  [SMALL_STATE(508)] = 15310,
  [SMALL_STATE(509)] = 15318,
  [SMALL_STATE(510)] = 15328,
  [SMALL_STATE(511)] = 15336,
  [SMALL_STATE(512)] = 15344,
  [SMALL_STATE(513)] = 15354,
  [SMALL_STATE(514)] = 15364,
  [SMALL_STATE(515)] = 15374,
  [SMALL_STATE(516)] = 15384,
  [SMALL_STATE(517)] = 15391,
  [SMALL_STATE(518)] = 15398,
  [SMALL_STATE(519)] = 15405,
  [SMALL_STATE(520)] = 15412,
  [SMALL_STATE(521)] = 15419,
  [SMALL_STATE(522)] = 15426,
  [SMALL_STATE(523)] = 15433,
  [SMALL_STATE(524)] = 15440,
  [SMALL_STATE(525)] = 15447,
  [SMALL_STATE(526)] = 15454,
  [SMALL_STATE(527)] = 15461,
  [SMALL_STATE(528)] = 15468,
  [SMALL_STATE(529)] = 15475,
  [SMALL_STATE(530)] = 15482,
  [SMALL_STATE(531)] = 15489,
  [SMALL_STATE(532)] = 15496,
  [SMALL_STATE(533)] = 15503,
  [SMALL_STATE(534)] = 15510,
  [SMALL_STATE(535)] = 15517,
  [SMALL_STATE(536)] = 15524,
  [SMALL_STATE(537)] = 15531,
  [SMALL_STATE(538)] = 15538,
  [SMALL_STATE(539)] = 15545,
  [SMALL_STATE(540)] = 15552,
  [SMALL_STATE(541)] = 15559,
  [SMALL_STATE(542)] = 15566,
  [SMALL_STATE(543)] = 15573,
  [SMALL_STATE(544)] = 15580,
  [SMALL_STATE(545)] = 15587,
  [SMALL_STATE(546)] = 15594,
  [SMALL_STATE(547)] = 15601,
  [SMALL_STATE(548)] = 15608,
  [SMALL_STATE(549)] = 15615,
  [SMALL_STATE(550)] = 15622,
  [SMALL_STATE(551)] = 15629,
  [SMALL_STATE(552)] = 15636,
  [SMALL_STATE(553)] = 15643,
  [SMALL_STATE(554)] = 15650,
  [SMALL_STATE(555)] = 15657,
  [SMALL_STATE(556)] = 15664,
  [SMALL_STATE(557)] = 15671,
  [SMALL_STATE(558)] = 15678,
  [SMALL_STATE(559)] = 15685,
  [SMALL_STATE(560)] = 15692,
  [SMALL_STATE(561)] = 15699,
  [SMALL_STATE(562)] = 15706,
  [SMALL_STATE(563)] = 15713,
  [SMALL_STATE(564)] = 15720,
  [SMALL_STATE(565)] = 15727,
  [SMALL_STATE(566)] = 15734,
  [SMALL_STATE(567)] = 15741,
  [SMALL_STATE(568)] = 15748,
  [SMALL_STATE(569)] = 15755,
  [SMALL_STATE(570)] = 15762,
  [SMALL_STATE(571)] = 15769,
  [SMALL_STATE(572)] = 15776,
  [SMALL_STATE(573)] = 15783,
  [SMALL_STATE(574)] = 15790,
  [SMALL_STATE(575)] = 15797,
  [SMALL_STATE(576)] = 15804,
  [SMALL_STATE(577)] = 15811,
  [SMALL_STATE(578)] = 15818,
  [SMALL_STATE(579)] = 15825,
  [SMALL_STATE(580)] = 15832,
  [SMALL_STATE(581)] = 15839,
  [SMALL_STATE(582)] = 15846,
  [SMALL_STATE(583)] = 15853,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [7] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_qualified_identifier, 3, 0, 18),
  [9] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_qualified_identifier, 3, 0, 18),
  [11] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_iri, 3, 0, 0),
  [13] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_iri, 3, 0, 0),
  [15] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 1, 0, 0),
  [17] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 1, 0, 0),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [21] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_identifier_reference, 1, 0, 0),
  [23] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_identifier_reference, 1, 0, 0),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(45),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(15),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(128),
  [35] = {.entry = {.count = 1, .reusable = true}}, SHIFT(177),
  [37] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean_truth, 1, 0, 0),
  [39] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean_truth, 1, 0, 0),
  [41] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_simple_value, 1, 0, 0),
  [43] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_simple_value, 1, 0, 0),
  [45] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean_falsity, 1, 0, 0),
  [47] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean_falsity, 1, 0, 0),
  [49] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary, 2, 0, 0),
  [51] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary, 2, 0, 0),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(326),
  [55] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2, 0, 35),
  [57] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2, 0, 35),
  [59] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary, 3, 0, 66),
  [61] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary, 3, 0, 66),
  [63] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_boolean, 1, 0, 0),
  [65] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean, 1, 0, 0),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(66),
  [69] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [71] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [73] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(325),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(481),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [85] = {.entry = {.count = 1, .reusable = false}}, SHIFT(8),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(526),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [101] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_expression, 3, 0, 88),
  [103] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_expression, 3, 0, 88),
  [105] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_constructor, 4, 0, 97),
  [107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_constructor, 4, 0, 97),
  [109] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_expression, 4, 0, 107),
  [111] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_expression, 4, 0, 107),
  [113] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_expression, 4, 0, 106),
  [115] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_expression, 4, 0, 106),
  [117] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_expression, 5, 0, 117),
  [119] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_expression, 5, 0, 117),
  [121] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_reference_expression, 3, 0, 88),
  [123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_reference_expression, 3, 0, 88),
  [125] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_reference_expression, 3, 0, 65),
  [127] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_reference_expression, 3, 0, 65),
  [129] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_reference_expression, 4, 0, 106),
  [131] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_reference_expression, 4, 0, 106),
  [133] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_reference_expression, 2, 0, 0),
  [135] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_reference_expression, 2, 0, 0),
  [137] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_reference_expression, 4, 0, 107),
  [139] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_reference_expression, 4, 0, 107),
  [141] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_reference_expression, 5, 0, 117),
  [143] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_reference_expression, 5, 0, 117),
  [145] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_reference_expression, 4, 0, 96),
  [147] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_reference_expression, 4, 0, 96),
  [149] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cardinality_reference_expression, 3, 0, 64),
  [151] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_reference_expression, 3, 0, 64),
  [153] = {.entry = {.count = 1, .reusable = false}}, SHIFT(523),
  [155] = {.entry = {.count = 1, .reusable = false}}, SHIFT(114),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [173] = {.entry = {.count = 1, .reusable = false}}, SHIFT(125),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(129),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [183] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__actual_arguments_repeat1, 2, 0, 101), SHIFT_REPEAT(114),
  [186] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__actual_arguments_repeat1, 2, 0, 101), SHIFT_REPEAT(69),
  [189] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__actual_arguments_repeat1, 2, 0, 101),
  [191] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__actual_arguments_repeat1, 2, 0, 101), SHIFT_REPEAT(120),
  [194] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__actual_arguments_repeat1, 2, 0, 101), SHIFT_REPEAT(329),
  [197] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__actual_arguments_repeat1, 2, 0, 101), SHIFT_REPEAT(122),
  [200] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__actual_arguments_repeat1, 2, 0, 101), SHIFT_REPEAT(576),
  [203] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__actual_arguments_repeat1, 2, 0, 101), SHIFT_REPEAT(474),
  [206] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__actual_arguments_repeat1, 2, 0, 101), SHIFT_REPEAT(125),
  [209] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__actual_arguments_repeat1, 2, 0, 101), SHIFT_REPEAT(125),
  [212] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__actual_arguments_repeat1, 2, 0, 101), SHIFT_REPEAT(129),
  [215] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__actual_arguments_repeat1, 2, 0, 101), SHIFT_REPEAT(127),
  [218] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__actual_arguments_repeat1, 2, 0, 101), SHIFT_REPEAT(145),
  [221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(156),
  [223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [225] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value, 1, 0, 0),
  [227] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value, 1, 0, 0),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [231] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mapping_value, 3, 0, 68),
  [233] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mapping_value, 3, 0, 68),
  [235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(546),
  [237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(548),
  [247] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [249] = {.entry = {.count = 1, .reusable = true}}, SHIFT(583),
  [251] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [253] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [255] = {.entry = {.count = 1, .reusable = true}}, SHIFT(494),
  [257] = {.entry = {.count = 1, .reusable = true}}, SHIFT(528),
  [259] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [265] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_values, 2, 0, 37),
  [267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_values, 2, 0, 37),
  [269] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_values, 4, 0, 98),
  [271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_values, 4, 0, 98),
  [273] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [275] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_values, 3, 0, 62),
  [277] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_values, 3, 0, 62),
  [279] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_values, 1, 0, 23),
  [281] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_values, 1, 0, 23),
  [283] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_values, 3, 0, 69),
  [285] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_values, 3, 0, 69),
  [287] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_values, 2, 0, 0),
  [289] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_values, 2, 0, 0),
  [291] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(553),
  [301] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [303] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 63), SHIFT_REPEAT(167),
  [306] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 63), SHIFT_REPEAT(69),
  [309] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 63),
  [311] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 63), SHIFT_REPEAT(364),
  [314] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 63), SHIFT_REPEAT(122),
  [317] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 63), SHIFT_REPEAT(576),
  [320] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 63), SHIFT_REPEAT(474),
  [323] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 63), SHIFT_REPEAT(125),
  [326] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 63), SHIFT_REPEAT(125),
  [329] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 63), SHIFT_REPEAT(129),
  [332] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 63), SHIFT_REPEAT(127),
  [335] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 2, 0, 63), SHIFT_REPEAT(145),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(146),
  [340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(148),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [350] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_term, 1, 0, 0),
  [352] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_term, 1, 0, 0),
  [354] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_composition, 2, 0, 38),
  [356] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_composition, 2, 0, 38),
  [358] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_composition_repeat1, 2, 0, 70),
  [360] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_composition_repeat1, 2, 0, 70),
  [362] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_composition_repeat1, 2, 0, 70), SHIFT_REPEAT(553),
  [365] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [367] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [369] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_composition_repeat1, 2, 0, 6),
  [371] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_composition_repeat1, 2, 0, 6),
  [373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [375] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_predicate_values, 3, 0, 69),
  [377] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_predicate_values, 3, 0, 69),
  [379] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_predicate_values, 2, 0, 37),
  [381] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_predicate_values, 2, 0, 37),
  [383] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_predicate_values, 3, 0, 62),
  [385] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_predicate_values, 3, 0, 62),
  [387] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__actual_arguments, 2, 0, 0),
  [389] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__actual_arguments, 2, 0, 0),
  [391] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_predicate_values, 2, 0, 0),
  [393] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_predicate_values, 2, 0, 0),
  [395] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__actual_arguments, 3, 0, 100),
  [397] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__actual_arguments, 3, 0, 100),
  [399] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_predicate_values, 4, 0, 98),
  [401] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_predicate_values, 4, 0, 98),
  [403] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_builder, 5, 0, 111),
  [405] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_builder, 5, 0, 111),
  [407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_predicate_value, 1, 0, 0),
  [409] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_predicate_value, 1, 0, 0),
  [411] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_of_predicate_values, 1, 0, 23),
  [413] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_sequence_of_predicate_values, 1, 0, 23),
  [415] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_functional_term, 2, 0, 42),
  [417] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_atomic_sentence, 2, 0, 41),
  [419] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_functional_term, 2, 0, 42),
  [421] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 63), SHIFT_REPEAT(167),
  [424] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 63),
  [426] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 63), SHIFT_REPEAT(122),
  [429] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 63), SHIFT_REPEAT(576),
  [432] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 63), SHIFT_REPEAT(474),
  [435] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 63), SHIFT_REPEAT(125),
  [438] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 63), SHIFT_REPEAT(125),
  [441] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 63), SHIFT_REPEAT(129),
  [444] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 2, 0, 63), SHIFT_REPEAT(127),
  [447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [449] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [457] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_logical_op_negation, 1, 0, 0),
  [459] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_logical_op_negation, 1, 0, 0),
  [461] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_logical_op_disjunction, 1, 0, 0),
  [463] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_logical_op_disjunction, 1, 0, 0),
  [465] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_logical_op_conjunction, 1, 0, 0),
  [467] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_logical_op_conjunction, 1, 0, 0),
  [469] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_logical_op_biconditional, 1, 0, 0),
  [471] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_logical_op_biconditional, 1, 0, 0),
  [473] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_logical_op_implication, 1, 0, 0),
  [475] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_logical_op_implication, 1, 0, 0),
  [477] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_logical_op_exclusive_disjunction, 1, 0, 0),
  [479] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_logical_op_exclusive_disjunction, 1, 0, 0),
  [481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(556),
  [483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [485] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0),
  [487] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(548),
  [490] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(518),
  [493] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(583),
  [496] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(568),
  [499] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(573),
  [502] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(494),
  [505] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(528),
  [508] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(530),
  [511] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(538),
  [514] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat3, 2, 0, 0), SHIFT_REPEAT(539),
  [517] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [521] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_composition_repeat1, 2, 0, 70), SHIFT_REPEAT(564),
  [524] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_module_body_repeat2, 2, 0, 0),
  [526] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_module_body_repeat2, 2, 0, 0),
  [528] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat2, 2, 0, 0), SHIFT_REPEAT(450),
  [531] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat2, 2, 0, 0), SHIFT_REPEAT(579),
  [534] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_builtin_simple_type, 1, 0, 0),
  [536] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_builtin_simple_type, 1, 0, 0),
  [538] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quantified_sentence, 3, 0, 73),
  [540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [546] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [548] = {.entry = {.count = 1, .reusable = true}}, SHIFT(111),
  [550] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [552] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_boolean_sentence, 3, 0, 72),
  [554] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_body, 2, 0, 40),
  [556] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_mapping_type, 5, 0, 116),
  [558] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_mapping_type, 5, 0, 116),
  [560] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_boolean_sentence, 2, 0, 43),
  [562] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__actual_arguments_repeat1, 1, 0, 75),
  [564] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__actual_arguments_repeat1, 1, 0, 75),
  [566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [570] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_import, 1, 0, 4),
  [572] = {.entry = {.count = 1, .reusable = false}}, SHIFT(582),
  [574] = {.entry = {.count = 1, .reusable = true}}, SHIFT(249),
  [576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(560),
  [578] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [586] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_inequation, 3, 0, 76),
  [588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [590] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_equation, 3, 0, 74),
  [592] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_informal_constraint, 2, 0, 24),
  [594] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_informal_constraint, 2, 0, 24),
  [596] = {.entry = {.count = 1, .reusable = true}}, SHIFT(179),
  [598] = {.entry = {.count = 1, .reusable = true}}, SHIFT(176),
  [600] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [602] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_datatype_def_restriction_repeat1, 2, 0, 0),
  [604] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_datatype_def_restriction_repeat1, 2, 0, 0), SHIFT_REPEAT(560),
  [607] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_datatype_def_restriction_repeat1, 2, 0, 0), SHIFT_REPEAT(561),
  [610] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_datatype_def_restriction_repeat1, 2, 0, 0), SHIFT_REPEAT(563),
  [613] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_datatype_def_restriction_repeat1, 2, 0, 0), SHIFT_REPEAT(565),
  [616] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_datatype_def_restriction_repeat1, 2, 0, 0), SHIFT_REPEAT(566),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(174),
  [621] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_module_body_repeat1, 2, 0, 0),
  [623] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat1, 2, 0, 0), SHIFT_REPEAT(372),
  [626] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_body_repeat1, 2, 0, 0), SHIFT_REPEAT(382),
  [629] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 1, 0, 34),
  [631] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sequence_of_predicate_values_repeat1, 1, 0, 34),
  [633] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation, 1, 0, 0),
  [635] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation, 1, 0, 0),
  [637] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_formal_constraint, 3, 0, 40),
  [639] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formal_constraint, 3, 0, 40),
  [641] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation_property, 4, 0, 22),
  [643] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_property, 4, 0, 22),
  [645] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_formal_constraint, 4, 0, 78),
  [647] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_formal_constraint, 4, 0, 78),
  [649] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_reference, 1, 0, 0),
  [651] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_reference, 1, 0, 0),
  [653] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_informal_constraint, 3, 0, 45),
  [655] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_informal_constraint, 3, 0, 45),
  [657] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_constraint, 3, 0, 1),
  [659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constraint, 3, 0, 1),
  [661] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member_import, 2, 0, 9),
  [663] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member_import, 2, 0, 9),
  [665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [669] = {.entry = {.count = 1, .reusable = false}}, SHIFT(58),
  [671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [675] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_import, 2, 0, 10),
  [677] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constraint_sentence, 1, 0, 0),
  [679] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_simple_sentence, 1, 0, 0),
  [681] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constraint_sentence, 3, 0, 0),
  [683] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_boolean_sentence, 1, 0, 0),
  [685] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_set_op_membership, 1, 0, 0),
  [687] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_set_op_membership, 1, 0, 0),
  [689] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_import, 2, 0, 9),
  [691] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_import, 2, 0, 9),
  [693] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_sequence_of_values_repeat1, 1, 0, 34),
  [695] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sequence_of_values_repeat1, 1, 0, 34),
  [697] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_import, 3, 0, 19),
  [699] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_import, 3, 0, 19),
  [701] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_inequality, 1, 0, 0),
  [703] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_inequality, 1, 0, 0),
  [705] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__rename_import, 2, 0, 17),
  [707] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__rename_import, 2, 0, 17),
  [709] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_less_than_or_equal, 1, 0, 0),
  [711] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_less_than_or_equal, 1, 0, 0),
  [713] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_op_greater_than_or_equal, 1, 0, 0),
  [715] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_op_greater_than_or_equal, 1, 0, 0),
  [717] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member_import, 1, 0, 4),
  [719] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__identifier_or_sequence, 1, 0, 83),
  [721] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__identifier_or_sequence, 1, 0, 83),
  [723] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__identifier_or_sequence, 3, 0, 86),
  [725] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__identifier_or_sequence, 3, 0, 86),
  [727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [729] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_def, 2, 0, 6),
  [731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [735] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member_def, 2, 0, 14),
  [737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [739] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member_def, 2, 0, 14),
  [741] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rdf_def, 2, 0, 6),
  [743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(435),
  [745] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 5, 0, 0),
  [747] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_def, 2, 0, 6),
  [749] = {.entry = {.count = 1, .reusable = true}}, SHIFT(323),
  [751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [753] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_def, 2, 0, 6),
  [755] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__type_expression_to, 3, 0, 55),
  [757] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__type_expression_to, 3, 0, 55),
  [759] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_data_type_def, 5, 0, 47),
  [761] = {.entry = {.count = 1, .reusable = true}}, SHIFT(178),
  [763] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__type_expression_to, 2, 0, 28),
  [765] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__type_expression_to, 2, 0, 28),
  [767] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_annotation_only_body, 3, 0, 0),
  [769] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_annotation_only_body, 3, 0, 0),
  [771] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_def, 5, 0, 60),
  [773] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 3, 0, 0),
  [775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [777] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structure_def, 2, 0, 6),
  [779] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 4, 0, 0),
  [781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [783] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_def, 2, 0, 6),
  [785] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_data_type_def, 4, 0, 25),
  [787] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_def, 2, 0, 6),
  [789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [793] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_def, 2, 0, 6),
  [795] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_import_statement, 2, 0, 0),
  [797] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member_def, 3, 0, 27),
  [799] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member_def, 3, 0, 27),
  [801] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_data_type_def, 5, 0, 49),
  [803] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_data_type_def, 6, 0, 80),
  [805] = {.entry = {.count = 1, .reusable = false}}, SHIFT(431),
  [807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [811] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_def, 6, 0, 93),
  [813] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_from_definition_with, 2, 0, 85),
  [815] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__wildcard_or_identifier_or_sequence, 1, 0, 84),
  [817] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rdf_def, 3, 0, 15),
  [819] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [821] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structure_def, 3, 0, 13),
  [823] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_def, 3, 0, 13),
  [825] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_from_definition_clause, 3, 0, 52),
  [827] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_def, 3, 0, 13),
  [829] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_def, 3, 0, 13),
  [831] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_def, 3, 0, 13),
  [833] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_from_definition_without, 2, 0, 86),
  [835] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_def, 3, 0, 13),
  [837] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_def, 3, 0, 13),
  [839] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__wildcard_or_identifier_or_sequence, 3, 0, 86),
  [841] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__wildcard_or_identifier_or_sequence, 1, 0, 83),
  [843] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rdf_types, 4, 0, 89),
  [845] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rdf_types, 2, 0, 29),
  [847] = {.entry = {.count = 1, .reusable = false}}, SHIFT(336),
  [849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [851] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_datatype_def_restriction, 3, 0, 0),
  [853] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rdf_types, 3, 0, 0),
  [855] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_length_restriction_facet, 4, 0, 119),
  [857] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_digit_restriction_facet, 4, 0, 119),
  [859] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_length_restriction_facet, 3, 0, 112),
  [861] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_digit_restriction_facet, 3, 0, 112),
  [863] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_restriction_facet, 4, 0, 119),
  [865] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_restriction_value, 1, 0, 0),
  [867] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_restriction_facet, 3, 0, 112),
  [869] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tz_restriction_value, 1, 0, 0),
  [871] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tz_restriction_facet, 4, 0, 120),
  [873] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_tz_restriction_facet, 3, 0, 113),
  [875] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_restriction_facet, 3, 0, 113),
  [877] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_pattern_restriction_facet, 5, 0, 123),
  [879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [881] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_body, 5, 0, 82),
  [883] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_def, 3, 0, 1),
  [885] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_def, 7, 0, 109),
  [887] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_body, 3, 0, 51),
  [889] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_def, 3, 0, 1),
  [891] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_def, 3, 0, 1),
  [893] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property_def, 2, 0, 7),
  [895] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_data_type_def, 6, 0, 79),
  [897] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_body, 6, 0, 82),
  [899] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_data_type_def, 6, 0, 81),
  [901] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rdf_def, 4, 0, 30),
  [903] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structure_body, 2, 0, 0),
  [905] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_body, 4, 0, 51),
  [907] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_body, 4, 0, 82),
  [909] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structure_body, 3, 0, 0),
  [911] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structure_def, 4, 0, 26),
  [913] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_body, 2, 0, 0),
  [915] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_body, 3, 0, 0),
  [917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(559),
  [921] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_def, 4, 0, 26),
  [923] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_body, 2, 0, 0),
  [925] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_body, 3, 0, 58),
  [927] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_def, 4, 0, 26),
  [929] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_body, 4, 0, 51),
  [931] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_body, 4, 0, 82),
  [933] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 4, 0, 0),
  [935] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_body, 4, 0, 51),
  [937] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_body, 3, 0, 51),
  [939] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_body, 4, 0, 82),
  [941] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_def, 4, 0, 26),
  [943] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_data_type_def, 5, 0, 48),
  [945] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structure_def, 3, 0, 1),
  [947] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [949] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_structure_body, 4, 0, 0),
  [951] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_body, 4, 0, 91),
  [953] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_def, 3, 0, 1),
  [955] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_body, 3, 0, 0),
  [957] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_def, 3, 0, 1),
  [959] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_class_def, 6, 0, 94),
  [961] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_union_body, 4, 0, 0),
  [963] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_def, 4, 0, 26),
  [965] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 2, 0, 0),
  [967] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_def, 4, 0, 26),
  [969] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_data_type_def, 7, 0, 103),
  [971] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_def, 4, 0, 26),
  [973] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_body, 3, 0, 51),
  [975] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_definition, 1, 0, 0),
  [977] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_enum_body, 3, 0, 0),
  [979] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_body, 5, 0, 51),
  [981] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_def, 3, 0, 1),
  [983] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_body, 5, 0, 82),
  [985] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_event_body, 5, 0, 82),
  [987] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_rdf_def, 3, 0, 1),
  [989] = {.entry = {.count = 1, .reusable = false}}, SHIFT(416),
  [991] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [993] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [995] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [997] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [999] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [1001] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [1003] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [1005] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [1007] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [1009] = {.entry = {.count = 1, .reusable = false}}, SHIFT(352),
  [1011] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [1013] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [1015] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1017] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [1019] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_def, 1, 0, 31),
  [1021] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [1023] = {.entry = {.count = 1, .reusable = true}}, SHIFT(288),
  [1025] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [1027] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [1029] = {.entry = {.count = 1, .reusable = true}}, SHIFT(287),
  [1031] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_type, 3, 0, 55),
  [1033] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_type, 3, 0, 55),
  [1035] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [1037] = {.entry = {.count = 1, .reusable = true}}, SHIFT(291),
  [1039] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_type_reference, 1, 0, 0),
  [1041] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_type_reference, 1, 0, 0),
  [1043] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_type, 2, 0, 28),
  [1045] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_type, 2, 0, 28),
  [1047] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [1049] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [1051] = {.entry = {.count = 1, .reusable = true}}, SHIFT(290),
  [1053] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_import_statement_repeat1, 2, 0, 0), SHIFT_REPEAT(359),
  [1056] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_import_statement_repeat1, 2, 0, 0),
  [1058] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [1060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(309),
  [1062] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable, 1, 0, 4),
  [1064] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 1, 0, 4),
  [1066] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [1068] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [1070] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_dimension_body_repeat2, 2, 0, 0), SHIFT_REPEAT(431),
  [1073] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_dimension_body_repeat2, 2, 0, 0),
  [1075] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dimension_body_repeat2, 2, 0, 0), SHIFT_REPEAT(443),
  [1078] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [1080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [1082] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_import, 1, 0, 4),
  [1084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(582),
  [1086] = {.entry = {.count = 1, .reusable = true}}, SHIFT(292),
  [1088] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_dimension_body_repeat1, 2, 0, 0),
  [1090] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_dimension_body_repeat1, 2, 0, 0),
  [1092] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_dimension_body_repeat1, 2, 0, 0), SHIFT_REPEAT(520),
  [1095] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1097] = {.entry = {.count = 1, .reusable = true}}, SHIFT(153),
  [1099] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [1101] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_parameter, 4, 0, 4),
  [1103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [1105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [1107] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_parameter_repeat1, 2, 0, 0),
  [1109] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_parameter_repeat1, 2, 0, 0), SHIFT_REPEAT(486),
  [1112] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_parameter, 3, 0, 4),
  [1114] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0), SHIFT_REPEAT(336),
  [1117] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_union_body_repeat1, 2, 0, 0),
  [1119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [1121] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dimension_parent, 4, 0, 114),
  [1123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_parent, 4, 0, 114),
  [1125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [1127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [1129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [1131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [1135] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_constraint_environment, 2, 0, 0),
  [1137] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_rdf_types_repeat1, 2, 0, 90), SHIFT_REPEAT(45),
  [1140] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_rdf_types_repeat1, 2, 0, 90),
  [1142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [1144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [1146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(471),
  [1148] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1150] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_parameter_restriction, 1, 0, 92),
  [1152] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [1154] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_constraint_environment_repeat1, 2, 0, 0),
  [1156] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_constraint_environment_repeat1, 2, 0, 0), SHIFT_REPEAT(559),
  [1159] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_source_entity, 2, 0, 50),
  [1161] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_entity, 2, 0, 50),
  [1163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [1167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [1169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [1171] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_parameter_restriction, 2, 0, 108),
  [1173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(424),
  [1175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [1177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [1179] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_parameter, 1, 0, 4),
  [1181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [1183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [1185] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_class_body_repeat1, 2, 0, 59),
  [1187] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_class_body_repeat1, 2, 0, 59), SHIFT_REPEAT(559),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [1192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [1194] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_signature, 6, 0, 118),
  [1196] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_variant, 1, 0, 4),
  [1198] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variant, 1, 0, 4),
  [1200] = {.entry = {.count = 1, .reusable = true}}, SHIFT(533),
  [1202] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_parameter_restriction_repeat1, 2, 0, 101), SHIFT_REPEAT(455),
  [1205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_parameter_restriction_repeat1, 2, 0, 101),
  [1207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [1209] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_signature, 3, 0, 77),
  [1211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [1213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [1215] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_variant, 3, 0, 95),
  [1217] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variant, 3, 0, 95),
  [1219] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable, 3, 0, 99),
  [1221] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 3, 0, 99),
  [1223] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_entity_identity, 2, 0, 51),
  [1225] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_entity_identity, 2, 0, 51),
  [1227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [1229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [1231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [1235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [1237] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_source_entity, 4, 0, 104),
  [1239] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_entity, 4, 0, 104),
  [1241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(289),
  [1243] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0), SHIFT_REPEAT(416),
  [1246] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_enum_body_repeat1, 2, 0, 0),
  [1248] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member, 1, 0, 0),
  [1250] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_member, 1, 0, 0),
  [1252] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_variant, 1, 0, 4),
  [1254] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_variant, 1, 0, 4),
  [1256] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_function_signature_repeat1, 2, 0, 61), SHIFT_REPEAT(407),
  [1259] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_signature_repeat1, 2, 0, 61),
  [1261] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1263] = {.entry = {.count = 1, .reusable = true}}, SHIFT(328),
  [1265] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_property_ref, 2, 0, 57),
  [1267] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_property_ref, 2, 0, 57),
  [1269] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_def, 2, 0, 46),
  [1271] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_type_class_def_repeat1, 2, 0, 61), SHIFT_REPEAT(393),
  [1274] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_class_def_repeat1, 2, 0, 61),
  [1276] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_dimension_parent, 5, 0, 121),
  [1278] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_dimension_parent, 5, 0, 121),
  [1280] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_parameter_restriction, 4, 0, 122),
  [1282] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_parameter_restriction, 5, 0, 124),
  [1284] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_member_import, 1, 0, 4),
  [1286] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_module_import, 2, 0, 10),
  [1288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [1290] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_ordering, 1, 0, 0),
  [1292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [1294] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_sequence_builder_repeat1, 2, 0, 71), SHIFT_REPEAT(352),
  [1297] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sequence_builder_repeat1, 2, 0, 71),
  [1299] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [1301] = {.entry = {.count = 1, .reusable = false}}, SHIFT(409),
  [1303] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [1305] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1307] = {.entry = {.count = 1, .reusable = true}}, SHIFT(327),
  [1309] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [1311] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [1313] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [1315] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [1317] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [1319] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [1321] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_module_path_absolute_repeat1, 2, 0, 21),
  [1323] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_module_path_absolute_repeat1, 2, 0, 21), SHIFT_REPEAT(567),
  [1326] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__cardinality_inner, 1, 0, 54),
  [1328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [1330] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quantified_variable, 3, 0, 102),
  [1332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [1334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [1336] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__wildcard_or_identifier_or_sequence_repeat1, 2, 0, 115), SHIFT_REPEAT(501),
  [1339] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__wildcard_or_identifier_or_sequence_repeat1, 2, 0, 115),
  [1341] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1343] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_restriction_argument, 1, 0, 0),
  [1345] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_parameter_restriction_repeat1, 1, 0, 75),
  [1347] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_path_absolute, 2, 0, 11),
  [1349] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [1351] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [1353] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [1355] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [1357] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [1359] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [1361] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_pattern_restriction_facet_repeat1, 2, 0, 0),
  [1363] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_pattern_restriction_facet_repeat1, 2, 0, 0), SHIFT_REPEAT(462),
  [1366] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_path_relative, 2, 0, 12),
  [1368] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_binary_repeat1, 2, 0, 67),
  [1370] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_binary_repeat1, 2, 0, 67), SHIFT_REPEAT(503),
  [1373] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [1375] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [1377] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [1379] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [1381] = {.entry = {.count = 1, .reusable = true}}, SHIFT(13),
  [1383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [1385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [1387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [1389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [1391] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [1393] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_path_absolute, 3, 0, 20),
  [1395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [1397] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_path_relative, 1, 0, 5),
  [1399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [1401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [1403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [1405] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_signature_repeat1, 1, 0, 33),
  [1407] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_class_def_repeat1, 1, 0, 33),
  [1409] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_op_combiner, 1, 0, 0),
  [1411] = {.entry = {.count = 1, .reusable = false}}, SHIFT(457),
  [1413] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_path_root_only, 1, 0, 0),
  [1415] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_variant, 2, 0, 53),
  [1417] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variant, 2, 0, 53),
  [1419] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_module_path_absolute_repeat1, 2, 0, 11),
  [1421] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_type_variant, 4, 0, 110),
  [1423] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_type_variant, 4, 0, 110),
  [1425] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_def, 3, 0, 46),
  [1427] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_parameter, 2, 0, 14),
  [1429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [1431] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__sequence_value_constraints, 3, 0, 64),
  [1433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [1435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [1437] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__sequence_value_constraints, 3, 0, 65),
  [1439] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_def, 2, 0, 31),
  [1441] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_uniqueness, 1, 0, 0),
  [1443] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__wildcard_or_identifier_or_sequence_repeat1, 1, 0, 83),
  [1445] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_value_variant, 2, 0, 53),
  [1447] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_value_variant, 2, 0, 53),
  [1449] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_binary_repeat1, 1, 0, 36),
  [1451] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__sequence_value_constraints, 4, 0, 96),
  [1453] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_rdf_types_repeat1, 1, 0, 56),
  [1455] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [1457] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__module_locations, 1, 0, 2),
  [1459] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_sequence_builder_repeat1, 1, 0, 39),
  [1461] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [1463] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_type_class_body_repeat1, 1, 0, 32),
  [1465] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_def, 2, 0, 46),
  [1467] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_range, 1, 0, 0),
  [1469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [1471] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [1473] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [1475] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [1477] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cardinality_range, 2, 0, 105),
  [1479] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [1481] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [1483] = {.entry = {.count = 1, .reusable = true}}, SHIFT(478),
  [1485] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_body, 5, 0, 0),
  [1487] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_body, 4, 0, 0),
  [1489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [1491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [1493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_body, 2, 0, 0),
  [1495] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_logical_quantifier_universal, 1, 0, 0),
  [1497] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_logical_quantifier_existential, 1, 0, 0),
  [1499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [1501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [1503] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [1505] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__module_locations, 3, 0, 8),
  [1507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [1509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [1511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [1513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [1515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [1517] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__module_locations, 4, 0, 16),
  [1519] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [1521] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [1523] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1525] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [1527] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [1529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [1531] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1535] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module_body, 3, 0, 0),
  [1537] = {.entry = {.count = 1, .reusable = false}}, SHIFT(574),
  [1539] = {.entry = {.count = 1, .reusable = false}}, SHIFT_EXTRA(),
  [1541] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [1543] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [1545] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quantified_variable_binding, 2, 0, 44),
  [1547] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [1549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [1551] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module, 3, 0, 1),
  [1553] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [1555] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [1557] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_sequence_builder_body, 1, 0, 0),
  [1559] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [1561] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [1563] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [1565] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [1567] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1569] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [1571] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [1573] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [1575] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [1577] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1579] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [1581] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1583] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1585] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_from_clause, 2, 0, 0),
  [1587] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__cardinality_inner, 2, 0, 87),
  [1589] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [1591] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [1593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [1595] = {.entry = {.count = 1, .reusable = false}}, SHIFT(555),
  [1597] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_module, 4, 0, 3),
  [1599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [1603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [1605] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [1607] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [1609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
};

#ifdef __cplusplus
extern "C" {
#endif
#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_sdml(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
