cert-error-intro = { $hostname } использует недействительный сертификат безопасности.
cert-error-mitm-intro = Веб-сайты подтверждают свою подлинность с помощью сертификатов, выдаваемых центрами сертификации.
cert-error-mitm-mozilla = { -brand-short-name } поддерживается некоммерческой организацией Mozilla, которая имеет собственное полностью открытое хранилище сертификатов центров сертификации. Это хранилище помогает убедиться, что центры сертификации следуют лучшим практикам обеспечения безопасности пользователей.
cert-error-mitm-connection = Для проверки защиты соединения { -brand-short-name } использует хранилище сертификатов центров сертификации Mozilla, а не хранилище, встроенное в операционную систему пользователя. Так что, если антивирусная или сетевая программа перехватывает соединение, используя сертификат безопасности, выданный центром сертификации, отсутствующем в хранилище Mozilla, соединение считается небезопасным.
cert-error-trust-unknown-issuer-intro = Кто-то может пытаться подменить настоящий сайт и вам лучше не продолжать.
cert-error-trust-unknown-issuer = Веб-сайты подтверждают свою подлинность с помощью сертификатов. { -brand-short-name } не доверяет { $hostname }, потому что издатель его сертификата неизвестен, сертификат является самоподписанным, или сервер не отправляет корректные промежуточные сертификаты.
cert-error-trust-cert-invalid = К сертификату нет доверия, так как он был издан с использованием недействительного сертификата центра сертификации (CA).
cert-error-trust-untrusted-issuer = К сертификату нет доверия, так как к сертификату его издателя нет доверия.
cert-error-trust-signature-algorithm-disabled = К сертификату нет доверия, так как он был подписан с использованием алгоритма подписи, который был отключён, так как алгоритм небезопасен.
cert-error-trust-expired-issuer = К сертификату нет доверия, так как у сертификата его издателя истёк срок действия.
cert-error-trust-self-signed = К сертификату нет доверия, так как он является самоподписанным.
cert-error-trust-symantec = Сертификаты, выпущенные GeoTrust, RapidSSL, Symantec, Thawte и VeriSign, более не считаются безопасными, так как эти центры сертификации в прошлом не соблюдали правила обеспечения безопасности.
cert-error-trust-certificate-transparency = { -brand-short-name } не доверяет { $hostname }, потому что он не смог подтвердить, что он соответствует требованиям прозрачности публичных сертификатов.
cert-error-revoked = Веб-сайты подтверждают свою подлинность с помощью сертификатов. { -brand-short-name } не доверяет { $hostname }, потому что он использует сертификат, который был отозван.
cert-error-untrusted-default = К источнику, издавшему сертификат, нет доверия.
cert-error-domain-mismatch = Веб-сайты подтверждают свою подлинность с помощью сертификатов. { -brand-short-name } не доверяет этому сайту, потому что он использует сертификат, недействительный для { $hostname }.
cert-error-domain-mismatch-single = Веб-сайты подтверждают свою подлинность с помощью сертификатов. { -brand-short-name } не доверяет этому сайту, потому что он использует сертификат, недействительный для { $hostname }. Сертификат действителен только для <a data-l10n-name="domain-mismatch-link">{ $alt-name }</a>.
cert-error-domain-mismatch-single-nolink = Веб-сайты подтверждают свою подлинность с помощью сертификатов. { -brand-short-name } не доверяет этому сайту, потому что он использует сертификат, недействительный для { $hostname }. Сертификат действителен только для { $alt-name }.
cert-error-domain-mismatch-multiple = Веб-сайты подтверждают свою подлинность с помощью сертификатов. { -brand-short-name } не доверяет этому сайту, потому что он использует сертификат, недействительный для { $hostname }. Сертификат действителен только для следующих доменов: { $subject-alt-names }
cert-error-expired-now = Веб-сайты подтверждают свою подлинность с помощью сертификатов, имеющих ограниченный срок действия. Срок действия сертификата для { $hostname } истёк { $not-after-local-time }.
cert-error-not-yet-valid-now = Веб-сайты подтверждают свою подлинность с помощью сертификатов, имеющих ограниченный срок действия. Сертификат для { $hostname } начнёт действовать не ранее { $not-before-local-time }.
cert-error-code-prefix = Код ошибки: { $error }
cert-error-code-prefix-link = Код ошибки: <a data-l10n-name="error-code-link">{ $error }</a>
cert-error-ssl-connection-error = При соединении с { $hostname } произошла ошибка. { $errorMessage }
cert-error-symantec-distrust-description = Веб-сайты подтверждают свою подлинность с помощью сертификатов, выдаваемых центрами сертификации. Большинство браузеров больше не доверяют сертификатам, выпущенным GeoTrust, RapidSSL, Symantec, Thawte и VeriSign. { $hostname } использует сертификат от одного из этих центров, поэтому его подлинность не может быть подтверждена.
cert-error-symantec-distrust-admin = Вы можете уведомить об этой проблеме администратора веб-сайта.
cert-error-old-tls-version = Этот веб-сайт может не поддерживать протокол TLS 1.2 — минимальную версию, поддерживаемую { -brand-short-name }.
cert-error-details-hsts-label = Форсированное защищённое соединение HTTP (HSTS): { $hasHSTS }
cert-error-details-key-pinning-label = Привязка открытого ключа HTTP (HPKP): { $hasHPKP }
cert-error-details-cert-chain-label = Цепочка сертификата:
csp-xfo-blocked-long-desc = Для обеспечения вашей безопасности { $hostname } не разрешил { -brand-short-name } отобразить страницу, так как она встроена в другой сайт. Чтобы увидеть эту страницу, вам нужно открыть её в новом окне.
connectionFailure-title = Попытка соединения не удалась
deniedPortAccess-title = Обращение к данному адресу заблокировано
dnsNotFound-title = Хмм. Нам не удаётся найти этот сайт.
fileNotFound-title = Файл не найден
fileAccessDenied-title = В доступе к файлу отказано
generic-title = Ой.
captivePortal-title = Вход в сеть
malformedURI-title = Хмм. Этот адрес не выглядит правильным.
netInterrupt-title = Соединение было прервано
notCached-title = Документ просрочен
netOffline-title = Автономный режим
contentEncodingError-title = Ошибка в типе содержимого
unsafeContentType-title = Небезопасный тип файла
netReset-title = Соединение было сброшено
netTimeout-title = Время ожидания соединения истекло
httpErrorPage-title = Похоже, на этом сайте есть проблема
serverError-title = Похоже, на этом сайте есть проблема
unknownProtocolFound-title = Неизвестный тип адреса
proxyConnectFailure-title = Прокси-сервер отказывается принимать соединения
proxyResolveFailure-title = Не удалось найти прокси-сервер
redirectLoop-title = Циклическое перенаправление на странице
unknownSocketType-title = Неизвестный/неопознанный ответ сервера
nssFailure2-title = Ошибка при установлении защищённого соединения
csp-xfo-error-title = { -brand-short-name } не может открыть эту страницу
corruptedContentError-title = Ошибка искажения содержимого
sslv3Used-title = Установка защищённого соединения не удалась
inadequateSecurityError-title = Ваше соединение не защищено
blockedByPolicy-title = Заблокированная страница
clockSkewError-title = Часы вашего компьютера установлены неправильно
networkProtocolError-title = Ошибка сетевого протокола
nssBadCert-title = Предупреждение: Вероятная угроза безопасности
nssBadCert-sts-title = Соединение не установлено: Вероятная угроза безопасности
certerror-mitm-title = Программное обеспечение не даёт { -brand-short-name } безопасно подключиться к этому сайту
fp-certerror-page-title = Предупреждение: Риск безопасности
fp-certerror-body-title = Будьте осторожны. Что-то выглядит не так.
fp-certerror-why-site-dangerous = Что делает сайт опасным?
fp-certerror-what-can-you-do = Как вы можете это исправить?
fp-certerror-advanced-title = Дополнительно
fp-certerror-advanced-button = Дополнительно
fp-certerror-hide-advanced-button = Скрыть подробности
fp-certerror-override-exception-button = Перейти на { $hostname } (рискованно)
fp-certerror-intro = { -brand-short-name } обнаружил потенциально значимую проблему с безопасностью <strong>{ $hostname }</strong>. Кто-то, выдающий себя за сайт, может попытаться украсть такие данные, как данные банковской карты, пароли или адреса электронной почты.
fp-certerror-expired-into = { -brand-short-name } обнаружил проблему с безопасностью на <strong>{ $hostname }</strong>. Либо сайт не настроен правильно, либо на часах вашего устройства установлена неверная дата и время.
fp-certerror-view-certificate-link = Просмотреть сертификат сайта
fp-certerror-return-to-previous-page-recommended-button = Вернуться назад (рекомендуется)
fp-certerror-bad-domain-why-dangerous-body = Сайт разрешает только защищённые соединения, но возникла проблема с сертификатом сайта. Возможно, злоумышленник пытается подменить этот сайт другим. Сайты используют сертификаты, выданные центром сертификации, чтобы подтвердить, что они действительно являются теми, за кого себя выдают. { -brand-short-name } не доверяет этому сайту, так как его сертификат недействителен для { $hostname }. Сертификат действителен только для: { $validHosts }.
fp-certerror-bad-domain-what-can-you-do-body = Вероятно, ничего, так как, вероятно, возникла проблема с самим сайтом. Сайты используют сертификаты, выданные центром сертификации, чтобы подтвердить, что они действительно являются теми, за кого себя выдают. Но если вы находитесь в корпоративной сети, ваша служба поддержки может иметь больше информации. Если вы используете антивирусную программу, попробуйте поискать потенциальные конфликты или известные проблемы.
fp-certerror-unknown-issuer-why-dangerous-body = Возникла проблема с сертификатом сайта. Возможно, злоумышленник пытается подменить этот сайт другим. Сайты используют сертификаты, выданные центром сертификации, чтобы подтвердить, что они действительно являются теми, за кого себя выдают. { -brand-short-name } не доверяет этому сайту, потому что мы не можем сказать, кто издал сертификат, он является самоподписанным или сайт не отправляет промежуточные сертификаты, которым мы доверяем.
fp-certerror-unknown-issuer-what-can-you-do-body = Вероятно, ничего, так как, вероятно, возникла проблема с самим сайтом. Но если вы находитесь в корпоративной сети, ваша служба поддержки может иметь больше информации. Если вы используете антивирусную программу, то её нужно настроить для работы с { -brand-short-name }.
fp-certerror-self-signed-why-dangerous-body = Потому что есть проблема с сертификатом сайта. Сайты используют сертификаты, выданные центром сертификации, чтобы подтвердить, что они действительно являются теми, за кого себя выдают. Сертификат этого сайта является самоподписанным. Он не был выдан признанным центром сертификации, поэтому мы не доверяем ему по умолчанию.
fp-certerror-self-signed-what-can-you-do-body = Не так уж много. Скорее всего, возникла проблема с самим сайтом.
fp-certerror-self-signed-important-note = ВАЖНО: Если вы пытаетесь посетить этот сайт через корпоративную интрасеть, ваши ИТ-специалисты могут использовать самоподписанные сертификаты. Они могут помочь вам проверить их подлинность.
fp-certerror-expired-why-dangerous-body = Сайты используют сертификаты, выданные центром сертификации, чтобы подтвердить, что они действительно являются теми, за кого себя выдают. { -brand-short-name } не доверяет этому сайту, так как похоже, что срок действия сертификата истёк { DATETIME($date, month: "numeric", day: "numeric", year: "numeric") }.
fp-certerror-not-yet-valid-why-dangerous-body = Сайты используют сертификаты, выданные центром сертификации, чтобы подтвердить, что они действительно являются теми, за кого себя выдают. { -brand-short-name } не доверяет этому сайту, так как похоже, что сертификат не будет действителен до { DATETIME($date, month: "numeric", day: "numeric", year: "numeric") } .
fp-certerror-expired-what-can-you-do-body = Часы вашего устройства установлены на { DATETIME($date, month: "numeric", day: "numeric", year: "numeric") }. Если время верное, то проблема с безопасностью, вероятно, связана с самим сайтом. Если время неверное, вы можете изменить его в системных настройках вашего устройства.
fp-cert-error-code = Код ошибки: { $error }
fp-datetime = { DATETIME($datetime, month: "short", year: "numeric", day: "numeric") } { DATETIME($datetime, timeStyle: "long") }
fp-learn-more-about-secure-connection-failures = Подробнее об ошибках защищённого соединения
fp-learn-more-about-cert-issues = Подробнее о подобных проблемах с сертификатами
fp-learn-more-about-time-related-errors = Узнайте больше об устранении ошибок, связанных со временем
